/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.reports.async;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.reports.model.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.MultiException;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.misc.IrrelevanceTolerantEntityStorage;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportParameters;
import com.gridnine.xtrip.common.reports.render.RenderHandlersRegistry;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.fx.async.AsyncTask;
import com.gridnine.xtrip.server.fx.async.TaskExecutionCallback;
import com.gridnine.xtrip.server.fx.reports.async.ReportTaskParameters;
import com.gridnine.xtrip.server.reports.prepare.PrepareHandlersRegistry;
import com.gridnine.xtrip.server.reports.prepare.PrepareReportCallback;
import com.gridnine.xtrip.server.reports.prepare.PrepareReportTask;
import com.gridnine.xtrip.server.reports.prepare.ReportPrepareHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncReportTask
implements AsyncTask<ReportTaskParameters, EntityReference<? extends BaseReportDocument>> {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());

    public EntityReference<? extends BaseReportDocument> execute(ReportTaskParameters parameters, TaskExecutionCallback callback) throws Exception {
        EntityContainer result;
        boolean templateReport = parameters.getReportParameters() instanceof BaseTemplateReportParameters;
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            if (templateReport && parameters.getReportDocument() != null) {
                params.put("KEY_REPORT_DOCUMENT", EntityStorage.get().resolve(parameters.getReportDocument()));
            }
            this.prepareData(params, parameters.getReportParameters(), callback);
        }
        catch (Exception e) {
            if (ExceptionUtil.isInterruptedError((Throwable)e)) {
                throw new InterruptedException();
            }
            try {
                PrepareReportTask.enrichException((Exception)e, (String)parameters.getReportParameters().getReportId(), (Object)parameters.getReportParameters());
            }
            catch (Exception e2) {
                MultiException me = new MultiException();
                me.addException((Throwable)e);
                me.addException((Throwable)e2);
                throw me;
            }
            throw e;
        }
        LinkedHashSet<Message> collectedMessages = new LinkedHashSet<Message>();
        Collection messages = (Collection)params.get("key-messages");
        if (messages != null) {
            boolean containsErrors = false;
            for (Object obj : messages) {
                if (!(obj instanceof Message)) continue;
                Message msg = (Message)obj;
                if (MessageType.ERROR == msg.getType()) {
                    containsErrors = true;
                }
                collectedMessages.add(msg);
            }
            callback.addMessages(collectedMessages);
            if (containsErrors) {
                callback.addMessages(new Message[]{Messages.getExceptionPreparationOfData()});
                return null;
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        callback.setProgress((byte)80, Messages.getGenerateReportFiles());
        try {
            result = ((RenderHandlersRegistry)Environment.getPublished(RenderHandlersRegistry.class)).get(parameters.getReportParameters().getReportId()).renderReport(params);
        }
        catch (Exception e) {
            if (ExceptionUtil.isInterruptedError((Throwable)e)) {
                throw new InterruptedException();
            }
            try {
                PrepareReportTask.enrichException((Exception)e, (String)parameters.getReportParameters().getReportId(), (Object)parameters.getReportParameters());
            }
            catch (Exception e2) {
                MultiException me = new MultiException();
                me.addExceptions(new Throwable[]{e, e2});
                throw me;
            }
            throw e;
        }
        messages = (Collection)params.get("key-messages");
        if (messages != null) {
            ArrayList<Message> msgs = new ArrayList<Message>();
            for (Object obj : messages) {
                Message msg;
                if (!(obj instanceof Message) || collectedMessages.contains(msg = (Message)obj)) continue;
                msgs.add(msg);
                collectedMessages.add(msg);
            }
            callback.addMessages(msgs);
        }
        if (result == null) {
            return null;
        }
        if (parameters.getReportDocument() == null || templateReport) {
            if (TextUtils.isBlank((CharSequence)result.getVersionInfo().getDataSource()) || !LogicalEntityStorage.isDataSourceModified((VersionInfo)result.getVersionInfo())) {
                result.getVersionInfo().setDataSource("async-report-task");
            }
            EntityStorage.get().save(result, true);
            return result.toReference();
        }
        EntityContainer ctr = EntityStorage.get().resolve(parameters.getReportDocument());
        if (ctr == null) {
            ctr = new EntityContainer(result.getEntityType());
        }
        if (TextUtils.isBlank((CharSequence)ctr.getVersionInfo().getDataSource()) || !LogicalEntityStorage.isDataSourceModified((VersionInfo)result.getVersionInfo())) {
            ctr.getVersionInfo().setDataSource("async-report-task");
        }
        ((BaseReportDocument)ctr.getEntity()).copyFrom(result.getEntity(), false, new HashMap());
        EntityStorage.get().save(ctr, true);
        return ctr.toReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareData(Map<String, Object> params, BaseReportParameters reportParameters, final TaskExecutionCallback callback) throws Exception {
        callback.setProgress((byte)1, Messages.getPreparingDataForAReport());
        ReportPrepareHandler handler = ((PrepareHandlersRegistry)Environment.getPublished(PrepareHandlersRegistry.class)).get(reportParameters.getReportId());
        if (handler == null) {
            throw Xeption.forDeveloper((String)Messages.getNoReportHandlerWasFoundById(), (Object[])new Object[]{reportParameters.getReportId()});
        }
        params.put("ASYNC_TASK_REPORT_ID", reportParameters.getReportId());
        params.put("key-report-params", reportParameters);
        params.put("KEY_PREPARE_REPORT_CALLBACK", new PrepareReportCallback(){

            public void updateProgress(byte progress, String message) {
                try {
                    callback.setProgress(progress, message);
                }
                catch (Exception e) {
                    AsyncReportTask.this.log.error("failed updating progress", (Throwable)e);
                }
            }

            public boolean isToBeStopped() {
                return Thread.currentThread().isInterrupted();
            }
        });
        EntityStorage entityStorage = EntityStorage.get();
        if (entityStorage instanceof IrrelevanceTolerantEntityStorage) {
            ((IrrelevanceTolerantEntityStorage)entityStorage).setTolerant(true);
            this.log.debug("storage irrelevance tolerant mode turned on");
        }
        try {
            handler.prepareData(params);
        }
        finally {
            if (entityStorage instanceof IrrelevanceTolerantEntityStorage) {
                ((IrrelevanceTolerantEntityStorage)entityStorage).setTolerant(false);
                this.log.debug("storage irrelevance tolerant mode turned off");
            }
        }
        params.remove("KEY_PREPARE_REPORT_CALLBACK");
    }
}

