/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.reports.rpc;

import com.gridnine.xtrip.common.fx.assets.AsyncTaskAssignment;
import com.gridnine.xtrip.common.fx.reports.rpc.ReportTaskInfo;
import com.gridnine.xtrip.common.fx.reports.rpc.ReportsService;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.IbusManager;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.DebitSlip;
import com.gridnine.xtrip.common.model.finance.DebitSlipType;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.StandardTransactionActions;
import com.gridnine.xtrip.common.model.finance.TransactionAction;
import com.gridnine.xtrip.common.model.finance.TransactionDataHolder;
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex;
import com.gridnine.xtrip.common.model.helpers.BalanceHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.PersonalLocalizableNameFormatter;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.helpers.WorklogHelper;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.reports.model.AgentTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.fx.async.AsyncTasksManager;
import com.gridnine.xtrip.server.fx.reports.async.AsyncReportTask;
import com.gridnine.xtrip.server.fx.reports.async.ReportTaskParameters;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class ReportsServiceImpl
extends BaseSecureServiceImpl
implements ReportsService {
    private static final String TASK_TAG = "report";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReportTaskInfo.Truncated> getAllTasks(ServiceInvocationContext ctx) throws ServiceException {
        DebugUtil.setThreadName((String)"FxReportsServiceImpl-getTasks");
        try {
            this.checkContext(ctx);
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AsyncTaskAssignment.Property.tag.name(), (Object)TASK_TAG));
            query.getPreferredProperties().add(AsyncTaskAssignment.Property.state.name());
            ArrayList<ReportTaskInfo.Truncated> result = new ArrayList<ReportTaskInfo.Truncated>();
            for (AsyncTaskAssignment assignment : AssetsStorage.get().search(AsyncTaskAssignment.class, query).getData()) {
                ReportTaskInfo.Truncated info = new ReportTaskInfo.Truncated();
                info.setTaskId(assignment.getUid());
                info.setState(assignment.getState());
                result.add(info);
            }
            ArrayList<ReportTaskInfo.Truncated> arrayList = result;
            return arrayList;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReportTaskInfo> getTasks(ServiceInvocationContext ctx, List<String> taskIds) throws ServiceException {
        DebugUtil.setThreadName((String)"FxReportsServiceImpl-getTasks");
        try {
            this.checkContext(ctx);
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.in((String)"uid", (Object[])taskIds.toArray()));
            query.getPreferredProperties().add("uid");
            ArrayList<ReportTaskInfo> result = new ArrayList<ReportTaskInfo>();
            for (AsyncTaskAssignment assignment : AssetsStorage.get().search(AsyncTaskAssignment.class, query).getData()) {
                AsyncTaskAssignment assignment2 = (AsyncTaskAssignment)AssetsStorage.get().load(AsyncTaskAssignment.class, assignment.getUid());
                if (null == assignment2 || assignment2.getState() == null) continue;
                result.add(this.buildTaskInfo(assignment2));
            }
            ArrayList<ReportTaskInfo> arrayList = result;
            return arrayList;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public void cancelTask(ServiceInvocationContext ctx, String taskId) throws ServiceException {
        DebugUtil.setThreadName((String)"FxReportsServiceImpl-cancelTask");
        try {
            this.checkContext(ctx);
            AsyncTasksManager.get().interrupt(taskId);
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("failed cancelling task " + taskId, t);
            throw new ServiceException("failed cancelling task", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public ReportTaskInfo createTask(ServiceInvocationContext ctx, BaseReportParameters parameters, String title) throws ServiceException {
        DebugUtil.setThreadName((String)"FxReportsServiceImpl-createTask");
        try {
            this.checkContext(ctx);
            ReportTaskInfo reportTaskInfo = this.buildTaskInfo(AsyncTasksManager.get().enqueue(AsyncReportTask.class, (Serializable)new ReportTaskParameters(parameters, title), TASK_TAG));
            return reportTaskInfo;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("failed creating task " + parameters.getReportId(), t);
            throw new ServiceException("failed creating task", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public ReportTaskInfo recreateTask(ServiceInvocationContext ctx, BaseReportParameters parameters, String title, EntityReference<? extends BaseReportDocument> document) throws ServiceException {
        DebugUtil.setThreadName((String)"FxReportsServiceImpl-createTask");
        try {
            this.checkContext(ctx);
            ReportTaskInfo reportTaskInfo = this.buildTaskInfo(AsyncTasksManager.get().enqueue(AsyncReportTask.class, (Serializable)new ReportTaskParameters(parameters, title, document), TASK_TAG));
            return reportTaskInfo;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("failed creating task " + parameters.getReportId(), t);
            throw new ServiceException("failed creating task", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private ReportTaskInfo buildTaskInfo(AsyncTaskAssignment assignment) {
        SimpleDateFormat dtf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ReportTaskInfo result = new ReportTaskInfo();
        result.setTaskId(assignment.getUid());
        result.setState(assignment.getState());
        result.setCreated(assignment.getEnqueued());
        result.setOwner(assignment.getCreator());
        result.setCurrentProgress(assignment.getProgress());
        result.setCurrentMessage(assignment.getMessage());
        if (assignment.getStarted() != null) {
            result.getLog().add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"started {0}", (Object[])new Object[]{dtf.format(assignment.getStarted())}));
        }
        if (assignment.getNodeId() != null) {
            result.getLog().add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"node ID {0}", (Object[])new Object[]{assignment.getNodeId()}));
        }
        result.getLog().addAll(assignment.getLog());
        if (assignment.getStopped() != null) {
            result.getLog().add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"stopped {0}", (Object[])new Object[]{dtf.format(assignment.getStopped())}));
        }
        try {
            Throwable error = (Throwable)MiscUtil.deserialize((byte[])assignment.getError());
            result.setError(error == null || error instanceof ServiceException ? error : new ServiceException(error.getMessage(), error));
        }
        catch (Exception e) {
            this.log.warn("failed deserializing error from report task assignment " + assignment.getUid(), (Throwable)e);
        }
        ReportTaskParameters parameters = null;
        try {
            parameters = (ReportTaskParameters)MiscUtil.deserialize((byte[])assignment.getParameters());
        }
        catch (Exception e) {
            this.log.warn("failed deserializing parameters of report task assignment " + assignment.getUid(), (Throwable)e);
        }
        if (parameters != null) {
            result.setReportId(parameters.getReportParameters().getReportId());
            result.setReportTitle(parameters.getReportTitle());
            result.setPeriodBegin(parameters.getReportParameters().getPeriodBegin());
            result.setPeriodEnd(parameters.getReportParameters().getPeriodEnd());
        }
        try {
            result.setDocument((EntityReference)MiscUtil.deserialize((byte[])assignment.getResult()));
        }
        catch (Exception e) {
            this.log.warn("failed deserializing result of report task assignment " + assignment.getUid(), (Throwable)e);
        }
        if (result.getDocument() == null && parameters != null) {
            result.setDocument(parameters.getReportDocument());
        }
        return result;
    }

    public boolean isAgentSettingsEnabled(ServiceInvocationContext ctx, EntityReference<Organization> agency) throws ServiceException {
        DebugUtil.setThreadName((String)"FxReportsServiceImpl-isAgentSettingsEnabled");
        try {
            this.checkContext(ctx);
            boolean bl = BalanceHelper.isSettingsEnabled(agency, (ChartOfAccountsElementType)ChartOfAccountsElementType.AGENT);
            return bl;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("failed getting agent settings", t);
            throw new ServiceException("failed getting agent settings", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public BigDecimal getAgentAmountToCommitAgentReport(ServiceInvocationContext ctx, AgentTemplateReportDocument reportDocument) throws ServiceException {
        DebugUtil.setThreadName((String)"FxReportsServiceImpl-getAgentAmountToCommitAgentReport");
        try {
            this.checkContext(ctx);
            Date periodBegin = reportDocument.getParameters().getPeriodBegin();
            Date periodEnd = reportDocument.getParameters().getPeriodEnd();
            EntityReference agency = reportDocument.getParameters().getSubagency();
            EntityReference cashRegisterWorkplace = reportDocument.getParameters().getCashRegisterWorkplace();
            EntityReference agent = reportDocument.getParameters().getAgent();
            CurrencyInfoReference currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
            boolean cashRemainsSettingEnabled = BalanceHelper.isSettingsEnabled((EntityReference)agency, (ChartOfAccountsElementType)ChartOfAccountsElementType.CASH_REMAINS_AGENT);
            boolean agentSettingsEnabled = BalanceHelper.isSettingsEnabled((EntityReference)agency, (ChartOfAccountsElementType)ChartOfAccountsElementType.AGENT);
            boolean individualCashRemains = ProfileHelper.isIndividualCashRemains((EntityReference)reportDocument.getParameters().getSalesPoint());
            Date startOperationDate = MiscUtil.getBeforeTime((Date)periodBegin);
            Date endOperationDate = periodEnd;
            Date calculationDate = new Date();
            BigDecimal agentAmount = null;
            if (cashRemainsSettingEnabled) {
                agentAmount = individualCashRemains ? BalanceHelper.calculateBalance((EntityReference)agency, (Date)startOperationDate, (Date)endOperationDate, (Date)calculationDate, (ChartOfAccountsElementType)ChartOfAccountsElementType.CASH_REMAINS_AGENT, (DictionaryReference)currency, Collections.singletonMap(DimensionType.AGENT, agent)) : BalanceHelper.calculateBalance((EntityReference)agency, (Date)startOperationDate, (Date)endOperationDate, (Date)calculationDate, (ChartOfAccountsElementType)ChartOfAccountsElementType.CASH_REMAINS_AGENT, (DictionaryReference)currency, Collections.singletonMap(DimensionType.CASH_REGISTER_WORKPLACE, cashRegisterWorkplace));
            } else if (agentSettingsEnabled) {
                agentAmount = BalanceHelper.calculateBalance((EntityReference)agency, (Date)startOperationDate, (Date)endOperationDate, (Date)calculationDate, (ChartOfAccountsElementType)ChartOfAccountsElementType.AGENT, (DictionaryReference)currency, Collections.singletonMap(DimensionType.AGENT, agent));
            }
            BigDecimal bigDecimal = agentAmount;
            return bigDecimal;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Throwable t) {
            this.log.error("failed calculating agent amount", t);
            throw new ServiceException("failed calculating agent amount", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public void processAgentTemplateReport(ServiceInvocationContext ctx, EntityContainer<?> reportDocumentContainer, BigDecimal agentDeliverAmount, BigDecimal agentTotalAmount) throws ServiceException {
        DebugUtil.setThreadName((String)"FxReportsServiceImpl-processAgentTemplateReport");
        try {
            this.checkContext(ctx);
            AgentTemplateReportDocument reportDocument = (AgentTemplateReportDocument)reportDocumentContainer.getEntity();
            Date periodEnd = reportDocument.getParameters().getPeriodEnd();
            EntityReference agency = reportDocument.getParameters().getSubagency();
            EntityReference salesPoint = reportDocument.getParameters().getSalesPoint();
            EntityReference cash = reportDocument.getParameters().getCash();
            EntityReference cashRegister = reportDocument.getParameters().getCashRegister();
            EntityReference cashRegisterWorkplace = reportDocument.getParameters().getCashRegisterWorkplace();
            EntityReference agent = reportDocument.getParameters().getAgent();
            if (agentTotalAmount != null && agentDeliverAmount != null) {
                EntityContainer worklogContainer;
                TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.CASH_REMAINS_AGENT_STASH, (EntityReference)agency).documentUid(reportDocumentContainer.getUid()).date(periodEnd).amount(SystemHelper.getMoney((BigDecimal)agentDeliverAmount, (String)DictHelper.getLocalCurrency2())).description("\u041f\u0435\u0440\u0435\u0434\u0430\u0447\u0430 \u043e\u0441\u0442\u0430\u0442\u043a\u0430").creditDimensionData().paymentType(PaymentType.CASH).salesPoint(salesPoint).agent(agent).cash(cash).cashRegister(cashRegister).cashRegisterWorkplace(cashRegisterWorkplace).end().debitDimensionData().paymentType(PaymentType.CASH).salesPoint(salesPoint).agent(agent).cash(cash).cashRegister(cashRegister).cashRegisterWorkplace(cashRegisterWorkplace).end().build();
                HashMap<String, TransactionDataHolder> data = new HashMap<String, TransactionDataHolder>();
                data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
                IbusManager.get().processSync("finance:create-custom-transaction", data);
                BigDecimal agentDifference = MiscUtil.sum((BigDecimal[])new BigDecimal[]{agentTotalAmount, MiscUtil.negate((BigDecimal)agentDeliverAmount)});
                if (agentDifference != null && agentDifference.compareTo(BigDecimal.ZERO) != 0) {
                    transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.CASH_REMAINS_AGENT_CORRECTION, (EntityReference)agency).documentUid(reportDocumentContainer.getUid()).date(periodEnd).amount(SystemHelper.getMoney((BigDecimal)agentDifference, (String)DictHelper.getLocalCurrency2())).description("\u041a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u044f \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0435 \u043e\u0441\u0442\u0430\u0442\u043a\u0430").creditDimensionData().paymentType(PaymentType.CASH).salesPoint(salesPoint).agent(agent).cash(cash).cashRegister(cashRegister).cashRegisterWorkplace(cashRegisterWorkplace).end().debitDimensionData().paymentType(PaymentType.CASH).salesPoint(salesPoint).agent(agent).cash(cash).cashRegister(cashRegister).cashRegisterWorkplace(cashRegisterWorkplace).end().build();
                    data = new HashMap();
                    data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
                    IbusManager.get().processSync("finance:create-custom-transaction", data);
                }
                if ((worklogContainer = EntityStorage.get().resolve(WorklogHelper.getCashierClerkWorklog((EntityReference)cashRegister, (Date)periodEnd))) != null) {
                    Worklog worklog = (Worklog)worklogContainer.getEntity();
                    transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.AGENT_CASH_REGISTER, (EntityReference)agency).documentUid(reportDocumentContainer.getUid()).date(periodEnd).amount(SystemHelper.getMoney((BigDecimal)agentDeliverAmount, (String)DictHelper.getLocalCurrency2())).description("\u041f\u0435\u0440\u0435\u0434\u0430\u0447\u0430 \u0434\u0435\u043d\u0435\u0433 \u043a\u0430\u0441\u0441\u0438\u0440\u0443-\u043e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u0438\u0441\u0442\u0443").creditDimensionData().paymentType(PaymentType.CASH).salesPoint(salesPoint).agent(agent).cash(cash).cashRegister(cashRegister).cashRegisterWorkplace(cashRegisterWorkplace).end().debitDimensionData().paymentType(PaymentType.CASH).salesPoint(worklog.getSalesPoint()).agent(worklog.getEmployee()).cash(worklog.getCash()).cashRegister(worklog.getCashRegister()).cashRegisterWorkplace(worklog.getCashRegisterWorkplace()).end().build();
                    data = new HashMap();
                    data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
                    IbusManager.get().processSync("finance:create-custom-transaction", data);
                    if (agentDifference != null && agentDifference.compareTo(BigDecimal.ZERO) != 0) {
                        transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.AGENT_AGENT_CORRECTION, (EntityReference)agency).documentUid(reportDocumentContainer.getUid()).date(periodEnd).amount(SystemHelper.getMoney((BigDecimal)agentDifference, (String)DictHelper.getLocalCurrency2())).description("\u041a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u044f \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0435 \u0434\u0435\u043d\u0435\u0433 \u043a\u0430\u0441\u0441\u0438\u0440\u0443-\u043e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u0438\u0441\u0442\u0443").creditDimensionData().paymentType(PaymentType.CASH).salesPoint(salesPoint).agent(agent).cash(cash).cashRegister(cashRegister).cashRegisterWorkplace(cashRegisterWorkplace).end().debitDimensionData().paymentType(PaymentType.CASH).salesPoint(salesPoint).agent(agent).cash(cash).cashRegister(cashRegister).cashRegisterWorkplace(cashRegisterWorkplace).end().build();
                        data = new HashMap();
                        data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
                        IbusManager.get().processSync("finance:create-custom-transaction", data);
                    }
                }
            }
            reportDocument.setCommited(true);
            reportDocumentContainer.getVersionInfo().setDataSource("fx-reports-service");
            EntityStorage.get().save(reportDocumentContainer, true);
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("failed registering agent report", t);
            throw new ServiceException("failed registering agent report", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public EntityContainer<Worklog> getWorklogContainer(ServiceInvocationContext ctx, EntityReference<CashRegister> cashRegister, Date periodEnd) throws ServiceException {
        DebugUtil.setThreadName((String)"FxReportsServiceImpl-getWorklogContainer");
        try {
            this.checkContext(ctx);
            EntityContainer entityContainer = EntityStorage.get().resolve(WorklogHelper.getCashierClerkWorklog(cashRegister, (Date)periodEnd));
            return entityContainer;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("failed getting worklog container", t);
            throw new ServiceException("failed getting worklog container", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public DebitSlip createDebitSlip(ServiceInvocationContext ctx, Worklog worklog, Date periodEndDate, Locale locale) throws ServiceException {
        DebugUtil.setThreadName((String)"FxReportsServiceImpl-createDebitSlip");
        try {
            this.checkContext(ctx);
            DebitSlip debitSlip = new DebitSlip();
            debitSlip.setType(DebitSlipType.CASH_REGISTER);
            debitSlip.setDate(periodEndDate);
            EntityReference agency = null;
            EntityContainer salesPointContainer = EntityStorage.get().resolve(worklog.getSalesPoint());
            if (salesPointContainer != null) {
                SalesPoint salesPoint = (SalesPoint)salesPointContainer.getEntity();
                agency = salesPoint.getAgency();
            }
            debitSlip.setOrganization(agency);
            debitSlip.setPayer(agency);
            if (agency != null && worklog.getCashRegister() != null) {
                CurrencyInfoReference currency = new CurrencyInfoReference(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
                BigDecimal amount = BalanceHelper.calculateBalance((EntityReference)agency, (Date)periodEndDate, (Date)new Date(), (ChartOfAccountsElementType)ChartOfAccountsElementType.CASH_REGISTER, (DictionaryReference)currency, Collections.singletonMap(DimensionType.CASH_REGISTER, worklog.getCashRegister()));
                Money money = new Money();
                money.setValue(amount);
                money.setCurrency(currency.getCode());
                debitSlip.setTotalAmount(money);
            }
            debitSlip.setPerson(worklog.getEmployee());
            EntityContainer personContainer = EntityStorage.get().resolve(worklog.getEmployee());
            if (personContainer != null) {
                Person person = (Person)personContainer.getEntity();
                PersonalLocalizableNameFormatter format = new PersonalLocalizableNameFormatter("L F M");
                String personName = format.format((PersonalLocalizableName)person, locale, false);
                debitSlip.setPersonName(personName);
            }
            DebitSlip debitSlip2 = debitSlip;
            return debitSlip2;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("failed creating debit slip", t);
            throw new ServiceException("failed creating debit slip", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public void uncommitAgentTransactions(ServiceInvocationContext ctx, AgentTemplateReportDocument reportDocument, EntityContainer<?> reportDocumentContainer) throws ServiceException {
        DebugUtil.setThreadName((String)"FxReportsServiceImpl-uncommitAgentTransactions");
        try {
            this.checkContext(ctx);
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.documentUid.name(), (Object)reportDocumentContainer.getUid()));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TransactionSplitIndex.Property.historical.name(), (Object)Boolean.FALSE));
            ArrayList<EntityContainer> transactions = new ArrayList<EntityContainer>();
            for (TransactionSplitIndex index : EntityStorage.get().search(TransactionSplitIndex.class, query).getData()) {
                EntityContainer transaction = EntityStorage.get().resolve(index.getSource());
                if (transactions.contains(transaction)) continue;
                transactions.add(transaction);
            }
            for (EntityContainer transaction : transactions) {
                HashMap<String, EntityContainer> data = new HashMap<String, EntityContainer>();
                data.put(IBusFinanceContextKeys.TRANSACTION_CONTAINER.name(), transaction);
                IbusManager.get().processSync("finance:delete-transaction", data);
            }
            reportDocument.setCommited(false);
            reportDocumentContainer.getVersionInfo().setDataSource("fx-reports-service");
            EntityStorage.get().save(reportDocumentContainer, true);
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("failed uncommiting agent transactions", t);
            throw new ServiceException("failed uncommiting agent transactions", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }
}

