/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.async;

import com.gridnine.xtrip.common.fx.async.OrganizationUdidsValuesImportParams;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.fx.async.AsyncTask;
import com.gridnine.xtrip.server.fx.async.TaskExecutionCallback;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class OrganizationUdidsValuesImportAsyncTask
implements AsyncTask<OrganizationUdidsValuesImportParams, Message> {
    public Message execute(OrganizationUdidsValuesImportParams parameters, TaskExecutionCallback callback) throws Exception {
        this.checkInterrupted();
        Message message = new Message();
        message.setType(MessageType.MESSAGE);
        StringBuilder messageDetails = new StringBuilder();
        EntityReference orgRef = parameters.getOrgRef();
        EntityContainer orgCtr = EntityStorage.get().resolve(orgRef);
        Organization org = (Organization)orgCtr.getEntity();
        byte[] fileContent = parameters.getFileContent();
        OrganizationUdidsValuesImportParams.FileExtension fileExtension = parameters.getFileExtension();
        OrganizationUdidsValuesImportParams.ImportCosCodesType importType = parameters.getImportType();
        this.checkInterrupted();
        if (org == null) {
            messageDetails.append(L10nResourcesManager.createL10nMessage((String)"ORGANIZATION_UDIDS_VALUES_IMPORT_ASYNC_TASK_ORGANIZATION_NOT_PROVIDED", (Object[])new Object[0]));
            message.setType(MessageType.WARNING);
        }
        if (fileContent == null) {
            messageDetails.append(L10nResourcesManager.createL10nMessage((String)"ORGANIZATION_UDIDS_VALUES_IMPORT_ASYNC_TASK_FILE_NOT_PROVIDED", (Object[])new Object[0]));
            message.setType(MessageType.WARNING);
        }
        if (message.getType() == MessageType.MESSAGE) {
            HashMap values = new HashMap();
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(fileContent);
                 XSSFWorkbook workbook = fileExtension == OrganizationUdidsValuesImportParams.FileExtension.XLSX ? new XSSFWorkbook((InputStream)inputStream) : new HSSFWorkbook((InputStream)inputStream);){
                this.checkInterrupted();
                Sheet sheet = workbook.getSheetAt(0);
                Row row = sheet.getRow(0);
                ArrayList<String> headers = new ArrayList<String>();
                for (int q = 0; q < row.getLastCellNum(); ++q) {
                    if (q % 3 != 0) continue;
                    String headerValue = row.getCell(q).getStringCellValue();
                    headers.add(headerValue);
                    values.put(headerValue, new ArrayList());
                }
                for (int rowIndex = 2; rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
                    row = sheet.getRow(rowIndex);
                    for (int q = 0; q < headers.size(); ++q) {
                        String value = this.getUdidValueFromCell(row, q * 3);
                        String ruValue = this.getUdidValueFromCell(row, q * 3 + 1);
                        String enValue = this.getUdidValueFromCell(row, q * 3 + 2);
                        if (TextUtil.isBlank((String)value) && TextUtil.isBlank((String)ruValue) && TextUtil.isBlank((String)enValue)) continue;
                        if (TextUtil.isBlank((String)value)) {
                            if (TextUtil.nonBlank((String)enValue)) {
                                value = enValue;
                            } else if (TextUtil.nonBlank((String)ruValue)) {
                                enValue = value = ProfileHelper.translitUdid((String)ruValue);
                            }
                        }
                        if (TextUtil.isBlank((String)enValue)) {
                            enValue = value;
                        }
                        if (TextUtil.isBlank((String)ruValue)) {
                            ruValue = value;
                        }
                        ArrayList<String> valuesList = new ArrayList<String>();
                        valuesList.add(0, value);
                        valuesList.add(1, ruValue);
                        valuesList.add(2, enValue);
                        ((List)values.get(headers.get(q))).add(valuesList);
                    }
                }
                this.checkInterrupted();
                ArrayList<CostCode> costCodes = new ArrayList<CostCode>();
                if (importType == OrganizationUdidsValuesImportParams.ImportCosCodesType.APPEND) {
                    costCodes.addAll(org.getCostCodes());
                }
                for (Map.Entry entry : values.entrySet()) {
                    this.checkInterrupted();
                    if (TextUtil.isBlank((String)((String)entry.getKey()))) continue;
                    CostCodeProperties costCodeProp = null;
                    for (CostCodeProperties existProp : org.getCostCodeProperties()) {
                        CostCodeCategory category = (CostCodeCategory)DictionaryCache.get().resolveReference(existProp.getCategory());
                        if (category == null || !((String)entry.getKey()).equals(category.getShortName())) continue;
                        costCodeProp = existProp;
                        break;
                    }
                    if (costCodeProp == null) {
                        if (message.getType() == MessageType.MESSAGE) {
                            message.setType(MessageType.WARNING);
                        }
                        messageDetails.append(L10nResourcesManager.createL10nMessage((String)"ORGANIZATION_UDIDS_VALUES_IMPORT_ASYNC_TASK_UDID_NOT_FOUND", (Object[])new Object[]{entry.getKey()}));
                        continue;
                    }
                    int added = 0;
                    CostCodeProperties properties = costCodeProp;
                    for (List value : (List)entry.getValue()) {
                        if (value == null) continue;
                        CostCode existCostCode = costCodes.stream().filter(item -> properties.equals((Object)item.getCostCodeProperties()) && (MiscUtil.equals((Object)item.getValue(), value.get(0)) || MiscUtil.equals((Object)item.getLocalValue(), value.get(1)) || MiscUtil.equals((Object)item.getEnglishValue(), value.get(2)))).findFirst().orElse(null);
                        if (existCostCode == null) {
                            CostCode costCode = new CostCode();
                            costCode.setCostCodeProperties(costCodeProp);
                            costCode.setValue((String)value.get(0));
                            costCode.setLocalValue((String)value.get(1));
                            costCode.setEnglishValue((String)value.get(2));
                            costCodes.add(costCode);
                            ++added;
                            continue;
                        }
                        if (TextUtil.isBlank((String)existCostCode.getValue())) {
                            existCostCode.setValue((String)value.get(0));
                        }
                        if (TextUtil.isBlank((String)existCostCode.getLocalValue())) {
                            existCostCode.setLocalValue((String)value.get(1));
                        }
                        if (!TextUtil.isBlank((String)existCostCode.getEnglishValue())) continue;
                        existCostCode.setEnglishValue((String)value.get(2));
                    }
                    messageDetails.append(L10nResourcesManager.createL10nMessage((String)"ORGANIZATION_UDIDS_VALUES_IMPORT_ASYNC_TASK_UDID_IMPORT_RESULT", (Object[])new Object[]{entry.getKey(), String.valueOf(added)}));
                }
                this.checkInterrupted();
                LockUtil.lock((EntityContainer)orgCtr, organizationCtr -> {
                    if (organizationCtr != null && organizationCtr.getEntity() != null) {
                        Organization organization = (Organization)organizationCtr.getEntity();
                        organization.getCostCodes().clear();
                        organization.getCostCodes().addAll(costCodes);
                        this.checkInterrupted();
                        organizationCtr.getVersionInfo().setDataSource("fx-import-udids-values-task");
                        EntityStorage.get().save(organizationCtr, true);
                    }
                });
            }
        }
        if (message.getType() == MessageType.MESSAGE) {
            message.setMessage(L10nResourcesManager.createL10nMessage((String)"ORGANIZATION_UDIDS_VALUES_IMPORT_ASYNC_TASK_SUCCESS", (Object[])new Object[0]));
        } else if (message.getType() == MessageType.WARNING) {
            message.setMessage(L10nResourcesManager.createL10nMessage((String)"ORGANIZATION_UDIDS_VALUES_IMPORT_ASYNC_TASK_WARNING", (Object[])new Object[0]));
        } else if (message.getType() == MessageType.ERROR) {
            message.setMessage(L10nResourcesManager.createL10nMessage((String)"ORGANIZATION_UDIDS_VALUES_IMPORT_ASYNC_TASK_ERROR", (Object[])new Object[0]));
        }
        message.setDetails(messageDetails.toString());
        return message;
    }

    private String getUdidValueFromCell(Row row, int colIndex) {
        if (row == null) {
            return null;
        }
        Cell cell = row.getCell(colIndex);
        if (cell == null) {
            return null;
        }
        String value = 0 == cell.getCellType() ? this.fmt(row.getCell(colIndex).getNumericCellValue()) : row.getCell(colIndex).getStringCellValue();
        return value;
    }

    private String fmt(double d) {
        int i = (int)d;
        return d == (double)i ? String.valueOf(i) : String.valueOf(d);
    }
}

