/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.async.entityactions;

import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.model.support.BugReportProcessingParameters;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.misc.EntityStorageThreadContext;
import com.gridnine.xtrip.common.model.support.BaseBugReport;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.exchange.ImportData;
import com.gridnine.xtrip.common.model.system.exchange.ImportType;
import com.gridnine.xtrip.common.model.system.exchange.ItemImportSettings;
import com.gridnine.xtrip.server.fx.async.AsyncTask;
import com.gridnine.xtrip.server.fx.async.TaskExecutionCallback;
import com.gridnine.xtrip.server.fx.async.entityactions.CallbackWrapperHelper;
import com.gridnine.xtrip.server.model.helpers.ExportImportHelper;
import com.gridnine.xtrip.server.model.tasks.AsyncServerTask;
import java.util.Set;
import java.util.stream.Collectors;

public class BugReportImportAsyncTask
implements AsyncTask<BugReportProcessingParameters, Object> {
    public Object execute(BugReportProcessingParameters parameters, TaskExecutionCallback callback) throws Exception {
        EntityStorageThreadContext.execute(() -> {
            EntityContainer reportCtr = EntityStorage.get().resolve(parameters.getReport());
            ItemImportSettings importSettings = new ItemImportSettings();
            importSettings.setGroup(true);
            importSettings.setObjectId("root");
            importSettings.setImportType(parameters.getImportType() == null ? ImportType.DONT_REPLACE : parameters.getImportType());
            ImportData importData = new ImportData();
            importData.setSettings(importSettings);
            importData.getItems().addAll(((BaseBugReport)reportCtr.getEntity()).getExportedItems());
            Set<String> objectIds = importData.getItems().stream().map(it -> it.getObjectId()).collect(Collectors.toSet());
            objectIds.forEach(id -> {
                ItemImportSettings objectSettings = new ItemImportSettings();
                objectSettings.setObjectId(id);
                objectSettings.setParent(importSettings);
                objectSettings.setImportType(importSettings.getImportType());
                importSettings.getChildren().add(objectSettings);
            });
            if (Thread.interrupted()) {
                callback.addMessages(new Message[]{Messages.getNotificationImportInterrupted()});
                throw new InterruptedException();
            }
            ExportImportHelper.importData((ImportData)importData, (AsyncServerTask.Callback)CallbackWrapperHelper.createCallbackWrapper(callback));
            callback.setProgress((byte)100, Messages.getImportEnded());
        });
        return null;
    }
}

