/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.async.entityactions;

import com.gridnine.xtrip.common.fx.rpc.ColumnSettings;
import com.gridnine.xtrip.common.fx.rpc.ExportProperties;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;

public class CSVExporter {
    static void createHeader(ExportProperties settings, PrintWriter out, AtomicBoolean firstColumn, AtomicBoolean useCustomRecordDelimiter, UserSettings userSettings) {
        settings.getColumnProperties().forEach(property -> {
            ColumnSettings tableSettings = (ColumnSettings)property;
            CSVExporter.write(tableSettings.getDisplayName(), true, out, firstColumn, useCustomRecordDelimiter, userSettings);
        });
        firstColumn.set(true);
        out.println();
    }

    static void createRow(ExportProperties settings, EntityIndex<BaseEntity> idx, PrintWriter out, AtomicBoolean firstColumn, AtomicBoolean useCustomRecordDelimiter, UserSettings userSettings) {
        settings.getColumnProperties().forEach(property -> {
            ColumnSettings tableSettings = (ColumnSettings)property;
            CSVExporter.write(CSVExporter.value2str(idx.getValue(tableSettings.getId())), true, out, firstColumn, useCustomRecordDelimiter, userSettings);
        });
        firstColumn.set(true);
        out.println();
    }

    static void write(String data, boolean preserveSpaces, PrintWriter out, AtomicBoolean firstColumn, AtomicBoolean useCustomRecordDelimiter, UserSettings userSettings) {
        boolean textQualify;
        String content;
        String string = content = data == null ? "" : data.trim();
        if (!firstColumn.get()) {
            out.write(userSettings.delimiter);
        }
        if (!(textQualify = userSettings.forceQualifier) && userSettings.useTextQualifier && (content.indexOf(userSettings.textQualifier) > -1 || content.indexOf(userSettings.delimiter) > -1 || !useCustomRecordDelimiter.get() && (content.indexOf(10) > -1 || content.indexOf(13) > -1) || useCustomRecordDelimiter.get() && content.indexOf(userSettings.recordDelimiter) > -1 || firstColumn.get() && content.length() > 0 && content.charAt(0) == userSettings.comment || firstColumn.get() && content.length() == 0)) {
            textQualify = true;
        }
        if (userSettings.useTextQualifier && !textQualify && content.length() > 0 && preserveSpaces) {
            char lastLetter;
            char firstLetter = content.charAt(0);
            if (firstLetter == ' ' || firstLetter == '\t') {
                textQualify = true;
            }
            if (!(textQualify || content.length() <= 1 || (lastLetter = content.charAt(content.length() - 1)) != ' ' && lastLetter != '\t')) {
                textQualify = true;
            }
        }
        if (textQualify) {
            out.write(userSettings.textQualifier);
            if (userSettings.escapeMode == EscapeMode.BACKSLASH) {
                content = CSVExporter.replace(content, "\\", "\\\\");
                content = CSVExporter.replace(content, "" + userSettings.textQualifier, "\\" + userSettings.textQualifier);
            } else {
                content = CSVExporter.replace(content, "" + userSettings.textQualifier, "" + userSettings.textQualifier + userSettings.textQualifier);
            }
        } else if (userSettings.escapeMode == EscapeMode.BACKSLASH) {
            content = CSVExporter.replace(content, "\\", "\\\\");
            content = CSVExporter.replace(content, "" + userSettings.delimiter, "\\" + userSettings.delimiter);
            if (useCustomRecordDelimiter.get()) {
                content = CSVExporter.replace(content, "" + userSettings.recordDelimiter, "\\" + userSettings.recordDelimiter);
            } else {
                content = CSVExporter.replace(content, "\r", "\\\r");
                content = CSVExporter.replace(content, "\n", "\\\n");
            }
            if (firstColumn.get() && content.length() > 0 && content.charAt(0) == userSettings.comment) {
                content = content.length() > 1 ? "\\" + userSettings.comment + content.substring(1) : "\\" + userSettings.comment;
            }
        }
        out.write(content);
        if (textQualify) {
            out.write(userSettings.textQualifier);
        }
        firstColumn.set(false);
    }

    private static String replace(String original, String pattern, String replace) {
        int len = pattern.length();
        int found = original.indexOf(pattern);
        if (found > -1) {
            StringBuffer sb = new StringBuffer();
            int start = 0;
            while (found != -1) {
                sb.append(original.substring(start, found));
                sb.append(replace);
                start = found + len;
                found = original.indexOf(pattern, start);
            }
            sb.append(original.substring(start));
            return sb.toString();
        }
        return original;
    }

    private static String value2str(Object value) {
        if (value instanceof Iterable) {
            StringBuilder buf = new StringBuilder();
            for (Object obj : (Iterable)value) {
                String val = CSVExporter.value2str(obj);
                if (TextUtil.isBlank((String)val)) continue;
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(val);
            }
            return buf.toString();
        }
        if (value == null) {
            return "";
        }
        if (value instanceof Date) {
            return new SimpleDateFormat("dd/MM/yyyy").format((Date)value);
        }
        if (value instanceof Number) {
            return new DecimalFormat("#0.00").format(value);
        }
        return value.toString();
    }

    static class UserSettings {
        char textQualifier = (char)34;
        boolean useTextQualifier = true;
        char delimiter = (char)44;
        char recordDelimiter = '\u0000';
        char comment = (char)35;
        EscapeMode escapeMode = EscapeMode.DOUBLED;
        boolean forceQualifier = false;
    }

    private static class Letters {
        static final char LF = '\n';
        static final char CR = '\r';
        static final char QUOTE = '\"';
        static final char COMMA = ',';
        static final char SPACE = ' ';
        static final char TAB = '\t';
        static final char POUND = '#';
        static final char BACKSLASH = '\\';
        static final char NULL = '\u0000';

        private Letters() {
        }
    }

    static enum EscapeMode {
        DOUBLED,
        BACKSLASH;

    }
}

