/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.async.entityactions;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.system.BaseDeleteEntitiesResult;
import com.gridnine.xtrip.common.model.system.DeleteEntitiesParameters;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.fx.async.AsyncTask;
import com.gridnine.xtrip.server.fx.async.TaskExecutionCallback;
import com.gridnine.xtrip.server.model.handlers.DeleteEntityHandler;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class DeleteEntitiesCustomAsyncTask
implements AsyncTask<DeleteEntitiesParameters, BaseDeleteEntitiesResult> {
    public BaseDeleteEntitiesResult execute(DeleteEntitiesParameters parameters, TaskExecutionCallback callback) throws Exception {
        BaseDeleteEntitiesResult result = this.deleteReferences(parameters);
        callback.addMessages((Collection)result.getMessages());
        return result;
    }

    private <E extends BaseEntity> BaseDeleteEntitiesResult deleteReferences(DeleteEntitiesParameters parameters) {
        List references = parameters.getReferences();
        CollectionUtil.requireNonEmpty((Collection)references, (String)"no objects for delete");
        Class entityType = ((EntityReference)references.get(0)).getType();
        DeleteEntityHandler handler = ServerHandlersRegistry.get().findDeleteEntitiesHandler(entityType);
        Objects.requireNonNull(handler, () -> String.format("delete handler for class %s is not found", entityType));
        return handler.delete((Collection)references);
    }
}

