/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.async.entityactions;

import com.gridnine.xtrip.common.fx.assets.ActivityItem;
import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DeleteEntitiesProperties;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Referenceable;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.BaseDeleteEntitiesResult;
import com.gridnine.xtrip.common.model.system.ChangeData;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.fx.async.AsyncTask;
import com.gridnine.xtrip.server.fx.async.TaskExecutionCallback;
import com.gridnine.xtrip.server.model.handlers.DeleteEntityHandler;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DeleteEntitiesQueryAsyncTask<E extends BaseEntity, I extends EntityIndex<E>>
implements AsyncTask<DeleteEntitiesProperties<E, I>, ChangeData> {
    public ChangeData execute(DeleteEntitiesProperties<E, I> parameters, TaskExecutionCallback callback) throws Exception {
        this.checkInterrupted();
        if (parameters.getEntityIndexType() == null && parameters.getQuery() == null) {
            callback.addMessages(new Message[]{Messages.getExceptionDelete()});
            return null;
        }
        callback.setProgress((byte)0, "");
        SearchQuery query = parameters.getQuery();
        ProjectionQuery projectionQuery = new ProjectionQuery();
        projectionQuery.getProjections().add(Projection.rowCount((String)"totalCount"));
        EntityStorage storage = EntityStorage.get();
        this.checkInterrupted();
        ChangeData result = new ChangeData();
        int totalCount = storage.search(parameters.getEntityIndexType(), projectionQuery).getInt("totalCount");
        float step = 100.0f / (float)totalCount;
        int deletedCount = 0;
        float progress = 0.0f;
        ArrayList notDeletableObjects = new ArrayList();
        do {
            boolean onlyNotDeletableObjects;
            this.checkInterrupted();
            Map references = storage.search(parameters.getEntityIndexType(), query).getData().stream().map(index -> index instanceof Referenceable ? ((Referenceable)index).getRef() : index.getSource()).map(ref -> ref).collect(Collectors.groupingBy(EntityReference::getType, Collectors.toSet()));
            if (references.isEmpty() || (onlyNotDeletableObjects = references.values().stream().flatMap(Collection::stream).allMatch(notDeletableObjects::contains))) break;
            for (Map.Entry entry : references.entrySet()) {
                this.checkInterrupted();
                DeleteEntityHandler handler = ServerHandlersRegistry.get().findDeleteEntitiesHandler(entry.getKey());
                if (handler == null) {
                    for (EntityReference reference : entry.getValue()) {
                        try {
                            this.checkInterrupted();
                            Set<String> owners = this.getLockOwners((EntityReference<BaseEntity>)reference);
                            if (!owners.isEmpty() && (owners.size() != 1 || !owners.contains(parameters.getUser()))) continue;
                            storage.delete(reference);
                            result.getDeleted().add(reference);
                            callback.setProgress((byte)(progress += step), "");
                            ++deletedCount;
                        }
                        catch (ServiceException owners) {}
                    }
                    continue;
                }
                BaseDeleteEntitiesResult deleteResult = handler.delete((Collection)entry.getValue());
                callback.addMessages((Collection)deleteResult.getMessages());
                ChangeData changeData = deleteResult.getChangeData();
                result.getChanged().addAll(changeData.getChanged());
                result.getDeleted().addAll(changeData.getDeleted());
                callback.setProgress((byte)(progress += step * (float)changeData.getDeleted().size()), "");
                deletedCount += changeData.getDeleted().size();
                ArrayList notDeletedObjects = new ArrayList(entry.getValue());
                notDeletedObjects.removeAll(changeData.getDeleted());
                notDeletableObjects.addAll(notDeletedObjects);
            }
        } while (deletedCount != totalCount);
        callback.addMessages(new Message[]{Messages.getNotificationDeleted((Integer)deletedCount, (Integer)totalCount)});
        return result;
    }

    private Set<String> getLockOwners(EntityReference<? extends BaseEntity> ref) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.like((String)ActivityItem.Property.lockToken.name(), (String)('%' + ref.getUid() + '%')));
        query.getPreferredProperties().add(ActivityItem.Property.owner.name());
        List lockedItems = AssetsStorage.get().search(ActivityItem.class, query).getData();
        HashSet<String> result = new HashSet<String>();
        for (ActivityItem item : lockedItems) {
            if (item.getOwner() == null) continue;
            result.add(item.getOwner());
        }
        return result;
    }
}

