/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.async.entityactions;

import com.gridnine.xtrip.common.fx.rpc.ColumnSettings;
import com.gridnine.xtrip.common.fx.rpc.ExportProperties;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;

public class ExcelExporter {
    static void collectCellStyles(ExportProperties settings, HSSFCellStyle dateTimeCellStyle, Map<String, HSSFCellStyle> cellStyles) {
        settings.getColumnProperties().forEach(property -> {
            ColumnSettings columnProperty = (ColumnSettings)property;
            if (columnProperty.getType().equals(Date.class.getName())) {
                cellStyles.put(columnProperty.getId(), dateTimeCellStyle);
            }
        });
    }

    static void createHeader(ExportProperties settings, HSSFSheet sheet, HSSFWorkbook wb) {
        HSSFRow headerRow = sheet.createRow(0);
        HSSFCellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setBoldweight((short)700);
        style.setFont(font);
        AtomicInteger i = new AtomicInteger(0);
        settings.getColumnProperties().forEach(property -> {
            ColumnSettings tableSettings = (ColumnSettings)property;
            HSSFCell cell = headerRow.createCell(i.getAndIncrement());
            cell.setCellStyle(style);
            cell.setCellValue((RichTextString)new HSSFRichTextString(tableSettings.getDisplayName()));
        });
    }

    static void createRow(ExportProperties settings, EntityIndex<BaseEntity> idx, HSSFSheet sheet, Map<String, HSSFCellStyle> cellStyles) {
        AtomicInteger i = new AtomicInteger(0);
        HSSFRow row = sheet.createRow(sheet.getLastRowNum() + 1);
        settings.getColumnProperties().forEach(property -> {
            ColumnSettings tableSettings = (ColumnSettings)property;
            ExcelExporter.setCellValue(row.createCell(i.getAndIncrement()), idx.getValue(tableSettings.getId()), tableSettings.getId(), tableSettings, cellStyles);
        });
    }

    private static void setCellValue(HSSFCell cell, Object value, String propName, ColumnSettings field, Map<String, HSSFCellStyle> cellStyles) {
        if (value == null) {
            cell.setCellValue((RichTextString)((HSSFRichTextString)null));
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
            cell.setCellStyle(cellStyles.get(propName));
        } else if (value instanceof BigDecimal) {
            cell.setCellValue(((BigDecimal)value).setScale(2, RoundingMode.HALF_UP).doubleValue());
        } else if (value instanceof Number) {
            cell.setCellValue(((Number)value).doubleValue());
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else {
            cell.setCellValue((RichTextString)new HSSFRichTextString(ExcelExporter.value2str(value)));
        }
    }

    private static String value2str(Object value) {
        if (value instanceof Iterable) {
            StringBuilder buf = new StringBuilder();
            for (Object obj : (Iterable)value) {
                String val = ExcelExporter.value2str(obj);
                if (TextUtil.isBlank((String)val)) continue;
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(val);
            }
            return buf.toString();
        }
        if (value == null) {
            return "";
        }
        if (value instanceof Number) {
            return new DecimalFormat("#0.00").format(value);
        }
        return value.toString();
    }
}

