/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.async.entityactions;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.ExportProperties;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.ProcessingStatus;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.server.fx.async.AsyncTask;
import com.gridnine.xtrip.server.fx.async.TaskExecutionCallback;
import com.gridnine.xtrip.server.parsers.ExchangeProcessHelper;
import com.gridnine.xtrip.server.parsers.ExchangeProcessor;
import com.gridnine.xtrip.server.parsers.ExchangeProcessorRegistry;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ExchangeFilesProcessAsyncTask
implements AsyncTask<ExportProperties, Void> {
    public Void execute(ExportProperties parameters, TaskExecutionCallback callback) throws Exception {
        ExchangeFilesProcessAsyncTask.checkInterruption();
        if (parameters.getReferenceList().size() == 1) {
            this.processExchangeFile(parameters, callback);
        } else {
            this.processExchangeFiles(parameters, callback);
        }
        return null;
    }

    private void processExchangeFile(ExportProperties parameters, TaskExecutionCallback callback) throws Exception {
        ExchangeFilesProcessAsyncTask.checkInterruption();
        callback.setProgress((byte)10, "");
        EntityContainer container = EntityStorage.get().resolve((EntityReference)parameters.getReferenceList().get(0));
        callback.setProgress((byte)30, "");
        ExchangeProcessHelper.processExchangeDocument((EntityContainer)container);
        callback.setProgress((byte)90, "");
    }

    private void processExchangeFiles(ExportProperties parameters, TaskExecutionCallback callback) throws Exception {
        ExchangeFilesProcessAsyncTask.checkInterruption();
        float progress = 20.0f;
        float step = 80.0f;
        parameters.getQuery().getCriteria().getCriterions().add(SearchCriterion.in((String)"uid", (Object[])parameters.getUids().toArray()));
        List data = EntityStorage.get().search(parameters.getEntityIndexType(), parameters.getQuery()).getData();
        if (data.size() != 0) {
            step /= (float)data.size();
            EntityContainer container = EntityStorage.get().resolve(((EntityIndex)data.get(0)).getSource());
            ExchangeProcessor processor = ((ExchangeProcessorRegistry)Environment.getPublished(ExchangeProcessorRegistry.class)).get(((BaseExchangeDocument)container.getEntity()).getType());
            if (processor == null) {
                ((BaseExchangeDocument)container.getEntity()).getMessages().clear();
                ((BaseExchangeDocument)container.getEntity()).getMessages().add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"ExchangeFilesProcess_ProcessorsNotFound", (Object[])new Object[]{((BaseExchangeDocument)container.getEntity()).getType()}));
                ((BaseExchangeDocument)container.getEntity()).setStatus(ProcessingStatus.ERROR);
                container.getVersionInfo().setDataSource("process exchange doc");
                EntityStorage.get().save(container, true);
                throw new Exception("no processors found for file type " + ((BaseExchangeDocument)container.getEntity()).getType());
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            processor.sortSearchResults(data);
        }
        ExchangeFilesProcessAsyncTask.checkInterruption();
        callback.setProgress((byte)progress, "");
        for (EntityIndex index : data) {
            if (parameters.getUids().contains(index.getUid())) {
                LockUtil.lock((EntityReference)index.getSource(), (long)10L, (TimeUnit)TimeUnit.SECONDS, () -> {
                    EntityContainer container = EntityStorage.get().resolve(index.getSource());
                    ExchangeProcessHelper.processExchangeDocument((EntityContainer)container);
                }, () -> callback.addMessages(new Message[]{Messages.getWarningFailedToTakeLock((EntityReference)index.getSource())}));
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            callback.setProgress((byte)(progress += step), "");
        }
    }

    private static void checkInterruption() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }
}

