/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.async.entityactions;

import com.gridnine.xtrip.common.fx.async.ExportAgainAsyncTaskParameters;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.BasicExportSettingsIndex;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.server.fx.async.AsyncTask;
import com.gridnine.xtrip.server.fx.async.TaskExecutionCallback;
import com.gridnine.xtrip.server.model.export.service.ExportDocumentsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportAgainAsyncTask<T extends BaseEntity>
implements AsyncTask<ExportAgainAsyncTaskParameters<T>, Void> {
    private static final Logger log = LoggerFactory.getLogger(ExportAgainAsyncTask.class);

    public Void execute(ExportAgainAsyncTaskParameters<T> parameters, TaskExecutionCallback callback) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicExportSettingsIndex.Property.createDocuments.name(), (Object)true));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicExportSettingsIndex.Property.sendData.name(), (Object)true));
        SearchResult res = EntityStorage.get().search(BasicExportSettingsIndex.class, query);
        if (res.getTotalCount() == 0) {
            log.error("reexporting: no settings with createDocuments and sendData equals true");
            throw new ServiceException("no settings with createDocuments and sendData equals true");
        }
        for (EntityReference reference : parameters.getEntities()) {
            String title = reference.getUid();
            try {
                EntityContainer ctr = EntityStorage.get().resolve(reference);
                title = ctr.getEntity().toString();
                log.debug("reexporting " + title);
                ExportDocumentsHelper.createExportDocuments((EntityContainer)ctr, (boolean)false, null);
            }
            catch (Throwable t) {
                log.error(String.format("failed create export document for %s: %s", title, t.getMessage()), t);
                throw new ServiceException("failed create export document " + title, t);
            }
        }
        return null;
    }
}

