/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.async.entityactions;

import com.gridnine.xtrip.common.fx.async.JoinBookingFileCreateTaskParameters;
import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.meta.BaseClassType;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.DeskEntry;
import com.gridnine.xtrip.common.model.assets.SysLogItem;
import com.gridnine.xtrip.common.model.booking.AppliedRule;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.entity.cache.EntityCacheManager;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.BillingItemsList;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.JoinBookingFileHandler;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.TravellerHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclEntityResources;
import com.gridnine.xtrip.common.model.system.BaseFileDocument;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.fx.async.AsyncTask;
import com.gridnine.xtrip.server.fx.async.TaskExecutionCallback;
import com.gridnine.xtrip.server.model.handlers.ProductReferencesHandler;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.restriction.helper.RestrictionsHelper;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinBookingFileAsyncTask
implements AsyncTask<JoinBookingFileCreateTaskParameters, EntityReference<BookingFile>> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public EntityReference<BookingFile> execute(JoinBookingFileCreateTaskParameters parameters, TaskExecutionCallback callback) throws Exception {
        EntityContainer<BookingFile> bookingFileDestination;
        if (!parameters.isTransferToNewBookingFile()) {
            bookingFileDestination = EntityStorage.get().resolve(parameters.getNewBookingFile());
            if (!this.checkAccess(bookingFileDestination, parameters.getUser(), callback) || !this.checkLocked(bookingFileDestination, parameters.getUser(), callback)) {
                return null;
            }
        } else {
            bookingFileDestination = this.createBookingFileContainer(parameters.getUser());
        }
        if (parameters.getTargetClient() != null) {
            ((BookingFile)bookingFileDestination.getEntity()).setCustomerProfile(parameters.getTargetClient());
        }
        HashSet<BaseProduct> processedProducts = new HashSet<BaseProduct>();
        HashSet setBfCtrTemp = new HashSet();
        parameters.getUidsOfSelectedProductsAndBF().forEach((kew, value) -> setBfCtrTemp.add(EntityStorage.get().resolve(value)));
        ArrayList<Message> messages = new ArrayList<Message>();
        ArrayList<EntityReference> deletedBookingFiles = new ArrayList<EntityReference>();
        HashMap<EntityContainer, List> infoForMovingToMap = new HashMap<EntityContainer, List>();
        HashMap<Traveller, Traveller> travellers = new HashMap<Traveller, Traveller>();
        for (JoinBookingFileHandler handler : HandlersRegistry.get().getAllJoinBookingFileHandlers()) {
            List messageList = handler.setSMSite(bookingFileDestination, setBfCtrTemp);
            if (messageList.isEmpty()) continue;
            callback.addMessages((Collection)messageList);
            return null;
        }
        for (EntityContainer bookingFileSource : setBfCtrTemp) {
            if (!this.checkAccess((EntityContainer<BookingFile>)bookingFileSource, parameters.getUser(), callback) || !this.checkLocked((EntityContainer<BookingFile>)bookingFileSource, parameters.getUser(), callback)) {
                return null;
            }
            HashSet<BaseProduct> productsForMoving = new HashSet<BaseProduct>();
            for (Reservation res : ((BookingFile)bookingFileSource.getEntity()).getReservations()) {
                for (BaseProduct product2 : res.getProducts()) {
                    if (!parameters.getUidsOfSelectedProductsAndBF().containsKey(product2.getUid()) || !this.checkAccess(product2, parameters.getUser(), callback) || productsForMoving.contains(product2)) continue;
                    productsForMoving.addAll(GeneralProductHelper.getRelatedProducts((BaseProduct)product2));
                    productsForMoving.add(product2);
                }
            }
            this.addProduct(productsForMoving, (EntityContainer<BookingFile>)bookingFileSource, bookingFileDestination, travellers, parameters);
            this.deleteProduct(productsForMoving, (EntityContainer<BookingFile>)bookingFileSource);
            String productNumbers = productsForMoving.stream().flatMap(product -> ProductHandler.of((BaseProduct)product).getProductNumbers(product).stream()).filter(TextUtil::nonBlank).collect(Collectors.joining(", "));
            processedProducts.addAll(productsForMoving);
            messages.add(Messages.getProductMovedFromBookingFile((String)productNumbers, (String)bookingFileSource.toReference().toString()));
            if (parameters.isDeleteEmptyBookingFiles() && this.isEmpty((BookingFile)bookingFileSource.getEntity())) {
                EntityStorage.get().delete(bookingFileSource);
                deletedBookingFiles.add(bookingFileSource.toReference());
                continue;
            }
            this.saveBookingFile((EntityContainer<BookingFile>)bookingFileSource);
            for (BaseProduct bp : productsForMoving) {
                List infoForMovingToList = infoForMovingToMap.getOrDefault(bookingFileSource, new ArrayList());
                infoForMovingToList.add(ProductHandler.of((BaseProduct)bp).generateShortProductName(bp));
                infoForMovingToMap.put(bookingFileSource, infoForMovingToList);
            }
        }
        this.saveBookingFile(bookingFileDestination);
        String bfDestinationNumber = ((BookingFile)bookingFileDestination.getEntity()).getNumber();
        for (Map.Entry entry : infoForMovingToMap.entrySet()) {
            String productsInfo = ((List)entry.getValue()).stream().collect(Collectors.joining("; ", " ", ""));
            SysLogHelper.audit((EntityReference)((EntityContainer)entry.getKey()).toReference(), (String)"entity-modification", (Message[])new Message[]{Messages.getProductMovedToBookingFile((String)bfDestinationNumber, (String)productsInfo)});
        }
        for (ProductReferencesHandler handler : ServerHandlersRegistry.get().getAllProductReferencesHandlers()) {
            handler.changeReferences(processedProducts, bookingFileDestination, deletedBookingFiles, travellers, "fx-join-booking-file-task");
        }
        messages.forEach(message -> SysLogHelper.audit((EntityReference)bookingFileDestination.toReference(), (String)"entity-modification", (Message[])new Message[]{message}));
        EntityCacheManager.get().check();
        if (parameters.isTransferToNewBookingFile()) {
            return bookingFileDestination.toReference();
        }
        return null;
    }

    private void saveBookingFile(EntityContainer<BookingFile> bookingFileContainer) {
        bookingFileContainer.getVersionInfo().setDataSource("fx-join-booking-file-task");
        EntityContainer newBfc = EntityStorage.get().save(bookingFileContainer, true);
        BookingFile bf = (BookingFile)bookingFileContainer.getEntity();
        if (TextUtil.isBlank((String)bf.getNumber())) {
            bf.setNumber(((BookingFile)newBfc.getEntity()).getNumber());
        }
        SysLogHelper.audit((EntityReference)newBfc.toReference(), (String)"entity-modification", (Message[])new Message[]{Messages.getBookingFileWasUpdateDueToJoin()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProduct(Collection<BaseProduct> productsForMoving, EntityContainer<BookingFile> bookingFileSource, EntityContainer<BookingFile> bookingFileDestination, Map<Traveller, Traveller> travellers, JoinBookingFileCreateTaskParameters parameters) throws Exception {
        BookingFile oldBf = (BookingFile)bookingFileSource.getEntity();
        BookingFile newBf = (BookingFile)bookingFileDestination.getEntity();
        boolean firstTime = true;
        for (BaseProduct product : productsForMoving) {
            Reservation res = product.getReservation();
            Reservation newRes = null;
            for (Reservation r : newBf.getReservations()) {
                if (r == null || !CommonReservationGdsNameInfoHelper.recordLocatorsMatch((Reservation)r, (Reservation)res)) continue;
                newRes = r;
                break;
            }
            if (newRes == null) {
                BookingFile booking = res.getBookingFile();
                res.setBookingFile(null);
                ArrayList products = new ArrayList(res.getProducts());
                res.getProducts().clear();
                try {
                    newRes = (Reservation)XCloneHelper.clone((XCloneable)res, (boolean)true);
                }
                finally {
                    res.setBookingFile(booking);
                    res.getProducts().addAll(products);
                }
                newBf.getReservations().add(newRes);
                newRes.setBookingFile(newBf);
            }
            if (firstTime) {
                if (newBf.getAgency() == null) {
                    newBf.setAgency(oldBf.getAgency());
                }
                if (newBf.getCustomerProfile() == null) {
                    newBf.setCustomerProfile(oldBf.getCustomerProfile());
                }
                if (newBf.getWorkflowStatus() == null) {
                    newBf.setWorkflowStatus(oldBf.getWorkflowStatus());
                }
                if (TextUtil.isBlank((String)newBf.getCustomer().getName()) && newBf.getCustomer().getProfile() == null && (TextUtil.nonBlank((String)oldBf.getCustomer().getName()) || oldBf.getCustomer().getProfile() != null)) {
                    BookingHelper.copyCustomer((Customer)newBf.getCustomer(), (Customer)oldBf.getCustomer());
                }
                firstTime = false;
            }
            ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
            HashMap<Traveller, Traveller> productTravellers = new HashMap<Traveller, Traveller>();
            for (Traveller prodTraveller : handler.getTravellers(product)) {
                Traveller bfTraveller = (Traveller)CollectionUtil.find((Collection)newBf.getTravellers(), (Object)prodTraveller, this::equalsTravellers);
                if (bfTraveller != null) {
                    if (!bfTraveller.equals((Object)prodTraveller)) {
                        this.updateTraveller(bfTraveller, prodTraveller);
                        handler.replaceTraveller(product, prodTraveller, bfTraveller);
                    }
                } else if (!newBf.getTravellers().contains(prodTraveller)) {
                    newBf.getTravellers().add(prodTraveller);
                }
                if (!this.isBookingFileContainsTravellerInOtherProducts(oldBf, product, prodTraveller)) {
                    oldBf.getTravellers().remove(prodTraveller);
                }
                productTravellers.put(prodTraveller, bfTraveller);
                travellers.put(prodTraveller, bfTraveller);
            }
            this.updatePrepaymentDocuments(product, productTravellers, bookingFileSource.getUid(), bookingFileDestination.getUid());
            if (!newRes.getProducts().contains(product)) {
                newRes.getProducts().add(product);
            }
            product.setReservation(newRes);
            List relations = GeneralProductHelper.copyContractRelations((BaseProduct)product);
            GeneralProductContractRelationData clientRelation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)relations, (ContractType)ContractType.CLIENT);
            boolean changed = false;
            if (clientRelation != null && parameters.getTargetClient() != null) {
                for (GeneralProductFop fop : clientRelation.getFops()) {
                    FopDetalization fopDetalization = (FopDetalization)product.getFopDetalizations().get(fop.getUid());
                    if (fopDetalization != null && fopDetalization.getComponents().stream().anyMatch(item -> item.getShipment() != null) || fop.getPayer() == null || fop.getPayer().equals((Object)parameters.getTargetClient()) || (!ProfileHelper.isRetailProfile((EntityReference)fop.getPayer()) || !parameters.isChangeRetailPayer()) && ProfileHelper.isRetailProfile((EntityReference)fop.getPayer())) continue;
                    fop.setPayer(parameters.getTargetClient());
                    changed = true;
                }
                if (oldBf.getCustomerProfile() != null && !oldBf.getCustomerProfile().equals((Object)parameters.getTargetClient())) {
                    clientRelation.getGeneralData().getContractData().setContract(null);
                    handler.setContractRulesApplied(product, false);
                    changed = true;
                }
            }
            if (changed) {
                handler.updateContractRelations(product, relations);
            }
            for (AppliedRule rule : oldBf.getAppliedRules()) {
                if (!rule.getProductUid().equals(product.getUid())) continue;
                newBf.getAppliedRules().add(rule);
            }
        }
        if (this.isEmpty((BookingFile)bookingFileSource.getEntity())) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)bookingFileSource.toReference()));
            query.getCriteria().getOrders().put(BasicDocumentIndex.Property.created.name(), SortOrder.ASC);
            for (BasicDocumentIndex idx : EntityStorage.get().search(BasicDocumentIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData()) {
                EntityContainer ctr = EntityStorage.get().resolve(idx.getSource());
                if (!EntityStorageHelper.nonEmpty((EntityContainer)ctr)) continue;
                ((BaseFileDocument)ctr.getEntity()).setOwner(bookingFileDestination.toReference());
                ctr.getVersionInfo().setDataSource("fx-join-booking-file-task");
                EntityStorage.get().save(ctr, true);
            }
            for (SysLogItem item2 : this.getCollectionSysLogItem((EntityReference<BookingFile>)bookingFileSource.toReference())) {
                item2.setReference(bookingFileDestination.toReference());
                AssetsStorage.get().save((BaseAsset)item2);
            }
        }
    }

    private Collection<SysLogItem> getCollectionSysLogItem(EntityReference<BookingFile> refBf) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)SysLogItem.Property.referenceType.name(), (Object)refBf.getType().getName()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)SysLogItem.Property.referenceUid.name(), (Object)refBf.getUid()));
        query.getCriteria().getOrders().put(SysLogItem.Property.eventDate.name(), SortOrder.DESC);
        return AssetsStorage.get().search(SysLogItem.class, query).getData();
    }

    private boolean equalsTravellers(Traveller traveller1, Traveller traveller2) {
        if (traveller1.equals((Object)traveller2)) {
            return true;
        }
        if (TravellerHelper.equals((Traveller)traveller1, (Traveller)traveller2)) {
            if (traveller1.getPassport() == null || traveller2.getPassport() == null) {
                return true;
            }
            if (traveller1.getPassport().getType() != null && traveller2.getPassport().getType() != null && traveller1.getPassport().getType() == traveller2.getPassport().getType()) {
                return true;
            }
        }
        return false;
    }

    private void updateTraveller(Traveller traveller, Traveller updateFrom) {
        if (traveller.getPassport() != null) {
            if (updateFrom.getPassport() != null) {
                this.updatePassport(traveller.getPassport(), updateFrom.getPassport());
            }
        } else {
            traveller.setPassport(updateFrom.getPassport());
        }
        this.updateProperties(traveller, updateFrom, Collections.singleton("passport"));
        this.updateCollections(traveller, updateFrom, null);
    }

    private void updatePassport(Passport passport, Passport updateFrom) {
        this.updateProperties(passport, updateFrom, null);
        this.updateCollections(passport, updateFrom, null);
    }

    private boolean isBookingFileContainsTravellerInOtherProducts(BookingFile bookingFile, BaseProduct currentProduct, Traveller traveller) {
        return bookingFile.getReservations().stream().flatMap(res -> res.getProducts().stream()).filter(product -> !product.equals((Object)currentProduct)).anyMatch(product -> GeneralProductHelper.getHandler((BaseProduct)product).getTravellers(product).contains(traveller));
    }

    private <T extends BaseEntity> void updateProperties(T object, T updateFrom, Collection<String> exclude) {
        EntityType entityType = MetaRegistryHelper.getEntityType((String)object.getClass().getName());
        if (entityType == null) {
            this.log.debug("Entity type not found for class " + object.getClass().getName());
            return;
        }
        for (Property property : MetaRegistryHelper.getAllProperties((EntityType)entityType).values()) {
            if (exclude != null && exclude.contains(property.getId()) || object.getValue(property.getId()) != null) continue;
            object.setValue(property.getId(), updateFrom.getValue(property.getId()));
        }
    }

    private boolean isEmpty(BookingFile bf) {
        if (bf == null) {
            return false;
        }
        if (bf.getReservations().isEmpty()) {
            return true;
        }
        for (Reservation res : bf.getReservations()) {
            if (res.getProducts().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private <T extends BaseEntity> void updateCollections(T object, T updateFrom, Collection<String> exclude) {
        EntityType entityType = MetaRegistryHelper.getEntityType((String)object.getClass().getName());
        if (entityType == null) {
            this.log.debug("Entity type not found for class " + object.getClass().getName());
            return;
        }
        for (EntityCollection collection : MetaRegistryHelper.getAllCollections((BaseClassType)entityType).values()) {
            if (exclude != null && exclude.contains(collection.getId())) continue;
            Object obj1 = object.getValue(collection.getId());
            Object obj2 = updateFrom.getValue(collection.getId());
            if (obj1 == null || obj2 == null) continue;
            if (obj1 instanceof Collection) {
                Collection coll1 = (Collection)obj1;
                Collection coll2 = (Collection)obj2;
                if (coll1.isEmpty()) {
                    coll1.addAll(coll2);
                    continue;
                }
                coll2.forEach(elem -> {
                    if (!CollectionUtil.contains((Collection)coll1, (Object)elem, this::isEquals)) {
                        coll1.add(elem);
                    }
                });
                continue;
            }
            if (!(obj1 instanceof Map)) continue;
            Map map1 = (Map)obj1;
            Map map2 = (Map)obj2;
            map1.putAll(map2);
        }
    }

    private <T> boolean isEquals(T first, T second) {
        if (first instanceof BaseEntity) {
            try {
                return EntityStorageHelper.isEqualsWithAllProperties((BaseEntity)((BaseEntity)first), (BaseEntity)((BaseEntity)second));
            }
            catch (Exception e) {
                this.log.error("unable to compare entities", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return MiscUtil.equals(first, second);
    }

    private void deleteProduct(Collection<BaseProduct> productsForMoving, EntityContainer<BookingFile> bookingFileSource) {
        for (BaseProduct product : productsForMoving) {
            ((BookingFile)bookingFileSource.getEntity()).getReservations().forEach(reservation -> reservation.getProducts().remove(product));
            GeneralProductHelper.getHandler((BaseProduct)product).getTravellers(product).forEach(traveller -> {
                if (!this.isBookingFileContainsTravellerInOtherProducts((BookingFile)bookingFileSource.getEntity(), product, (Traveller)traveller)) {
                    ((BookingFile)bookingFileSource.getEntity()).getTravellers().remove(traveller);
                }
            });
        }
    }

    private boolean checkAccess(EntityContainer<BookingFile> entityContainer, String userId, TaskExecutionCallback callback) throws Exception {
        boolean granted;
        RestrictionResourceProxy proxy = null;
        if (entityContainer != null && ((BookingFile)entityContainer.getEntity()).getUid() != null) {
            proxy = (RestrictionResourceProxy)RestrictionsHelper.buildProxies(entityContainer, (String)entityContainer.getEntityType().getName()).get(((BookingFile)entityContainer.getEntity()).getUid());
        }
        if (!(granted = AclHelper.isGranted(proxy, (String)ModelAclEntityResources.ENTITY_BOOKING_FILE.getId(), (String)userId, (String)StandardRestrictionResourceOperations.EDIT.getId(), Collections.emptyList()))) {
            callback.addMessages(new Message[]{Messages.getJoinBookingFileDenied((EntityReference)entityContainer.toReference())});
        }
        return granted;
    }

    private boolean checkAccess(BaseProduct product, String userId, TaskExecutionCallback callback) throws Exception {
        boolean granted;
        RestrictionResourceProxy proxy = null;
        if (product != null && product.getUid() != null) {
            proxy = (RestrictionResourceProxy)RestrictionsHelper.buildProxies((Object)product.getReservation().getBookingFile(), (String)ModelAclEntityResources.ENTITY_BOOKING_FILE.getId()).get(product.getUid());
        }
        if (!(granted = AclHelper.isGranted(proxy, (String)ModelAclEntityResources.ENTITY_PRODUCT.getId(), (String)userId, (String)StandardRestrictionResourceOperations.EDIT.getId(), Collections.emptyList()))) {
            callback.addMessages(new Message[]{Messages.getProductJoinDenied((String)BookingHelper.generateShortProductName((BaseProduct)product), (String)product.getReservation().getBookingFile().toString())});
        }
        return granted;
    }

    private boolean checkLocked(EntityContainer<BookingFile> entityContainer, String user, TaskExecutionCallback callback) throws Exception {
        String lockerUser = null;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)DeskEntry.Property.targetUid.name(), (Object)entityContainer.toReference().getUid()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)DeskEntry.Property.targetType.name(), (Object)entityContainer.toReference().getType().getName()));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)DeskEntry.Property.lockedSince.name(), null));
        List deskEntries = AssetsStorage.get().search(DeskEntry.class, query).getData();
        for (DeskEntry deskEntry : deskEntries) {
            if (deskEntry.getOwner() == null) continue;
            lockerUser = deskEntry.getOwner();
        }
        if (lockerUser != null && !user.equals(lockerUser)) {
            callback.addMessages(new Message[]{Messages.getJoinBookingFileAccessDenied((EntityReference)entityContainer.toReference(), (String)lockerUser)});
            return false;
        }
        return true;
    }

    private EntityContainer<BookingFile> createBookingFileContainer(String user) {
        EntityContainer result = new EntityContainer(BookingFile.class);
        Date createdDate = new Date();
        result.setCreatedBy(user);
        result.setModifiedBy(user);
        result.getVersionInfo().setDataSource("fx-editor join bf");
        ((BookingFile)result.getEntity()).setCreateDate(createdDate);
        result.setCreated(createdDate);
        result.setModified(createdDate);
        result.getVersionInfo().setCreated(createdDate);
        result.getVersionInfo().setModified(createdDate);
        result.getVersionInfo().setCreatedBy(user);
        result.getVersionInfo().setModifiedBy(user);
        return result;
    }

    private void updatePrepaymentDocuments(BaseProduct product, Map<Traveller, Traveller> travellers, String oldBfUid, String newBfUid) {
        for (EntityReference documentRef : product.getPrepaymentDocuments()) {
            EntityContainer document = EntityStorage.get().resolve(documentRef);
            if (document == null) continue;
            Set billingItemLists = ((FinanceDocument)document.getEntity()).getBillingItems().stream().map(item -> EntityStorage.get().resolve((EntityReference)item)).filter(Objects::nonNull).collect(Collectors.toSet());
            for (EntityContainer billingItemList : billingItemLists) {
                boolean changed = false;
                for (BillingItem billingItem : ((BillingItemsList)billingItemList.getEntity()).getData()) {
                    NestedEntityReference productRef = billingItem.getProduct();
                    if (productRef != null && productRef.getNestedEntityUid().equals(product.getUid())) {
                        Traveller oldTraveller;
                        if (productRef.getUid().equals(oldBfUid) && !productRef.getUid().equals(newBfUid)) {
                            productRef.setUid(newBfUid);
                            changed = true;
                        }
                        if (billingItem.getTraveller() != null && (oldTraveller = (Traveller)travellers.keySet().stream().filter(item -> billingItem.getTraveller().getNestedEntityUid().equals(item.getUid())).findFirst().orElse(null)) != null) {
                            Traveller newTraveller;
                            if (billingItem.getTraveller().getUid().equals(oldBfUid) && !billingItem.getTraveller().getUid().equals(newBfUid)) {
                                billingItem.getTraveller().setUid(newBfUid);
                                changed = true;
                            }
                            if ((newTraveller = travellers.get(oldTraveller)) != null) {
                                billingItem.getTraveller().setNestedEntityUid(newTraveller.getUid());
                                billingItem.getTraveller().setCaption(newTraveller.getName());
                                changed = true;
                            }
                        }
                    }
                    if (!changed) continue;
                    billingItemList.getVersionInfo().setDataSource("fx-join-booking-file-task");
                    EntityStorage.get().save(billingItemList, true);
                }
            }
        }
    }
}

