/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.async.entityactions;

import com.gridnine.xtrip.common.fx.async.ShipmentsProductsExcludeTaskParameters;
import com.gridnine.xtrip.common.fx.async.ShipmentsProductsExcludeTaskResult;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.system.ChangeData;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.fx.async.AsyncTask;
import com.gridnine.xtrip.server.fx.async.TaskExecutionCallback;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ShipmentsProductsExcludeAsyncTask
implements AsyncTask<ShipmentsProductsExcludeTaskParameters, ShipmentsProductsExcludeTaskResult> {
    public ShipmentsProductsExcludeTaskResult execute(ShipmentsProductsExcludeTaskParameters parameters, TaskExecutionCallback callback) throws Exception {
        ChangeData changeData = new ChangeData();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(IBusFinanceContextKeys.PRODUCT_BATCHES.name(), parameters.getProductBatches());
        context.put(IBusFinanceContextKeys.REMOVE_EMPTY_SHIPMENT.name(), parameters.isRemoveEmptyShipment());
        IntegrationBusFacade.get().processRouteSync("shipments:products-exclude", context);
        callback.addMessages(((Map)context.get("messages")).values());
        Collection documents = (Collection)context.get(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCES.name());
        ChangeData data = (ChangeData)context.get(IBusStandardContextKeys.CHANGED_DATA.name());
        if (data != null) {
            changeData.getChanged().addAll(data.getChanged());
            changeData.getDeleted().addAll(data.getDeleted());
        }
        for (EntityReference document : documents) {
            context.clear();
            context.put(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCE.name(), document);
            IntegrationBusFacade.get().processRouteSync("finance-documents:render-and-save", context);
        }
        ShipmentsProductsExcludeTaskResult result = new ShipmentsProductsExcludeTaskResult();
        result.setChangeData(changeData);
        result.getDocuments().clear();
        result.getDocuments().addAll(documents);
        return result;
    }
}

