/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.async.entityactions;

import com.gridnine.xtrip.common.fx.async.ShipmentsProductsIncludeTaskParameters;
import com.gridnine.xtrip.common.fx.async.ShipmentsProductsIncludeTaskResult;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.finance.Shipment;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.system.ChangeData;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.fx.async.AsyncTask;
import com.gridnine.xtrip.server.fx.async.TaskExecutionCallback;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ShipmentsProductsIncludeAsyncTask
implements AsyncTask<ShipmentsProductsIncludeTaskParameters, ShipmentsProductsIncludeTaskResult> {
    public ShipmentsProductsIncludeTaskResult execute(ShipmentsProductsIncludeTaskParameters parameters, TaskExecutionCallback callback) throws Exception {
        EntityContainer contractCtr;
        ChangeData changedData = new ChangeData();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(IBusFinanceContextKeys.DATE.name(), parameters.getDate());
        context.put(IBusFinanceContextKeys.PRODUCT_REFERENCES.name(), parameters.getProducts());
        context.put(IBusFinanceContextKeys.SHIPMENT_REFERENCES.name(), parameters.getShipments());
        EntityContainer shipmentCtr = EntityStorage.get().resolve((EntityReference)parameters.getShipments().stream().findFirst().orElse(null));
        if (shipmentCtr != null && (contractCtr = EntityStorage.get().resolve((EntityReference)((Shipment)shipmentCtr.getEntity()).getContract())) != null) {
            context.put(IBusFinanceContextKeys.CONTRACT_TYPE.name(), ((Contract)contractCtr.getEntity()).getContractType());
        }
        context.put(IBusFinanceContextKeys.FINANCE_DOCUMENTS_CONSOLIDATED.name(), Boolean.FALSE);
        context.put(IBusFinanceContextKeys.FINANCE_DOCUMENTS_PREPAYMENT.name(), Boolean.FALSE);
        IntegrationBusFacade.get().processRouteSync("shipments:products-include", context);
        callback.addMessages(((Map)context.get("messages")).values());
        Collection documents = (Collection)context.get(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCES.name());
        ChangeData changeData = (ChangeData)context.get(IBusStandardContextKeys.CHANGED_DATA.name());
        if (changeData != null) {
            changedData.getChanged().addAll(changeData.getChanged());
            changedData.getDeleted().addAll(changeData.getDeleted());
        }
        for (EntityReference document : documents) {
            context.clear();
            context.put(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCE.name(), document);
            IntegrationBusFacade.get().processRouteSync("finance-documents:render-and-save", context);
        }
        ShipmentsProductsIncludeTaskResult result = new ShipmentsProductsIncludeTaskResult();
        result.setChangeData(changedData);
        result.getDocuments().clear();
        result.getDocuments().addAll(documents);
        return result;
    }
}

