/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.async.entityactions.contract;

import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.RulesImportProperties;
import com.gridnine.xtrip.common.model.rules.standard.TchXmlCommissionsImportHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.server.fx.async.AsyncTask;
import com.gridnine.xtrip.server.fx.async.TaskExecutionCallback;
import com.gridnine.xtrip.server.fx.async.entityactions.contract.ContractRulesImportHelper;
import com.gridnine.xtrip.server.fx.async.entityactions.contract.RulesComparator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ContractRulesImportAsyncTask
implements AsyncTask<RulesImportProperties, RuleSet> {
    public RuleSet execute(RulesImportProperties parameters, TaskExecutionCallback callback) throws Exception {
        boolean updated;
        if (Thread.interrupted()) {
            callback.addMessages(new Message[]{Messages.getNotificationRuleImportInterrupted()});
            throw new InterruptedException();
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        RuleSet oldRules = parameters.getRuleSet();
        RuleSet newRules = null;
        callback.setProgress((byte)0, Messages.getReadingRulesFromFile());
        switch (parameters.getFileType()) {
            case TCH_EXCEL: {
                newRules = ContractRulesImportHelper.importTchExcelRules(parameters.getContent(), messages);
                break;
            }
            case TCH_XML: {
                newRules = ContractRulesImportHelper.importTchXMLRules(parameters.getContent(), parameters.getFilename(), messages);
                break;
            }
            case XTRIP: {
                newRules = ContractRulesImportHelper.importXtripZipRules(parameters.getContent(), messages);
                break;
            }
        }
        if (newRules == null || newRules.getRules().size() == 0) {
            messages.add(Messages.getWarningNoRules());
            callback.addMessages(messages);
            callback.setProgress((byte)100, Messages.getRulesImported());
            return oldRules;
        }
        callback.setProgress((byte)10, Messages.getRulesReaded());
        if (parameters.getImportType() != RulesImportProperties.ImportType.MERGE_TCH) {
            ContractRulesImportHelper.replaceOldRules(newRules.getRules());
            if (parameters.getImportType() == RulesImportProperties.ImportType.SUBSTITUTE) {
                oldRules.getRules().clear();
                oldRules.getRules().addAll(newRules.getRules());
                messages.add(Messages.getNotificationImportCompleted((String)Integer.toString(newRules.getRules().size())));
            } else if (parameters.getImportType() == RulesImportProperties.ImportType.MERGE_MANUAL && parameters.getConflictAction() != RulesImportProperties.ConflictAction.ASK) {
                ContractRulesImportAsyncTask.regenerateNewUids(newRules.getRules(), oldRules.getRules());
                LinkedList<RuleSettings> result = new LinkedList<RuleSettings>();
                int deletedRulesCount = 0;
                int appendedRulesCount = 0;
                HashMap<RulesImportProperties.Coincidence, RulesImportProperties.UserAction> actions = new HashMap<RulesImportProperties.Coincidence, RulesImportProperties.UserAction>();
                result.addAll(newRules.getRules());
                appendedRulesCount = newRules.getRules().size();
                for (RuleSettings rsOld : oldRules.getRules()) {
                    RuleSettings ruleToSubstitute = null;
                    RulesImportProperties.UserAction action = null;
                    boolean found = false;
                    int count = newRules.getRules().size();
                    block15: for (RuleSettings rsImp : newRules.getRules()) {
                        RulesImportProperties.Coincidence coinc;
                        --count;
                        List<RulesImportProperties.Coincidence> compareRules = RulesComparator.compareRules(rsOld, rsImp);
                        if (compareRules.isEmpty()) continue;
                        RulesImportProperties.Coincidence coincidence = compareRules.get(0);
                        Iterator<RulesImportProperties.Coincidence> iterator = compareRules.iterator();
                        while (iterator.hasNext() && (action = (RulesImportProperties.UserAction)actions.get(coinc = iterator.next())) == null) {
                        }
                        if (action == null) {
                            action = this.getUserAction(parameters.getConflictAction());
                            actions.put(coincidence, action);
                        }
                        found = true;
                        if (action == null) break;
                        switch (action) {
                            case SAVE_OLD_IGNORE_NEW: {
                                ruleToSubstitute = rsImp;
                                break block15;
                            }
                            case IMPORT_NEW_DELETE_OLD: {
                                break block15;
                            }
                        }
                    }
                    if (!found) {
                        result.addLast(rsOld);
                        continue;
                    }
                    if (action == null) {
                        action = RulesImportProperties.UserAction.IMPORT_NEW_SAVE_OLD;
                    }
                    switch (action) {
                        case SAVE_OLD_IGNORE_NEW: {
                            result.addLast(rsOld);
                            result.remove(ruleToSubstitute);
                            --appendedRulesCount;
                            break;
                        }
                        case IMPORT_NEW_DELETE_OLD: {
                            ++deletedRulesCount;
                            break;
                        }
                        case IMPORT_NEW_SAVE_OLD: {
                            result.addLast(rsOld);
                        }
                    }
                }
                oldRules.getRules().clear();
                oldRules.getRules().addAll(result);
                messages.add(Messages.getNotificationImportCompletedRules((String)Integer.toString(newRules.getRules().size()), (String)Integer.toString(deletedRulesCount), (String)Integer.toString(appendedRulesCount)));
            }
        } else if (parameters.getImportType() == RulesImportProperties.ImportType.MERGE_TCH && (updated = TchXmlCommissionsImportHelper.mergeRules((RuleSet)newRules, (RuleSet)oldRules, (Date)newRules.getModified(), messages))) {
            messages.add(Messages.getNotificationImportTKPRules());
        }
        callback.addMessages(messages);
        callback.setProgress((byte)100, Messages.getRulesImported());
        return oldRules;
    }

    private RulesImportProperties.UserAction getUserAction(RulesImportProperties.ConflictAction conflictAction) {
        if (conflictAction == RulesImportProperties.ConflictAction.ADD) {
            return RulesImportProperties.UserAction.IMPORT_NEW_SAVE_OLD;
        }
        if (conflictAction == RulesImportProperties.ConflictAction.SUBSTITUTE) {
            return RulesImportProperties.UserAction.IMPORT_NEW_DELETE_OLD;
        }
        if (conflictAction == RulesImportProperties.ConflictAction.SKIP) {
            return RulesImportProperties.UserAction.SAVE_OLD_IGNORE_NEW;
        }
        return RulesImportProperties.UserAction.IMPORT_NEW_DELETE_OLD;
    }

    private static void regenerateNewUids(List<RuleSettings> newRules, List<RuleSettings> oldRules) {
        block0: for (RuleSettings newRs : newRules) {
            for (RuleSettings oldRs : oldRules) {
                if (oldRs.getUid() == null || !oldRs.getUid().equals(newRs.getUid())) continue;
                newRs.setUid(UUIDGenerator.generate((boolean)false).toString());
                continue block0;
            }
        }
    }
}

