/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.async.entityactions.contract;

import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RuleAttributes;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.TchXmlCommissionsImportHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.parsers.model.TchXmlCommissionsImportSettings;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.server.fx.async.entityactions.contract.TchDataImportHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class ContractRulesImportHelper {
    private static Logger log = LoggerFactory.getLogger(ContractRulesImportHelper.class);

    ContractRulesImportHelper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static RuleSet importXtripZipRules(byte[] content, List<Message> messages) throws Exception {
        RuleSet result = new RuleSet();
        try (ZipInputStream strm = new ZipInputStream(new ByteArrayInputStream(content));){
            ZipEntry entry = strm.getNextEntry();
            if (entry == null) {
                messages.add(Messages.getExceptionNoXMLInFile());
                RuleSet ruleSet = null;
                return ruleSet;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IoUtil.copyStream((InputStream)strm, (OutputStream)baos, (int)256);
            byte[] arr = baos.toByteArray();
            if (arr.length == 0) {
                messages.add(Messages.getExceptionFileNoContainData((ZipEntry)entry));
                RuleSet ruleSet = null;
                return ruleSet;
            }
            Element rdElm = XmlUtil.getElement((Element)DocumentBuilderHelper.parse((InputStream)new ByteArrayInputStream(arr)).getDocumentElement(), (String)"rulesData");
            if (null == rdElm) {
                throw Xeption.forEndUser((String)"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442", (Object[])new Object[0]);
            }
            result.fromXML(rdElm);
            RuleSet ruleSet = (RuleSet)XCloneHelper.clone((XCloneable)result, (boolean)true);
            return ruleSet;
        }
        catch (Exception e) {
            messages.add(Messages.getExceptionFileOpen((Throwable)e));
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static RuleSet importTchXMLRules(byte[] content, String filename, List<Message> messages) {
        try {
            RuleSet rules = null;
            Date date = null;
            try {
                date = new SimpleDateFormat("yyyyMMdd").parse(filename.substring(filename.length() - 12));
            }
            catch (Exception e) {
                date = new Date();
            }
            try (ZipInputStream strm = new ZipInputStream(new ByteArrayInputStream(content));){
                strm.getNextEntry();
                rules = TchXmlCommissionsImportHelper.parseRules((Document)DocumentBuilderHelper.parse((InputStream)strm), messages);
                if (rules == null) {
                    RuleSet ruleSet2 = null;
                    return ruleSet2;
                }
                rules.setModified(date);
                RuleSet ruleSet = rules;
                return ruleSet;
            }
        }
        catch (Exception e) {
            log.error("Could not read file", (Throwable)e);
            messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0430\u0432\u0438\u043b\u0430", (Throwable)e, (Object[])new Object[0]));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RuleSet importTchExcelRules(byte[] content, List<Message> messages) throws Exception {
        Element[] rows;
        TchXmlCommissionsImportSettings tchCommissionSettings = TchXmlCommissionsImportHelper.updateAndReturnTchCommissionsSettings();
        if (tchCommissionSettings == null || tchCommissionSettings.getCommission() == null) {
            messages.add(Messages.getExceptionLoadTKPCommission());
            return null;
        }
        try (ByteArrayInputStream strm = new ByteArrayInputStream(content);){
            rows = XmlUtil.getElements((Element)DocumentBuilderHelper.parse((InputStream)strm).getDocumentElement(), (String)"Worksheet/Table/Row");
        }
        catch (Exception e) {
            log.debug("Could not read file", (Throwable)e);
            messages.add(Messages.getExceptionImportTKPRules((Throwable)e));
            return null;
        }
        try {
            RuleSet result = ContractRulesImportHelper.analizeRulesData(rows, (EntityReference<CommissionProperties>)tchCommissionSettings.getCommission());
            ContractRulesImportHelper.addStandardCommisionRule(result, (EntityReference<CommissionProperties>)tchCommissionSettings.getCommission());
            return result;
        }
        catch (Exception e) {
            messages.add(Messages.getExceptionImportTKPRules((Throwable)e));
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    static void addStandardCommisionRule(RuleSet result, EntityReference<CommissionProperties> tchCommission) {
        RuleSettings rs = new RuleSettings();
        rs.setUid("standardTCHCommission");
        RuleRestriction rr = new RuleRestriction();
        rr.setProperty((RuleProperty)Properties.BLANK_OWNERS);
        rr.setCondition((RuleCondition)Conditions.INCLUDE);
        rr.setValue((Object)"\u04281");
        rs.getRestrictions().add(rr);
        rs.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
        rs.setName(Messages.getDefaultCommission());
        RuleResult res = new RuleResult();
        res.setAction((RuleAction)Actions.FOP_COMMISSION);
        RuleResultValue value = new RuleResultValue();
        value.setFopValues(new Object[]{new Double[][]{{5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}, {5.0, 5.0, 5.0}}, new String[][]{{"%", "%", "%"}, {"%", "%", "%"}, {"%", "%", "%"}, {"%", "%", "%"}, {"%", "%", "%"}, {"%", "%", "%"}, {"%", "%", "%"}, {"%", "%", "%"}, {"%", "%", "%"}, {"%", "%", "%"}, {"%", "%", "%"}, {"%", "%", "%"}}});
        value.setTarget(tchCommission);
        res.setValue((Object)value);
        rs.getResults().add(res);
        result.getRules().add(rs);
    }

    private static RuleSet analizeRulesData(Element[] rows, EntityReference<CommissionProperties> tchCommission) throws Exception {
        RuleSet result = new RuleSet();
        String carrierNumber = null;
        LinkedList<RuleSettings> ruleSettings = new LinkedList<RuleSettings>();
        RuleSettings rule = null;
        for (int n = 0; n < rows.length; ++n) {
            Element rowElm = rows[n];
            String cn = TchDataImportHelper.getCarrierNumber(rowElm);
            if (cn == null && carrierNumber == null) continue;
            if (cn != null) {
                carrierNumber = cn;
                continue;
            }
            if (TchDataImportHelper.isNewRuleRecord(rowElm)) {
                if (rule != null) {
                    ContractRulesImportHelper.addRule(rule, ruleSettings);
                }
                rule = new RuleSettings();
                rule.setTarget((RuleTarget)Targets.PRODUCT_COMMISSION);
                TchDataImportHelper.addCarrierNumberRestriction(rule, carrierNumber);
            }
            try {
                for (TchDataImportHelper.RowType rowType : TchDataImportHelper.RowType.values()) {
                    if (!rowType.isApplicable(rowElm)) continue;
                    rowType.analizeData(rowElm, rule, tchCommission);
                }
                continue;
            }
            catch (Exception e) {
                log.error(String.format("failed analizing info in row %s", n + 1), (Throwable)e);
                throw new Exception(String.format("failed analizing info in row %s", n + 1), e);
            }
        }
        if (rule != null) {
            ContractRulesImportHelper.addRule(rule, ruleSettings);
        }
        result.getRules().addAll(ruleSettings);
        return result;
    }

    private static void addRule(RuleSettings rule, LinkedList<RuleSettings> ruleSettings) {
        String telexNo = null;
        Map attributes = rule.getAttributes();
        String code = null;
        for (Map.Entry entry : attributes.entrySet()) {
            if (!RuleAttributes.TCH_TELEX_NO.name().equals(entry.getKey())) continue;
            telexNo = (String)entry.getValue();
            break;
        }
        for (RuleRestriction rr : rule.getRestrictions()) {
            if (!rr.getProperty().equals(Properties.CARRIER_NUMBER)) continue;
            code = (String)rr.getValue();
            break;
        }
        rule.setName(code == null ? "" : code + ": \u2116 " + telexNo + (rule.getRevisionDate() != null ? "\\ from" + new SimpleDateFormat("dd.MM.yyyy").format(rule.getRevisionDate()) : ""));
        ruleSettings.addFirst(rule);
    }

    static void replaceOldRules(List<RuleSettings> rulesToImport) {
        Iterator<RuleSettings> it = rulesToImport.iterator();
        block0: while (it.hasNext()) {
            RuleSettings rs = it.next();
            for (RuleResult rr : rs.getResults()) {
                RuleAction action = rr.getAction();
                if (action != null && !TextUtil.isBlank((String)action.getId()) && rr.getValue() != null) continue;
                it.remove();
                continue block0;
            }
        }
    }
}

