/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.async.entityactions.contract;

import com.gridnine.xtrip.common.fx.rpc.RulesImportProperties;
import com.gridnine.xtrip.common.model.rules.standard.RuleAttributes;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import java.util.LinkedList;
import java.util.List;

public class RulesComparator {
    private static int COMPARE_ABSENT = -1;
    private static int COMPARE_EQUALS = 0;
    private static int COMPARE_DIFFERS = 1;

    public static List<RulesImportProperties.Coincidence> compareRules(RuleSettings rs1, RuleSettings rs2) {
        LinkedList<RulesImportProperties.Coincidence> result = new LinkedList<RulesImportProperties.Coincidence>();
        if (!RulesComparator.isHasEqualTargets(rs1, rs2)) {
            return result;
        }
        int names = RulesComparator.compareNames(rs1, rs2);
        int telexes = RulesComparator.compareTelexes(rs1, rs2);
        int conditions = RulesComparator.compareConditions(rs1, rs2);
        int results = RulesComparator.compareResults(rs1, rs2);
        if (names == COMPARE_EQUALS) {
            result.addFirst(RulesImportProperties.Coincidence.NAME);
        }
        if (telexes == COMPARE_EQUALS) {
            result.addFirst(RulesImportProperties.Coincidence.TCH_TELEX_NO);
        }
        if (conditions == COMPARE_EQUALS) {
            result.addFirst(RulesImportProperties.Coincidence.CONDITIONS);
        }
        if (results == COMPARE_EQUALS && conditions == COMPARE_EQUALS) {
            result.addFirst(RulesImportProperties.Coincidence.CONDITIONS_AND_RESULTS);
        }
        if (results == COMPARE_EQUALS && conditions == COMPARE_EQUALS && names != COMPARE_DIFFERS && telexes != COMPARE_DIFFERS) {
            result.addFirst(RulesImportProperties.Coincidence.FULL);
        }
        return result;
    }

    private static int compareResults(RuleSettings rs1, RuleSettings rs2) {
        if (rs1.getResults().size() != rs2.getResults().size()) {
            return COMPARE_DIFFERS;
        }
        for (RuleResult rr1 : rs1.getResults()) {
            boolean found = false;
            for (RuleResult rr2 : rs2.getResults()) {
                if (!rr2.equals((Object)rr1)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return COMPARE_DIFFERS;
        }
        return COMPARE_EQUALS;
    }

    private static int compareConditions(RuleSettings rs1, RuleSettings rs2) {
        if (rs1.getRestrictions().size() != rs2.getRestrictions().size()) {
            return COMPARE_DIFFERS;
        }
        for (RuleRestriction rr1 : rs1.getRestrictions()) {
            boolean found = false;
            for (RuleRestriction rr2 : rs2.getRestrictions()) {
                if (!rr2.equals((Object)rr1)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return COMPARE_DIFFERS;
        }
        return COMPARE_EQUALS;
    }

    private static int compareTelexes(RuleSettings rs1, RuleSettings rs2) {
        String telex1 = (String)rs1.getAttributes().get(RuleAttributes.TCH_TELEX_NO.name());
        String telex2 = (String)rs2.getAttributes().get(RuleAttributes.TCH_TELEX_NO.name());
        return RulesComparator.comapareStrings(telex1, telex2);
    }

    private static boolean isHasEqualTargets(RuleSettings rs1, RuleSettings rs2) {
        RuleTarget target1 = rs1.getTarget();
        RuleTarget target2 = rs2.getTarget();
        if (target1 == null || target2 == null) {
            return target1 == null && target2 == null;
        }
        return rs1.getTarget().equals(rs2.getTarget());
    }

    private static int compareNames(RuleSettings rs1, RuleSettings rs2) {
        String name1 = rs1.getName();
        String name2 = rs2.getName();
        return RulesComparator.comapareStrings(name1, name2);
    }

    private static int comapareStrings(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return COMPARE_ABSENT;
        }
        if (str1 == null && str2 != null) {
            return COMPARE_DIFFERS;
        }
        if (str1 != null && str2 == null) {
            return COMPARE_DIFFERS;
        }
        return str1.equals(str2) ? COMPARE_EQUALS : COMPARE_DIFFERS;
    }
}

