/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.async.entityactions.contract;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RuleAttributes;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.TchRouteRestrictions;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class TchDataImportHelper {
    static Logger log = LoggerFactory.getLogger(TchDataImportHelper.class);
    static final List<String> fops = Arrays.asList("\u041d\u0410\u041b", "\u041f\u041a", "\u041d\u0410\u041b+\u041f\u041a", "\u0410\u0412", "\u0412\u0417", "\u041d\u0410\u041b+\u0412\u0417", "\u041a\u0420", "\u041d\u0410\u041b+\u041a\u0420", "\u0412\u0422", "\u041d\u0410\u041b+\u0412\u0422", "\u0420\u0422", "ANY");

    static String getCarrierNumber(Element rowElm) {
        for (Element cellElm : XmlUtil.getElements((Element)rowElm, (String)"Cell")) {
            String value = XmlUtil.getValue((Element)cellElm, (String)"Data");
            if (TextUtil.isBlank((String)value) || !value.matches("[^\\s]{3}\\s[^\\s]{2,3}")) continue;
            return value.substring(0, 3);
        }
        return null;
    }

    static void addCarrierNumberRestriction(RuleSettings rule, String carrierNumber) {
        RuleRestriction rr = new RuleRestriction();
        rr.setCondition((RuleCondition)Conditions.EQUALS);
        rr.setProperty((RuleProperty)Properties.CARRIER_NUMBER);
        rr.setValue((Object)carrierNumber);
        rule.getRestrictions().add(rr);
        rr = new RuleRestriction();
        rr.setCondition((RuleCondition)Conditions.INCLUDE);
        rr.setProperty((RuleProperty)Properties.BLANK_OWNERS);
        rr.setValue((Object)"\u04281");
        rule.getRestrictions().add(rr);
    }

    static boolean isNewRuleRecord(Element rowElm) {
        for (Element cellElm : XmlUtil.getElements((Element)rowElm, (String)"Cell")) {
            String value = XmlUtil.getValue((Element)cellElm, (String)"Data");
            if (TextUtil.isBlank((String)value) || !value.contains("\u2116 \u043f/\u043f.")) continue;
            return true;
        }
        return false;
    }

    static boolean isRecordContains(Element rowElm, String value) {
        for (Element cellElm : XmlUtil.getElements((Element)rowElm, (String)"Cell")) {
            String val = XmlUtil.getValue((Element)cellElm, (String)"Data");
            if (TextUtil.isBlank((String)val) || !val.contains(value)) continue;
            return true;
        }
        return false;
    }

    static String getRecordValue(Element rowElm, String obligatoryValue, String pattern) {
        String value = null;
        for (Element cellElm : XmlUtil.getElements((Element)rowElm, (String)"Cell")) {
            String val = XmlUtil.getValue((Element)cellElm, (String)"Data");
            if (TextUtil.isBlank((String)val) || !val.contains(obligatoryValue)) continue;
            value = val.trim();
        }
        if (value == null) {
            return null;
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(value);
        if (!m.find()) {
            return null;
        }
        return m.group();
    }

    static String buildLogErrorMessage(RowType row, Element row2, RuleSettings rule) {
        String carrier = null;
        for (RuleRestriction rr : rule.getRestrictions()) {
            if (!rr.getProperty().equals(Properties.CARRIERS)) continue;
            carrier = (String)rr.getValue();
            break;
        }
        StringBuilder result = new StringBuilder("RowType value " + (Object)((Object)row) + "is applicable to record but no proper information found in the record\r\n");
        result.append("Carrier: ").append(carrier).append("\r\n");
        for (Element cell : XmlUtil.getElements((Element)row2, (String)"Cell")) {
            result.append("Cell: ").append(XmlUtil.getValue((Element)cell, (String)"Data")).append("\r\n");
        }
        return result.toString();
    }

    static RuleRestriction getRouteRestrictions(RuleSettings rs) {
        for (RuleRestriction rr : rs.getRestrictions()) {
            if (!rr.getProperty().equals(Properties.TCH_ROUTE)) continue;
            return rr;
        }
        RuleRestriction result = new RuleRestriction();
        result.setCondition((RuleCondition)Conditions.TCH_ROUTE_ALL);
        result.setProperty((RuleProperty)Properties.TCH_ROUTE);
        result.setValue((Object)new TchRouteRestrictions());
        rs.getRestrictions().add(result);
        return result;
    }

    static String getFop(Element row) {
        for (Element cellElm : XmlUtil.getElements((Element)row, (String)"Cell")) {
            String value = XmlUtil.getValue((Element)cellElm, (String)"Data");
            if (TextUtil.isBlank((String)value)) continue;
            for (String fop : fops) {
                if (!fop.equalsIgnoreCase(value.replaceAll(" ", ""))) continue;
                return fop;
            }
        }
        return null;
    }

    static RecordValue getRecordValue(Element row, String[] types) {
        for (Element cellElm : XmlUtil.getElements((Element)row, (String)"Cell")) {
            String val = XmlUtil.getValue((Element)cellElm, (String)"Data");
            if (TextUtil.isBlank((String)val)) continue;
            val = val.trim();
            String restrictionType = null;
            for (String type : types) {
                if (!val.startsWith(type)) continue;
                restrictionType = type;
                break;
            }
            if (restrictionType == null) continue;
            String restrictionValue = null;
            if (val.length() > restrictionType.length()) {
                restrictionValue = val.substring(restrictionType.length());
            }
            if (TextUtil.isBlank(restrictionValue)) {
                restrictionValue = null;
            }
            if (restrictionValue != null) {
                restrictionValue = restrictionValue.replaceAll("\\r", "");
                restrictionValue = restrictionValue.replaceAll("\\n", "");
            }
            return new RecordValue(restrictionType, restrictionValue);
        }
        return null;
    }

    private static final class RecordValue {
        private final String restrictionType;
        private final String restrictionValue;

        RecordValue(String type, String value) {
            this.restrictionType = type;
            this.restrictionValue = value;
        }

        String getRestrictionType() {
            return this.restrictionType;
        }

        String getRestrictionValue() {
            return this.restrictionValue;
        }
    }

    static enum RowType {
        TchTelexNo{

            @Override
            void analizeData(Element row, RuleSettings rule, EntityReference<CommissionProperties> tchCommission) throws Exception {
                String telexNo = TchDataImportHelper.getRecordValue(row, "\u2116 \u043f/\u043f.", "\u2116 [0-9,\\-]+");
                if (telexNo == null) {
                    throw new Exception(TchDataImportHelper.buildLogErrorMessage(this, row, rule));
                }
                rule.getAttributes().put(RuleAttributes.TCH_TELEX_NO.name(), telexNo.substring(2));
            }

            @Override
            boolean isApplicable(Element row) {
                return TchDataImportHelper.isRecordContains(row, "\u2116 \u043f/\u043f.");
            }
        }
        ,
        IssueDate{

            @Override
            void analizeData(Element row, RuleSettings rule, EntityReference<CommissionProperties> tchCommission) throws Exception {
                String date = TchDataImportHelper.getRecordValue(row, "\u2116 \u043f/\u043f.", "[0-9]{2}\\.[0-9]{2}\\.[0-9]{4}");
                if (date == null) {
                    throw new Exception(TchDataImportHelper.buildLogErrorMessage(this, row, rule));
                }
                Date issueDate = new SimpleDateFormat("dd.MM.yyyy").parse(date);
                if (issueDate == null) {
                    throw new Exception(TchDataImportHelper.buildLogErrorMessage(this, row, rule));
                }
                rule.setRevisionDate(issueDate);
            }

            @Override
            boolean isApplicable(Element row) {
                return TchDataImportHelper.isRecordContains(row, "\u2116 \u043f/\u043f.");
            }
        }
        ,
        ActionPeriod{

            @Override
            void analizeData(Element row, RuleSettings rule, EntityReference<CommissionProperties> tchCommission) throws Exception {
                String startDateStr = TchDataImportHelper.getRecordValue(row, "\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f", "\u0441 [0-9]{2}\\.[0-9]{2}\\.[0-9]{4}");
                if (startDateStr == null) {
                    throw new Exception(TchDataImportHelper.buildLogErrorMessage(this, row, rule));
                }
                Date startDate = new SimpleDateFormat("dd.MM.yyyy").parse(startDateStr.substring(2));
                if (startDate == null) {
                    throw new Exception(TchDataImportHelper.buildLogErrorMessage(this, row, rule));
                }
                rule.setPeriodBegin(startDate);
                String endDateStr = TchDataImportHelper.getRecordValue(row, "\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f", "\u043f\u043e [0-9]{2}\\.[0-9]{2}\\.[0-9]{4}");
                if (endDateStr == null) {
                    return;
                }
                Date endDate = new SimpleDateFormat("dd.MM.yyyy").parse(endDateStr.substring(3));
                if (endDate == null) {
                    return;
                }
                rule.setPeriodEnd(endDate);
            }

            @Override
            boolean isApplicable(Element row) {
                return TchDataImportHelper.isRecordContains(row, "\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f");
            }
        }
        ,
        Transportation{

            @Override
            void analizeData(Element row, RuleSettings rule, EntityReference<CommissionProperties> tchCommission) throws Exception {
                RecordValue recordValue = TchDataImportHelper.getRecordValue(row, new String[]{"\u0412\u0441\u0435:", "\u0417\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0421\u041d\u0413:", "\u0412 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u0445 \u0421\u041d\u0413:", "\u0417\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0441\u0442\u0440\u0430\u043d\u044b:", "\u0412 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u0445 \u0441\u0442\u0440\u0430\u043d\u044b:"});
                if (recordValue == null) {
                    throw new Exception(TchDataImportHelper.buildLogErrorMessage(this, row, rule));
                }
                RuleRestriction rr = new RuleRestriction();
                rr.setProperty((RuleProperty)Properties.TRANSPORTATION_TYPE);
                rr.setValue(null);
                String restrictionType = recordValue.getRestrictionType();
                if ("\u0412\u0441\u0435:".equals(restrictionType)) {
                    return;
                }
                if ("\u0417\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0421\u041d\u0413:".equals(restrictionType)) {
                    rr.setCondition((RuleCondition)Conditions.TRANSPORTATION_OUTSIDE_CIS);
                } else if ("\u0412 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u0445 \u0421\u041d\u0413:".equals(restrictionType)) {
                    rr.setCondition((RuleCondition)Conditions.TRANSPORTATION_INSIDE_CIS);
                } else if ("\u0412 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u0445 \u0441\u0442\u0440\u0430\u043d\u044b:".equals(restrictionType)) {
                    rr.setCondition((RuleCondition)Conditions.TRANSPORTATION_INSIDE_COUNTRY);
                    rr.setValue((Object)recordValue.getRestrictionValue());
                } else if ("\u0417\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0441\u0442\u0440\u0430\u043d\u044b:".equals(restrictionType)) {
                    rr.setCondition((RuleCondition)Conditions.TRANSPORTATION_OUTSIDE_COUNTRY);
                    rr.setValue((Object)recordValue.getRestrictionValue());
                }
                rule.getRestrictions().add(rr);
            }

            @Override
            boolean isApplicable(Element row) {
                return TchDataImportHelper.isRecordContains(row, "\u041f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438");
            }
        }
        ,
        ConditionType{

            @Override
            void analizeData(Element row, RuleSettings rule, EntityReference<CommissionProperties> tchCommission) throws Exception {
                boolean all = TchDataImportHelper.isRecordContains(row, "\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0430 \u043f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e \u0443\u0434\u043e\u0432\u043b\u0435\u0442\u0432\u043e\u0440\u044f\u044e\u0449\u0430\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u044f\u043c");
                if (all) {
                    RuleRestriction rr = TchDataImportHelper.getRouteRestrictions(rule);
                    rr.setCondition((RuleCondition)Conditions.TCH_ROUTE_ALL);
                    ((TchRouteRestrictions)rr.getValue()).setAppliedToSegment(false);
                    return;
                }
                boolean segment = TchDataImportHelper.isRecordContains(row, "\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0430, \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0430\u044f \u0443\u0447\u0430\u0441\u0442\u043e\u043a");
                if (segment) {
                    RuleRestriction rr = TchDataImportHelper.getRouteRestrictions(rule);
                    rr.setCondition((RuleCondition)Conditions.TCH_ROUTE_SEGMENT);
                    ((TchRouteRestrictions)rr.getValue()).setAppliedToSegment(true);
                    return;
                }
                throw new Exception(TchDataImportHelper.buildLogErrorMessage(this, row, rule));
            }

            @Override
            boolean isApplicable(Element row) {
                return TchDataImportHelper.isRecordContains(row, "\u0422\u0438\u043f \u0443\u0441\u043b\u043e\u0432\u0438\u0439");
            }
        }
        ,
        Interline{

            @Override
            void analizeData(Element row, RuleSettings rule, EntityReference<CommissionProperties> tchCommission) throws Exception {
                RecordValue recordValue = TchDataImportHelper.getRecordValue(row, new String[]{"\u0412\u0441\u0435:", "\u041d\u0435\u0442:", "\u0412\u043a\u043b\u044e\u0447\u0430\u044f \u0438\u043d\u0442\u0435\u0440\u043b\u0430\u0439\u043d \u0441:", "\u0422\u043e\u043b\u044c\u043a\u043e \u0438\u043d\u0442\u0435\u0440\u043b\u0430\u0439\u043d \u0441:"});
                if (recordValue == null) {
                    throw new Exception(TchDataImportHelper.buildLogErrorMessage(this, row, rule));
                }
                RuleRestriction rr = TchDataImportHelper.getRouteRestrictions(rule);
                TchRouteRestrictions val = (TchRouteRestrictions)rr.getValue();
                val.setInterlineValue(null);
                String restrictionType = recordValue.getRestrictionType();
                if ("\u0412\u0441\u0435:".equals(restrictionType)) {
                    val.setInterlineRestriction(TchRouteRestrictions.InterlineRestriction.ALL);
                    return;
                }
                if ("\u041d\u0435\u0442:".equals(restrictionType)) {
                    val.setInterlineRestriction(TchRouteRestrictions.InterlineRestriction.NONE);
                } else if ("\u0422\u043e\u043b\u044c\u043a\u043e \u0438\u043d\u0442\u0435\u0440\u043b\u0430\u0439\u043d \u0441:".equals(restrictionType)) {
                    val.setInterlineRestriction(TchRouteRestrictions.InterlineRestriction.ONLY);
                    val.setInterlineValue(recordValue.getRestrictionValue());
                } else if ("\u0412\u043a\u043b\u044e\u0447\u0430\u044f \u0438\u043d\u0442\u0435\u0440\u043b\u0430\u0439\u043d \u0441:".equals(restrictionType)) {
                    val.setInterlineRestriction(TchRouteRestrictions.InterlineRestriction.INCLUDING);
                    val.setInterlineValue(recordValue.getRestrictionValue());
                }
            }

            @Override
            boolean isApplicable(Element row) {
                return TchDataImportHelper.isRecordContains(row, "\u0418\u043d\u0442\u0435\u0440\u043b\u0430\u0439\u043d");
            }
        }
        ,
        Validators{

            @Override
            void analizeData(Element row, RuleSettings rule, EntityReference<CommissionProperties> tchCommission) throws Exception {
                RecordValue recordValue = TchDataImportHelper.getRecordValue(row, new String[]{"\u0412\u0441\u0435:", "\u041a\u0440\u043e\u043c\u0435 \u043a\u043e\u0434\u043e\u0432 \u043f\u0443\u043d\u043a\u0442\u043e\u0432 \u043f\u0440\u043e\u0434\u0430\u0436\u0438:", "\u041a\u043e\u0434\u044b \u043f\u0443\u043d\u043a\u0442\u043e\u0432 \u043f\u0440\u043e\u0434\u0430\u0436\u0438:"});
                if (recordValue == null) {
                    throw new Exception(TchDataImportHelper.buildLogErrorMessage(this, row, rule));
                }
                RuleRestriction rr = new RuleRestriction();
                rr.setProperty((RuleProperty)Properties.VALIDATOR);
                rr.setValue(null);
                String restrictionType = recordValue.getRestrictionType();
                if ("\u0412\u0441\u0435:".equals(restrictionType)) {
                    return;
                }
                if ("\u041a\u043e\u0434\u044b \u043f\u0443\u043d\u043a\u0442\u043e\u0432 \u043f\u0440\u043e\u0434\u0430\u0436\u0438:".equals(restrictionType)) {
                    rr.setCondition((RuleCondition)Conditions.EQUALS);
                    rr.setValue((Object)recordValue.getRestrictionValue());
                } else if ("\u041a\u0440\u043e\u043c\u0435 \u043a\u043e\u0434\u043e\u0432 \u043f\u0443\u043d\u043a\u0442\u043e\u0432 \u043f\u0440\u043e\u0434\u0430\u0436\u0438:".equals(restrictionType)) {
                    rr.setCondition((RuleCondition)Conditions.NOT_EQUALS);
                    rr.setValue((Object)recordValue.getRestrictionValue());
                }
                rule.getRestrictions().add(rr);
            }

            @Override
            boolean isApplicable(Element row) {
                return TchDataImportHelper.isRecordContains(row, "\u041f\u0443\u043d\u043a\u0442\u044b \u043f\u0440\u043e\u0434\u0430\u0436\u0438");
            }
        }
        ,
        Routes{

            @Override
            void analizeData(Element row, RuleSettings rule, EntityReference<CommissionProperties> tchCommission) throws Exception {
                RecordValue recordValue = TchDataImportHelper.getRecordValue(row, new String[]{"\u0412\u0441\u0435:", "\u0422\u043e\u043b\u044c\u043a\u043e:", "\u041a\u0440\u043e\u043c\u0435:", "\u041d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f \u0438\u0437:"});
                if (recordValue == null) {
                    throw new Exception(TchDataImportHelper.buildLogErrorMessage(this, row, rule));
                }
                RuleRestriction rr = TchDataImportHelper.getRouteRestrictions(rule);
                TchRouteRestrictions val = (TchRouteRestrictions)rr.getValue();
                val.setRouteRestriction(TchRouteRestrictions.RouteRestriction.ALL);
                val.setRouteValue(null);
                String restrictionType = recordValue.getRestrictionType();
                if ("\u0412\u0441\u0435:".equals(restrictionType)) {
                    return;
                }
                if ("\u0422\u043e\u043b\u044c\u043a\u043e:".equals(restrictionType)) {
                    val.setRouteRestriction(TchRouteRestrictions.RouteRestriction.ONLY);
                    val.setRouteValue(recordValue.getRestrictionValue());
                } else if ("\u041a\u0440\u043e\u043c\u0435:".equals(restrictionType)) {
                    val.setRouteRestriction(TchRouteRestrictions.RouteRestriction.EXCEPT);
                    val.setRouteValue(recordValue.getRestrictionValue());
                } else if ("\u041d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f \u0438\u0437:".equals(restrictionType)) {
                    val.setRouteRestriction(TchRouteRestrictions.RouteRestriction.START);
                    val.setRouteValue(recordValue.getRestrictionValue());
                }
            }

            @Override
            boolean isApplicable(Element row) {
                return TchDataImportHelper.isRecordContains(row, "\u041c\u0430\u0440\u0448\u0440\u0443\u0442\u044b");
            }
        }
        ,
        Flight{

            @Override
            void analizeData(Element row, RuleSettings rule, EntityReference<CommissionProperties> tchCommission) throws Exception {
                RecordValue recordValue = TchDataImportHelper.getRecordValue(row, new String[]{"\u0412\u0441\u0435:", "\u041d\u043e\u043c\u0435\u0440\u0430 \u0440\u0435\u0439\u0441\u043e\u0432:", "\u041a\u0440\u043e\u043c\u0435:"});
                if (recordValue == null) {
                    throw new Exception(TchDataImportHelper.buildLogErrorMessage(this, row, rule));
                }
                RuleRestriction rr = TchDataImportHelper.getRouteRestrictions(rule);
                TchRouteRestrictions val = (TchRouteRestrictions)rr.getValue();
                val.setFlightNumbersRestriction(TchRouteRestrictions.FlightNumbersRestriction.ALL);
                val.setFlightNumbersValue(null);
                String restrictionType = recordValue.getRestrictionType();
                if ("\u0412\u0441\u0435:".equals(restrictionType)) {
                    return;
                }
                if ("\u041d\u043e\u043c\u0435\u0440\u0430 \u0440\u0435\u0439\u0441\u043e\u0432:".equals(restrictionType)) {
                    val.setFlightNumbersRestriction(TchRouteRestrictions.FlightNumbersRestriction.ONLY);
                    val.setFlightNumbersValue(recordValue.getRestrictionValue());
                } else if ("\u041a\u0440\u043e\u043c\u0435:".equals(restrictionType)) {
                    val.setFlightNumbersRestriction(TchRouteRestrictions.FlightNumbersRestriction.EXCEPT);
                    val.setFlightNumbersValue(recordValue.getRestrictionValue());
                }
            }

            @Override
            boolean isApplicable(Element row) {
                return TchDataImportHelper.isRecordContains(row, "\u0420\u0435\u0439\u0441\u044b");
            }
        }
        ,
        DepartureDate{

            @Override
            void analizeData(Element row, RuleSettings rule, EntityReference<CommissionProperties> tchCommission) throws Exception {
                String restrictionType;
                Pattern p;
                Matcher m;
                RecordValue recordValue = TchDataImportHelper.getRecordValue(row, new String[]{"\u0412\u0441\u0435:", "\u0414\u0430\u0442\u0430 \u0432\u044b\u043b\u0435\u0442\u0430:", "\u041a\u0440\u043e\u043c\u0435:"});
                if (recordValue == null) {
                    throw new Exception(TchDataImportHelper.buildLogErrorMessage(this, row, rule));
                }
                RuleRestriction rr = TchDataImportHelper.getRouteRestrictions(rule);
                TchRouteRestrictions val = (TchRouteRestrictions)rr.getValue();
                val.setDepartureDatesRestriction(TchRouteRestrictions.DepartureDatesRestriction.ALL);
                val.setDepartureDatesFromValue(null);
                val.setDepartureDatesToValue(null);
                String value = recordValue.getRestrictionValue();
                if (value != null && (m = (p = Pattern.compile("\u0441 [0-9]{2}\\.[0-9]{2}\\.[0-9]{4}")).matcher(value)).find()) {
                    try {
                        val.setDepartureDatesFromValue(new SimpleDateFormat("dd.MM.yyyy").parse(m.group().substring(2)));
                    }
                    catch (ParseException e) {
                        log.error("Error ocured during parcing departure date");
                    }
                }
                if (value != null && (m = (p = Pattern.compile("\u043f\u043e [0-9]{2}\\.[0-9]{2}\\.[0-9]{4}")).matcher(value)).find()) {
                    try {
                        val.setDepartureDatesToValue(new SimpleDateFormat("dd.MM.yyyy").parse(m.group().substring(3)));
                    }
                    catch (ParseException e) {
                        log.error("Error ocured during parcing departure date");
                    }
                }
                if ("\u0412\u0441\u0435:".equals(restrictionType = recordValue.getRestrictionType())) {
                    return;
                }
                if ("\u0414\u0430\u0442\u0430 \u0432\u044b\u043b\u0435\u0442\u0430:".equals(restrictionType)) {
                    val.setDepartureDatesRestriction(TchRouteRestrictions.DepartureDatesRestriction.ONLY);
                } else if ("\u041a\u0440\u043e\u043c\u0435:".equals(restrictionType)) {
                    val.setDepartureDatesRestriction(TchRouteRestrictions.DepartureDatesRestriction.EXCEPT);
                } else if ("\u0421\u043e\u0441\u0442\u043e\u0438\u0442 \u0438\u0437:".equals(restrictionType)) {
                    val.setDepartureDatesRestriction(TchRouteRestrictions.DepartureDatesRestriction.CONSIST_OF);
                }
            }

            @Override
            boolean isApplicable(Element row) {
                return TchDataImportHelper.isRecordContains(row, "\u0414\u0430\u0442\u0430 \u0432\u044b\u043b\u0435\u0442\u0430");
            }
        }
        ,
        DepartureDay{

            @Override
            void analizeData(Element row, RuleSettings rule, EntityReference<CommissionProperties> tchCommission) throws Exception {
                RecordValue recordValue = TchDataImportHelper.getRecordValue(row, new String[]{"\u0412\u0441\u0435:", "\u0414\u0435\u043d\u044c \u043d\u0435\u0434\u0435\u043b\u0438 \u0432\u044b\u043b\u0435\u0442\u0430:", "\u041a\u0440\u043e\u043c\u0435:"});
                if (recordValue == null) {
                    throw new Exception(TchDataImportHelper.buildLogErrorMessage(this, row, rule));
                }
                RuleRestriction rr = TchDataImportHelper.getRouteRestrictions(rule);
                TchRouteRestrictions val = (TchRouteRestrictions)rr.getValue();
                val.setDepartureDaysRestriction(TchRouteRestrictions.DepartureDaysRestriction.ALL);
                val.setDepartureDaysValue(null);
                String restrictionType = recordValue.getRestrictionType();
                if ("\u0412\u0441\u0435:".equals(restrictionType)) {
                    return;
                }
                if ("\u0414\u0435\u043d\u044c \u043d\u0435\u0434\u0435\u043b\u0438 \u0432\u044b\u043b\u0435\u0442\u0430:".equals(restrictionType)) {
                    val.setDepartureDaysRestriction(TchRouteRestrictions.DepartureDaysRestriction.ONLY);
                    val.setDepartureDaysValue(recordValue.getRestrictionValue());
                } else if ("\u041a\u0440\u043e\u043c\u0435:".equals(restrictionType)) {
                    val.setDepartureDaysRestriction(TchRouteRestrictions.DepartureDaysRestriction.EXCEPT);
                    val.setDepartureDaysValue(recordValue.getRestrictionValue());
                }
            }

            @Override
            boolean isApplicable(Element row) {
                return TchDataImportHelper.isRecordContains(row, "\u0414\u0435\u043d\u044c \u0432\u044b\u043b\u0435\u0442\u0430");
            }
        }
        ,
        BookingClass{

            @Override
            void analizeData(Element row, RuleSettings rule, EntityReference<CommissionProperties> tchCommission) throws Exception {
                RecordValue recordValue = TchDataImportHelper.getRecordValue(row, new String[]{"\u0412\u0441\u0435:", "\u041a\u043e\u0434\u044b \u043f\u043e\u0434\u043a\u043b\u0430\u0441\u0441\u043e\u0432:", "\u041a\u0440\u043e\u043c\u0435:"});
                if (recordValue == null) {
                    throw new Exception(TchDataImportHelper.buildLogErrorMessage(this, row, rule));
                }
                RuleRestriction rr = TchDataImportHelper.getRouteRestrictions(rule);
                TchRouteRestrictions val = (TchRouteRestrictions)rr.getValue();
                val.setClassOfBookingRestriction(TchRouteRestrictions.ClassOfBookingRestriction.ALL);
                val.setClassOfBookingValue(null);
                String restrictionType = recordValue.getRestrictionType();
                if ("\u0412\u0441\u0435:".equals(restrictionType)) {
                    return;
                }
                if ("\u041a\u043e\u0434\u044b \u043f\u043e\u0434\u043a\u043b\u0430\u0441\u0441\u043e\u0432:".equals(restrictionType)) {
                    val.setClassOfBookingRestriction(TchRouteRestrictions.ClassOfBookingRestriction.ONLY);
                    val.setClassOfBookingValue(recordValue.getRestrictionValue());
                } else if ("\u041a\u0440\u043e\u043c\u0435:".equals(restrictionType)) {
                    val.setClassOfBookingRestriction(TchRouteRestrictions.ClassOfBookingRestriction.EXCEPT);
                    val.setClassOfBookingValue(recordValue.getRestrictionValue());
                }
            }

            @Override
            boolean isApplicable(Element row) {
                return TchDataImportHelper.isRecordContains(row, "\u041a\u043b\u0430\u0441\u0441\u044b");
            }
        }
        ,
        TariffCode{

            @Override
            void analizeData(Element row, RuleSettings rule, EntityReference<CommissionProperties> tchCommission) throws Exception {
                RecordValue recordValue = TchDataImportHelper.getRecordValue(row, new String[]{"\u0412\u0441\u0435:", "\u041a\u043e\u0434\u044b \u0442\u0430\u0440\u0438\u0444\u043e\u0432:", "\u041a\u0440\u043e\u043c\u0435:", "\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u0442:", "\u041d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442:", "\u041d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f \u0441:", "\u041d\u0435 \u043d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f \u0441:"});
                if (recordValue == null) {
                    throw new Exception(TchDataImportHelper.buildLogErrorMessage(this, row, rule));
                }
                RuleRestriction rr = TchDataImportHelper.getRouteRestrictions(rule);
                TchRouteRestrictions val = (TchRouteRestrictions)rr.getValue();
                val.setTariffCodeRestriction(TchRouteRestrictions.TariffCodeRestriction.ALL);
                val.setTariffCodeValue(null);
                String restrictionType = recordValue.getRestrictionType();
                if ("\u0412\u0441\u0435:".equals(restrictionType)) {
                    return;
                }
                if ("\u041a\u043e\u0434\u044b \u0442\u0430\u0440\u0438\u0444\u043e\u0432:".equals(restrictionType)) {
                    val.setTariffCodeRestriction(TchRouteRestrictions.TariffCodeRestriction.ONLY);
                    val.setTariffCodeValue(recordValue.getRestrictionValue());
                } else if ("\u041a\u0440\u043e\u043c\u0435:".equals(restrictionType)) {
                    val.setTariffCodeRestriction(TchRouteRestrictions.TariffCodeRestriction.EXCEPT);
                    val.setTariffCodeValue(recordValue.getRestrictionValue());
                } else if ("\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u0442:".equals(restrictionType)) {
                    val.setTariffCodeRestriction(TchRouteRestrictions.TariffCodeRestriction.INCLUDE);
                    val.setTariffCodeValue(recordValue.getRestrictionValue());
                } else if ("\u041d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442:".equals(restrictionType)) {
                    val.setTariffCodeRestriction(TchRouteRestrictions.TariffCodeRestriction.NOT_INCLUDE);
                    val.setTariffCodeValue(recordValue.getRestrictionValue());
                } else if ("\u041d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f \u0441:".equals(restrictionType)) {
                    val.setTariffCodeRestriction(TchRouteRestrictions.TariffCodeRestriction.STARTS);
                    val.setTariffCodeValue(recordValue.getRestrictionValue());
                } else if ("\u041d\u0435 \u043d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f \u0441:".equals(restrictionType)) {
                    val.setTariffCodeRestriction(TchRouteRestrictions.TariffCodeRestriction.NOT_STARTS);
                    val.setTariffCodeValue(recordValue.getRestrictionValue());
                }
            }

            @Override
            boolean isApplicable(Element row) {
                return TchDataImportHelper.isRecordContains(row, "\u0422\u0430\u0440\u0438\u0444\u044b");
            }
        }
        ,
        Commission{

            @Override
            void analizeData(Element row, RuleSettings rule, EntityReference<CommissionProperties> tchCommission) throws Exception {
                String fop = TchDataImportHelper.getFop(row);
                if (fop == null) {
                    throw new Exception(TchDataImportHelper.buildLogErrorMessage(this, row, rule));
                }
                RuleResult rres = null;
                for (RuleResult rr : rule.getResults()) {
                    if (rr.getAction() == null || !rr.getAction().equals(Actions.FOP_COMMISSION)) continue;
                    rres = rr;
                    break;
                }
                if (rres == null) {
                    rres = new RuleResult();
                    rule.getResults().add(rres);
                    rres.setAction((RuleAction)Actions.FOP_COMMISSION);
                    RuleResultValue val = new RuleResultValue();
                    val.setTarget(tchCommission);
                    val.setFopValues(new Object[]{new Double[fops.size()][3], new String[fops.size()][3]});
                    rres.setValue((Object)val);
                }
                List<Money> commissions = this.getCommmissions(row);
                this.setCommissions((RuleResultValue)rres.getValue(), commissions, fops.indexOf(fop));
                if ("\u041d\u0410\u041b".equals(fop)) {
                    this.setCommissions((RuleResultValue)rres.getValue(), commissions, fops.indexOf("\u0410\u0412"));
                    this.setCommissions((RuleResultValue)rres.getValue(), commissions, fops.indexOf("ANY"));
                }
            }

            private List<Money> getCommmissions(Element row) throws Exception {
                ArrayList<Money> commissions = new ArrayList<Money>();
                Element[] cells = XmlUtil.getElements((Element)row, (String)"Cell");
                if (cells.length > 4) {
                    int max = 7;
                    int n = 1;
                    while (n < max) {
                        String amount = XmlUtil.getValue((Element)cells[n], (String)"Data");
                        if ("x".equals(amount)) {
                            commissions.add(null);
                            n += 2;
                            continue;
                        }
                        String currency = XmlUtil.getValue((Element)cells[n + 1], (String)"Data");
                        commissions.add(SystemHelper.getMoney((double)this.parseAmount(amount), (String)this.parseCurrency(currency)));
                        n += 2;
                    }
                } else {
                    for (int n = 1; n < 4; ++n) {
                        String amountCurrency = XmlUtil.getValue((Element)cells[n], (String)"Data");
                        if ("x".equals(amountCurrency)) {
                            commissions.add(null);
                            continue;
                        }
                        commissions.add(SystemHelper.getMoney((double)this.parseAmount(amountCurrency), (String)this.parseCurrency(amountCurrency)));
                    }
                }
                return commissions;
            }

            private String parseCurrency(String value) throws Exception {
                if (value.contains("%")) {
                    return "XXX";
                }
                if (value.contains("\u0420\u0443\u0431")) {
                    return "RUB";
                }
                if (value.contains("\u0415\u0432\u0440")) {
                    return "EUR";
                }
                if (value.contains("\u0414\u043e\u043b")) {
                    return "USD";
                }
                throw new Exception("Unparseble commission currency " + value);
            }

            private double parseAmount(String value) throws Exception {
                Pattern p;
                Matcher matcher;
                if (TextUtil.isBlank((String)value)) {
                    log.warn("value is null");
                }
                if ((matcher = (p = Pattern.compile("[0-9]+\\.*[0-9]*")).matcher(value)).find()) {
                    return Double.parseDouble(matcher.group());
                }
                throw new Exception("Unparsable commission ammount" + value);
            }

            private void setCommissions(RuleResultValue value, List<Money> commissions, int indexOf) throws Exception {
                Object[] values = value.getFopValues();
                Double[][] doubleValues = (Double[][])values[0];
                String[][] codes = (String[][])values[1];
                for (int n = 0; n < 3; ++n) {
                    Money commission = commissions.get(n);
                    if (commission == null) {
                        doubleValues[indexOf][n] = null;
                        codes[indexOf][n] = null;
                        continue;
                    }
                    doubleValues[indexOf][n] = this.getDouble(commission.getValue());
                    String currencyCode = commission.getCurrency();
                    codes[indexOf][n] = "XXX".equals(currencyCode) ? "%" : currencyCode;
                }
            }

            private Double getDouble(BigDecimal value) {
                if (value == null) {
                    return null;
                }
                return value.doubleValue();
            }

            @Override
            boolean isApplicable(Element row) {
                return TchDataImportHelper.getFop(row) != null;
            }
        }
        ,
        ElectronicTicket{

            @Override
            void analizeData(Element row, RuleSettings rule, EntityReference<CommissionProperties> tchCommission) throws Exception {
                RecordValue recordValue = TchDataImportHelper.getRecordValue(row, new String[]{"\u0412\u0441\u0435:", "\u041a\u0440\u043e\u043c\u0435 \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0433\u043e \u0431\u0438\u043b\u0435\u0442\u0430:", "\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0431\u0438\u043b\u0435\u0442:"});
                if (recordValue == null) {
                    throw new Exception(TchDataImportHelper.buildLogErrorMessage(this, row, rule));
                }
                String restrictionType = recordValue.getRestrictionType();
                if ("\u0412\u0441\u0435:".equals(restrictionType)) {
                    return;
                }
                RuleRestriction rr = new RuleRestriction();
                rr.setProperty((RuleProperty)Properties.E_TICKET);
                rr.setCondition((RuleCondition)Conditions.EQUALS);
                rr.setValue((Object)Boolean.FALSE);
                if ("\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0431\u0438\u043b\u0435\u0442:".equals(restrictionType)) {
                    rr.setValue((Object)Boolean.TRUE);
                }
                rule.getRestrictions().add(rr);
            }

            @Override
            boolean isApplicable(Element row) {
                return TchDataImportHelper.isRecordContains(row, "\u041f\u0435\u0440\u0435\u0432.\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
            }
        };


        abstract void analizeData(Element var1, RuleSettings var2, EntityReference<CommissionProperties> var3) throws Exception;

        abstract boolean isApplicable(Element var1);
    }
}

