/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bookingFile.handler;

import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.SysLogItem;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.AdditionalServiceProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.SysLogHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.server.fx.bookingFile.handler.BaseProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.helper.BookingFileHelper;
import com.gridnine.xtrip.server.model.helpers.clone.AdditionalServiceProductCloneHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdditionalServiceProductFXHandler
extends BaseProductFXHandler<AdditionalServiceProduct> {
    private static final Logger log = LoggerFactory.getLogger(SysLogHelper.class);

    @Override
    public Class<AdditionalServiceProduct> getProductClass() {
        return AdditionalServiceProduct.class;
    }

    @Override
    public List<Message> recalculateFOP(AdditionalServiceProduct AdditionalServiceProduct2, ProductStatus[] appropriateStatusArray, EntityContainer<BookingFile> ctr) {
        return BookingFileHelper.recalculateFop((BaseProduct)AdditionalServiceProduct2, appropriateStatusArray, GeneralProductHelper::updateFops, AdditionalServiceProduct2.getStatus(), ctr);
    }

    @Override
    public EntityReference<Organization> getSubAgency(AdditionalServiceProduct baseProduct) {
        return AdditionalServiceProductHelper.getSubagency((AdditionalServiceProduct)baseProduct);
    }

    @Override
    public BookingFileService.ProductRPCResult refundProduct(AdditionalServiceProduct productToRefund, EntityContainer<BookingFile> ctr, ProductExchangeRefundProperties exchangeProperties) {
        ArrayList<Message> messages = new ArrayList<Message>();
        String newProductUid = null;
        if (productToRefund.getStatus() != ProductStatus.SELL) {
            messages.add(Messages.getExceptionTicketReturnCannot((String)productToRefund.getSystemNumber(), (String)ProductStatus.SELL.toString()));
        } else if (productToRefund.getNextProduct() != null) {
            messages.add(Messages.getExceptionProductReturnCannot((String)productToRefund.getSystemNumber()));
        } else {
            try {
                AdditionalServiceProduct refundProduct = AdditionalServiceProductHelper.createRefund((AdditionalServiceProduct)productToRefund);
                newProductUid = refundProduct.getUid();
                Message msg = Messages.getNotificationAddedInOrder((BaseProduct)refundProduct);
                AdditionalServiceProductFXHandler.logging((EntityReference<BookingFile>)ctr.toReference(), msg);
            }
            catch (Exception e) {
                messages.add(Messages.getExceptionTicketReturn((String)productToRefund.getSystemNumber(), (Exception)e));
            }
        }
        return new BookingFileService.ProductRPCResult(messages, newProductUid);
    }

    @Override
    public List<Message> cloneProductToSameReservation(AdditionalServiceProduct source, EntityContainer<BookingFile> bookingFileContainer, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToSameReservation(source, bookingFileContainer, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewReservation(AdditionalServiceProduct source, EntityContainer<BookingFile> bookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToNewReservation(source, bookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewBookingFile(AdditionalServiceProduct source, EntityContainer<BookingFile> sourceBookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, EntityContainer<BookingFile> targetBookingFileContainer, int amount, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer) {
        return BaseProductFXHandler.cloneProductToNewBookingFile(source, sourceBookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, targetBookingFileContainer, amount, forwardAgencyMemo, targetClient, changeRetailPayer, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductForCorrection(AdditionalServiceProduct source, EntityContainer<BookingFile> targetBookingFileContainer, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer, Map<String, String> uidsMapping) {
        return AdditionalServiceProductFXHandler.cloneProductForCorrection(source, targetBookingFileContainer, targetClient, targetPayer, uidsMapping, this.createCloneHandler());
    }

    @Override
    public void setSubAgency(AdditionalServiceProduct product, EntityReference<Organization> subagency) {
        AdditionalServiceProductHelper.setSubagency((AdditionalServiceProduct)product, subagency);
    }

    private ProductFXHandler.ProductCloneFXHandler<AdditionalServiceProduct> createCloneHandler() {
        return new ProductFXHandler.ProductCloneFXHandler<AdditionalServiceProduct>(){
            final Date date = new Date();

            @Override
            public AdditionalServiceProduct createProduct() {
                return new AdditionalServiceProduct();
            }

            @Override
            public void cloneProduct(AdditionalServiceProduct source, AdditionalServiceProduct target) throws Exception {
                AdditionalServiceProductCloneHelper.clone((AdditionalServiceProduct)source, (AdditionalServiceProduct)target);
            }

            @Override
            public void cloneProduct(AdditionalServiceProduct source, AdditionalServiceProduct target, Map<String, String> uidsMapping) throws Exception {
                AdditionalServiceProductCloneHelper.clone((AdditionalServiceProduct)source, (AdditionalServiceProduct)target, uidsMapping);
            }

            @Override
            public void updateProduct(AdditionalServiceProduct target, String systemNumber) {
                target.setSystemNumber(systemNumber);
                target.setIssueDate(this.date);
            }

            @Override
            public void updateProductsForCorrection(AdditionalServiceProduct source, AdditionalServiceProduct target, Map<String, String> uidsMapping) {
                source.setCorrectionDate(new Date());
                source.setTicketType(TicketType.CORRECTION);
                target.setIssueDate(source.getIssueDate());
                target.setContractRulesApplied(false);
                target.setCompleted(false);
                target.setShipmentsDate(null);
                target.setShipmentsDateSubagent(null);
                target.getPrepaymentDocuments().clear();
                target.getFopDetalizations().clear();
            }

            @Override
            public void resetTraveller(AdditionalServiceProduct target) {
                target.getTravellers().clear();
            }
        };
    }

    private static void logging(EntityReference<BookingFile> ref, Message msg) {
        List<SysLogItem> lst = Collections.singletonList(SysLogHelper.newAuditItem(ref, (String)"entity-modification", (Message)msg));
        try {
            log.debug("saveMultiple() BEGIN");
            AssetsStorage.get().save(lst);
            log.debug("saveMultiple() END");
        }
        catch (Exception e) {
            log.error("unable to create log  item for object " + ref, (Throwable)e);
        }
    }
}

