/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bookingFile.handler;

import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.AeroExpressHelper;
import com.gridnine.xtrip.common.model.helpers.AeroexpressTicketHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.server.fx.bookingFile.handler.BaseProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.helper.BookingFileHelper;
import com.gridnine.xtrip.server.model.helpers.clone.AeroexpressTicketCloneHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class AeroexpressProductFXHandler
extends BaseProductFXHandler<AeroexpressTicket> {
    @Override
    public Class<AeroexpressTicket> getProductClass() {
        return AeroexpressTicket.class;
    }

    @Override
    public EntityReference<Organization> getSubAgency(AeroexpressTicket baseProduct) {
        return AeroExpressHelper.getSubagency((AeroexpressTicket)baseProduct);
    }

    @Override
    public List<Message> recalculateFOP(AeroexpressTicket aeroexpressTicket, ProductStatus[] appropriateStatusArray, EntityContainer<BookingFile> ctr) {
        return BookingFileHelper.recalculateFop((BaseProduct)aeroexpressTicket, appropriateStatusArray, GeneralProductHelper::updateFops, aeroexpressTicket.getStatus(), ctr);
    }

    @Override
    public List<Message> voidProduct(AeroexpressTicket productToVoid) {
        ArrayList<Message> errorList = new ArrayList<Message>();
        if (productToVoid.getNextProduct() != null) {
            errorList.add(Messages.getWarningProductStatusNotChanged((String)productToVoid.getSystemNumber(), (String)productToVoid.getNextProduct().getSystemNumber()));
        } else if (productToVoid.getStatus() == ProductStatus.BOOKING) {
            productToVoid.setStatus(ProductStatus.VOID_BOOKING);
        } else if (productToVoid.getStatus() == ProductStatus.SELL) {
            productToVoid.setStatus(ProductStatus.VOID);
        }
        return errorList;
    }

    @Override
    public BookingFileService.ProductRPCResult refundProduct(AeroexpressTicket productToRefund, EntityContainer<BookingFile> ctr, ProductExchangeRefundProperties exchangeProperties) {
        ArrayList<Message> messages = new ArrayList<Message>();
        String newProductUid = null;
        if (productToRefund.getStatus() != ProductStatus.SELL) {
            messages.add(Messages.getExceptionTicketReturnCannot((String)productToRefund.getSystemNumber(), (String)ProductStatus.SELL.toString()));
        } else if (productToRefund.getNextProduct() != null) {
            messages.add(Messages.getExceptionProductReturnCannot((String)productToRefund.getSystemNumber()));
        } else {
            try {
                AeroexpressTicket refundProduct = AeroexpressTicketHelper.createRefund((AeroexpressTicket)productToRefund);
                newProductUid = refundProduct.getUid();
            }
            catch (Exception e) {
                messages.add(Messages.getExceptionTicketReturn((String)productToRefund.getSystemNumber(), (Exception)e));
            }
        }
        return new BookingFileService.ProductRPCResult(messages, newProductUid);
    }

    @Override
    public BookingFileService.ProductRPCResult exchangeProduct(AeroexpressTicket productToExchange, EntityContainer<BookingFile> ctr, ProductExchangeRefundProperties exchangeProperties) {
        ArrayList<Message> messages = new ArrayList<Message>();
        String newProductUid = null;
        try {
            AeroexpressTicket exchange = AeroexpressTicketHelper.createExchange((AeroexpressTicket)productToExchange);
            newProductUid = exchange.getUid();
        }
        catch (Throwable e) {
            messages.add(Messages.getExceptionTicketExchange((String)productToExchange.getSystemNumber(), (Throwable)e));
        }
        return new BookingFileService.ProductRPCResult(messages, newProductUid);
    }

    @Override
    public List<Message> cloneProductToSameReservation(AeroexpressTicket source, EntityContainer<BookingFile> bookingFileContainer, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToSameReservation(source, bookingFileContainer, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewReservation(AeroexpressTicket source, EntityContainer<BookingFile> bookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToNewReservation(source, bookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewBookingFile(AeroexpressTicket source, EntityContainer<BookingFile> sourceBookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, EntityContainer<BookingFile> targetBookingFileContainer, int amount, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer) {
        return BaseProductFXHandler.cloneProductToNewBookingFile(source, sourceBookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, targetBookingFileContainer, amount, forwardAgencyMemo, targetClient, changeRetailPayer, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductForCorrection(AeroexpressTicket source, EntityContainer<BookingFile> targetBookingFileContainer, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer, Map<String, String> uidsMapping) {
        return AeroexpressProductFXHandler.cloneProductForCorrection(source, targetBookingFileContainer, targetClient, targetPayer, uidsMapping, this.createCloneHandler());
    }

    @Override
    public void setSubAgency(AeroexpressTicket product, EntityReference<Organization> subagency) {
        AeroexpressTicketHelper.setSubagency((AeroexpressTicket)product, subagency);
    }

    private ProductFXHandler.ProductCloneFXHandler<AeroexpressTicket> createCloneHandler() {
        return new ProductFXHandler.ProductCloneFXHandler<AeroexpressTicket>(){
            final Date date = new Date();

            @Override
            public AeroexpressTicket createProduct() {
                return new AeroexpressTicket();
            }

            @Override
            public void cloneProduct(AeroexpressTicket source, AeroexpressTicket target) throws Exception {
                AeroexpressTicketCloneHelper.clone((AeroexpressTicket)source, (AeroexpressTicket)target);
            }

            @Override
            public void cloneProduct(AeroexpressTicket source, AeroexpressTicket target, Map<String, String> uidsMapping) throws Exception {
                AeroexpressTicketCloneHelper.clone((AeroexpressTicket)source, (AeroexpressTicket)target, uidsMapping);
            }

            @Override
            public void updateProduct(AeroexpressTicket target, String systemNumber) {
                target.setSystemNumber(systemNumber);
                target.setIssueDate(this.date);
            }

            @Override
            public void updateProductsForCorrection(AeroexpressTicket source, AeroexpressTicket target, Map<String, String> uidsMapping) {
                source.setCorrectionDate(new Date());
                source.setTicketType(TicketType.CORRECTION);
                target.setIssueDate(source.getIssueDate());
                target.setContractRulesApplied(false);
                target.setCompleted(false);
                target.setShipmentsDate(null);
                target.setShipmentsDateSubagent(null);
                target.getPrepaymentDocuments().clear();
                target.getFopDetalizations().clear();
            }

            @Override
            public void resetTraveller(AeroexpressTicket target) {
                target.setTraveller(null);
            }
        };
    }
}

