/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bookingFile.handler;

import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorInfo;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationSystemInfo;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.fx.bookingFile.handler.BaseProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.helper.BookingFileHelper;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.model.helpers.clone.AgencyMemoProductCloneHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class AgencyMemoProductFXHandler
extends BaseProductFXHandler<AgencyMemoProduct> {
    @Override
    public Class<AgencyMemoProduct> getProductClass() {
        return AgencyMemoProduct.class;
    }

    @Override
    public List<Message> recalculateFOP(AgencyMemoProduct product, ProductStatus[] appropriateStatusArray, EntityContainer<BookingFile> ctr) {
        return BookingFileHelper.recalculateFop((BaseProduct)product, appropriateStatusArray, GeneralProductHelper::updateFops, ProductStatus.SELL, ctr);
    }

    public List<Message> reSubmitProductToSameReservation(AgencyMemoProduct srcProduct, EntityContainer<BookingFile> srcBookingFileContainer, String ticketNum, EntityReference<Organization> targetClient, EntityReference<Contract> targetContract) {
        ProductFXHandler.ProductCloneFXHandler<AgencyMemoProduct> fxHandler = this.createCloneHandler();
        try {
            ArrayList<Message> messages = new ArrayList<Message>();
            Reservation targetReservation = srcProduct.getReservation();
            AgencyMemoProduct target = this.linkSrcToTarget(srcProduct, srcBookingFileContainer, targetReservation, ticketNum, targetClient, targetContract, fxHandler);
            fxHandler.resetTraveller(target);
            messages.add(BookingFileHelper.createSuccessMessage((BaseProduct)target, (BaseProduct)srcProduct, srcBookingFileContainer));
            srcBookingFileContainer.getVersionInfo().setDataSource("re-submit-product-same-reservation");
            ((BookingFile)srcBookingFileContainer.getEntity()).setCustomerProfile(targetClient);
            EntityStorage.get().save(srcBookingFileContainer, true);
            SysLogHelper.audit((EntityReference)srcBookingFileContainer.toReference(), (String)"entity-modification", messages);
            return messages;
        }
        catch (Exception e) {
            return Collections.singletonList(Messages.getExceptionCannotCopyProduct((Throwable)e));
        }
    }

    public List<Message> reSubmitProductToNewBookingFile(AgencyMemoProduct srcProduct, EntityContainer<BookingFile> srcBookingFileContainer, EntityContainer<BookingFile> destBookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String reservationNum, String ticketNum, EntityReference<Organization> targetClient, EntityReference<Contract> targetContract) {
        ProductFXHandler.ProductCloneFXHandler<AgencyMemoProduct> fxHandler = this.createCloneHandler();
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            BookingFile tgtBookingFile = (BookingFile)destBookingFileContainer.getEntity();
            tgtBookingFile.setCreateDate(new Date());
            tgtBookingFile.setAgency(((BookingFile)srcBookingFileContainer.getEntity()).getAgency());
            tgtBookingFile.setCustomerProfile(((BookingFile)srcBookingFileContainer.getEntity()).getCustomerProfile());
            ArrayList<Consumer<EntityContainer>> addMessageOperations = new ArrayList<Consumer<EntityContainer>>();
            AgencyMemoProduct target = fxHandler.createProduct();
            Reservation targetReservation = new Reservation();
            ReservationSystemInfo systemInfo = new ReservationSystemInfo();
            systemInfo.setGdsName(gdsName);
            RecordLocatorInfo recordLocatorInfo = new RecordLocatorInfo();
            recordLocatorInfo.setType(recordLocatorType);
            recordLocatorInfo.setRecordLocator(reservationNum);
            systemInfo.getRecordLocators().add(recordLocatorInfo);
            targetReservation.getGdsNameInfo().getSystemInfos().add(systemInfo);
            this.linkSrcToTarget(srcProduct, srcBookingFileContainer, targetReservation, ticketNum, targetClient, targetContract, fxHandler);
            BookingHelper.addReservation((BookingFile)tgtBookingFile, (Reservation)targetReservation);
            fxHandler.resetTraveller(target);
            addMessageOperations.add(ctr -> messages.add(BookingFileHelper.createSuccessMessage((BaseProduct)target, (BaseProduct)srcProduct, (EntityContainer<BookingFile>)ctr)));
            destBookingFileContainer.getVersionInfo().setDataSource("fx-reSubmitProductToNewBookingFile");
            EntityStorage.get().save(destBookingFileContainer, true);
            addMessageOperations.forEach(op -> op.accept(destBookingFileContainer));
            SysLogHelper.audit((EntityReference)destBookingFileContainer.toReference(), (String)"entity-modification", messages);
            return messages;
        }
        catch (Exception e) {
            return Collections.singletonList(Messages.getExceptionCannotCopyProduct((Throwable)e));
        }
    }

    private AgencyMemoProduct linkSrcToTarget(AgencyMemoProduct srcProduct, EntityContainer<BookingFile> srcBookingFileContainer, Reservation targetReservation, String ticketNum, EntityReference<Organization> targetClient, EntityReference<Contract> targetContract, ProductFXHandler.ProductCloneFXHandler<AgencyMemoProduct> fxHandler) throws Exception {
        AgencyMemoProduct target = fxHandler.createProduct();
        fxHandler.cloneProduct(srcProduct, target);
        fxHandler.updateProduct(target, ticketNum);
        target.setSupplier(srcProduct.getAgency());
        target.setAgency(targetClient);
        target.getFops().forEach(fop -> fop.setPayer(targetClient));
        EntityContainer contractContainer = EntityStorage.get().resolve(targetContract);
        ContractCustomerInfo cci = ((Contract)contractContainer.getEntity()).getCustomers().stream().filter(ci -> MiscUtil.equals((Object)ci.getCustomer(), (Object)targetClient)).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"Exception when get contract from client", (Object[])new Object[0]));
        target.setContract(new NestedEntityReference(contractContainer, (BaseEntity)cci, cci.getCustomer().getCaption()));
        target.setSupplierAgencyMemo(new NestedEntityReference(srcBookingFileContainer, (BaseEntity)srcProduct, srcProduct.getSystemNumber()));
        BookingHelper.addProduct((Reservation)targetReservation, (BaseProduct)target);
        return target;
    }

    @Override
    public List<Message> cloneProductToSameReservation(AgencyMemoProduct source, EntityContainer<BookingFile> bookingFileContainer, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToSameReservation(source, bookingFileContainer, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewReservation(AgencyMemoProduct source, EntityContainer<BookingFile> bookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToNewReservation(source, bookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewBookingFile(AgencyMemoProduct source, EntityContainer<BookingFile> sourceBookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, EntityContainer<BookingFile> targetBookingFileContainer, int amount, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer) {
        return BaseProductFXHandler.cloneProductToNewBookingFile(source, sourceBookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, targetBookingFileContainer, amount, forwardAgencyMemo, targetClient, changeRetailPayer, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductForCorrection(AgencyMemoProduct source, EntityContainer<BookingFile> targetBookingFileContainer, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer, Map<String, String> uidsMapping) {
        return AgencyMemoProductFXHandler.cloneProductForCorrection(source, targetBookingFileContainer, targetClient, targetPayer, uidsMapping, this.createCloneHandler());
    }

    private ProductFXHandler.ProductCloneFXHandler<AgencyMemoProduct> createCloneHandler() {
        return new ProductFXHandler.ProductCloneFXHandler<AgencyMemoProduct>(){
            final Date date = new Date();

            @Override
            public AgencyMemoProduct createProduct() {
                return new AgencyMemoProduct();
            }

            @Override
            public void cloneProduct(AgencyMemoProduct source, AgencyMemoProduct target) throws Exception {
                AgencyMemoProductCloneHelper.clone((AgencyMemoProduct)source, (AgencyMemoProduct)target);
            }

            @Override
            public void cloneProduct(AgencyMemoProduct source, AgencyMemoProduct target, Map<String, String> uidsMapping) throws Exception {
                AgencyMemoProductCloneHelper.clone((AgencyMemoProduct)source, (AgencyMemoProduct)target, uidsMapping);
            }

            @Override
            public void updateProduct(AgencyMemoProduct target, String systemNumber) {
                target.setSystemNumber(systemNumber);
                target.setIssueDate(this.date);
            }

            @Override
            public void updateProductsForCorrection(AgencyMemoProduct source, AgencyMemoProduct target, Map<String, String> uidsMapping) {
                source.setCorrectionDate(new Date());
                source.setTicketType(TicketType.CORRECTION);
                target.setIssueDate(source.getIssueDate());
                target.setCompleted(false);
                target.setShipmentsDate(null);
                target.setShipmentsDateSubagent(null);
                target.getPrepaymentDocuments().clear();
                target.getFopDetalizations().clear();
            }

            @Override
            public void resetTraveller(AgencyMemoProduct target) {
            }
        };
    }
}

