/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bookingFile.handler;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.misc.AgentTouch;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.handlers.standard.AgentTouchProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.server.fx.bookingFile.handler.BaseProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.helper.BookingFileHelper;
import com.gridnine.xtrip.server.model.helpers.clone.AgentTouchCloneHelper;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class AgentTouchProductFXHandler
extends BaseProductFXHandler<AgentTouch> {
    @Override
    public Class<AgentTouch> getProductClass() {
        return AgentTouch.class;
    }

    @Override
    public List<Message> recalculateFOP(AgentTouch product, ProductStatus[] appropriateStatusArray, EntityContainer<BookingFile> ctr) {
        return BookingFileHelper.recalculateFop((BaseProduct)product, appropriateStatusArray, GeneralProductHelper::updateFops, ProductStatus.SELL, ctr);
    }

    @Override
    public EntityReference<Organization> getSubAgency(AgentTouch baseProduct) {
        return AgentTouchProductHelper.getSubagency((AgentTouch)baseProduct);
    }

    @Override
    public List<Message> cloneProductToSameReservation(AgentTouch source, EntityContainer<BookingFile> bookingFileContainer, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToSameReservation(source, bookingFileContainer, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewReservation(AgentTouch source, EntityContainer<BookingFile> bookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToNewReservation(source, bookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewBookingFile(AgentTouch source, EntityContainer<BookingFile> sourceBookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, EntityContainer<BookingFile> targetBookingFileContainer, int amount, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer) {
        return BaseProductFXHandler.cloneProductToNewBookingFile(source, sourceBookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, targetBookingFileContainer, amount, forwardAgencyMemo, targetClient, changeRetailPayer, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductForCorrection(AgentTouch source, EntityContainer<BookingFile> targetBookingFileContainer, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer, Map<String, String> uidsMapping) {
        return AgentTouchProductFXHandler.cloneProductForCorrection(source, targetBookingFileContainer, targetClient, targetPayer, uidsMapping, this.createCloneHandler());
    }

    private ProductFXHandler.ProductCloneFXHandler<AgentTouch> createCloneHandler() {
        return new ProductFXHandler.ProductCloneFXHandler<AgentTouch>(){
            final Date date = new Date();

            @Override
            public AgentTouch createProduct() {
                return new AgentTouch();
            }

            @Override
            public void cloneProduct(AgentTouch source, AgentTouch target) throws Exception {
                AgentTouchCloneHelper.clone((AgentTouch)source, (AgentTouch)target);
            }

            @Override
            public void cloneProduct(AgentTouch source, AgentTouch target, Map<String, String> uidsMapping) throws Exception {
                AgentTouchCloneHelper.clone((AgentTouch)source, (AgentTouch)target, uidsMapping);
            }

            @Override
            public void updateProduct(AgentTouch target, String systemNumber) {
                target.setIssueDate(this.date);
            }

            @Override
            public void updateProductsForCorrection(AgentTouch source, AgentTouch target, Map<String, String> uidsMapping) {
                source.setCorrectionDate(new Date());
                source.setTicketType(TicketType.CORRECTION);
                target.setIssueDate(source.getIssueDate());
                target.setContractRulesApplied(false);
                target.setCompleted(false);
                target.setShipmentsDate(null);
                target.setShipmentsDateSubagent(null);
                target.getPrepaymentDocuments().clear();
                target.getFopDetalizations().clear();
            }

            @Override
            public void resetTraveller(AgentTouch target) {
            }
        };
    }
}

