/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bookingFile.handler;

import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AdditionalServiceProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.FOPHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.fx.bookingFile.handler.BaseProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.helper.BookingFileHelper;
import com.gridnine.xtrip.server.fx.bookingFile.helper.ProductExchangeRefundHelper;
import com.gridnine.xtrip.server.fx.bookingFile.helper.ProductVoidHelper;
import com.gridnine.xtrip.server.model.helpers.clone.AirProductCloneHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;

public class AirProductFXHandler
extends BaseProductFXHandler<Product> {
    @Override
    public Collection<? extends Message> sellProduct(Product product, String number) {
        ArrayList<Message> errorList = new ArrayList<Message>();
        if (product.getStatus().equals((Object)ProductStatus.BOOKING)) {
            product.setStatus(ProductStatus.SELL);
            product.setSystemNumber(number);
        } else {
            errorList.add(Messages.getExceptionProductSalesCannot());
        }
        return errorList;
    }

    @Override
    public EntityReference<Organization> getSubAgency(Product baseProduct) {
        return AirProductHelper.getSubagency((Product)baseProduct);
    }

    @Override
    public Class<Product> getProductClass() {
        return Product.class;
    }

    @Override
    public List<Message> cloneProductToSameReservation(Product source, EntityContainer<BookingFile> bookingFileContainer, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToSameReservation(source, bookingFileContainer, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler(() -> false));
    }

    @Override
    public List<Message> cloneProductToNewReservation(Product source, EntityContainer<BookingFile> bookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToNewReservation(source, bookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler(() -> !BookingHelper.hasReservation((BookingFile)((BookingFile)bookingFileContainer.getEntity()), (String)recordLocator)));
    }

    @Override
    public List<Message> cloneProductToNewBookingFile(Product source, EntityContainer<BookingFile> sourceBookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, EntityContainer<BookingFile> targetBookingFileContainer, int amount, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer) {
        return BaseProductFXHandler.cloneProductToNewBookingFile(source, sourceBookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, targetBookingFileContainer, amount, forwardAgencyMemo, targetClient, changeRetailPayer, this.createCloneHandler(() -> true));
    }

    @Override
    public List<Message> cloneProductForCorrection(Product source, EntityContainer<BookingFile> targetBookingFileContainer, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer, Map<String, String> uidsMapping) {
        return AirProductFXHandler.cloneProductForCorrection(source, targetBookingFileContainer, targetClient, targetPayer, uidsMapping, this.createCloneHandler(() -> true));
    }

    @Override
    public List<Message> recalculateFOP(Product airProduct, ProductStatus[] appropriateStatusArray, EntityContainer<BookingFile> ctr) {
        return BookingFileHelper.recalculateFop((BaseProduct)airProduct, appropriateStatusArray, product -> AirProductHelper.updateFops((Product)((Product)product)), airProduct.getStatus(), ctr);
    }

    @Override
    public List<Message> voidProduct(Product productToVoid) {
        ArrayList<Message> errorList = new ArrayList<Message>();
        boolean isVoidable = ProductVoidHelper.checkVoidableStatus(productToVoid, errorList);
        if (!isVoidable) {
            return errorList;
        }
        Product previousProduct = productToVoid.getPreviousProduct();
        if (productToVoid.isDuplicate()) {
            productToVoid.getRelatedProducts().clear();
            productToVoid.setDuplicate(false);
        }
        productToVoid.setStatus(productToVoid.getStatus() == ProductStatus.BOOKING ? ProductStatus.VOID_BOOKING : ProductStatus.VOID);
        if (previousProduct != null && previousProduct.getStatus() == ProductStatus.EXCHANGE) {
            Product previousPreviousProduct = previousProduct.getPreviousProduct();
            if (previousPreviousProduct != null) {
                previousPreviousProduct.setNextProduct(null);
            }
            productToVoid.getReservation().getBookingFile().getReservations().forEach(reservation -> reservation.getProducts().remove(previousProduct));
            productToVoid.setPreviousProductStatus(previousProduct.getStatus());
            productToVoid.setPreviousProduct(null);
        }
        return errorList;
    }

    @Override
    public BookingFileService.ProductRPCResult exchangeProduct(Product product, EntityContainer<BookingFile> bookingFileContainer, ProductExchangeRefundProperties exchangeProperties) {
        ArrayList<Message> messages = new ArrayList<Message>();
        String productName = BookingHelper.generateShortProductName((BaseProduct)product);
        String newProductUid = null;
        if (!AirProductHelper.getDuplicateByRelatedProduct((Product)product).isEmpty()) {
            messages.add(Messages.getExceptionTicketDublicate((String)productName));
            return new BookingFileService.ProductRPCResult(messages, null);
        }
        try {
            EntityContainer agentContainer = exchangeProperties.getAgent() == null ? null : EntityStorage.get().resolve(exchangeProperties.getAgent());
            String agentCode = agentContainer == null ? null : ((Person)agentContainer.getEntity()).getCode();
            Product exchangeProduct = ProductExchangeRefundHelper.createExchangeProduct(product, exchangeProperties, agentCode);
            ProductExchangeRefundHelper.addSummaryMessages(exchangeProduct, (EntityReference<BookingFile>)bookingFileContainer.toReference(), messages);
            Product sellProduct = ProductExchangeRefundHelper.createNewSellProduct(product, exchangeProduct, exchangeProperties, agentCode);
            newProductUid = sellProduct.getUid();
            ProductExchangeRefundHelper.addSummaryMessages(sellProduct, (EntityReference<BookingFile>)bookingFileContainer.toReference(), messages);
            if (!exchangeProperties.getEmds().isEmpty()) {
                for (ProductExchangeRefundProperties.ExchangeRefundEMD element : exchangeProperties.getEmds()) {
                    Product mco = ProductExchangeRefundHelper.createMCO(sellProduct, element, exchangeProperties.getOperationDate());
                    ProductExchangeRefundHelper.addSummaryMessages(mco, exchangeProduct, (EntityReference<BookingFile>)bookingFileContainer.toReference(), messages);
                }
            }
        }
        catch (Exception e) {
            messages.add(Messages.getExceptionTicketExchange((String)productName, (Throwable)e));
        }
        return new BookingFileService.ProductRPCResult(messages, newProductUid);
    }

    @Override
    public BookingFileService.ProductRPCResult exchangeProductToVoucher(Product productToExchange, EntityContainer<BookingFile> ctr, ProductExchangeRefundProperties exchangeProperties) {
        ArrayList<Message> messages = new ArrayList<Message>();
        String productName = BookingHelper.generateShortProductName((BaseProduct)productToExchange);
        String newProductUid = null;
        try {
            if (exchangeProperties.getEmds().size() != 1) {
                throw new IllegalArgumentException();
            }
            if (!AirProductHelper.getDuplicateByRelatedProduct((Product)productToExchange).isEmpty()) {
                messages.add(Messages.getExceptionTicketDublicate((String)productName));
                return new BookingFileService.ProductRPCResult(messages, null);
            }
            EntityContainer agentContainer = exchangeProperties.getAgent() == null ? null : EntityStorage.get().resolve(exchangeProperties.getAgent());
            String agentCode = agentContainer == null ? null : ((Person)agentContainer.getEntity()).getCode();
            Product exchangeProduct = ProductExchangeRefundHelper.createExchangeProduct(productToExchange, exchangeProperties, agentCode);
            ProductExchangeRefundHelper.addSummaryMessages(exchangeProduct, (EntityReference<BookingFile>)ctr.toReference(), messages);
            ProductExchangeRefundProperties.ExchangeRefundEMD exchangeRefundEMD = (ProductExchangeRefundProperties.ExchangeRefundEMD)exchangeProperties.getEmds().get(0);
            Product mco = ProductExchangeRefundHelper.createVoucherMCO(exchangeProduct, exchangeRefundEMD, exchangeProperties.getOperationDate(), exchangeProperties.getPenalty());
            mco.getRelatedProducts().add(productToExchange);
            ProductExchangeRefundHelper.addSummaryMessages(mco, exchangeProduct, (EntityReference<BookingFile>)ctr.toReference(), messages);
            newProductUid = mco.getUid();
        }
        catch (Exception e) {
            messages.add(Messages.getExceptionTicketExchange((String)productName, (Throwable)e));
        }
        return new BookingFileService.ProductRPCResult(messages, newProductUid);
    }

    @Override
    public BookingFileService.ProductRPCResult refundProduct(Product product, EntityContainer<BookingFile> bookingFileContainer, ProductExchangeRefundProperties refundProperties) {
        ArrayList<Message> messages = new ArrayList<Message>();
        String productName = BookingHelper.generateShortProductName((BaseProduct)product);
        String newProductUid = null;
        if (!AirProductHelper.getDuplicateByRelatedProduct((Product)product).isEmpty()) {
            messages.add(Messages.getExceptionTicketDublicate((String)productName));
            return new BookingFileService.ProductRPCResult(messages, null);
        }
        try {
            Product mco;
            EntityContainer agentContainer = refundProperties.getAgent() == null ? null : EntityStorage.get().resolve(refundProperties.getAgent());
            String agentCode = agentContainer == null ? null : ((Person)agentContainer.getEntity()).getCode();
            Product refundProduct = ProductExchangeRefundHelper.createRefundProduct(product, refundProperties, agentCode);
            newProductUid = refundProduct.getUid();
            ProductExchangeRefundHelper.addSummaryMessages(refundProduct, (EntityReference<BookingFile>)bookingFileContainer.toReference(), messages);
            if (!refundProperties.getEmds().isEmpty()) {
                mco = ProductExchangeRefundHelper.createMCO(refundProduct, (ProductExchangeRefundProperties.ExchangeRefundEMD)refundProperties.getEmds().get(0), refundProperties.getOperationDate());
                ProductExchangeRefundHelper.addSummaryMessages(mco, refundProduct, (EntityReference<BookingFile>)bookingFileContainer.toReference(), messages);
            }
            if (!TextUtil.isBlank((String)refundProperties.getEmdReferenceNumber())) {
                mco = ProductExchangeRefundHelper.createReferenceMCO(refundProduct, refundProperties.getEmdReferenceNumber(), refundProperties.getOperationDate());
                ProductExchangeRefundHelper.addSummaryMessages(mco, refundProduct, (EntityReference<BookingFile>)bookingFileContainer.toReference(), messages);
            }
        }
        catch (Exception e) {
            messages.add(Messages.getExceptionTicketReturn((String)productName, (Exception)e));
        }
        return new BookingFileService.ProductRPCResult(messages, newProductUid);
    }

    @Override
    public BookingFileService.ProductRPCResult addCertificateOfCompletedFlight(Product product, List<String> usedSegments) {
        ArrayList messages = new ArrayList();
        AdditionalServiceProduct certificate = AdditionalServiceProductHelper.createCertificateOfCompletedFlight((Product)product, usedSegments);
        String referenceUid = certificate.getUid();
        return new BookingFileService.ProductRPCResult(messages, referenceUid);
    }

    @Override
    public void setSubAgency(Product product, EntityReference<Organization> subagency) {
        AirProductHelper.setSubagency((Product)product, subagency);
    }

    private ProductFXHandler.ProductCloneFXHandler<Product> createCloneHandler(BooleanSupplier travellerRequired) {
        return new ProductFXHandler.ProductCloneFXHandler<Product>(){
            final Date date = new Date();

            @Override
            public Product createProduct() {
                return new Product();
            }

            @Override
            public void cloneProduct(Product source, Product target) throws Exception {
                AirProductCloneHelper.clone((Product)source, (Product)target);
            }

            @Override
            public void cloneProduct(Product source, Product target, Map<String, String> uidsMapping) throws Exception {
                AirProductCloneHelper.clone((Product)source, (Product)target, uidsMapping);
            }

            @Override
            public void updateProduct(Product target, String systemNumber) {
                target.setSystemNumber(systemNumber);
                target.setIssueDate(this.date);
            }

            @Override
            public void updateProductsForCorrection(Product source, Product target, Map<String, String> uidsMapping) {
                source.setCorrectionDate(new Date());
                source.setTicketType(TicketType.CORRECTION);
                target.setIssueDate(source.getIssueDate());
                target.setContractRulesApplied(false);
                target.setCompleted(false);
                target.setShipmentsDate(null);
                target.setShipmentsDateSubagent(null);
                target.getPrepaymentDocuments().clear();
                target.getFopDetalizations().clear();
                if (target.getVendorVatDetalization() != null) {
                    FOPHelper.updateTaxesUids((List)target.getVendorVatDetalization().getComponents(), uidsMapping);
                }
            }

            @Override
            public void resetTraveller(Product target) {
                target.setTraveller(null);
            }
        };
    }
}

