/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bookingFile.handler;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorInfo;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationSystemInfo;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProductVoidingHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.helper.BookingFileHelper;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseProductFXHandler<P extends BaseProduct>
implements ProductFXHandler<P> {
    static final Logger log = LoggerFactory.getLogger(BaseProductFXHandler.class);

    @Override
    public List<Message> unVoidProduct(BaseProduct product) {
        ArrayList<Message> messages = new ArrayList<Message>();
        AtomicBoolean hasErrors = new AtomicBoolean(false);
        List relatedVoidings = ProductVoidingHelper.getRelatedVoidings((BaseProduct)product);
        ProductStatus status = GeneralProductHelper.getStatus((BaseProduct)product);
        if (status != ProductStatus.VOID_BOOKING && status != ProductStatus.VOID) {
            messages.add(com.gridnine.xtrip.common.fx.l10n.Messages.getWarningProductStatusOther((String)GeneralProductHelper.getSystemNumber((BaseProduct)product), (ProductStatus)ProductStatus.VOID_BOOKING, (ProductStatus)ProductStatus.VOID));
            hasErrors.set(true);
        }
        relatedVoidings.forEach(pv -> {
            if (ShipmentHelper.hasRelatedShipment((BaseProduct)pv)) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.AirRulesHelper_productHasShimpent, (Object[])new Object[]{GeneralProductHelper.getProductTitle((BaseProduct)pv)}));
                log.debug(String.format("product %s has related shipment, skipping", GeneralProductHelper.getProductTitle((BaseProduct)pv)));
                hasErrors.set(true);
            }
        });
        if (!hasErrors.get()) {
            GeneralProductHelper.setStatus((BaseProduct)product, (ProductStatus)(status == ProductStatus.VOID_BOOKING ? ProductStatus.BOOKING : ProductStatus.SELL));
            relatedVoidings.forEach(ProductVoidingHelper::removeProduct);
        }
        return messages;
    }

    public static <P extends BaseProduct> List<Message> cloneProductToSameReservation(P source, EntityContainer<BookingFile> bookingFileContainer, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo, ProductFXHandler.ProductCloneFXHandler<P> handler) {
        try {
            ArrayList<Message> messages = new ArrayList<Message>();
            for (int i = 0; i < amount; ++i) {
                P target = handler.createProduct();
                handler.cloneProduct(source, target);
                String targetSystemNumber = !TextUtil.isBlank((String)systemNumber) ? (i != 0 ? FormattedNumberUtil.add((String)systemNumber, (long)i) : systemNumber) : null;
                handler.updateProduct(target, targetSystemNumber);
                Reservation targetReservation = source.getReservation();
                targetReservation.getProducts().add(target);
                target.setReservation(targetReservation);
                handler.resetTraveller(target);
                messages.add(BookingFileHelper.createSuccessMessage(target, source, bookingFileContainer));
            }
            bookingFileContainer.getVersionInfo().setDataSource("clone-product-same-reservation");
            EntityStorage.get().save(bookingFileContainer, true);
            SysLogHelper.audit((EntityReference)bookingFileContainer.toReference(), (String)"entity-modification", messages);
            return messages;
        }
        catch (Exception e) {
            return Collections.singletonList(com.gridnine.xtrip.common.fx.l10n.Messages.getExceptionCannotCopyProduct((Throwable)e));
        }
    }

    public static <P extends BaseProduct> List<Message> cloneProductToNewReservation(P source, EntityContainer<BookingFile> bookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo, ProductFXHandler.ProductCloneFXHandler<P> handler) {
        try {
            ArrayList<Message> messages = new ArrayList<Message>();
            for (int i = 0; i < amount; ++i) {
                P target = handler.createProduct();
                handler.cloneProduct(source, target);
                String targetSystemNumber = !TextUtil.isBlank((String)systemNumber) ? (i != 0 ? FormattedNumberUtil.add((String)systemNumber, (long)i) : systemNumber) : null;
                handler.updateProduct(target, targetSystemNumber);
                Reservation targetReservation = source.getReservation().getBookingFile().getReservations().stream().filter(item -> CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)item, (String)recordLocator)).findFirst().orElse(null);
                if (targetReservation == null) {
                    targetReservation = new Reservation();
                    source.getReservation().getBookingFile().getReservations().add(targetReservation);
                    targetReservation.setBookingFile(source.getReservation().getBookingFile());
                    ReservationSystemInfo systemInfo = new ReservationSystemInfo();
                    systemInfo.setGdsName(gdsName);
                    RecordLocatorInfo recordLocatorInfo = new RecordLocatorInfo();
                    recordLocatorInfo.setType(recordLocatorType);
                    recordLocatorInfo.setRecordLocator(recordLocator);
                    systemInfo.getRecordLocators().add(recordLocatorInfo);
                    targetReservation.getGdsNameInfo().getSystemInfos().add(systemInfo);
                }
                targetReservation.getProducts().add(target);
                target.setReservation(targetReservation);
                handler.resetTraveller(target);
                messages.add(BookingFileHelper.createSuccessMessage(target, source, bookingFileContainer));
            }
            bookingFileContainer.getVersionInfo().setDataSource("clone-product-new-reservation");
            EntityStorage.get().save(bookingFileContainer, true);
            SysLogHelper.audit((EntityReference)bookingFileContainer.toReference(), (String)"entity-modification", messages);
            return messages;
        }
        catch (Exception e) {
            return Collections.singletonList(com.gridnine.xtrip.common.fx.l10n.Messages.getExceptionCannotCopyProduct((Throwable)e));
        }
    }

    public static <P extends BaseProduct> List<Message> cloneProductToNewBookingFile(P source, EntityContainer<BookingFile> sourceBookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, EntityContainer<BookingFile> targetBookingFileContainer, int amount, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer, ProductFXHandler.ProductCloneFXHandler<P> handler) {
        try {
            ArrayList<Message> messages = new ArrayList<Message>();
            ArrayList<Consumer<EntityContainer>> addMessageOperations = new ArrayList<Consumer<EntityContainer>>();
            BookingFile targetBookingFile = (BookingFile)targetBookingFileContainer.getEntity();
            boolean clientChanged = false;
            if (targetClient != null && !targetClient.equals((Object)targetBookingFile.getCustomerProfile())) {
                targetBookingFile.setCustomerProfile(targetClient);
                clientChanged = true;
            }
            for (int i = 0; i < amount; ++i) {
                Object target = handler.createProduct();
                handler.cloneProduct(source, target);
                String targetSystemNumber = !TextUtil.isBlank((String)systemNumber) ? (i != 0 ? FormattedNumberUtil.add((String)systemNumber, (long)i) : systemNumber) : null;
                handler.updateProduct(target, targetSystemNumber);
                Reservation targetReservation = targetBookingFile.getReservations().stream().filter(item -> CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)item, (String)recordLocator)).findFirst().orElse(null);
                if (targetReservation == null) {
                    targetReservation = new Reservation();
                    targetBookingFile.getReservations().add(targetReservation);
                    targetReservation.setBookingFile(targetBookingFile);
                    ReservationSystemInfo systemInfo = new ReservationSystemInfo();
                    systemInfo.setGdsName(gdsName);
                    RecordLocatorInfo recordLocatorInfo = new RecordLocatorInfo();
                    recordLocatorInfo.setType(recordLocatorType);
                    recordLocatorInfo.setRecordLocator(recordLocator);
                    systemInfo.getRecordLocators().add(recordLocatorInfo);
                    targetReservation.getGdsNameInfo().getSystemInfos().add(systemInfo);
                }
                targetReservation.getProducts().add(target);
                target.setReservation(targetReservation);
                handler.resetTraveller(target);
                if (clientChanged) {
                    List contractRelations = GeneralProductHelper.copyContractRelations(target);
                    GeneralProductContractRelationData clientContractRelation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)contractRelations, (ContractType)ContractType.CLIENT);
                    boolean payerChanged = false;
                    if (clientContractRelation != null) {
                        for (GeneralProductFop fop : clientContractRelation.getFops()) {
                            if (fop.getPayer() == null || fop.getPayer().equals(targetClient) || (!changeRetailPayer || !ProfileHelper.isRetailProfile((EntityReference)fop.getPayer())) && ProfileHelper.isRetailProfile((EntityReference)fop.getPayer())) continue;
                            fop.setPayer(targetClient);
                            payerChanged = true;
                        }
                    }
                    if (payerChanged) {
                        GeneralProductHelper.getHandler(target).updateContractRelations(target, contractRelations);
                    }
                }
                addMessageOperations.add(ctr -> messages.add(BookingFileHelper.createSuccessMessage(target, source, (EntityContainer<BookingFile>)ctr)));
            }
            targetBookingFileContainer.getVersionInfo().setDataSource("clone-product-new-booking-file");
            EntityStorage.get().save(targetBookingFileContainer, true);
            addMessageOperations.forEach(op -> op.accept(targetBookingFileContainer));
            SysLogHelper.audit((EntityReference)targetBookingFileContainer.toReference(), (String)"entity-modification", messages);
            return messages;
        }
        catch (Exception e) {
            return Collections.singletonList(com.gridnine.xtrip.common.fx.l10n.Messages.getExceptionCannotCopyProduct((Throwable)e));
        }
    }

    public static <P extends BaseProduct> List<Message> cloneProductForCorrection(P source, EntityContainer<BookingFile> targetBookingFileContainer, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer, Map<String, String> uidsMapping, ProductFXHandler.ProductCloneFXHandler<P> handler) {
        try {
            ArrayList<Message> messages = new ArrayList<Message>();
            ArrayList<Consumer<EntityContainer>> addMessageOperations = new ArrayList<Consumer<EntityContainer>>();
            BookingFile targetBookingFile = (BookingFile)targetBookingFileContainer.getEntity();
            if (targetClient != null) {
                targetBookingFile.setCustomerProfile(targetClient);
            }
            Object target = handler.createProduct();
            if (!uidsMapping.containsKey(source.getUid())) {
                uidsMapping.put(source.getUid(), target.getUid());
            } else {
                target.setUid(uidsMapping.get(source.getUid()));
            }
            handler.cloneProduct(source, target, uidsMapping);
            handler.updateProductsForCorrection(source, target, uidsMapping);
            ProductHandler sourceProductHandler = ProductHandler.of(source);
            Reservation targetReservation = targetBookingFile.getReservations().stream().filter(item -> CommonReservationGdsNameInfoHelper.recordLocatorsMatch((Reservation)item, (Reservation)source.getReservation())).findFirst().orElse(null);
            if (targetReservation == null) {
                targetReservation = new Reservation();
                XCloneModelHelper.copy((BaseEntity)source.getReservation(), (BaseEntity)targetReservation, (boolean)true, uidsMapping);
                targetReservation.getProducts().clear();
                targetBookingFile.getReservations().add(targetReservation);
                targetReservation.setBookingFile(targetBookingFile);
            }
            targetReservation.getProducts().add(target);
            target.setReservation(targetReservation);
            if (targetPayer != null) {
                List contractRelations = GeneralProductHelper.copyContractRelations(target);
                GeneralProductContractRelationData clientContractRelation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)contractRelations, (ContractType)ContractType.CLIENT);
                boolean payerChanged = false;
                if (clientContractRelation != null) {
                    for (GeneralProductFop fop : clientContractRelation.getFops()) {
                        if (fop.getPayer() == null || fop.getPayer().equals(targetPayer)) continue;
                        fop.setPayer(targetPayer);
                        payerChanged = true;
                    }
                }
                if (payerChanged) {
                    GeneralProductHelper.getHandler(target).updateContractRelations(target, contractRelations);
                }
            }
            addMessageOperations.add(ctr -> messages.add(BookingFileHelper.createSuccessMessage(target, source, (EntityContainer<BookingFile>)ctr)));
            addMessageOperations.forEach(op -> op.accept(targetBookingFileContainer));
            SysLogHelper.audit((EntityReference)targetBookingFileContainer.toReference(), (String)"entity-modification", messages);
            return messages;
        }
        catch (Exception e) {
            return Collections.singletonList(com.gridnine.xtrip.common.fx.l10n.Messages.getExceptionCannotCopyProduct((Throwable)e));
        }
    }
}

