/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bookingFile.handler;

import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProduct;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProductHelper;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.fx.bookingFile.handler.BaseProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.helper.BookingFileHelper;
import com.gridnine.xtrip.server.model.helpers.clone.CarRentalProductCloneHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class CarRentalProductFXHandler
extends BaseProductFXHandler<CarRentalProduct> {
    @Override
    public Class<CarRentalProduct> getProductClass() {
        return CarRentalProduct.class;
    }

    @Override
    public List<Message> recalculateFOP(CarRentalProduct carRentalProduct, ProductStatus[] appropriateStatusArray, EntityContainer<BookingFile> ctr) {
        return BookingFileHelper.recalculateFop((BaseProduct)carRentalProduct, appropriateStatusArray, GeneralProductHelper::updateFops, carRentalProduct.getStatus(), ctr);
    }

    @Override
    public EntityReference<Organization> getSubAgency(CarRentalProduct baseProduct) {
        return CarRentalProductHelper.getSubagency((CarRentalProduct)baseProduct);
    }

    @Override
    public BookingFileService.ProductRPCResult refundProduct(CarRentalProduct productToRefund, EntityContainer<BookingFile> ctr, ProductExchangeRefundProperties exchangeProperties) {
        String productName = BookingHelper.generateShortProductName((BaseProduct)productToRefund);
        ArrayList<Message> messages = new ArrayList<Message>();
        String newProductUid = null;
        if (productToRefund.getStatus() != ProductStatus.SELL) {
            messages.add(Messages.getExceptionTicketReturnCannot((String)productName, (String)ProductStatus.SELL.toString()));
        } else if (productToRefund.getNextProduct() != null) {
            messages.add(Messages.getExceptionProductReturnCannot((String)productName));
        } else {
            try {
                CarRentalProduct refundProduct = CarRentalProductHelper.createRefund((CarRentalProduct)productToRefund);
                newProductUid = refundProduct.getUid();
            }
            catch (Exception e) {
                messages.add(Messages.getExceptionTicketReturn((String)productName, (Exception)e));
            }
        }
        return new BookingFileService.ProductRPCResult(messages, newProductUid);
    }

    @Override
    public List<Message> cloneProductToSameReservation(CarRentalProduct source, EntityContainer<BookingFile> bookingFileContainer, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToSameReservation(source, bookingFileContainer, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewReservation(CarRentalProduct source, EntityContainer<BookingFile> bookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToNewReservation(source, bookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewBookingFile(CarRentalProduct source, EntityContainer<BookingFile> sourceBookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, EntityContainer<BookingFile> targetBookingFileContainer, int amount, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer) {
        return BaseProductFXHandler.cloneProductToNewBookingFile(source, sourceBookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, targetBookingFileContainer, amount, forwardAgencyMemo, targetClient, changeRetailPayer, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductForCorrection(CarRentalProduct source, EntityContainer<BookingFile> targetBookingFileContainer, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer, Map<String, String> uidsMapping) {
        return CarRentalProductFXHandler.cloneProductForCorrection(source, targetBookingFileContainer, targetClient, targetPayer, uidsMapping, this.createCloneHandler());
    }

    @Override
    public void setSubAgency(CarRentalProduct product, EntityReference<Organization> subagency) {
        CarRentalProductHelper.setSubagency((CarRentalProduct)product, subagency);
    }

    private CarRentalProduct copyProduct(CarRentalProduct srcProduct, Reservation reservation, String ticketNum, List<Message> result) {
        CarRentalProduct destProduct = new CarRentalProduct();
        try {
            CarRentalProductHelper.copy((CarRentalProduct)srcProduct, (CarRentalProduct)destProduct);
            destProduct.setPenalty(null);
        }
        catch (Exception e) {
            result.add(Messages.getExceptionCannotCopyProduct((Throwable)e));
        }
        if (result.isEmpty()) {
            if (!TextUtil.isBlank((String)ticketNum)) {
                destProduct.setSystemNumber(ticketNum);
            }
            destProduct.setIssueDate(new Date());
            destProduct.setReservation(reservation);
            reservation.getProducts().add(destProduct);
        }
        return destProduct;
    }

    private ProductFXHandler.ProductCloneFXHandler<CarRentalProduct> createCloneHandler() {
        return new ProductFXHandler.ProductCloneFXHandler<CarRentalProduct>(){
            final Date date = new Date();

            @Override
            public CarRentalProduct createProduct() {
                return new CarRentalProduct();
            }

            @Override
            public void cloneProduct(CarRentalProduct source, CarRentalProduct target) throws Exception {
                CarRentalProductCloneHelper.clone((CarRentalProduct)source, (CarRentalProduct)target);
            }

            @Override
            public void cloneProduct(CarRentalProduct source, CarRentalProduct target, Map<String, String> uidsMapping) throws Exception {
                CarRentalProductCloneHelper.clone((CarRentalProduct)source, (CarRentalProduct)target, uidsMapping);
            }

            @Override
            public void updateProduct(CarRentalProduct target, String systemNumber) {
                target.setSystemNumber(systemNumber);
                target.setIssueDate(this.date);
            }

            @Override
            public void updateProductsForCorrection(CarRentalProduct source, CarRentalProduct target, Map<String, String> uidsMapping) {
                source.setCorrectionDate(new Date());
                source.setTicketType(TicketType.CORRECTION);
                target.setIssueDate(source.getIssueDate());
                target.setContractRulesApplied(false);
                target.setCompleted(false);
                target.setShipmentsDate(null);
                target.setShipmentsDateSubagent(null);
                target.getPrepaymentDocuments().clear();
                target.getFopDetalizations().clear();
            }

            @Override
            public void resetTraveller(CarRentalProduct target) {
            }
        };
    }
}

