/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bookingFile.handler;

import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.SysLogHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.server.fx.bookingFile.handler.BaseProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.helper.BookingFileHelper;
import com.gridnine.xtrip.server.model.helpers.clone.DeliveryCloneHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeliveryProductFXHandler
extends BaseProductFXHandler<Delivery> {
    private static final Logger log = LoggerFactory.getLogger(SysLogHelper.class);

    @Override
    public Class<Delivery> getProductClass() {
        return Delivery.class;
    }

    @Override
    public List<Message> recalculateFOP(Delivery delivery, ProductStatus[] appropriateStatusArray, EntityContainer<BookingFile> ctr) {
        return BookingFileHelper.recalculateFop((BaseProduct)delivery, appropriateStatusArray, GeneralProductHelper::updateFops, ProductStatus.SELL, ctr);
    }

    @Override
    public EntityReference<Organization> getSubAgency(Delivery baseProduct) {
        return null;
    }

    @Override
    public BookingFileService.ProductRPCResult refundProduct(Delivery productToRefund, EntityContainer<BookingFile> ctr, ProductExchangeRefundProperties exchangeProperties) {
        throw Xeption.forDeveloper((String)"not implemented", (Object[])new Object[0]);
    }

    @Override
    public List<Message> cloneProductToSameReservation(Delivery source, EntityContainer<BookingFile> bookingFileContainer, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToSameReservation(source, bookingFileContainer, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewReservation(Delivery source, EntityContainer<BookingFile> bookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToNewReservation(source, bookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewBookingFile(Delivery source, EntityContainer<BookingFile> sourceBookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, EntityContainer<BookingFile> targetBookingFileContainer, int amount, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer) {
        return BaseProductFXHandler.cloneProductToNewBookingFile(source, sourceBookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, targetBookingFileContainer, amount, forwardAgencyMemo, targetClient, changeRetailPayer, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductForCorrection(Delivery source, EntityContainer<BookingFile> targetBookingFileContainer, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer, Map<String, String> uidsMapping) {
        return DeliveryProductFXHandler.cloneProductForCorrection(source, targetBookingFileContainer, targetClient, targetPayer, uidsMapping, this.createCloneHandler());
    }

    @Override
    public BookingFileService.ProductRPCResult exchangeProduct(Delivery productToExchange, EntityContainer<BookingFile> ctr, ProductExchangeRefundProperties exchangeProperties) {
        throw Xeption.forDeveloper((String)"not implemented", (Object[])new Object[0]);
    }

    @Override
    public List<Message> voidProduct(Delivery productToVoid) {
        ArrayList messages = new ArrayList();
        throw Xeption.forDeveloper((String)"not implemented", (Object[])new Object[0]);
    }

    @Override
    public List<Message> unVoidProduct(Delivery productToVoid) {
        throw Xeption.forDeveloper((String)"not implemented", (Object[])new Object[0]);
    }

    @Override
    public void setSubAgency(Delivery product, EntityReference<Organization> subagency) {
    }

    private ProductFXHandler.ProductCloneFXHandler<Delivery> createCloneHandler() {
        return new ProductFXHandler.ProductCloneFXHandler<Delivery>(){
            final Date date = new Date();

            @Override
            public Delivery createProduct() {
                return new Delivery();
            }

            @Override
            public void cloneProduct(Delivery source, Delivery target) throws Exception {
                DeliveryCloneHelper.clone((Delivery)source, (Delivery)target);
            }

            @Override
            public void cloneProduct(Delivery source, Delivery target, Map<String, String> uidsMapping) throws Exception {
                DeliveryCloneHelper.clone((Delivery)source, (Delivery)target, uidsMapping);
            }

            @Override
            public void updateProduct(Delivery target, String systemNumber) {
                target.setSystemNumber(systemNumber);
                target.setIssueDate(this.date);
            }

            @Override
            public void updateProductsForCorrection(Delivery source, Delivery target, Map<String, String> uidsMapping) {
                source.setCorrectionDate(new Date());
                source.setTicketType(TicketType.CORRECTION);
                target.setIssueDate(source.getIssueDate());
                target.setContractRulesApplied(false);
                target.setCompleted(false);
                target.setShipmentsDate(null);
                target.setShipmentsDateSubagent(null);
                target.getPrepaymentDocuments().clear();
                target.getFopDetalizations().clear();
            }

            @Override
            public void resetTraveller(Delivery target) {
            }
        };
    }
}

