/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bookingFile.handler;

import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.FOPHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.server.fx.bookingFile.handler.BaseProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.helper.BookingFileHelper;
import com.gridnine.xtrip.server.model.helpers.clone.HotelProductCloneHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class HotelProductFXHandler
extends BaseProductFXHandler<HotelProduct> {
    private static final String NAVIGATION_KEY = "navigationKey";
    private static final String TEST_NOT_UNIQ_UID_MSG = "testNotUniqUidMsg";

    @Override
    public Class<HotelProduct> getProductClass() {
        return HotelProduct.class;
    }

    @Override
    public List<Message> recalculateFOP(HotelProduct hotelProduct, ProductStatus[] appropriateStatusArray, EntityContainer<BookingFile> ctr) {
        return BookingFileHelper.recalculateFop((BaseProduct)hotelProduct, appropriateStatusArray, product -> HotelProductHelper.updateFops((HotelProduct)((HotelProduct)product)), hotelProduct.getStatus(), ctr);
    }

    @Override
    public EntityReference<Organization> getSubAgency(HotelProduct baseProduct) {
        return HotelProductHelper.getSubagency((HotelProduct)baseProduct);
    }

    @Override
    public void setSubAgency(HotelProduct product, EntityReference<Organization> subagency) {
        HotelProductHelper.setSubagency((HotelProduct)product, subagency);
    }

    @Override
    public List<Message> cloneProductToSameReservation(HotelProduct source, EntityContainer<BookingFile> bookingFileContainer, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToSameReservation(source, bookingFileContainer, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewReservation(HotelProduct source, EntityContainer<BookingFile> bookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToNewReservation(source, bookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewBookingFile(HotelProduct source, EntityContainer<BookingFile> sourceBookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, EntityContainer<BookingFile> targetBookingFileContainer, int amount, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer) {
        return BaseProductFXHandler.cloneProductToNewBookingFile(source, sourceBookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, targetBookingFileContainer, amount, forwardAgencyMemo, targetClient, changeRetailPayer, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductForCorrection(HotelProduct source, EntityContainer<BookingFile> targetBookingFileContainer, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer, Map<String, String> uidsMapping) {
        return HotelProductFXHandler.cloneProductForCorrection(source, targetBookingFileContainer, targetClient, targetPayer, uidsMapping, this.createCloneHandler());
    }

    private ProductFXHandler.ProductCloneFXHandler<HotelProduct> createCloneHandler() {
        return new ProductFXHandler.ProductCloneFXHandler<HotelProduct>(){
            final Date date = new Date();

            @Override
            public HotelProduct createProduct() {
                return new HotelProduct();
            }

            @Override
            public void cloneProduct(HotelProduct source, HotelProduct target) throws Exception {
                HotelProductCloneHelper.clone((HotelProduct)source, (HotelProduct)target);
            }

            @Override
            public void cloneProduct(HotelProduct source, HotelProduct target, Map<String, String> uidsMapping) throws Exception {
                HotelProductCloneHelper.clone((HotelProduct)source, (HotelProduct)target, uidsMapping);
            }

            @Override
            public void updateProduct(HotelProduct target, String systemNumber) {
                target.setSystemNumber(systemNumber);
                target.setIssueDate(this.date);
            }

            @Override
            public void updateProductsForCorrection(HotelProduct source, HotelProduct target, Map<String, String> uidsMapping) {
                source.setCorrectionDate(new Date());
                source.setTicketType(TicketType.CORRECTION);
                target.setIssueDate(source.getIssueDate());
                target.setContractRulesApplied(false);
                target.setCompleted(false);
                target.setShipmentsDate(null);
                target.setShipmentsDateSubagent(null);
                target.getPrepaymentDocuments().clear();
                target.getFopDetalizations().clear();
                if (target.getVendorVatDetalization() != null) {
                    FOPHelper.updateTaxesUids((List)target.getVendorVatDetalization().getComponents(), uidsMapping);
                }
            }

            @Override
            public void resetTraveller(HotelProduct target) {
                target.getTravellers().clear();
            }
        };
    }

    @Override
    public Collection<? extends Message> sellProduct(HotelProduct product, String number) {
        ArrayList<Message> errorList = new ArrayList<Message>();
        if (product.getStatus() != ProductStatus.SELL) {
            product.setStatus(ProductStatus.SELL);
            product.setSystemNumber(number);
        } else {
            errorList.add(Messages.getExceptionProductSalesCannot());
        }
        return errorList;
    }

    @Override
    public Collection<? extends Message> rejectProduct(HotelProduct product, String number) {
        ArrayList<Message> errorList = new ArrayList<Message>();
        if (product.getStatus() != ProductStatus.REJECT) {
            product.setStatus(ProductStatus.REJECT);
            product.setSystemNumber(number);
        } else {
            errorList.add(Messages.getExceptionRejectRequestCannot());
        }
        return errorList;
    }
}

