/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bookingFile.handler;

import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentHelper;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.fx.bookingFile.handler.BaseProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.helper.BookingFileHelper;
import com.gridnine.xtrip.server.model.helpers.clone.InsuranceAccidentCloneHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class InsuranceAccidentProductFXHandler
extends BaseProductFXHandler<InsuranceAccident> {
    @Override
    public Class<InsuranceAccident> getProductClass() {
        return InsuranceAccident.class;
    }

    @Override
    public List<Message> recalculateFOP(InsuranceAccident insuranceAccident, ProductStatus[] appropriateStatusArray, EntityContainer<BookingFile> ctr) {
        return BookingFileHelper.recalculateFop((BaseProduct)insuranceAccident, appropriateStatusArray, GeneralProductHelper::updateFops, insuranceAccident.getStatus(), ctr);
    }

    @Override
    public void setSubAgency(InsuranceAccident product, EntityReference<Organization> subagency) {
        InsuranceAccidentHelper.setSubagency((InsuranceAccident)product, subagency);
    }

    @Override
    public EntityReference<Organization> getSubAgency(InsuranceAccident baseProduct) {
        return InsuranceAccidentHelper.getSubagency((InsuranceAccident)baseProduct);
    }

    private InsuranceAccident copyProduct(InsuranceAccident srcProduct, Reservation reservation, String ticketNum, List<Message> result) {
        InsuranceAccident destProduct = new InsuranceAccident();
        try {
            InsuranceAccidentHelper.copy((InsuranceAccident)srcProduct, (InsuranceAccident)destProduct);
        }
        catch (Exception e) {
            result.add(Messages.getExceptionCannotCopyProduct((Throwable)e));
        }
        if (result.isEmpty()) {
            if (!TextUtil.isBlank((String)ticketNum)) {
                destProduct.setSystemNumber(ticketNum);
            }
            destProduct.setIssueDate(new Date());
            if (!TextUtil.isBlank((String)srcProduct.getScn())) {
                destProduct.setScn(FormattedNumberUtil.add((String)srcProduct.getScn(), (long)1L));
            }
            destProduct.setReservation(reservation);
            reservation.getProducts().add(destProduct);
        }
        return destProduct;
    }

    @Override
    public BookingFileService.ProductRPCResult refundProduct(InsuranceAccident productToRefund, EntityContainer<BookingFile> ctr, ProductExchangeRefundProperties exchangeProperties) {
        String productName = BookingHelper.generateShortProductName((BaseProduct)productToRefund);
        ArrayList<Message> messages = new ArrayList<Message>();
        String newProductUid = null;
        if (productToRefund.getStatus() != ProductStatus.SELL) {
            messages.add(Messages.getExceptionTicketReturnCannot((String)productName, (String)ProductStatus.SELL.toString()));
        } else if (productToRefund.getNextProduct() != null) {
            messages.add(Messages.getExceptionProductReturnCannot((String)productName));
        } else {
            try {
                InsuranceAccident refundProduct = InsuranceAccidentHelper.createRefundProduct((InsuranceAccident)productToRefund);
                newProductUid = refundProduct.getUid();
            }
            catch (Exception e) {
                messages.add(Messages.getExceptionTicketReturn((String)productName, (Exception)e));
            }
        }
        return new BookingFileService.ProductRPCResult(messages, newProductUid);
    }

    @Override
    public List<Message> voidProduct(InsuranceAccident productToVoid) {
        ArrayList<Message> errorList = new ArrayList<Message>();
        InsuranceAccident previousProduct = productToVoid.getPreviousProduct();
        productToVoid.setStatus(productToVoid.getStatus() == ProductStatus.BOOKING ? ProductStatus.VOID_BOOKING : ProductStatus.VOID);
        if (previousProduct != null && previousProduct.getStatus() == ProductStatus.EXCHANGE) {
            List bookingFileProducts = BookingHelper.getProducts((BookingFile)productToVoid.getReservation().getBookingFile());
            InsuranceAccident previousPreviousProduct = previousProduct.getPreviousProduct();
            if (previousPreviousProduct != null) {
                previousPreviousProduct.setNextProduct(null);
            }
            bookingFileProducts.removeIf(bfProduct -> bfProduct.getUid().equals(previousProduct.getUid()));
            productToVoid.setPreviousProduct(null);
        }
        return errorList;
    }

    @Override
    public List<Message> cloneProductToSameReservation(InsuranceAccident source, EntityContainer<BookingFile> bookingFileContainer, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToSameReservation(source, bookingFileContainer, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewReservation(InsuranceAccident source, EntityContainer<BookingFile> bookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToNewReservation(source, bookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewBookingFile(InsuranceAccident source, EntityContainer<BookingFile> sourceBookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, EntityContainer<BookingFile> targetBookingFileContainer, int amount, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer) {
        return BaseProductFXHandler.cloneProductToNewBookingFile(source, sourceBookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, targetBookingFileContainer, amount, forwardAgencyMemo, targetClient, changeRetailPayer, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductForCorrection(InsuranceAccident source, EntityContainer<BookingFile> targetBookingFileContainer, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer, Map<String, String> uidsMapping) {
        return InsuranceAccidentProductFXHandler.cloneProductForCorrection(source, targetBookingFileContainer, targetClient, targetPayer, uidsMapping, this.createCloneHandler());
    }

    private ProductFXHandler.ProductCloneFXHandler<InsuranceAccident> createCloneHandler() {
        return new ProductFXHandler.ProductCloneFXHandler<InsuranceAccident>(){
            final Date date = new Date();

            @Override
            public InsuranceAccident createProduct() {
                return new InsuranceAccident();
            }

            @Override
            public void cloneProduct(InsuranceAccident source, InsuranceAccident target) throws Exception {
                InsuranceAccidentCloneHelper.clone((InsuranceAccident)source, (InsuranceAccident)target);
            }

            @Override
            public void cloneProduct(InsuranceAccident source, InsuranceAccident target, Map<String, String> uidsMapping) throws Exception {
                InsuranceAccidentCloneHelper.clone((InsuranceAccident)source, (InsuranceAccident)target, uidsMapping);
            }

            @Override
            public void updateProduct(InsuranceAccident target, String systemNumber) {
                target.setSystemNumber(systemNumber);
                target.setIssueDate(this.date);
            }

            @Override
            public void updateProductsForCorrection(InsuranceAccident source, InsuranceAccident target, Map<String, String> uidsMapping) {
                source.setCorrectionDate(new Date());
                source.setTicketType(TicketType.CORRECTION);
                target.setIssueDate(source.getIssueDate());
                target.setContractRulesApplied(false);
                target.setCompleted(false);
                target.setShipmentsDate(null);
                target.setShipmentsDateSubagent(null);
                target.getPrepaymentDocuments().clear();
                target.getFopDetalizations().clear();
            }

            @Override
            public void resetTraveller(InsuranceAccident target) {
                target.setTravellerUid(null);
            }
        };
    }
}

