/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bookingFile.handler;

import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicHelper;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.fx.bookingFile.handler.BaseProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.helper.BookingFileHelper;
import com.gridnine.xtrip.server.model.helpers.clone.InsuranceTouristicCloneHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsuranceTouristicProductFXHandler
extends BaseProductFXHandler<InsuranceTouristic> {
    static final Logger log = LoggerFactory.getLogger(InsuranceTouristicProductFXHandler.class);

    @Override
    public Class<InsuranceTouristic> getProductClass() {
        return InsuranceTouristic.class;
    }

    @Override
    public List<Message> recalculateFOP(InsuranceTouristic insuranceTouristic, ProductStatus[] appropriateStatusArray, EntityContainer<BookingFile> ctr) {
        return BookingFileHelper.recalculateFop((BaseProduct)insuranceTouristic, appropriateStatusArray, GeneralProductHelper::updateFops, insuranceTouristic.getStatus(), ctr);
    }

    @Override
    public void setSubAgency(InsuranceTouristic product, EntityReference<Organization> subagency) {
        InsuranceTouristicHelper.setSubagency((InsuranceTouristic)product, subagency);
    }

    @Override
    public EntityReference<Organization> getSubAgency(InsuranceTouristic baseProduct) {
        return InsuranceTouristicHelper.getSubagency((InsuranceTouristic)baseProduct);
    }

    private InsuranceTouristic copyProduct(InsuranceTouristic srcProduct, Reservation reservation, String ticketNum, List<Message> result) {
        InsuranceTouristic destProduct = new InsuranceTouristic();
        try {
            InsuranceTouristicHelper.copy((InsuranceTouristic)srcProduct, (InsuranceTouristic)destProduct);
        }
        catch (Exception e) {
            result.add(Messages.getExceptionCannotCopyProduct((Throwable)e));
        }
        if (result.isEmpty()) {
            if (!TextUtil.isBlank((String)ticketNum)) {
                destProduct.setSystemNumber(ticketNum);
            }
            destProduct.setIssueDate(new Date());
            if (!TextUtil.isBlank((String)srcProduct.getScn())) {
                destProduct.setScn(FormattedNumberUtil.add((String)srcProduct.getScn(), (long)1L));
            }
            destProduct.setReservation(reservation);
            reservation.getProducts().add(destProduct);
        }
        return destProduct;
    }

    @Override
    public BookingFileService.ProductRPCResult refundProduct(InsuranceTouristic productToRefund, EntityContainer<BookingFile> ctr, ProductExchangeRefundProperties exchangeProperties) {
        String productName = BookingHelper.generateShortProductName((BaseProduct)productToRefund);
        ArrayList<Message> messages = new ArrayList<Message>();
        String newProductUid = null;
        if (productToRefund.getStatus() != ProductStatus.SELL) {
            messages.add(Messages.getExceptionTicketReturnCannot((String)productName, (String)ProductStatus.SELL.toString()));
        } else if (productToRefund.getNextProduct() != null) {
            messages.add(Messages.getExceptionProductReturnCannot((String)productName));
        } else {
            try {
                InsuranceTouristic refundProduct = InsuranceTouristicHelper.createRefund((InsuranceTouristic)productToRefund);
                newProductUid = refundProduct.getUid();
            }
            catch (Exception e) {
                messages.add(Messages.getExceptionTicketReturn((String)productName, (Exception)e));
            }
        }
        return new BookingFileService.ProductRPCResult(messages, newProductUid);
    }

    @Override
    public List<Message> voidProduct(InsuranceTouristic productToVoid) {
        ArrayList<Message> errorList = new ArrayList<Message>();
        InsuranceTouristic previousProduct = productToVoid.getPreviousProduct();
        productToVoid.setStatus(productToVoid.getStatus() == ProductStatus.BOOKING ? ProductStatus.VOID_BOOKING : ProductStatus.VOID);
        if (previousProduct != null && previousProduct.getStatus() == ProductStatus.EXCHANGE) {
            List bookingFileProducts = BookingHelper.getProducts((BookingFile)productToVoid.getReservation().getBookingFile());
            InsuranceTouristic previousPreviousProduct = previousProduct.getPreviousProduct();
            if (previousPreviousProduct != null) {
                previousPreviousProduct.setNextProduct(null);
            }
            bookingFileProducts.removeIf(bfProduct -> bfProduct.getUid().equals(previousProduct.getUid()));
            productToVoid.setPreviousProduct(null);
        }
        return errorList;
    }

    @Override
    public List<Message> cloneProductToSameReservation(InsuranceTouristic source, EntityContainer<BookingFile> bookingFileContainer, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToSameReservation(source, bookingFileContainer, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewReservation(InsuranceTouristic source, EntityContainer<BookingFile> bookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToNewReservation(source, bookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewBookingFile(InsuranceTouristic source, EntityContainer<BookingFile> sourceBookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, EntityContainer<BookingFile> targetBookingFileContainer, int amount, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer) {
        return BaseProductFXHandler.cloneProductToNewBookingFile(source, sourceBookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, targetBookingFileContainer, amount, forwardAgencyMemo, targetClient, changeRetailPayer, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductForCorrection(InsuranceTouristic source, EntityContainer<BookingFile> targetBookingFileContainer, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer, Map<String, String> uidsMapping) {
        return InsuranceTouristicProductFXHandler.cloneProductForCorrection(source, targetBookingFileContainer, targetClient, targetPayer, uidsMapping, this.createCloneHandler());
    }

    private ProductFXHandler.ProductCloneFXHandler<InsuranceTouristic> createCloneHandler() {
        return new ProductFXHandler.ProductCloneFXHandler<InsuranceTouristic>(){
            final Date date = new Date();

            @Override
            public InsuranceTouristic createProduct() {
                return new InsuranceTouristic();
            }

            @Override
            public void cloneProduct(InsuranceTouristic source, InsuranceTouristic target) throws Exception {
                InsuranceTouristicCloneHelper.clone((InsuranceTouristic)source, (InsuranceTouristic)target);
            }

            @Override
            public void cloneProduct(InsuranceTouristic source, InsuranceTouristic target, Map<String, String> uidsMapping) throws Exception {
                InsuranceTouristicCloneHelper.clone((InsuranceTouristic)source, (InsuranceTouristic)target, uidsMapping);
            }

            @Override
            public void updateProduct(InsuranceTouristic target, String systemNumber) {
                target.setSystemNumber(systemNumber);
                target.setIssueDate(this.date);
            }

            @Override
            public void updateProductsForCorrection(InsuranceTouristic source, InsuranceTouristic target, Map<String, String> uidsMapping) {
                source.setCorrectionDate(new Date());
                source.setTicketType(TicketType.CORRECTION);
                target.setIssueDate(source.getIssueDate());
                target.setContractRulesApplied(false);
                target.setCompleted(false);
                target.setShipmentsDate(null);
                target.setShipmentsDateSubagent(null);
                target.getPrepaymentDocuments().clear();
                target.getFopDetalizations().clear();
            }

            @Override
            public void resetTraveller(InsuranceTouristic target) {
                target.getTravellersUids().clear();
            }
        };
    }
}

