/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bookingFile.handler;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProductVoidingHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.fx.bookingFile.handler.BaseProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import com.gridnine.xtrip.server.model.helpers.clone.McoFeesCloneHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCOFeesProductFXHandler
extends BaseProductFXHandler<MCOFees> {
    static final Logger log = LoggerFactory.getLogger(MCOFeesProductFXHandler.class);

    @Override
    public Class<MCOFees> getProductClass() {
        return MCOFees.class;
    }

    @Override
    public List<Message> voidProduct(MCOFees productToVoid) {
        ArrayList<Message> errorList = new ArrayList<Message>();
        if (productToVoid.getStatus() != ProductStatus.SELL) {
            errorList.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"Error setting MCO Fees status - not SELL", (Object[])new Object[0]));
        }
        productToVoid.setStatus(ProductStatus.VOID);
        return errorList;
    }

    @Override
    public List<Message> unVoidProduct(MCOFees product) {
        ArrayList<Message> messages = new ArrayList<Message>();
        AtomicBoolean hasErrors = new AtomicBoolean(false);
        List relatedVoidings = ProductVoidingHelper.getRelatedVoidings((BaseProduct)product);
        if (product.getStatus() != ProductStatus.VOID) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"Error setting MCO Fees status - not VOID", (Object[])new Object[0]));
            hasErrors.set(true);
        }
        relatedVoidings.forEach(pv -> {
            if (ShipmentHelper.hasRelatedShipment((BaseProduct)pv)) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.AirRulesHelper_productHasShimpent, (Object[])new Object[]{GeneralProductHelper.getProductTitle((BaseProduct)pv)}));
                log.debug(String.format("product %s has related shipment, skipping", GeneralProductHelper.getProductTitle((BaseProduct)pv)));
                hasErrors.set(true);
            }
        });
        if (!hasErrors.get()) {
            product.setStatus(ProductStatus.SELL);
            relatedVoidings.forEach(ProductVoidingHelper::removeProduct);
        }
        return messages;
    }

    @Override
    public List<Message> cloneProductToSameReservation(MCOFees source, EntityContainer<BookingFile> bookingFileContainer, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToSameReservation(source, bookingFileContainer, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewReservation(MCOFees source, EntityContainer<BookingFile> bookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToNewReservation(source, bookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewBookingFile(MCOFees source, EntityContainer<BookingFile> sourceBookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, EntityContainer<BookingFile> targetBookingFileContainer, int amount, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer) {
        return BaseProductFXHandler.cloneProductToNewBookingFile(source, sourceBookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, targetBookingFileContainer, amount, forwardAgencyMemo, targetClient, changeRetailPayer, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductForCorrection(MCOFees source, EntityContainer<BookingFile> targetBookingFileContainer, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer, Map<String, String> uidsMapping) {
        return MCOFeesProductFXHandler.cloneProductForCorrection(source, targetBookingFileContainer, targetClient, targetPayer, uidsMapping, this.createCloneHandler());
    }

    private ProductFXHandler.ProductCloneFXHandler<MCOFees> createCloneHandler() {
        return new ProductFXHandler.ProductCloneFXHandler<MCOFees>(){
            final Date date = new Date();

            @Override
            public MCOFees createProduct() {
                return new MCOFees();
            }

            @Override
            public void cloneProduct(MCOFees source, MCOFees target) throws Exception {
                McoFeesCloneHelper.clone((MCOFees)source, (MCOFees)target);
            }

            @Override
            public void cloneProduct(MCOFees source, MCOFees target, Map<String, String> uidsMapping) throws Exception {
                McoFeesCloneHelper.clone((MCOFees)source, (MCOFees)target, uidsMapping);
            }

            @Override
            public void updateProduct(MCOFees target, String systemNumber) {
                target.setIssueDate(this.date);
            }

            @Override
            public void updateProductsForCorrection(MCOFees source, MCOFees target, Map<String, String> uidsMapping) {
                source.setCorrectionDate(new Date());
                source.setTicketType(TicketType.CORRECTION);
                target.setIssueDate(source.getIssueDate());
                target.setCompleted(false);
                target.setShipmentsDate(null);
                target.setShipmentsDateSubagent(null);
                target.getPrepaymentDocuments().clear();
                target.getFopDetalizations().clear();
            }

            @Override
            public void resetTraveller(MCOFees target) {
                target.setTravellerUid(null);
            }
        };
    }
}

