/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bookingFile.handler;

import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface ProductFXHandler<P extends BaseEntity> {
    public Class<P> getProductClass();

    default public List<Message> recalculateFOP(P product, ProductStatus[] appropriateStatusArray, EntityContainer<BookingFile> ctr) {
        return Collections.singletonList(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("FOP recalculation not implemented for %s", product.getClass().getCanonicalName()), (Object[])new Object[0]));
    }

    default public List<Message> voidProduct(P product) {
        return Collections.singletonList(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Voiding not implemented for %s", product.getClass().getCanonicalName()), (Object[])new Object[0]));
    }

    default public List<Message> unVoidProduct(P product) {
        return Collections.singletonList(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Unvoiding not implemented for %s", product.getClass().getCanonicalName()), (Object[])new Object[0]));
    }

    default public Collection<? extends Message> sellProduct(P product, String number) {
        return Collections.singletonList(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Selling not implemented for %s", product.getClass().getCanonicalName()), (Object[])new Object[0]));
    }

    default public Collection<? extends Message> unsellProduct(P product) {
        return Collections.singletonList(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Unselling not implemented for %s", product.getClass().getCanonicalName()), (Object[])new Object[0]));
    }

    default public Collection<? extends Message> rejectProduct(P product, String number) {
        return Collections.singletonList(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Reject product not implemented for %s", product.getClass().getCanonicalName()), (Object[])new Object[0]));
    }

    public List<Message> cloneProductToNewBookingFile(P var1, EntityContainer<BookingFile> var2, GdsName var3, RecordLocatorType var4, String var5, String var6, EntityContainer<BookingFile> var7, int var8, boolean var9, EntityReference<Organization> var10, boolean var11);

    public List<Message> cloneProductForCorrection(P var1, EntityContainer<BookingFile> var2, EntityReference<Organization> var3, EntityReference<Organization> var4, Map<String, String> var5);

    public List<Message> cloneProductToNewReservation(P var1, EntityContainer<BookingFile> var2, GdsName var3, RecordLocatorType var4, String var5, String var6, int var7, boolean var8);

    public List<Message> cloneProductToSameReservation(P var1, EntityContainer<BookingFile> var2, String var3, String var4, int var5, boolean var6);

    default public BookingFileService.ProductRPCResult exchangeProduct(P productToExchange, EntityContainer<BookingFile> ctr, ProductExchangeRefundProperties exchangeProperties) {
        return new BookingFileService.ProductRPCResult(Collections.singletonList(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Exchange not implemented for %s", productToExchange.getClass().getCanonicalName()), (Object[])new Object[0])), null);
    }

    default public BookingFileService.ProductRPCResult exchangeProductToVoucher(P productToExchange, EntityContainer<BookingFile> ctr, ProductExchangeRefundProperties exchangeProperties) {
        return new BookingFileService.ProductRPCResult(Collections.singletonList(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Exchange to voucher not implemented for %s", productToExchange.getClass().getCanonicalName()), (Object[])new Object[0])), null);
    }

    default public BookingFileService.ProductRPCResult refundProduct(P productToExchange, EntityContainer<BookingFile> ctr, ProductExchangeRefundProperties exchangeProperties) {
        return new BookingFileService.ProductRPCResult(Collections.singletonList(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Refund not implemented for %s", productToExchange.getClass().getCanonicalName()), (Object[])new Object[0])), null);
    }

    default public BookingFileService.ProductRPCResult addCertificateOfCompletedFlight(P product, List<String> usedSegments) {
        return new BookingFileService.ProductRPCResult(Collections.singletonList(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Certificate not implemented for %s", product.getClass().getCanonicalName()), (Object[])new Object[0])), null);
    }

    default public void setSubAgency(P baseProduct, EntityReference<Organization> subagency) {
    }

    default public EntityReference<Organization> getSubAgency(P baseProduct) {
        return null;
    }

    public static interface ProductCloneFXHandler<P extends BaseProduct> {
        public P createProduct();

        public void cloneProduct(P var1, P var2) throws Exception;

        public void cloneProduct(P var1, P var2, Map<String, String> var3) throws Exception;

        public void updateProduct(P var1, String var2);

        public void updateProductsForCorrection(P var1, P var2, Map<String, String> var3);

        public void resetTraveller(P var1);
    }
}

