/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bookingFile.handler;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import java.util.HashMap;
import java.util.Map;

public final class ProductFXHandlersRegistry<P extends BaseProduct> {
    private final Map<String, ProductFXHandler<P>> handlers = new HashMap<String, ProductFXHandler<P>>();

    public static <P extends BaseProduct> ProductFXHandlersRegistry<P> get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return (ProductFXHandlersRegistry)Environment.getPublished(ProductFXHandlersRegistry.class);
    }

    public void register(ProductFXHandler handler) {
        this.handlers.computeIfAbsent(handler.getProductClass().getName(), k -> handler);
    }

    public ProductFXHandler<P> getForProduct(P product) {
        return this.handlers.get(product.getClass().getName());
    }

    private static class Holder {
        static final ProductFXHandlersRegistry INSTANCE = (ProductFXHandlersRegistry)Environment.getPublished(ProductFXHandlersRegistry.class);

        private Holder() {
        }
    }
}

