/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bookingFile.handler;

import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiHelper;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProduct;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.server.fx.bookingFile.handler.BaseProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.helper.BookingFileHelper;
import com.gridnine.xtrip.server.model.helpers.clone.TaxiCloneHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class TaxiProductFXHandler
extends BaseProductFXHandler<TaxiProduct> {
    @Override
    public Class<TaxiProduct> getProductClass() {
        return TaxiProduct.class;
    }

    @Override
    public List<Message> recalculateFOP(TaxiProduct taxiProduct, ProductStatus[] appropriateStatusArray, EntityContainer<BookingFile> ctr) {
        return BookingFileHelper.recalculateFop((BaseProduct)taxiProduct, appropriateStatusArray, GeneralProductHelper::updateFops, taxiProduct.getStatus(), ctr);
    }

    @Override
    public EntityReference<Organization> getSubAgency(TaxiProduct baseProduct) {
        return TaxiHelper.getSubagency((TaxiProduct)baseProduct);
    }

    @Override
    public BookingFileService.ProductRPCResult refundProduct(TaxiProduct productToRefund, EntityContainer<BookingFile> ctr, ProductExchangeRefundProperties exchangeProperties) {
        String productName = BookingHelper.generateShortProductName((BaseProduct)productToRefund);
        ArrayList<Message> messages = new ArrayList<Message>();
        String newProductUid = null;
        if (productToRefund.getStatus() != ProductStatus.SELL) {
            messages.add(Messages.getExceptionTicketReturnCannot((String)productName, (String)ProductStatus.SELL.toString()));
        } else if (productToRefund.getNextProduct() != null) {
            messages.add(Messages.getExceptionProductReturnCannot((String)productName));
        } else {
            try {
                TaxiProduct refundProduct = TaxiHelper.createRefund((TaxiProduct)productToRefund);
                newProductUid = refundProduct.getUid();
            }
            catch (Exception e) {
                messages.add(Messages.getExceptionTicketReturn((String)productName, (Exception)e));
            }
        }
        return new BookingFileService.ProductRPCResult(messages, newProductUid);
    }

    @Override
    public List<Message> cloneProductToSameReservation(TaxiProduct source, EntityContainer<BookingFile> bookingFileContainer, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToSameReservation(source, bookingFileContainer, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewReservation(TaxiProduct source, EntityContainer<BookingFile> bookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToNewReservation(source, bookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewBookingFile(TaxiProduct source, EntityContainer<BookingFile> sourceBookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, EntityContainer<BookingFile> targetBookingFileContainer, int amount, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer) {
        return BaseProductFXHandler.cloneProductToNewBookingFile(source, sourceBookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, targetBookingFileContainer, amount, forwardAgencyMemo, targetClient, changeRetailPayer, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductForCorrection(TaxiProduct source, EntityContainer<BookingFile> targetBookingFileContainer, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer, Map<String, String> uidsMapping) {
        return TaxiProductFXHandler.cloneProductForCorrection(source, targetBookingFileContainer, targetClient, targetPayer, uidsMapping, this.createCloneHandler());
    }

    @Override
    public void setSubAgency(TaxiProduct product, EntityReference<Organization> subagency) {
        TaxiHelper.setSubagency((TaxiProduct)product, subagency);
    }

    private ProductFXHandler.ProductCloneFXHandler<TaxiProduct> createCloneHandler() {
        return new ProductFXHandler.ProductCloneFXHandler<TaxiProduct>(){
            final Date date = new Date();

            @Override
            public TaxiProduct createProduct() {
                return new TaxiProduct();
            }

            @Override
            public void cloneProduct(TaxiProduct source, TaxiProduct target) throws Exception {
                TaxiCloneHelper.clone((TaxiProduct)source, (TaxiProduct)target);
            }

            @Override
            public void cloneProduct(TaxiProduct source, TaxiProduct target, Map<String, String> uidsMapping) throws Exception {
                TaxiCloneHelper.clone((TaxiProduct)source, (TaxiProduct)target, uidsMapping);
            }

            @Override
            public void updateProduct(TaxiProduct target, String systemNumber) {
                target.setSystemNumber(systemNumber);
                target.setIssueDate(this.date);
            }

            @Override
            public void updateProductsForCorrection(TaxiProduct source, TaxiProduct target, Map<String, String> uidsMapping) {
                source.setCorrectionDate(new Date());
                source.setTicketType(TicketType.CORRECTION);
                target.setIssueDate(source.getIssueDate());
                target.setContractRulesApplied(false);
                target.setCompleted(false);
                target.setShipmentsDate(null);
                target.setShipmentsDateSubagent(null);
                target.getPrepaymentDocuments().clear();
                target.getFopDetalizations().clear();
            }

            @Override
            public void resetTraveller(TaxiProduct target) {
                target.getTravellers().clear();
            }
        };
    }
}

