/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bookingFile.handler;

import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.SysLogItem;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProduct;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.UniversalProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.SysLogHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.server.fx.bookingFile.handler.BaseProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.helper.BookingFileHelper;
import com.gridnine.xtrip.server.model.helpers.clone.UniversalProductCloneHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalProductFXHandler
extends BaseProductFXHandler<UniversalProduct> {
    private static final Logger log = LoggerFactory.getLogger(SysLogHelper.class);

    @Override
    public Class<UniversalProduct> getProductClass() {
        return UniversalProduct.class;
    }

    @Override
    public List<Message> recalculateFOP(UniversalProduct universalProduct, ProductStatus[] appropriateStatusArray, EntityContainer<BookingFile> ctr) {
        return BookingFileHelper.recalculateFop((BaseProduct)universalProduct, appropriateStatusArray, GeneralProductHelper::updateFops, universalProduct.getStatus(), ctr);
    }

    @Override
    public EntityReference<Organization> getSubAgency(UniversalProduct baseProduct) {
        return UniversalProductHelper.getSubagency((UniversalProduct)baseProduct);
    }

    @Override
    public BookingFileService.ProductRPCResult refundProduct(UniversalProduct productToRefund, EntityContainer<BookingFile> ctr, ProductExchangeRefundProperties exchangeProperties) {
        ArrayList<Message> messages = new ArrayList<Message>();
        String newProductUid = null;
        if (productToRefund.getStatus() != ProductStatus.SELL) {
            messages.add(Messages.getExceptionTicketReturnCannot((String)productToRefund.getSystemNumber(), (String)ProductStatus.SELL.toString()));
        } else if (productToRefund.getNextProduct() != null) {
            messages.add(Messages.getExceptionProductReturnCannot((String)productToRefund.getSystemNumber()));
        } else {
            try {
                UniversalProduct refundProduct = UniversalProductHelper.createRefund((UniversalProduct)productToRefund);
                newProductUid = refundProduct.getUid();
                Message msg = Messages.getNotificationAddedInOrder((BaseProduct)refundProduct);
                UniversalProductFXHandler.logging((EntityReference<BookingFile>)ctr.toReference(), msg);
            }
            catch (Exception e) {
                messages.add(Messages.getExceptionTicketReturn((String)productToRefund.getSystemNumber(), (Exception)e));
            }
        }
        return new BookingFileService.ProductRPCResult(messages, newProductUid);
    }

    @Override
    public List<Message> cloneProductToSameReservation(UniversalProduct source, EntityContainer<BookingFile> bookingFileContainer, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToSameReservation(source, bookingFileContainer, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewReservation(UniversalProduct source, EntityContainer<BookingFile> bookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToNewReservation(source, bookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewBookingFile(UniversalProduct source, EntityContainer<BookingFile> sourceBookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, EntityContainer<BookingFile> targetBookingFileContainer, int amount, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer) {
        return BaseProductFXHandler.cloneProductToNewBookingFile(source, sourceBookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, targetBookingFileContainer, amount, forwardAgencyMemo, targetClient, changeRetailPayer, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductForCorrection(UniversalProduct source, EntityContainer<BookingFile> targetBookingFileContainer, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer, Map<String, String> uidsMapping) {
        return UniversalProductFXHandler.cloneProductForCorrection(source, targetBookingFileContainer, targetClient, targetPayer, uidsMapping, this.createCloneHandler());
    }

    @Override
    public BookingFileService.ProductRPCResult exchangeProduct(UniversalProduct productToExchange, EntityContainer<BookingFile> ctr, ProductExchangeRefundProperties exchangeProperties) {
        ArrayList<Message> messages = new ArrayList<Message>();
        String newProductUid = null;
        try {
            UniversalProduct exchange = UniversalProductHelper.createExchange((UniversalProduct)productToExchange);
            newProductUid = exchange.getUid();
        }
        catch (Throwable e) {
            messages.add(Messages.getExceptionExchange((String)productToExchange.getSystemNumber(), (Throwable)e));
        }
        return new BookingFileService.ProductRPCResult(messages, newProductUid);
    }

    @Override
    public List<Message> voidProduct(UniversalProduct productToVoid) {
        Message msg;
        ArrayList<Message> messages = new ArrayList<Message>();
        BookingFile bf = productToVoid.getReservation().getBookingFile();
        EntityReference ref = new EntityReference();
        ref.setType(BookingFile.class);
        ref.setUid(bf.getUid());
        ref.setCaption(bf.toString());
        if (productToVoid.getStatus() == ProductStatus.SELL || productToVoid.getStatus() == ProductStatus.BOOKING) {
            if (productToVoid.getNextProduct() != null) {
                msg = Messages.getNotificationStatusNotChanged((String)productToVoid.getSystemNumber(), (String)productToVoid.getNextProduct().getSystemNumber());
                UniversalProductFXHandler.logging((EntityReference<BookingFile>)ref, msg);
                messages.add(msg);
            } else if (productToVoid.getStatus() == ProductStatus.BOOKING) {
                productToVoid.setStatus(ProductStatus.VOID_BOOKING);
                msg = Messages.getNotificationStatusChanged((String)productToVoid.getSystemNumber(), (ProductStatus)ProductStatus.VOID_BOOKING);
                UniversalProductFXHandler.logging((EntityReference<BookingFile>)ref, msg);
                messages.add(msg);
            } else if (productToVoid.getStatus() == ProductStatus.SELL) {
                productToVoid.setStatus(ProductStatus.VOID);
                Message msg2 = Messages.getNotificationStatusChanged((String)productToVoid.getSystemNumber(), (ProductStatus)ProductStatus.VOID);
                UniversalProductFXHandler.logging((EntityReference<BookingFile>)ref, msg2);
                messages.add(msg2);
                return messages;
            }
        }
        msg = Messages.getNotificationCancellationCannotBeMade((String)productToVoid.getSystemNumber(), (UniversalProduct)productToVoid.getNextProduct());
        messages.add(msg);
        return messages;
    }

    private static void logging(EntityReference<BookingFile> ref, Message msg) {
        List<SysLogItem> lst = Collections.singletonList(SysLogHelper.newAuditItem(ref, (String)"entity-modification", (Message)msg));
        try {
            log.debug("saveMultiple() BEGIN");
            AssetsStorage.get().save(lst);
            log.debug("saveMultiple() END");
        }
        catch (Exception e) {
            log.error("unable to create log  item for object " + ref, (Throwable)e);
        }
    }

    @Override
    public void setSubAgency(UniversalProduct product, EntityReference<Organization> subagency) {
        UniversalProductHelper.setSubagency((UniversalProduct)product, subagency);
    }

    private ProductFXHandler.ProductCloneFXHandler<UniversalProduct> createCloneHandler() {
        return new ProductFXHandler.ProductCloneFXHandler<UniversalProduct>(){
            final Date date = new Date();

            @Override
            public UniversalProduct createProduct() {
                return new UniversalProduct();
            }

            @Override
            public void cloneProduct(UniversalProduct source, UniversalProduct target) throws Exception {
                UniversalProductCloneHelper.clone((UniversalProduct)source, (UniversalProduct)target);
            }

            @Override
            public void cloneProduct(UniversalProduct source, UniversalProduct target, Map<String, String> uidsMapping) throws Exception {
                UniversalProductCloneHelper.clone((UniversalProduct)source, (UniversalProduct)target, uidsMapping);
            }

            @Override
            public void updateProduct(UniversalProduct target, String systemNumber) {
                target.setSystemNumber(systemNumber);
                target.setIssueDate(this.date);
            }

            @Override
            public void updateProductsForCorrection(UniversalProduct source, UniversalProduct target, Map<String, String> uidsMapping) {
                source.setCorrectionDate(new Date());
                source.setTicketType(TicketType.CORRECTION);
                target.setIssueDate(source.getIssueDate());
                target.setContractRulesApplied(false);
                target.setCompleted(false);
                target.setShipmentsDate(null);
                target.setShipmentsDateSubagent(null);
                target.getPrepaymentDocuments().clear();
                target.getFopDetalizations().clear();
            }

            @Override
            public void resetTraveller(UniversalProduct target) {
                target.getTravellersUids().clear();
            }
        };
    }
}

