/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bookingFile.handler;

import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.visa.VisaProduct;
import com.gridnine.xtrip.common.model.booking.visa.VisaProductHelper;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.server.fx.bookingFile.handler.BaseProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.helper.BookingFileHelper;
import com.gridnine.xtrip.server.model.helpers.clone.VisaProductCloneHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class VisaProductFXHandler
extends BaseProductFXHandler<VisaProduct> {
    @Override
    public Class<VisaProduct> getProductClass() {
        return VisaProduct.class;
    }

    @Override
    public List<Message> recalculateFOP(VisaProduct visaProduct, ProductStatus[] appropriateStatusArray, EntityContainer<BookingFile> ctr) {
        return BookingFileHelper.recalculateFop((BaseProduct)visaProduct, appropriateStatusArray, GeneralProductHelper::updateFops, visaProduct.getStatus(), ctr);
    }

    @Override
    public EntityReference<Organization> getSubAgency(VisaProduct baseProduct) {
        return VisaProductHelper.getSubagency((VisaProduct)baseProduct);
    }

    @Override
    public BookingFileService.ProductRPCResult refundProduct(VisaProduct productToRefund, EntityContainer<BookingFile> ctr, ProductExchangeRefundProperties exchangeProperties) {
        ArrayList<Message> messages = new ArrayList<Message>();
        String newProductUid = null;
        if (productToRefund.getStatus() != ProductStatus.SELL) {
            messages.add(Messages.getExceptionTicketReturnCannot((String)productToRefund.getSystemNumber(), (String)ProductStatus.SELL.toString()));
        } else if (productToRefund.getNextProduct() != null) {
            messages.add(Messages.getExceptionProductReturnCannot((String)productToRefund.getSystemNumber()));
        } else {
            try {
                VisaProduct refundProduct = VisaProductHelper.createRefund((VisaProduct)productToRefund);
                newProductUid = refundProduct.getUid();
            }
            catch (Exception e) {
                messages.add(Messages.getExceptionTicketReturn((String)productToRefund.getSystemNumber(), (Exception)e));
            }
        }
        return new BookingFileService.ProductRPCResult(messages, newProductUid);
    }

    @Override
    public List<Message> cloneProductToSameReservation(VisaProduct source, EntityContainer<BookingFile> bookingFileContainer, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToSameReservation(source, bookingFileContainer, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewReservation(VisaProduct source, EntityContainer<BookingFile> bookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, int amount, boolean forwardAgencyMemo) {
        return BaseProductFXHandler.cloneProductToNewReservation(source, bookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, amount, forwardAgencyMemo, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductToNewBookingFile(VisaProduct source, EntityContainer<BookingFile> sourceBookingFileContainer, GdsName gdsName, RecordLocatorType recordLocatorType, String recordLocator, String systemNumber, EntityContainer<BookingFile> targetBookingFileContainer, int amount, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer) {
        return BaseProductFXHandler.cloneProductToNewBookingFile(source, sourceBookingFileContainer, gdsName, recordLocatorType, recordLocator, systemNumber, targetBookingFileContainer, amount, forwardAgencyMemo, targetClient, changeRetailPayer, this.createCloneHandler());
    }

    @Override
    public List<Message> cloneProductForCorrection(VisaProduct source, EntityContainer<BookingFile> targetBookingFileContainer, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer, Map<String, String> uidsMapping) {
        return VisaProductFXHandler.cloneProductForCorrection(source, targetBookingFileContainer, targetClient, targetPayer, uidsMapping, this.createCloneHandler());
    }

    @Override
    public void setSubAgency(VisaProduct product, EntityReference<Organization> subagency) {
        VisaProductHelper.setSubagency((VisaProduct)product, subagency);
    }

    private ProductFXHandler.ProductCloneFXHandler<VisaProduct> createCloneHandler() {
        return new ProductFXHandler.ProductCloneFXHandler<VisaProduct>(){
            final Date date = new Date();

            @Override
            public VisaProduct createProduct() {
                return new VisaProduct();
            }

            @Override
            public void cloneProduct(VisaProduct source, VisaProduct target) throws Exception {
                VisaProductCloneHelper.clone((VisaProduct)source, (VisaProduct)target);
            }

            @Override
            public void cloneProduct(VisaProduct source, VisaProduct target, Map<String, String> uidsMapping) throws Exception {
                VisaProductCloneHelper.clone((VisaProduct)source, (VisaProduct)target, uidsMapping);
            }

            @Override
            public void updateProduct(VisaProduct target, String systemNumber) {
                target.setSystemNumber(systemNumber);
                target.setIssueDate(this.date);
            }

            @Override
            public void updateProductsForCorrection(VisaProduct source, VisaProduct target, Map<String, String> uidsMapping) {
                source.setCorrectionDate(new Date());
                source.setTicketType(TicketType.CORRECTION);
                target.setIssueDate(source.getIssueDate());
                target.setContractRulesApplied(false);
                target.setCompleted(false);
                target.setShipmentsDate(null);
                target.setShipmentsDateSubagent(null);
                target.getPrepaymentDocuments().clear();
                target.getFopDetalizations().clear();
            }

            @Override
            public void resetTraveller(VisaProduct target) {
                target.getTravellers().clear();
            }
        };
    }
}

