/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bookingFile.helper;

import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.Preference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.misc.EntityStorageThreadContext;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BookingFileHelper {
    public static List<Message> recalculateFop(BaseProduct product, ProductStatus[] appropriateStatusArray, Consumer<BaseProduct> updateFOPFunction, ProductStatus productStatus, EntityContainer<BookingFile> ctr) {
        List<Message> errorMessageList = BookingFileHelper.performChecksFOP(product, appropriateStatusArray, productStatus);
        if (errorMessageList.isEmpty()) {
            try {
                updateFOPFunction.accept(product);
            }
            catch (Exception e) {
                errorMessageList = BookingFileHelper.handleExceptionFOP(e, product);
            }
        }
        if (errorMessageList.isEmpty()) {
            try {
                EntityStorageThreadContext.execute(() -> {
                    ctr.getVersionInfo().setDataSource("fx-recalculate-FOP");
                    EntityStorageThreadContext.setActionSource((EntityStorageThreadContext.ActionSource)EntityStorageThreadContext.ActionSource.MIDOFFICE_CLIENT_FX);
                    EntityStorage.get().save(ctr, true);
                });
            }
            catch (Exception e) {
                errorMessageList.addAll(BookingFileHelper.handleExceptionFOP(e, product));
            }
        }
        return errorMessageList;
    }

    private static List<Message> performChecksFOP(BaseProduct product, ProductStatus[] appropriateStatusArray, ProductStatus productStatus) {
        ArrayList<Message> result = new ArrayList<Message>();
        if (!BookingFileHelper.isAccessGranted()) {
            result.add(Messages.getExceptionRecalculateFop((String)BookingHelper.generateShortProductName((BaseProduct)product)));
            result.add(Messages.getExceptionAccessDenied());
        } else if (!Arrays.asList(appropriateStatusArray).contains(productStatus)) {
            result.add(Messages.getExceptionRecalculateFop((String)BookingHelper.generateShortProductName((BaseProduct)product)));
            result.add(Messages.getExceptionProductStatus((String)Stream.of(appropriateStatusArray).map(ProductStatus::toString).collect(Collectors.joining(", "))));
        }
        return result;
    }

    private static boolean isAccessGranted() {
        return true;
    }

    private static List<Message> handleExceptionFOP(Throwable t, BaseProduct product) {
        ArrayList<Message> result = new ArrayList<Message>();
        Message message = Messages.getExceptionRecalculateFop((String)BookingHelper.generateShortProductName((BaseProduct)product));
        try {
            message.setDetails(TextUtil.getExceptionStackTraceRegular((Throwable)t));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        result.add(message);
        return result;
    }

    public static Message createSuccessMessage(BaseProduct destProduct, BaseProduct srcProduct, EntityContainer<BookingFile> bookingFileEntityContainer) {
        return Messages.getNotificationSuccessfullyCloned((String)BookingHelper.generateShortProductName((BaseProduct)destProduct), (String)BookingHelper.generateShortProductName((BaseProduct)srcProduct), (EntityReference)bookingFileEntityContainer.toReference());
    }

    public static void isTicketUnique(String name, String sysNum, Class<EntityIndex<BaseEntity>> productClass, List<Message> mesList, EntityReference<BookingFile> ref) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)name, (Object)sysNum));
        if (!EntityStorage.get().search(productClass, query).getData().isEmpty()) {
            mesList.add(Messages.getNotificationFailedClonedSameNumber((String)sysNum, ref));
        }
    }

    public static Collection<String> getAvailablePayersUids(EntityContainer<Organization> organization, boolean addRetailClient) {
        HashSet<String> uids = new HashSet<String>();
        if (organization != null) {
            uids.add(organization.getUid());
            for (EntityReference payerRef : ((Organization)organization.getEntity()).getPayers()) {
                EntityContainer payer = EntityStorage.get().resolve(payerRef);
                if (payer == null) continue;
                uids.add(payer.getUid());
            }
        }
        if (addRetailClient) {
            EntityContainer retailProfileCtr;
            String value;
            Preference preference = DictHelper.getPreference((PreferenceKey)PreferenceKey.RETAIL_PROFILE_CODE);
            String string = value = preference == null ? null : preference.getValue();
            if (TextUtil.nonBlank((String)value) && (retailProfileCtr = EntityStorage.get().find(OrganizationIndex.class, OrganizationIndex.Property.code.name(), (Object)value)) != null) {
                uids.add(retailProfileCtr.getUid());
            }
        }
        return uids;
    }
}

