/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bookingFile.helper;

import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ProductExchangeRefundHelper {
    public static void updateSegmentTariffs(Product exchangeProduct, ProductExchangeRefundProperties exchangeProperties) {
        if (exchangeProperties.getSegmentDescriptions().isEmpty()) {
            return;
        }
        Iterator stIterator = exchangeProduct.getSegmentTariffs().iterator();
        while (stIterator.hasNext()) {
            SegmentTariff st = (SegmentTariff)stIterator.next();
            Iterator segIter = st.getSegments().iterator();
            while (segIter.hasNext()) {
                Segment segment = (Segment)segIter.next();
                String segmentDescription = String.valueOf(segment.getRecordNumber()) + TextUtil.nonNullStr((String)segment.getDepartCityCode()) + TextUtil.nonNullStr((String)segment.getArriveCityCode());
                if (exchangeProperties.getSegmentDescriptions().contains(segmentDescription)) continue;
                segIter.remove();
            }
            if (!st.getSegments().isEmpty()) continue;
            Iterator taxIterator = exchangeProduct.getTaxes().iterator();
            while (taxIterator.hasNext()) {
                Tax tax = (Tax)taxIterator.next();
                if (tax.getSegmentTariff() == null || !tax.getSegmentTariff().equals((Object)st)) continue;
                taxIterator.remove();
            }
            Iterator fareIter = exchangeProduct.getFares().iterator();
            while (fareIter.hasNext()) {
                ProductFare fare = (ProductFare)fareIter.next();
                if (fare.getSegmentTariff() == null || !fare.getSegmentTariff().equals((Object)st)) continue;
                fareIter.remove();
            }
            stIterator.remove();
        }
    }

    public static void updateFare(Product refProduct, ProductExchangeRefundProperties exchangeProperties) {
        if (exchangeProperties.getUsedEquivFare() != null || exchangeProperties.getUsedBaseFare() != null) {
            Money baseFare = AirProductHelper.getBaseFare((Product)refProduct);
            BigDecimal equivFare = AirProductHelper.getEquivalentFare((Product)refProduct);
            BigDecimal rate = AirProductHelper.calculateFareRate((Product)refProduct);
            if (exchangeProperties.getUsedEquivFare() != null) {
                if (equivFare != null) {
                    equivFare = equivFare.subtract(exchangeProperties.getUsedEquivFare());
                    AirProductHelper.setEquivalentFare((Product)refProduct, (BigDecimal)equivFare);
                }
            } else if (rate != null) {
                BigDecimal fare = exchangeProperties.getUsedBaseFare().multiply(rate);
                AirProductHelper.setEquivalentFare((Product)refProduct, (BigDecimal)fare);
            }
            if (exchangeProperties.getUsedBaseFare() != null) {
                BigDecimal baseFareValue;
                if (baseFare != null && (baseFareValue = baseFare.getValue()) != null) {
                    baseFareValue = baseFareValue.subtract(exchangeProperties.getUsedBaseFare());
                    baseFare.setValue(baseFareValue);
                    AirProductHelper.setBaseFare((Product)refProduct, (Money)baseFare);
                    ProductExchangeRefundHelper.updateNuc(refProduct);
                }
            } else if (baseFare != null) {
                String defaultCurrency;
                String defaultCurrCode = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null);
                String string = defaultCurrency = TextUtil.isBlank((String)defaultCurrCode) ? null : defaultCurrCode;
                if (baseFare.getCurrency() != null && defaultCurrency != null) {
                    if (baseFare.getCurrency().equals(defaultCurrency)) {
                        BigDecimal baseFareValue = baseFare.getValue();
                        if (baseFareValue != null) {
                            baseFareValue = baseFareValue.subtract(exchangeProperties.getUsedEquivFare());
                            baseFare.setValue(baseFareValue);
                            AirProductHelper.setBaseFare((Product)refProduct, (Money)baseFare);
                            ProductExchangeRefundHelper.updateNuc(refProduct);
                        }
                    } else {
                        BigDecimal baseFareValue = baseFare.getValue();
                        if (baseFareValue != null && rate != null) {
                            BigDecimal equivFareValue = exchangeProperties.getUsedEquivFare().divide(rate, RoundingMode.HALF_UP);
                            baseFareValue = baseFareValue.subtract(equivFareValue);
                            baseFare.setValue(baseFareValue);
                            AirProductHelper.setBaseFare((Product)refProduct, (Money)baseFare);
                            ProductExchangeRefundHelper.updateNuc(refProduct);
                        }
                    }
                }
            }
        }
    }

    public static void updateNewSellFare(Product newSellProduct, ProductExchangeRefundProperties exchangeProperties) {
        if (MiscUtil.isZero((BigDecimal)exchangeProperties.getBaseFareAddition(), (boolean)true) && MiscUtil.isZero((BigDecimal)exchangeProperties.getEquivFareAddition(), (boolean)true)) {
            return;
        }
        Money baseFare = AirProductHelper.getBaseFare((Product)newSellProduct);
        BigDecimal equivFare = AirProductHelper.getEquivalentFare((Product)newSellProduct);
        BigDecimal rate = AirProductHelper.calculateFareRate((Product)newSellProduct);
        if (!MiscUtil.isZero((BigDecimal)exchangeProperties.getEquivFareAddition(), (boolean)true)) {
            AirProductHelper.setEquivalentFare((Product)newSellProduct, (BigDecimal)MiscUtil.sum((BigDecimal[])new BigDecimal[]{equivFare, exchangeProperties.getEquivFareAddition()}));
            newSellProduct.setAddCollectEquivalent(exchangeProperties.getEquivFareAddition());
        } else if (rate != null) {
            BigDecimal addition = exchangeProperties.getBaseFareAddition().multiply(rate);
            AirProductHelper.setEquivalentFare((Product)newSellProduct, (BigDecimal)MiscUtil.sum((BigDecimal[])new BigDecimal[]{equivFare, addition}));
            newSellProduct.setAddCollectEquivalent(addition);
        }
        if (exchangeProperties.getBaseFareAddition() != null) {
            BigDecimal baseFareValue;
            if (baseFare != null && (baseFareValue = baseFare.getValue()) != null) {
                baseFareValue = MiscUtil.sum((BigDecimal[])new BigDecimal[]{baseFareValue, exchangeProperties.getBaseFareAddition()});
                baseFare.setValue(baseFareValue);
                newSellProduct.setAddCollectBase(exchangeProperties.getBaseFareAddition());
                AirProductHelper.setBaseFare((Product)newSellProduct, (Money)baseFare);
                ProductExchangeRefundHelper.updateNuc(newSellProduct);
            }
        } else if (baseFare != null) {
            String defaultCurrency;
            String defaultCurrCode = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null);
            String string = defaultCurrency = TextUtil.isBlank((String)defaultCurrCode) ? null : defaultCurrCode;
            if (baseFare.getCurrency() != null && defaultCurrency != null) {
                if (baseFare.getCurrency().equals(defaultCurrency)) {
                    BigDecimal baseFareValue = baseFare.getValue();
                    if (baseFareValue != null) {
                        baseFareValue = MiscUtil.sum((BigDecimal[])new BigDecimal[]{baseFareValue, exchangeProperties.getEquivFareAddition()});
                        baseFare.setValue(baseFareValue);
                        newSellProduct.setAddCollectBase(exchangeProperties.getEquivFareAddition());
                        AirProductHelper.setBaseFare((Product)newSellProduct, (Money)baseFare);
                        ProductExchangeRefundHelper.updateNuc(newSellProduct);
                    }
                } else {
                    BigDecimal baseFareValue = baseFare.getValue();
                    if (baseFareValue != null && rate != null) {
                        BigDecimal equivAddition = exchangeProperties.getEquivFareAddition().divide(rate, RoundingMode.HALF_UP);
                        baseFareValue = MiscUtil.sum((BigDecimal[])new BigDecimal[]{baseFareValue, equivAddition});
                        newSellProduct.setAddCollectBase(equivAddition);
                        baseFare.setValue(baseFareValue);
                        AirProductHelper.setBaseFare((Product)newSellProduct, (Money)baseFare);
                        ProductExchangeRefundHelper.updateNuc(newSellProduct);
                    }
                }
            }
        }
    }

    public static void updateNewSellTaxes(Product newSellProduct, ProductExchangeRefundProperties exchangeProperties) {
        for (Tax addTax : exchangeProperties.getTaxesAddition()) {
            Tax productTax = newSellProduct.getTaxes().stream().filter(t -> ProductExchangeRefundHelper.isSameTax(addTax, t)).findFirst().orElse(null);
            if (productTax == null) {
                addTax.setAddCollect(addTax.getEquivalentAmount());
                newSellProduct.getTaxes().add(addTax);
                continue;
            }
            productTax.setEquivalentAmount(MiscUtil.sum((BigDecimal[])new BigDecimal[]{productTax.getEquivalentAmount(), addTax.getEquivalentAmount()}));
            productTax.setAddCollect(addTax.getEquivalentAmount());
            Money productAmount = productTax.getAmount();
            if (productAmount == null) continue;
            productAmount.setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{productAmount.getValue(), addTax.getAmount().getValue()}));
        }
    }

    private static boolean isSameTax(Tax tax1, Tax tax2) {
        if (!MiscUtil.equals((Object)tax1.getCode(), (Object)tax2.getCode())) {
            return false;
        }
        if (!MiscUtil.equals((Object)tax1.getSegmentTariff(), (Object)tax2.getSegmentTariff())) {
            return false;
        }
        if (tax1.getAmount() == null != (tax2.getAmount() == null)) {
            return false;
        }
        return tax1 == null || MiscUtil.equals((Object)tax1.getAmount().getCurrency(), (Object)tax2.getAmount().getCurrency());
    }

    public static void updateNuc(Product product) {
        BigDecimal roe = AirProductHelper.getNucRoe((Product)product);
        Money baseFare = AirProductHelper.getBaseFare((Product)product);
        if (roe != null && baseFare != null && baseFare.getValue() != null) {
            BigDecimal nuc = baseFare.getValue().divide(roe, RoundingMode.HALF_UP);
            AirProductHelper.setNucFare((Product)product, (BigDecimal)nuc);
        }
    }

    public static void updateFops(Product refProduct, ProductExchangeRefundProperties exchangeProperties) throws Exception {
        AirProductHelper.recalcFops((Product)refProduct);
        AirProductHelper.updateFopsByDate((Product)refProduct, (Date)exchangeProperties.getOperationDate());
        AirProductHelper.updateClientFop((Product)refProduct, (Date)exchangeProperties.getOperationDate(), (EntityReference)exchangeProperties.getAgent());
    }

    public static Product createMCO(Product exchangeOrRefundProduct, ProductExchangeRefundProperties.ExchangeRefundEMD element, Date operationDate) throws Exception {
        Product mcoProduct = new Product();
        mcoProduct.setProductCategory(ProductCategory.MCO);
        if (element == null) {
            return mcoProduct;
        }
        mcoProduct.setMcoCategory(element.getCategory());
        BigDecimal fopValue = null;
        mcoProduct.setSystemNumber(element.getSystemNumber());
        mcoProduct.getScns().add(element.getSystemNumber());
        Money baseFare = new Money();
        baseFare.setValue(element.getBaseAmount() == null ? element.getEquivAmount() : element.getBaseAmount().getValue());
        if (element.getBaseAmount() != null && element.getBaseAmount().getCurrency() != null) {
            baseFare.setCurrency(element.getBaseAmount().getCurrency());
        } else if (element.getBaseAmount() != null || element.getEquivAmount() != null) {
            baseFare.setCurrency(DictHelper.getLocalCurrency());
        }
        AirProductHelper.setBaseFare((Product)mcoProduct, (Money)baseFare);
        AirProductHelper.setEquivalentFare((Product)mcoProduct, (BigDecimal)(element.getEquivAmount() == null && element.getBaseAmount() != null ? element.getBaseAmount().getValue() : element.getEquivAmount()));
        fopValue = AirProductHelper.getEquivalentFare((Product)mcoProduct);
        ProductFop fop = new ProductFop();
        Money money = new Money();
        money.setCurrency(DictHelper.getLocalCurrency());
        money.setValue(fopValue);
        fop.setAmount(money);
        fop.setType(PaymentType.CASH);
        AirProductHelper.getVendorContractRelation((Product)mcoProduct).getFops().add(fop);
        mcoProduct.setStatus(ProductStatus.SELL);
        ProductExchangeRefundHelper.copyProductData(exchangeOrRefundProduct, mcoProduct);
        AirProductHelper.updateClientFop((Product)mcoProduct, (Date)operationDate, (EntityReference)mcoProduct.getCashier());
        AirProductHelper.recalcFops((Product)mcoProduct);
        if (exchangeOrRefundProduct.getReservation() != null && !exchangeOrRefundProduct.getReservation().getProducts().contains(mcoProduct)) {
            exchangeOrRefundProduct.getReservation().getProducts().add(mcoProduct);
        }
        return mcoProduct;
    }

    public static Product createVoucherMCO(Product exchangeProduct, ProductExchangeRefundProperties.ExchangeRefundEMD element, Date operationDate, BigDecimal penalty) throws Exception {
        Product mcoProduct = new Product();
        mcoProduct.setProductCategory(ProductCategory.MCO);
        mcoProduct.setStatus(ProductStatus.SELL);
        mcoProduct.setMcoCategory(element.getCategory());
        exchangeProduct.setNextProduct(mcoProduct);
        mcoProduct.setPreviousProduct(exchangeProduct);
        mcoProduct.setPenalty(penalty);
        mcoProduct.setSystemNumber(element.getSystemNumber());
        mcoProduct.getScns().add(element.getSystemNumber());
        Money baseFare = new Money();
        baseFare.setValue(element.getBaseAmount() == null ? element.getEquivAmount() : element.getBaseAmount().getValue());
        if (element.getBaseAmount() != null && element.getBaseAmount().getCurrency() != null) {
            baseFare.setCurrency(element.getBaseAmount().getCurrency());
        } else if (element.getBaseAmount() != null || element.getEquivAmount() != null) {
            baseFare.setCurrency(DictHelper.getLocalCurrency());
        }
        AirProductHelper.setBaseFare((Product)mcoProduct, (Money)baseFare);
        AirProductHelper.setEquivalentFare((Product)mcoProduct, (BigDecimal)(element.getEquivAmount() == null && element.getBaseAmount() != null ? element.getBaseAmount().getValue() : element.getEquivAmount()));
        AirProductHelper.setAgency((Product)mcoProduct, (EntityReference)AirProductHelper.getAgency((Product)exchangeProduct));
        AirProductHelper.setSubagency((Product)mcoProduct, (EntityReference)AirProductHelper.getSubagency((Product)exchangeProduct));
        AirProductHelper.setSupplier((Product)mcoProduct, (EntityReference)AirProductHelper.getSupplier((Product)exchangeProduct));
        mcoProduct.setTariffType(exchangeProduct.getTariffType());
        mcoProduct.setAgencyCode(exchangeProduct.getAgencyCode());
        mcoProduct.setPcc(exchangeProduct.getPcc());
        mcoProduct.setSalesPoint(exchangeProduct.getSalesPoint());
        mcoProduct.setCashier(exchangeProduct.getCashier());
        mcoProduct.setCashierCode(exchangeProduct.getCashierCode());
        mcoProduct.setDescIdentifier(exchangeProduct.getDescIdentifier());
        mcoProduct.setValidatorCode(exchangeProduct.getValidatorCode());
        mcoProduct.setValidatorRef(exchangeProduct.getValidatorRef());
        mcoProduct.setBlankOwnerRef(exchangeProduct.getBlankOwnerRef());
        mcoProduct.setBlankOwnerNumber(exchangeProduct.getBlankOwnerNumber());
        mcoProduct.setCarrier(exchangeProduct.getCarrier());
        mcoProduct.setCarrierNumber(exchangeProduct.getCarrierNumber());
        mcoProduct.setTraveller(exchangeProduct.getTraveller());
        mcoProduct.setIssueDate(exchangeProduct.getIssueDate());
        mcoProduct.setReservation(exchangeProduct.getReservation());
        mcoProduct.setTicketType(exchangeProduct.getTicketType());
        mcoProduct.getSegmentTariffs().addAll(exchangeProduct.getSegmentTariffs());
        mcoProduct.getTaxes().addAll(exchangeProduct.getTaxes());
        mcoProduct.setBlankType(DictHelper.getBlankType((EntityReference)exchangeProduct.getBlankOwnerRef(), null, (ProductCategory)ProductCategory.MCO, (BlankCategory)BlankCategory.ETICKET));
        ProductFop fop = new ProductFop();
        Money money = new Money();
        money.setCurrency(DictHelper.getLocalCurrency());
        money.setValue(AirProductHelper.getEquivalentFare((Product)mcoProduct));
        fop.setAmount(money);
        fop.setType(PaymentType.VOUCHER);
        AirProductHelper.getVendorContractRelation((Product)mcoProduct).getFops().add(fop);
        AirProductHelper.updateClientFop((Product)mcoProduct, (Date)operationDate, (EntityReference)mcoProduct.getCashier());
        AirProductHelper.updateFops((Product)mcoProduct);
        if (exchangeProduct.getReservation() != null && !exchangeProduct.getReservation().getProducts().contains(mcoProduct)) {
            exchangeProduct.getReservation().getProducts().add(mcoProduct);
        }
        return mcoProduct;
    }

    public static void copyProductData(Product srcProduct, Product destProduct) {
        if (srcProduct == null || destProduct == null) {
            return;
        }
        destProduct.getRelatedProducts().add(srcProduct);
        destProduct.setTariffType(srcProduct.getTariffType());
        destProduct.setAgencyCode(srcProduct.getAgencyCode());
        AirProductHelper.setSubagency((Product)destProduct, (EntityReference)AirProductHelper.getSubagency((Product)srcProduct));
        destProduct.setPcc(srcProduct.getPcc());
        destProduct.setSalesPoint(srcProduct.getSalesPoint());
        destProduct.setCashier(srcProduct.getCashier());
        destProduct.setCashierCode(srcProduct.getCashierCode());
        destProduct.setDescIdentifier(srcProduct.getDescIdentifier());
        destProduct.setValidatorCode(srcProduct.getValidatorCode());
        destProduct.setValidatorRef(srcProduct.getValidatorRef());
        AirProductHelper.setAgency((Product)destProduct, (EntityReference)AirProductHelper.getAgency((Product)srcProduct));
        AirProductHelper.setSupplier((Product)destProduct, (EntityReference)AirProductHelper.getSupplier((Product)srcProduct));
        BlankType type = BookingHelper.getBlankType((String)destProduct.getSystemNumber(), (EntityReference)srcProduct.getBlankOwnerRef(), null, (boolean)false);
        if (type != null) {
            destProduct.setBlankType((DictionaryReference)type.toReference());
        }
        destProduct.setBlankOwnerRef(srcProduct.getBlankOwnerRef());
        destProduct.setBlankOwnerNumber(srcProduct.getBlankOwnerNumber());
        destProduct.setCarrier(srcProduct.getCarrier());
        destProduct.setCarrierNumber(srcProduct.getCarrierNumber());
        destProduct.setTraveller(srcProduct.getTraveller());
        destProduct.setIssueDate(srcProduct.getIssueDate());
        destProduct.setReservation(srcProduct.getReservation());
        if (!AirProductHelper.getVendorContractRelation((Product)srcProduct).getFops().isEmpty() && !AirProductHelper.getVendorContractRelation((Product)destProduct).getFops().isEmpty()) {
            ProductFop destFop = (ProductFop)AirProductHelper.getVendorContractRelation((Product)destProduct).getFops().get(0);
            destFop.setType(((ProductFop)AirProductHelper.getVendorContractRelation((Product)srcProduct).getFops().get(0)).getType());
            destFop.setOperationDate(srcProduct.getIssueDate());
        }
    }

    public static Product createExchangeProduct(Product product, ProductExchangeRefundProperties exchangeProperties, String agentCode) throws Exception {
        Product exchangeProduct = new Product();
        AirProductHelper.copy((Product)product, (Product)exchangeProduct, (boolean)true);
        AirProductHelper.clearCommissions((Product)exchangeProduct);
        exchangeProduct.setPenalty(null);
        product.setNextProduct(exchangeProduct);
        exchangeProduct.setPreviousProduct(product);
        exchangeProduct.setIssueDate(exchangeProperties.getOperationDate());
        exchangeProduct.setCashier(exchangeProperties.getAgent());
        exchangeProduct.setCashierCode(agentCode);
        exchangeProduct.setStatus(ProductStatus.EXCHANGE);
        exchangeProduct.setEndorsement(null);
        exchangeProduct.setFareCalculationData(null);
        exchangeProduct.setChecked(false);
        exchangeProduct.setContractRulesApplied(false);
        exchangeProduct.setVendorVatCalculated(false);
        exchangeProduct.setTotalVendorEquivalentVatAmount(null);
        exchangeProduct.getShipments().clear();
        exchangeProduct.getPrepaymentDocuments().clear();
        exchangeProduct.getFopDetalizations().clear();
        exchangeProduct.setForcedRefund(exchangeProperties.isForced());
        ProductExchangeRefundHelper.updateSegmentTariffs(exchangeProduct, exchangeProperties);
        exchangeProduct.getTaxes().clear();
        exchangeProduct.getTaxes().addAll(exchangeProperties.getTaxes());
        exchangeProduct.getObFees().clear();
        ProductExchangeRefundHelper.updateFare(exchangeProduct, exchangeProperties);
        ProductExchangeRefundHelper.updateFops(exchangeProduct, exchangeProperties);
        return exchangeProduct;
    }

    public static Product createNewSellProduct(Product product, Product exchangeProduct, ProductExchangeRefundProperties exchangeProperties, String agentCode) throws Exception {
        Product sellProduct = new Product();
        AirProductHelper.copy((Product)exchangeProduct, (Product)sellProduct, (boolean)true);
        exchangeProduct.setNextProduct(sellProduct);
        sellProduct.setPreviousProduct(exchangeProduct);
        sellProduct.setIssueDate(exchangeProperties.getOperationDate());
        sellProduct.setCashier(exchangeProperties.getAgent());
        sellProduct.setCashierCode(agentCode);
        sellProduct.setStatus(ProductStatus.SELL);
        sellProduct.setChecked(false);
        sellProduct.setContractRulesApplied(false);
        sellProduct.setVendorVatCalculated(false);
        sellProduct.setSystemNumber(null);
        sellProduct.getScns().clear();
        sellProduct.getShipments().clear();
        sellProduct.getPrepaymentDocuments().clear();
        sellProduct.getFopDetalizations().clear();
        AirProductHelper.clearFops((Product)sellProduct);
        if (exchangeProperties.getMcoCategory() != null) {
            sellProduct.setProductCategory(ProductCategory.MCO);
            sellProduct.setMcoCategory(exchangeProperties.getMcoCategory());
            sellProduct.setBlankType(null);
            if (exchangeProduct.getBlankOwnerRef() != null) {
                sellProduct.setBlankType(DictHelper.getBlankType((EntityReference)exchangeProduct.getBlankOwnerRef(), null, (ProductCategory)ProductCategory.MCO, (BlankCategory)BlankCategory.ETICKET));
            }
        } else if (exchangeProduct.getMcoCategory() == MCOCategory.VOUCHER) {
            sellProduct.setProductCategory(ProductCategory.AIR);
            sellProduct.setMcoCategory(null);
            sellProduct.setBlankType(null);
            if (exchangeProduct.getBlankOwnerRef() != null) {
                sellProduct.setBlankType(DictHelper.getBlankType((EntityReference)exchangeProduct.getBlankOwnerRef(), null, (ProductCategory)ProductCategory.AIR, (BlankCategory)BlankCategory.ETICKET));
            }
        }
        if (exchangeProperties.getEmds().isEmpty()) {
            sellProduct.setPenalty(exchangeProperties.getPenalty());
        }
        ProductExchangeRefundHelper.updateNewSellFare(sellProduct, exchangeProperties);
        ProductExchangeRefundHelper.updateNewSellTaxes(sellProduct, exchangeProperties);
        ProductFop fop = new ProductFop();
        PaymentType fopType = PaymentType.CASH;
        if (!AirProductHelper.getVendorContractRelation((Product)product).getFops().isEmpty()) {
            fopType = ((ProductFop)AirProductHelper.getVendorContractRelation((Product)product).getFops().get(0)).getType();
        }
        fop.setType(fopType);
        fop.setAmount(new Money());
        fop.getAmount().setValue(BigDecimal.ZERO);
        fop.getAmount().setCurrency(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
        List vendorFops = AirProductHelper.getVendorContractRelation((Product)sellProduct).getFops();
        vendorFops.add(fop);
        fop = new ProductFop();
        fopType = PaymentType.TICKET;
        fop.setType(fopType);
        fop.setAmount(new Money());
        fop.getAmount().setValue(BigDecimal.ZERO);
        fop.getAmount().setCurrency(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
        fop.setRelatedTicketNumber(exchangeProduct.getSystemNumber());
        vendorFops.add(fop);
        AirProductHelper.updateFopsByDate((Product)sellProduct, (Date)exchangeProperties.getOperationDate());
        AirProductHelper.updateClientFop((Product)sellProduct, (Date)exchangeProperties.getOperationDate(), (EntityReference)exchangeProperties.getAgent());
        AirProductHelper.recalcFops((Product)sellProduct);
        return sellProduct;
    }

    public static Product createRefundProduct(Product product, ProductExchangeRefundProperties refundProperties, String agentCode) throws Exception {
        Product refundProduct = new Product();
        AirProductHelper.copy((Product)product, (Product)refundProduct, (boolean)true);
        for (AirProductContractRelationData relation : AirProductHelper.getContractRelations((Product)refundProduct)) {
            Iterator iterator = relation.getFops().iterator();
            while (iterator.hasNext()) {
                ProductFop fop = (ProductFop)iterator.next();
                if (fop.getType() != PaymentType.TICKET) continue;
                iterator.remove();
            }
        }
        product.setNextProduct(refundProduct);
        refundProduct.setPreviousProduct(product);
        refundProduct.setIssueDate(refundProperties.getOperationDate());
        refundProduct.setCashier(refundProperties.getAgent());
        refundProduct.setCashierCode(agentCode);
        refundProduct.setStatus(ProductStatus.REFUND);
        refundProduct.setEndorsement(null);
        refundProduct.setFareCalculationData(null);
        refundProduct.setChecked(false);
        refundProduct.setContractRulesApplied(false);
        refundProduct.setVendorVatCalculated(false);
        refundProduct.setTotalVendorEquivalentVatAmount(null);
        refundProduct.getShipments().clear();
        refundProduct.getPrepaymentDocuments().clear();
        refundProduct.getFopDetalizations().clear();
        if (refundProperties.getEmds().isEmpty()) {
            refundProduct.setPenalty(refundProperties.getPenalty());
        }
        refundProduct.setForcedRefund(refundProperties.isForced());
        ProductExchangeRefundHelper.updateSegmentTariffs(refundProduct, refundProperties);
        ProductExchangeRefundHelper.updateFare(refundProduct, refundProperties);
        BigDecimal equivalentFare = AirProductHelper.getEquivalentFare((Product)refundProduct);
        if (equivalentFare != null && refundProduct.getBspCommissionRate() != null) {
            Money money = new Money();
            money.setValue(MiscUtil.scale((BigDecimal)equivalentFare.multiply(BigDecimal.valueOf(refundProduct.getBspCommissionRate())).divide(BigDecimal.valueOf(100L)), (int)2, (RoundingMode)RoundingMode.HALF_UP));
            money.setCurrency(DictHelper.getLocalCurrency2());
            refundProduct.setBspCommissionValue(money);
        }
        refundProduct.getTaxes().clear();
        refundProduct.getTaxes().addAll(refundProperties.getTaxes());
        ProductExchangeRefundHelper.updateFops(refundProduct, refundProperties);
        refundProduct.setCompleted(false);
        refundProduct.getObFees().clear();
        return refundProduct;
    }

    public static Product createReferenceMCO(Product refundProduct, String emdReferenceNumber, Date operationDate) {
        Product mcoProduct = new Product();
        mcoProduct.setProductCategory(ProductCategory.MCO);
        mcoProduct.setMcoCategory(MCOCategory.INFORMATION);
        mcoProduct.setSystemNumber(emdReferenceNumber);
        mcoProduct.getScns().add(emdReferenceNumber);
        mcoProduct.setStatus(ProductStatus.SELL);
        ProductExchangeRefundHelper.copyProductData(refundProduct, mcoProduct);
        if (refundProduct.getReservation() != null && !refundProduct.getReservation().getProducts().contains(mcoProduct)) {
            refundProduct.getReservation().getProducts().add(mcoProduct);
        }
        return mcoProduct;
    }

    public static void addSummaryMessages(Product product, EntityReference<BookingFile> bfRef, List<Message> messages) {
        SysLogHelper.audit(bfRef, (String)"entity-modification", (Message[])new Message[]{Messages.getNotificationProductAddedInOrder((String)BookingHelper.generateShortProductName((BaseProduct)product))});
        messages.add(Messages.getNotificationProductAddedInOrderN((String)BookingHelper.generateShortProductName((BaseProduct)product), bfRef));
    }

    public static void addSummaryMessages(Product newProduct, Product connectedWithProduct, EntityReference<BookingFile> bfRef, List<Message> messages) {
        SysLogHelper.audit(bfRef, (String)"entity-modification", (Message[])new Message[]{Messages.getNotificationReleatedAddedInOrder((String)BookingHelper.generateShortProductName((BaseProduct)newProduct), (String)BookingHelper.generateShortProductName((BaseProduct)connectedWithProduct))});
        messages.add(Messages.getNotificationReleatedAddedInOrderN((String)BookingHelper.generateShortProductName((BaseProduct)newProduct), (String)BookingHelper.generateShortProductName((BaseProduct)connectedWithProduct), bfRef));
    }
}

