/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.bookingFile.helper;

import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.Message;
import java.util.List;

public class ProductVoidHelper {
    public static boolean checkVoidableStatus(Product productToVoid, List<Message> errorList) {
        boolean isVoidable = true;
        String productName = BookingHelper.generateShortProductName((BaseProduct)productToVoid);
        Product nextProduct = productToVoid.getNextProduct();
        if (!AirProductHelper.getDuplicateByRelatedProduct((Product)productToVoid).isEmpty()) {
            errorList.add(Messages.getWarningTicketHasDublicate((String)productName));
            isVoidable = false;
        }
        if (errorList.isEmpty() && nextProduct != null) {
            ProductStatus nextProductStatus = nextProduct.getStatus();
            switch (nextProductStatus) {
                case REFUND: {
                    errorList.add(Messages.getWarningTicketAlreadyReturned((String)productName));
                    isVoidable = false;
                    break;
                }
                case EXCHANGE: {
                    errorList.add(Messages.getWarningTicketAlreadyExchanged((String)productName));
                    isVoidable = false;
                    break;
                }
                default: {
                    errorList.add(Messages.getWarningTicketHasAssociatedTicket((String)productName));
                    isVoidable = false;
                }
            }
        }
        if (errorList.isEmpty() && productToVoid.getStatus() != ProductStatus.BOOKING && productToVoid.getStatus() != ProductStatus.SELL) {
            errorList.add(Messages.getWarningProductStatusOther((String)productName, (ProductStatus)ProductStatus.BOOKING, (ProductStatus)ProductStatus.SELL));
            isVoidable = false;
        }
        return isVoidable;
    }
}

