/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.db.update;

import com.gridnine.xtrip.common.fx.assets.FxWorkspace;
import com.gridnine.xtrip.common.fx.assets.FxWorkspaceItem;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.restriction.RestrictionGroup;
import com.gridnine.xtrip.common.restriction.RestrictionGroupType;
import com.gridnine.xtrip.common.restriction.RestrictionValue;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyConditions;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class WorkspaceProfilesRestrictionsUpdateHandler
implements SetupUpdateHandler {
    private static final Set<String> INDEX_TYPES = new HashSet<String>(Arrays.asList("com.gridnine.xtrip.common.model.profile.BranchIndex", "com.gridnine.xtrip.common.model.profile.CashIndex", "com.gridnine.xtrip.common.model.profile.CashRegisterIndex", "com.gridnine.xtrip.common.model.profile.CashRegisterWorkplaceIndex", "com.gridnine.xtrip.common.model.profile.HoldingIndex", "com.gridnine.xtrip.common.model.profile.OrganizationIndex", "com.gridnine.xtrip.common.model.profile.OrganizationBalanceIndex", "com.gridnine.xtrip.common.model.profile.OrganizationMetadataIndex", "com.gridnine.xtrip.common.model.profile.PersonIndex", "com.gridnine.xtrip.common.model.profile.PersonMetadataIndex", "com.gridnine.xtrip.common.model.profile.SalesPointIndex"));

    public void execute(Element command) {
        ExecutorServiceFacade.get().execute(() -> {
            DebugUtil.setThreadName((String)"WorkspaceProfilesRestrictionsUpdateHandler");
            try {
                SearchQuery query = new SearchQuery();
                query.getPreferredProperties().add(FxWorkspace.Property.name.name());
                query.getPreferredProperties().add(FxWorkspace.Property.owner.name());
                for (FxWorkspace workspace : AssetsStorage.get().search(FxWorkspace.class, query).getData()) {
                    try {
                        this.process(workspace.getUid());
                    }
                    catch (Exception e) {
                        LoggerFactory.getLogger(this.getClass()).error(String.format("failed processing workspace, owner=%s, name=%s", workspace.getOwner(), workspace.getName()), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("failed processing saved workspaces", (Throwable)e);
            }
            finally {
                DebugUtil.restoreThreadName();
            }
        });
    }

    private void process(String workspaceUid) throws Exception {
        FxWorkspace workspace = (FxWorkspace)AssetsStorage.get().load(FxWorkspace.class, workspaceUid);
        if (workspace == null) {
            return;
        }
        if (this.process(workspace.getItems())) {
            AssetsStorage.get().save((BaseAsset)workspace);
        }
    }

    private boolean process(List<FxWorkspaceItem> items) throws Exception {
        boolean result = false;
        for (FxWorkspaceItem item : items) {
            result |= this.process(item);
            result |= this.process(item.getSubItems());
        }
        return result;
    }

    private boolean process(FxWorkspaceItem item) throws Exception {
        if (!"index-list-nav-tool".equals(item.getToolId()) || item.getParameters() == null || item.getParameters().length == 0) {
            return false;
        }
        Element rootElm = XUtil.fromBytes((byte[])item.getParameters());
        String indexType = XmlUtil.getValue((Element)rootElm, (String)"indexType");
        if (!INDEX_TYPES.contains(indexType)) {
            return false;
        }
        if (XmlUtil.getElement((Element)rootElm, (String)"criterions/item") != null || XmlUtil.getElement((Element)rootElm, (String)"restrictionGroups/item") != null) {
            return false;
        }
        RestrictionValue rv = new RestrictionValue();
        rv.setPropertyId(indexType + ".disabled");
        rv.setConditionId(StandardRestrictionResourcePropertyConditions.NOT_EQUALS.getId());
        rv.setValue((Object)Boolean.TRUE);
        RestrictionGroup rg = new RestrictionGroup();
        rg.setType(RestrictionGroupType.SIMPLE);
        rg.setValue((Object)rv);
        XHelper.writeObject((Element)rootElm, (String)"restrictionGroups/item", (Object)rg);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XUtil.newTransformer().transform(new DOMSource(rootElm), new StreamResult(baos));
        item.setParameters(baos.toByteArray());
        return true;
    }
}

