/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.prefetched;

import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.model.AgentSalesPoint;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.PreferenceHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.WorklogHelper;
import com.gridnine.xtrip.common.model.profile.Cash;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplace;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefetchedDataHelper {
    private static final Logger log = LoggerFactory.getLogger(PrefetchedDataHelper.class);

    public static void populateCurrentAgentData(AgentData agentData, String agencyUid, String salesPointUid, String cashUid, String cashRegisterUid, String cashRegisterWorkplaceUid) {
        try {
            EntityContainer salesPointCtr;
            EntityContainer worklogCtr;
            log.debug("initializing agent data");
            EntityContainer agentContainer = ProfileHelper.getPersonCtr((String)UserData.get().getCurrentUser());
            if (agentContainer == null) {
                log.debug("agent was not found by login name");
                return;
            }
            log.debug(String.format("agent %s was found", agentContainer.toReference()));
            agentData.setAgent(agentContainer.toReference());
            Person agent = (Person)agentContainer.getEntity();
            Date currentDate = new Date();
            agentData.getPersonTypes().clear();
            agentData.getPersonTypes().addAll(agent.getTypes());
            agent.getSalesPoints().stream().filter(Objects::nonNull).filter(pos -> pos.getOpened() == null || !MiscUtil.clearTime((Date)pos.getOpened()).after(currentDate)).filter(pos -> pos.getClosed() == null || !MiscUtil.setDayEndTime((Date)pos.getClosed()).before(currentDate)).filter(pos -> pos.getSalesPoint() != null).forEach(pos -> {
                EntityContainer spCtr = EntityStorage.get().resolve(pos.getSalesPoint());
                if (spCtr != null) {
                    AgentSalesPoint agentSp = new AgentSalesPoint();
                    agentSp.setSalesPoint(spCtr.toReference());
                    agentSp.setAgency(((SalesPoint)spCtr.getEntity()).getAgency());
                    agentSp.setDefaultForOrg(pos.isDefaultForOrg());
                    agentData.getAvailableSalesPoints().add(agentSp);
                }
            });
            boolean worklogEnabled = Boolean.parseBoolean(PreferenceHelper.getPreferenceValue((PreferenceKey)PreferenceKey.WORKLOG_ENABLED, (String)"false"));
            boolean dataFromUidsNeeded = true;
            if (worklogEnabled && (worklogCtr = EntityStorage.get().resolve(WorklogHelper.getWorklog((EntityReference)agentContainer.toReference(), (Date)currentDate))) != null) {
                Worklog worklog = (Worklog)worklogCtr.getEntity();
                agentData.setAgency(worklog.getAgency());
                agentData.setSubagency(worklog.getAgency());
                agentData.getPersonTypes().clear();
                agentData.getPersonTypes().addAll(worklog.getTypes());
                agentData.setSalesPoint(worklog.getSalesPoint());
                agentData.setCash(worklog.getCash());
                agentData.setCashRegister(worklog.getCashRegister());
                agentData.setCashRegisterWorkplace(worklog.getCashRegisterWorkplace());
                dataFromUidsNeeded = false;
            }
            if (dataFromUidsNeeded) {
                EntityContainer agencyCtr = null;
                if (!TextUtil.isBlank((String)agencyUid)) {
                    log.debug(String.format("agency uid %s is found in config file", agencyUid));
                    agencyCtr = EntityStorage.get().load(Organization.class, agencyUid.trim());
                } else {
                    log.debug("agency uid was not found in config file");
                }
                if (agencyCtr == null) {
                    agencyCtr = ProfileHelper.getMainEmployment((Person)agent);
                }
                if (agencyCtr != null) {
                    log.debug(String.format("agency %s was found", agencyCtr.toReference()));
                    agentData.setAgency(agencyCtr.toReference());
                    agentData.setSubagency(agencyCtr.toReference());
                } else {
                    agentData.setAgency(null);
                    agentData.setSubagency(null);
                }
                if (!TextUtil.isBlank((String)salesPointUid)) {
                    log.debug(String.format("sales point uid %s is found in config file", salesPointUid));
                    EntityContainer salesPointCtr2 = EntityStorage.get().load(SalesPoint.class, salesPointUid.trim());
                    if (salesPointCtr2 != null) {
                        log.debug(String.format("sales point %s was found", salesPointCtr2.toReference()));
                        agentData.setSalesPoint(salesPointCtr2.toReference());
                    } else {
                        agentData.setSalesPoint(null);
                        log.debug("sales point was not found");
                    }
                } else {
                    agentData.setSalesPoint(null);
                    log.debug("sales point uid was not found");
                }
                if (!TextUtil.isBlank((String)cashUid)) {
                    log.debug(String.format("cash uid %s is found in config file", cashUid));
                    EntityContainer cashCtr = EntityStorage.get().load(Cash.class, cashUid.trim());
                    if (cashCtr != null) {
                        log.debug(String.format("cash %s was found", cashCtr.toReference()));
                        agentData.setCash(cashCtr.toReference());
                    } else {
                        agentData.setCash(null);
                        log.debug("cash was not found");
                    }
                } else {
                    agentData.setCash(null);
                    log.debug("cash uid was not found in config file");
                }
                if (!TextUtil.isBlank((String)cashRegisterUid)) {
                    log.debug(String.format("cash register uid %s is found in config file", cashRegisterUid));
                    EntityContainer cashRegCtr = EntityStorage.get().load(CashRegister.class, cashRegisterUid.trim());
                    if (cashRegCtr != null) {
                        log.debug(String.format("cash register %s was found", cashRegCtr.toReference()));
                        agentData.setCashRegister(cashRegCtr.toReference());
                    } else {
                        agentData.setCashRegister(null);
                        log.debug("cash register was not found");
                    }
                } else {
                    agentData.setCashRegister(null);
                    log.debug("cash register uid was not found in config file");
                }
                if (!TextUtil.isBlank((String)cashRegisterWorkplaceUid)) {
                    log.debug(String.format("cash register workplace uid %s is found in config file", cashRegisterWorkplaceUid));
                    EntityContainer cashRegWorkplaceCtr = EntityStorage.get().load(CashRegisterWorkplace.class, cashRegisterWorkplaceUid.trim());
                    if (cashRegWorkplaceCtr != null) {
                        log.debug(String.format("cash register workplace %s was found", cashRegWorkplaceCtr.toReference()));
                        agentData.setCashRegisterWorkplace(cashRegWorkplaceCtr.toReference());
                    } else {
                        agentData.setCashRegisterWorkplace(null);
                        log.debug("cash register workplace was not found");
                    }
                } else {
                    agentData.setCashRegisterWorkplace(null);
                    log.debug("cash register workplace uid was not found in config file");
                }
            }
            if (agentData.getSalesPoint() == null) {
                salesPointCtr = null;
                if (agentData.getAgency() != null) {
                    List agentSalesPoints = agentData.getAvailableSalesPoints().stream().filter(sp -> MiscUtil.equals((Object)sp.getAgency(), (Object)agentData.getAgency())).collect(Collectors.toList());
                    if (agentSalesPoints.size() == 1) {
                        salesPointCtr = EntityStorage.get().resolve(((AgentSalesPoint)agentSalesPoints.get(0)).getSalesPoint());
                    } else if (agentSalesPoints.size() > 1) {
                        salesPointCtr = agentSalesPoints.stream().filter(AgentSalesPoint::isDefaultForOrg).findFirst().map(AgentSalesPoint::getSalesPoint).map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).orElse(null);
                        if (salesPointCtr == null) {
                            salesPointCtr = EntityStorage.get().resolve(((AgentSalesPoint)agentSalesPoints.get(0)).getSalesPoint());
                        }
                    }
                } else {
                    log.debug("agency is null, so can't define default sales point");
                }
                if (salesPointCtr != null) {
                    log.debug(String.format("sales point %s was found", salesPointCtr.toReference()));
                    agentData.setSalesPoint(salesPointCtr.toReference());
                } else {
                    log.debug("sales point uid was not found in agent's sales points");
                }
            } else {
                salesPointCtr = EntityStorage.get().resolve(agentData.getSalesPoint());
                if (salesPointCtr != null) {
                    SalesPoint salesPoint = (SalesPoint)salesPointCtr.getEntity();
                    for (Pcc pcc : salesPoint.getPccs()) {
                        if (pcc.getGdsName() == null || TextUtil.isBlank((String)pcc.getCode()) || pcc.getOpened() != null && MiscUtil.clearTime((Date)pcc.getOpened()).after(currentDate) || pcc.getClosed() != null && MiscUtil.setDayEndTime((Date)pcc.getClosed()).before(currentDate)) continue;
                        agentData.getPccMap().put(pcc.getGdsName(), pcc.getCode());
                        log.debug(String.format("pcc %s for gds %s was added to pccs list", pcc.getCode(), pcc.getGdsName()));
                    }
                }
            }
        }
        catch (Throwable e) {
            log.error("unable to initialize agent context", e);
        }
    }
}

