/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.prefetched;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.Publisher;
import com.gridnine.xtrip.common.fx.model.PrefetchedData;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.server.fx.prefetched.PrefetchedDataHandler;
import com.gridnine.xtrip.server.fx.prefetched.PrefetchedDataHelper;
import java.util.ArrayList;
import java.util.List;
import org.java.plugin.registry.Extension;

public class PrefetchedDataSupport
implements Publisher {
    private final List<PrefetchedDataHandler> handlers = new ArrayList<PrefetchedDataHandler>();

    public static PrefetchedDataSupport get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return (PrefetchedDataSupport)Environment.getPublished(PrefetchedDataSupport.class);
    }

    public List<PrefetchedDataHandler> getHandlers() {
        return this.handlers;
    }

    public void publish() throws Exception {
        if (Environment.isPublished(PrefetchedDataSupport.class)) {
            return;
        }
        this.handlers.clear();
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server.fx.standard", (String)"PrefetchedDataHandler")) {
            this.handlers.add((PrefetchedDataHandler)JpfUtil.getClass((Extension)ext).newInstance());
        }
        Environment.publish(PrefetchedDataSupport.class, (Object)this);
    }

    public PrefetchedData getFilledData(String agencyUid, String salesPointUid, String cashUid, String cashRegisterUid, String cashRegisterWorkplaceUid) {
        PrefetchedData prefetchedData = new PrefetchedData();
        PrefetchedDataHelper.populateCurrentAgentData(prefetchedData.getCurrentAgentData(), agencyUid, salesPointUid, cashUid, cashRegisterUid, cashRegisterWorkplaceUid);
        for (PrefetchedDataHandler handler : this.handlers) {
            handler.populate(prefetchedData);
        }
        return prefetchedData;
    }

    private static class Holder {
        public static final PrefetchedDataSupport INSTANCE = (PrefetchedDataSupport)Environment.getPublished(PrefetchedDataSupport.class);

        private Holder() {
        }
    }
}

