/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.prefetched;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.model.FeeRemarkTemplateEntry;
import com.gridnine.xtrip.common.fx.model.FiscalSettings;
import com.gridnine.xtrip.common.fx.model.GetThereSyncSettings;
import com.gridnine.xtrip.common.fx.model.PrefetchedData;
import com.gridnine.xtrip.common.fx.model.RulesRelatedData;
import com.gridnine.xtrip.common.fx.model.SabreProfilesSettings;
import com.gridnine.xtrip.common.fx.model.UniversalProductDescriptionData;
import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.EMDCategorySettings;
import com.gridnine.xtrip.common.model.booking.NomenclatureSettings;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBookingHandlersRegistry;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBookingRelatedObjectHandler;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescription;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductDescriptionIndex;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CommissionCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.FeeRemarkTemplate;
import com.gridnine.xtrip.common.model.dict.Preference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.sabre.ProfileSynchronizationUtil;
import com.gridnine.xtrip.common.model.gds.sabre.SabreProfilesConnectionSettings;
import com.gridnine.xtrip.common.model.gds.sabre.SabreProfilesPNRBuilderType;
import com.gridnine.xtrip.common.model.gds.sabre.passivesegments.SabrePassiveSegmentsUtil;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.PCIDSSServerExchangeSettings;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.RollbackVersionsSettings;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionGroupResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.system.model.RegionalSettings;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.fx.prefetched.PrefetchedDataHandler;
import com.gridnine.xtrip.server.model.licence2.AppConfiguration;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class StandardPrefetchedDataHandler
implements PrefetchedDataHandler {
    @Override
    public void populate(PrefetchedData data) {
        this.populateCurrentAgentData(data.getCurrentAgentData());
        this.populateCurrencies(data);
        this.populateAvailablePaymentTypes(data);
        this.populateRulesRelatedData(data.getRulesRelatedData());
        this.populateSabreProfileSettings(data.getSabreProfilesSettings());
        this.populateGetThereSyncSettings(data.getGetThereSyncSettings());
        this.populateFiscalSettings(data.getFiscalSettings());
        this.populatePCIDSSServerExchangeSettings(data);
        this.populateRegionalSettings(data);
        this.populateArchivedBookingHandlers(data);
        this.populateUniversalProductDescriptions(data.getUniversalProductDescriptionData());
        this.populateFindocsData(data);
        this.populateEmdCategorySettings(data);
        this.populateRollbackVersionsSettings(data);
        String code = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.RETAIL_PROFILE_CODE, null);
        if (!TextUtil.isBlank((String)code)) {
            data.setRetailProfileCode(code);
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.code.name(), (Object)code));
            List idxs = EntityStorage.get().search(OrganizationIndex.class, query).getData();
            if (!idxs.isEmpty()) {
                data.setRetailProfile(((OrganizationIndex)idxs.get(0)).getSource());
            }
        }
        data.setShowSabreSyncRuleTargets(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.SHOW_SABRE_SYNCH_RULE_TARGETS, (boolean)false));
        data.setDefaultVAT(MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat()).doubleValue());
        data.setSabrePassiveSegmentsSettingsEnabled(SabrePassiveSegmentsUtil.getSabrePassiveSegmentsSettings() != null);
        data.setRestrictedTextSearch(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.RESTRICTED_FREE_TEXT_SEARCH, (boolean)false));
        data.setNotificationsEnabled(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.NOTIFICATIONS_ENABLED, (boolean)false));
        data.setCheckOrganizationsCodeUniquenessEnabled(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.CHECK_ORGANIZATIONS_CODE_UNIQUENESS, (boolean)false));
        data.setRegionalVariation(AppConfiguration.get().getRegionalVariation());
        data.setRestrictedAclResources(!DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.FULL_ACCESS_TO_FX_ACL_EDITOR, (boolean)false));
    }

    private void populateUniversalProductDescriptions(List<UniversalProductDescriptionData> listData) {
        List index = EntityStorage.get().search(UniversalProductDescriptionIndex.class, new SearchQuery()).getData();
        if (index.isEmpty()) {
            return;
        }
        listData.clear();
        listData.addAll(index.stream().map(idx -> {
            UniversalProductDescriptionData result = new UniversalProductDescriptionData();
            result.setReference(idx.getSource());
            result.setData((UniversalProductDescription)EntityStorage.get().resolve(idx.getSource()).getEntity());
            return result;
        }).collect(Collectors.toList()));
    }

    private void populatePCIDSSServerExchangeSettings(PrefetchedData data) {
        EntityContainer container = EntityStorage.get().load(PCIDSSServerExchangeSettings.class, UniqueSettingsRegistry.get().getUidByClassName(PCIDSSServerExchangeSettings.class.getName()));
        if (container != null) {
            data.setPCIDSSServerExchangeSettings((PCIDSSServerExchangeSettings)container.getEntity());
        }
    }

    private void populateFindocsData(PrefetchedData data) {
        SearchQuery nomenclatureQuery = new SearchQuery();
        nomenclatureQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)"entityType", (Object)NomenclatureSettings.class.getName()));
        nomenclatureQuery.setResultMode(ResultMode.COUNT_ONLY);
        data.setFindocsEnabled(EntityStorage.get().search(BasicSystemSettingsIndex.class, nomenclatureQuery).getTotalCount() > 0);
    }

    private void populateFiscalSettings(FiscalSettings data) {
        EntityContainer fiscalSettingsCtr = EntityStorage.get().load(com.gridnine.xtrip.common.fiscal.model.FiscalSettings.class, "fiscal-settings");
        if (fiscalSettingsCtr != null) {
            data.setUseMidofficeCashier(((com.gridnine.xtrip.common.fiscal.model.FiscalSettings)fiscalSettingsCtr.getEntity()).isUseMidofficeCashier());
            data.getAvailablePaymentTypes().clear();
            data.getAvailablePaymentTypes().putAll(((com.gridnine.xtrip.common.fiscal.model.FiscalSettings)fiscalSettingsCtr.getEntity()).getAvailablePaymentTypes());
        }
    }

    private void populateArchivedBookingHandlers(PrefetchedData data) {
        data.getArchivedBookingHandlersIdAndDisplayName().clear();
        for (ArchivedBookingRelatedObjectHandler handler : ((ArchivedBookingHandlersRegistry)Environment.getPublished(ArchivedBookingHandlersRegistry.class)).getAllHandlers()) {
            data.getArchivedBookingHandlersIdAndDisplayName().put(handler.getId(), handler.getDisplayName());
        }
    }

    private void populateCurrentAgentData(AgentData data) {
        try {
            data.setPrivilegedGroup(AclHelper.isGranted(null, (String)StandardRestrictionGroupResources.GROUP_ADMINISTRATION.getId(), (String)UserData.get().getCurrentUser(), (String)StandardRestrictionResourceOperations.USE.getId(), Collections.emptyList()));
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("failed applying ACL", (Throwable)e);
        }
    }

    private void populateCurrencies(PrefetchedData data) {
        String prefValue;
        if (data.getEquivalentCurrency() == null) {
            data.setEquivalentCurrency(DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB"));
        }
        if (!TextUtil.isBlank((String)(prefValue = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.CURRENCY_CHOICE_SETTINGS, (String)"")))) {
            List codes = TextUtil.split((String)prefValue, (String)"\\|", (boolean)true, (boolean)true);
            for (String currencyCode : codes) {
                data.getPreferredCurrencies().add(currencyCode);
            }
        }
    }

    private void populateAvailablePaymentTypes(PrefetchedData data) {
        String value;
        List paymentTypes = data.getAvailablePaymentTypes();
        Preference preference = DictHelper.getPreference((PreferenceKey)PreferenceKey.FOP_CHOICE_SETTINGS);
        String string = value = preference == null ? null : preference.getValue();
        if (!TextUtil.isBlank((String)value)) {
            for (String code : TextUtil.split((String)value, (String)"\\|", (boolean)true, (boolean)true)) {
                PaymentType pt = (PaymentType)CollectionUtil.findEnumConstant(PaymentType.class, (String)code);
                if (pt == null) continue;
                paymentTypes.add(pt);
            }
        }
        if (paymentTypes.isEmpty()) {
            paymentTypes.addAll(Arrays.asList(PaymentType.values()));
        }
    }

    private void populateRulesRelatedData(RulesRelatedData data) {
        data.setDiscountAsAgencyFeeCode((String)DictionaryCache.get().getAll(CommissionCategory.class).values().stream().filter(item -> item.getTranslations().containsValue("discount as an agency fee")).map(BaseDictionary::getCode).findFirst().orElse(null));
        DictionaryCache.get().getAll(FeeRemarkTemplate.class).values().stream().map(item -> {
            FeeRemarkTemplateEntry entry = new FeeRemarkTemplateEntry();
            entry.setDictRef((DictionaryReference)item.toReference());
            entry.setTemplate(item.getTemplate());
            return entry;
        }).collect(Collectors.toCollection(() -> ((RulesRelatedData)data).getFeeRemarkTemplates()));
    }

    private void populateSabreProfileSettings(SabreProfilesSettings data) {
        SabreProfilesConnectionSettings pccSettings = ProfileSynchronizationUtil.getSabreProfilesConnectionSettings();
        if (pccSettings != null) {
            if (pccSettings.isActive() && !pccSettings.getPccSettings().isEmpty()) {
                data.setSyncActive(true);
                data.getDefaultPccSettings().addAll(pccSettings.getPccSettings());
                data.setServerURL(pccSettings.getServerURL());
                List types = pccSettings.getBuilderTypes();
                for (SabreProfilesPNRBuilderType type : types) {
                    data.getPnrBuilderTypes().add(type.getName());
                }
            }
            data.setLoadActive(pccSettings.isLoadActive());
        }
        EntityContainer currentUserCtr = ProfileHelper.getCurrentUserCtr();
        data.getCurrentUserPccSettings().clear();
        if (currentUserCtr != null && currentUserCtr.getEntity() != null) {
            data.getCurrentUserPccSettings().addAll(((Person)currentUserCtr.getEntity()).getSabreProfilesPccSettings().stream().filter(s -> !TextUtil.isBlank((String)s.getPcc())).peek(a -> a.setPcc(a.getPcc().toUpperCase())).collect(Collectors.toList()));
        }
    }

    private void populateGetThereSyncSettings(GetThereSyncSettings data) {
        EntityContainer setCont = EntityStorage.get().load(ScheduledTaskSettings.class, "system-settings-getthere-synchronization-task");
        if (setCont == null || !((ScheduledTaskSettings)setCont.getEntity()).isEnabled()) {
            return;
        }
        ScheduledTaskSettings task = (ScheduledTaskSettings)setCont.getEntity();
        data.setSyncActive(true);
        for (NamedValue nv : task.getDataMap()) {
            if ("subsiteName".equals(nv.getName())) {
                data.setSubsiteName(nv.getValue());
                continue;
            }
            if (!"siteName".equals(nv.getName())) continue;
            data.setSiteName(nv.getValue());
        }
    }

    private void populateRegionalSettings(PrefetchedData prefetchedData) {
        SystemHelper.searchSystemSettings(RegionalSettings.class).stream().findFirst().ifPresent(arg_0 -> ((PrefetchedData)prefetchedData).setRegionalSettings(arg_0));
    }

    private void populateEmdCategorySettings(PrefetchedData prefetchedData) {
        SystemHelper.searchSystemSettings(EMDCategorySettings.class).stream().findFirst().ifPresent(arg_0 -> ((PrefetchedData)prefetchedData).setEmdCategoriesSettings(arg_0));
    }

    private void populateRollbackVersionsSettings(PrefetchedData prefetchedData) {
        SystemHelper.searchSystemSettings(RollbackVersionsSettings.class).stream().findFirst().ifPresent(arg_0 -> ((PrefetchedData)prefetchedData).setRollbackVersionsSettings(arg_0));
    }
}

