/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.rpc.AclDataService;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.security.acl.AclChangeRegistry;
import com.gridnine.xtrip.common.fx.security.acl.AclRegistry;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcesRegistry;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.security.acl.entry.AclEntry;
import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.util.AuthUtil;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.fx.AclUtil;
import com.gridnine.xtrip.server.restriction.helper.RestrictionsHelper;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AclDataServiceImpl
extends BaseSecureServiceImpl
implements AclDataService {
    public AclRegistry getFullAclRegistry(ServiceInvocationContext ctx) throws ServiceException {
        DebugUtil.setThreadName((String)"AclServiceImpl-getFullAclRegistry");
        try {
            this.checkContext(ctx);
            try {
                AclRegistry registry = new AclRegistry();
                for (AclGroup group : AssetsStorage.get().search(AclGroup.class, new SearchQuery()).getData()) {
                    registry.addGroup(group);
                }
                for (AclUser user : AssetsStorage.get().search(AclUser.class, new SearchQuery()).getData()) {
                    registry.addUser(user);
                }
                for (AclEntry entry : AssetsStorage.get().search(AclEntry.class, new SearchQuery()).getData()) {
                    registry.addEntry(entry);
                }
                AclRegistry aclRegistry = registry;
                return aclRegistry;
            }
            catch (Throwable t) {
                this.log.error("failed creating full acl registry", t);
                throw new ServiceException("failed creating full acl registry", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public AclRegistry getRestrictedAclRegistry(ServiceInvocationContext ctx, AclChangeRegistry changeRegistry, String pattern) throws ServiceException {
        DebugUtil.setThreadName((String)"AclServiceImpl-getRestrictedAclRegistry");
        try {
            this.checkContext(ctx);
            try {
                AclRegistry registry = new AclRegistry();
                Collection groups = Stream.concat(AclHelper.getGroups().stream().filter(item -> changeRegistry.getGroups().get(item.getId()) == null), changeRegistry.getGroups().values().stream().filter(item -> item.getType() == AclChangeRegistry.AclChangeType.ADD || item.getType() == AclChangeRegistry.AclChangeType.EDIT).map(item -> (AclGroup)((AclChangeRegistry.AclGroupData)item.getData()).getPrincipal())).collect(Collectors.toList());
                for (AclGroup group : groups) {
                    registry.addGroup(group);
                    List entries = Stream.concat(AclHelper.getEntries((String)group.getId()).stream().filter(item -> changeRegistry.getEntries().get((Object)item.getPrincipalId(), (Object)item.getResourceId()) == null), changeRegistry.getEntries().getKey1Values((Object)group.getId()).stream().filter(item -> item.getType() == AclChangeRegistry.AclChangeType.ADD || item.getType() == AclChangeRegistry.AclChangeType.EDIT).map(item -> item.getData().getEntry())).collect(Collectors.toList());
                    for (AclEntry entry : entries) {
                        registry.addEntry(entry);
                    }
                }
                if (pattern != null && pattern.length() > 0) {
                    boolean all = pattern.equals("*");
                    SearchQuery query = new SearchQuery();
                    if (!all) {
                        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ilike((String)AclUser.Property.id.name(), (String)String.format("%%%s%%", pattern)), SearchCriterion.ilike((String)AclUser.Property.name.name(), (String)String.format("%%%s%%", pattern)), SearchCriterion.ilike((String)AclUser.Property.description.name(), (String)String.format("%%%s%%", pattern))}));
                    }
                    List users = Stream.concat(AssetsStorage.get().search(AclUser.class, query).getData().stream().filter(item -> changeRegistry.getUsers().get(item.getId()) == null), changeRegistry.getUsers().values().stream().filter(item -> item.getType() == AclChangeRegistry.AclChangeType.ADD || item.getType() == AclChangeRegistry.AclChangeType.EDIT).map(item -> (AclUser)((AclChangeRegistry.AclUserData)item.getData()).getPrincipal()).filter(item -> TextUtil.isLike((String)item.getId(), (String)pattern, (boolean)true, (boolean)false) || TextUtil.isLike((String)item.getName(), (String)pattern, (boolean)true, (boolean)false) || TextUtil.isLike((String)item.getDescription(), (String)pattern, (boolean)true, (boolean)false))).collect(Collectors.toList());
                    for (AclUser user : users) {
                        registry.addUser(user);
                        List entries = Stream.concat(AclHelper.getEntries((String)user.getId()).stream().filter(item -> changeRegistry.getEntries().get((Object)item.getPrincipalId(), (Object)item.getResourceId()) == null), changeRegistry.getEntries().getKey1Values((Object)user.getId()).stream().filter(item -> item.getType() == AclChangeRegistry.AclChangeType.ADD || item.getType() == AclChangeRegistry.AclChangeType.EDIT).map(item -> item.getData().getEntry())).collect(Collectors.toList());
                        for (AclEntry entry : entries) {
                            registry.addEntry(entry);
                        }
                    }
                }
                AclRegistry aclRegistry = registry;
                return aclRegistry;
            }
            catch (Throwable t) {
                this.log.error("failed creating restricted acl registry", t);
                throw new ServiceException("failed creating restricted acl registry", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public Serializable save(ServiceInvocationContext ctx, AclChangeRegistry registry) throws ServiceException {
        DebugUtil.setThreadName((String)"AclServiceImpl-save");
        try {
            AclChangeRegistry.AclGroupData data;
            AclChangeRegistry.AclChangeType type;
            Serializable authToken = null;
            this.checkContext(ctx);
            for (AclChangeRegistry.AclChange change : registry.getGroups().values()) {
                type = change.getType();
                data = (AclChangeRegistry.AclGroupData)change.getData();
                if (type == AclChangeRegistry.AclChangeType.ADD || type == AclChangeRegistry.AclChangeType.EDIT) {
                    AssetsStorage.get().save((BaseAsset)data.getPrincipal());
                    continue;
                }
                if (type != AclChangeRegistry.AclChangeType.DELETE) continue;
                AssetsStorage.get().delete((BaseAsset)data.getPrincipal());
            }
            for (AclChangeRegistry.AclChange change : registry.getUsers().values()) {
                type = change.getType();
                data = (AclChangeRegistry.AclUserData)change.getData();
                if (type == AclChangeRegistry.AclChangeType.ADD || type == AclChangeRegistry.AclChangeType.EDIT) {
                    EntityContainer newPersonContainer;
                    Serializable token;
                    if (data.isUserChanged()) {
                        AssetsStorage.get().save((BaseAsset)data.getPrincipal());
                    }
                    if (data.isAccountChanged() && (token = this.updateUserAccount(ctx, data.getAccount(), !TextUtil.isBlank((String)data.getPassword(), (boolean)false) ? data.getPassword().toCharArray() : null, type == AclChangeRegistry.AclChangeType.ADD)) != null) {
                        authToken = token;
                    }
                    if (!data.isProfileChanged()) continue;
                    EntityContainer oldPersonContainer = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)data.getAccount().getLoginName());
                    if (oldPersonContainer != null) {
                        ((Person)oldPersonContainer.getEntity()).setLoginName(null);
                        oldPersonContainer.getVersionInfo().setDataSource("fx-editor");
                        oldPersonContainer.getVersionInfo().setVersionNotes("save acl");
                        EntityStorage.get().save(oldPersonContainer, true);
                    }
                    if ((newPersonContainer = EntityStorage.get().resolve(data.getProfile())) == null) continue;
                    ((Person)newPersonContainer.getEntity()).setLoginName(data.getAccount().getLoginName());
                    newPersonContainer.getVersionInfo().setDataSource("fx-editor");
                    newPersonContainer.getVersionInfo().setVersionNotes("save acl");
                    EntityStorage.get().save(newPersonContainer, true);
                    continue;
                }
                if (type != AclChangeRegistry.AclChangeType.DELETE) continue;
                AssetsStorage.get().delete((BaseAsset)data.getPrincipal());
                AssetsStorage.get().delete((BaseAsset)data.getAccount());
            }
            for (AclChangeRegistry.AclChange change : registry.getEntries().values()) {
                type = change.getType();
                data = change.getData();
                if (type == AclChangeRegistry.AclChangeType.ADD || type == AclChangeRegistry.AclChangeType.EDIT) {
                    AssetsStorage.get().save((BaseAsset)data.getEntry());
                    continue;
                }
                if (type != AclChangeRegistry.AclChangeType.DELETE) continue;
                AssetsStorage.get().delete((BaseAsset)data.getEntry());
            }
            Iterator<Object> iterator = authToken;
            return iterator;
        }
        catch (Throwable t) {
            this.log.error("failed saving ACL", t);
            throw new ServiceException("failed saving ACL", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable updateUserAccount(ServiceInvocationContext ctx, UserAccount account, char[] password, boolean virgin) throws ServiceException {
        DebugUtil.setThreadName((String)"AclServiceImpl-updateUserAccount");
        try {
            String authToken = null;
            this.checkContext(ctx);
            if (virgin) {
                if (TextUtil.isBlank((String)account.getLoginName())) {
                    throw new ServiceException(L10nResourcesManager.getStr((String)Messages.ModelServiceImpl_loginNotDefine, (Object[])new Object[0]));
                }
                if (!account.getLoginName().matches("[0-9a-zA-Z\\_\\-\\~\\!\\#\\$\\%\\^\\&\\*\\(\\)\\{\\}\\[\\]\\+\\=\\;\\:\\<\\>\\?\\/\\@\\.\\,\\|]+")) {
                    throw new ServiceException(L10nResourcesManager.getStr((String)Messages.ModelServiceImpl_accountNameCanContain, (Object[])new Object[0]), true);
                }
                if (TextUtil.isBlank((String)account.getFullName())) {
                    throw new ServiceException(L10nResourcesManager.getStr((String)Messages.ModelServiceImpl_accountNameNotDefine, (Object[])new Object[0]), true);
                }
                if (password == null) {
                    throw new ServiceException(L10nResourcesManager.getStr((String)Messages.ModelServiceImpl_passwordShouldBeNotEmpty, (Object[])new Object[0]), true);
                }
            }
            if (password != null) {
                try {
                    account.setPassword(password);
                    authToken = AuthUtil.buildAuthToken((String)account.getLoginName(), (char[])password);
                }
                catch (Throwable t) {
                    this.log.error(String.format("failed setting password for account %s", account.getLoginName()), t);
                    throw new ServiceException(L10nResourcesManager.getStr((String)Messages.ModelServiceImpl_cantChangePassword, (Object[])new Object[]{account.getLoginName()}), t);
                }
            }
            AssetsStorage.get().save((BaseAsset)account);
            String string = LogicalStorage.get().getUser().equals(account.getLoginName()) ? authToken : null;
            return string;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, Boolean>> applyAcl(ServiceInvocationContext ctx, Set<String> resources) throws ServiceException {
        DebugUtil.setThreadName((String)"AclServiceImpl-applyAcl");
        try {
            this.checkContext(ctx);
            Map<String, Map<String, Boolean>> map = CollectionUtil.flatTreeStream(resources, item -> RestrictionResourcesRegistry.get().getResourceChildren(item)).collect(Collectors.toMap(resource -> resource, resource -> RestrictionResourcesRegistry.get().getResourceOperations(resource).stream().collect(Collectors.toMap(operation -> operation, operation -> (Boolean)MiscUtil.uncheckCall(() -> AclHelper.isGranted(null, (String)resource, (String)ctx.getUser(), (String)operation, Collections.emptyList()))))));
            return map;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public Set<String> applyAcl(ServiceInvocationContext context, Map<String, AclQuery> queries) throws ServiceException {
        DebugUtil.setThreadName((String)"AclServiceImpl-applyACL");
        try {
            this.checkContext(context);
            try {
                HashSet<String> result = new HashSet<String>();
                HashMap<String, String> uids = new HashMap<String, String>();
                HashMap proxies = new HashMap();
                for (Map.Entry<String, AclQuery> entry : queries.entrySet()) {
                    String key = entry.getKey();
                    AclQuery query = entry.getValue();
                    boolean granted = true;
                    for (AclQuery.AclQueryEntry queryEntry : query.getEntries()) {
                        RestrictionResourceProxy proxy = null;
                        NestedEntityReference reference = queryEntry.getReference();
                        if (reference != null) {
                            EntityContainer container;
                            if (uids.get(reference.getUid()) == null && (container = EntityStorage.get().resolve((EntityReference)reference)) != null) {
                                uids.put(reference.getUid(), container.getEntity().getUid());
                                proxies.putAll(RestrictionsHelper.buildProxies((EntityContainer)container, (String)queryEntry.getRootResourceId()));
                            }
                            proxy = (RestrictionResourceProxy)proxies.get(reference.getNestedEntityUid() != null ? reference.getNestedEntityUid() : uids.get(reference.getUid()));
                        }
                        if (AclHelper.isGranted(proxy, (String)queryEntry.getResourceId(), (String)context.getUser(), (String)queryEntry.getOperationId(), Collections.emptyList())) continue;
                        granted = false;
                        break;
                    }
                    if (!granted) continue;
                    result.add(key);
                }
                HashSet<String> hashSet = result;
                return hashSet;
            }
            catch (Throwable t) {
                this.log.error("failed applying ACL", t);
                throw new ServiceException("failed applying ACL", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public Map<String, Boolean> applyAcl(ServiceInvocationContext context, Class<? extends BaseEntity> entityClass, String entityUid, Integer versionNumber) throws ServiceException {
        DebugUtil.setThreadName((String)"AclServiceImpl-applyACL");
        try {
            this.checkContext(context);
            try {
                EntityContainer container = EntityStorage.get().load(entityClass, entityUid, versionNumber);
                Map map = AclUtil.getPermissions((EntityContainer)container, entityClass, (String)context.getUser());
                return map;
            }
            catch (Throwable t) {
                this.log.error("failed applying ACL", t);
                throw new ServiceException("failed applying ACL", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }
}

