/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.model.booking.HotelRefundFaresSettings;
import com.gridnine.xtrip.common.fx.model.booking.HotelRefundSettings;
import com.gridnine.xtrip.common.fx.rpc.AeroexpressItineraryReceiptProperties;
import com.gridnine.xtrip.common.fx.rpc.AirItineraryReceiptProperties;
import com.gridnine.xtrip.common.fx.rpc.AirRefundReceiptProperties;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.CertificateOfCompletedFlightProperties;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.fx.rpc.RailwayItineraryReceiptProperties;
import com.gridnine.xtrip.common.fx.rpc.RailwayRefundReceiptProperties;
import com.gridnine.xtrip.common.fx.rpc.TransferItineraryReceiptProperties;
import com.gridnine.xtrip.common.fx.rpc.VoucherProperties;
import com.gridnine.xtrip.common.fx.rpc.exceptions.BookingFileNotFoundException;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.aggregator.HotelAggregatorHelper;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.SysLogItem;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.AirItineraryReceiptData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.HotelVoucherData;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.ProductReplaceDetailsType;
import com.gridnine.xtrip.common.model.booking.ProductSearchIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatCalculationSettings;
import com.gridnine.xtrip.common.model.booking.VatCalculationSettingsSynchronizationResult;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.passive.SabrePassiveSegmentsSettings;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.booking.uidata.fopmap.ExchangePaymentTypeWrapper;
import com.gridnine.xtrip.common.model.booking.uidata.fopmap.PenaltyCostItem;
import com.gridnine.xtrip.common.model.booking.uidata.fopmap.PriceComponentWrapper;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductTax;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Penalty;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryIndex;
import com.gridnine.xtrip.common.model.delivery.DeliveryItemIndex;
import com.gridnine.xtrip.common.model.delivery.DeliveryItemType;
import com.gridnine.xtrip.common.model.delivery.MetroLine;
import com.gridnine.xtrip.common.model.delivery.MetroStation;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.Hotel;
import com.gridnine.xtrip.common.model.dict.HotelsBrand;
import com.gridnine.xtrip.common.model.dict.InformationNote;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.RemoteDictionaryResolver;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.entity.misc.EntityStorageThreadContext;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.gds.sabre.SabrePassiveSegmentsConnectionSettings;
import com.gridnine.xtrip.common.model.gds.sabre.passivesegments.SabrePassiveSegmentsUtil;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.handlers.ProductPassiveSegmentsHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.helpers.ValidationUtil;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.profile.BaseContractAppendix;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendix;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.standard.helpers.SysLogHelper;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.templates.jr.AeroexpressReceiptRender;
import com.gridnine.xtrip.common.model.templates.jr.CertificateOfCompletedFlightRender;
import com.gridnine.xtrip.common.model.templates.jr.DeliveryBlankRenderer;
import com.gridnine.xtrip.common.model.templates.jr.RailwayItineraryReceiptRender;
import com.gridnine.xtrip.common.model.templates.jr.RailwayRefundReceiptRender;
import com.gridnine.xtrip.common.model.templates.jr.RefundReceiptRender;
import com.gridnine.xtrip.common.model.templates.jr.TransferItineraryReceiptRender;
import com.gridnine.xtrip.common.model.templates.jr.VoucherRender;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.fx.bookingFile.handler.AgencyMemoProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandler;
import com.gridnine.xtrip.server.fx.bookingFile.handler.ProductFXHandlersRegistry;
import com.gridnine.xtrip.server.fx.bookingFile.helper.BookingFileHelper;
import com.gridnine.xtrip.server.fx.util.DateUtil;
import com.gridnine.xtrip.server.model.handlers.AeroexpressTicketActionSet;
import com.gridnine.xtrip.server.model.handlers.HotelActionSet;
import com.gridnine.xtrip.server.model.handlers.ProductCommissionActionSet;
import com.gridnine.xtrip.server.model.handlers.ServerHandlersRegistry;
import com.gridnine.xtrip.server.model.handlers.TransferActionSet;
import com.gridnine.xtrip.server.model.handlers.rules.AeroexpressTicketRulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.AirRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.GeneralProductRulesHelper;
import com.gridnine.xtrip.server.model.handlers.rules.RulesProductHandler;
import com.gridnine.xtrip.server.model.handlers.rules.TransferRulesHandler;
import com.gridnine.xtrip.server.model.handlers.rules.hotel.HotelRulesHelper;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import com.gridnine.xtrip.server.model.helpers.vat.common.CommonVatSynchronizationHelper;
import com.gridnine.xtrip.server.model.mail.MailSender;
import com.gridnine.xtrip.server.model.rules.RulesHelper;
import com.gridnine.xtrip.server.model.templates.jr.ItineraryReceiptRender;
import com.gridnine.xtrip.server.restriction.helper.RestrictionsHelper;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.time.DateUtils;

public class BookingFileServiceImpl
extends BaseSecureServiceImpl
implements BookingFileService {
    private static List<Message> getNoSuchHandlerMessage(BaseProduct product) {
        return Collections.singletonList(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("No handler registered for product type: %s", product.getClass().getCanonicalName()), (Object[])new Object[0]));
    }

    private static void audit(EntityReference<?> ref, String tag, Message message, List<Message> errorList) {
        ArrayList<SysLogItem> lst = new ArrayList<SysLogItem>();
        lst.add(SysLogHelper.newAuditItem(ref, (String)tag, (Message)message));
        try {
            AssetsStorage.get().save(lst);
        }
        catch (Exception e) {
            errorList.add(Messages.getExceptionFailedAddEntryToSystemLog((Throwable)e, (String)ref.getCaption()));
        }
    }

    private static Map<String, String> getProductsInExistingDeliveries(List<String> productUidList) {
        SearchQuery query = new SearchQuery();
        Object[] uids = productUidList.toArray(new Object[0]);
        query.getPreferredProperties().add(DeliveryItemIndex.Property.nestedEntityUid.name());
        query.getPreferredProperties().add(DeliveryItemIndex.Property.deliverySystemNumber.name());
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)DeliveryItemIndex.Property.type.name(), (Object)DeliveryItemType.PRODUCT));
        query.getCriteria().getCriterions().add(SearchCriterion.in((String)DeliveryItemIndex.Property.nestedEntityUid.name(), (Object[])uids));
        return EntityStorage.get().search(DeliveryItemIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData().stream().collect(Collectors.toMap(DeliveryItemIndex::getNestedEntityUid, DeliveryItemIndex::getDeliverySystemNumber));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> updateClientFops(ServiceInvocationContext ctx, Map<EntityReference<BookingFile>, Map<String, List<GeneralProductFop>>> fopMap) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-update-client-fops");
        ArrayList<Message> result = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            fopMap.forEach((bfReference, productMap) -> {
                EntityContainer ctr = EntityStorage.get().resolve(bfReference);
                ArrayList products = new ArrayList();
                productMap.forEach((productUID, fopList) -> {
                    if (ctr == null) {
                        this.addContainerResolveErrorMessage(result, (String)productUID);
                        return;
                    }
                    BaseProduct product = BookingHelper.findProductByUid((String)productUID, (BookingFile)((BookingFile)ctr.getEntity()));
                    if (product == null) {
                        this.addProductResolveErrorMessage(result, (String)productUID);
                        return;
                    }
                    products.add(product);
                    GeneralProductHelper.updateFops((BaseProduct)product, (ContractType)ContractType.CLIENT, (List)fopList);
                });
                try {
                    ctr.getVersionInfo().setDataSource("fx-updateClientFops");
                    EntityStorage.get().save(ctr, true);
                    products.forEach(product -> {
                        Message successMes = Messages.getNotificationFOPOperationSuccess((String)BookingHelper.generateShortProductName((BaseProduct)product), (String)((BookingFile)ctr.getEntity()).getNumber());
                        result.add(successMes);
                        BookingFileServiceImpl.audit(ctr.toReference(), "entity-modification", successMes, result);
                    });
                }
                catch (Exception e) {
                    result.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"Error saving booking file", (Throwable)e, (Object[])new Object[0]));
                    this.updateErrorListWithXeption(result, e);
                }
            });
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return result;
    }

    public BigDecimal getProductTotalPrice(ServiceInvocationContext ctx, BaseProduct product, ContractType contractType, boolean initialPriceForVoidProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-get-product-total-price");
        try {
            this.checkContext(ctx);
            try {
                BigDecimal bigDecimal = BookingHelper.getTotalPrice((BaseProduct)product, (ContractType)contractType, (boolean)initialPriceForVoidProduct);
                return bigDecimal;
            }
            catch (Exception e) {
                this.log.error("failed calculation product total price" + product.getUid(), (Throwable)e);
                throw new ServiceException("failed calculation product total price", (Throwable)e);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> applyRules(ServiceInvocationContext ctx, List<EntityReference<BookingFile>> bookingFileReferenceList) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-apply-rules");
        try {
            this.checkContext(ctx);
            ArrayList<Message> result = new ArrayList<Message>();
            bookingFileReferenceList.forEach(bookingFileReference -> result.addAll(this.applyRules((EntityReference<BookingFile>)bookingFileReference)));
            ArrayList<Message> arrayList = result;
            return arrayList;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public BookingFileService.BookingFileRPCResult<BookingFile> reSubmitProductToSameReservation(ServiceInvocationContext ctx, String srcProductUID, EntityReference<BookingFile> bookingFileEntityReference, String ticketNum, EntityReference<Organization> targetClient, EntityReference<Contract> targetContract) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-clone-product");
        ArrayList resultMessages = new ArrayList();
        AtomicReference result = new AtomicReference();
        try {
            this.checkContext(ctx);
            LockUtil.lock(bookingFileEntityReference, bookingFileCtr -> {
                ArrayList<Message> errorList = new ArrayList<Message>();
                if (bookingFileCtr == null) {
                    this.addContainerResolveErrorMessage(errorList, srcProductUID);
                }
                AgencyMemoProduct srcProduct = null;
                if (errorList.isEmpty() && bookingFileCtr != null && (srcProduct = (AgencyMemoProduct)BookingHelper.findProductByUid((String)srcProductUID, (BookingFile)((BookingFile)bookingFileCtr.getEntity()))) == null) {
                    this.addProductResolveErrorMessage(errorList, srcProductUID);
                    resultMessages.addAll(errorList);
                    result.set(new BookingFileService.BookingFileRPCResult(resultMessages, null, null));
                    return;
                }
                Reservation srcReservation = srcProduct.getReservation();
                ArrayList productList = new ArrayList(srcReservation.getProducts());
                if (errorList.isEmpty()) {
                    AgencyMemoProductFXHandler fxHandler = (AgencyMemoProductFXHandler)ProductFXHandlersRegistry.get().getForProduct(srcProduct);
                    if (fxHandler != null) {
                        List<Message> messages = fxHandler.reSubmitProductToSameReservation(srcProduct, (EntityContainer<BookingFile>)bookingFileCtr, ticketNum, targetClient, targetContract);
                        resultMessages.addAll(messages);
                    } else {
                        resultMessages.addAll(BookingFileServiceImpl.getNoSuchHandlerMessage((BaseProduct)srcProduct));
                    }
                }
                List productListAfterClone = BookingStreamHelper.reservationStreamSafe((BookingFile)((BookingFile)bookingFileCtr.getEntity())).filter(arg_0 -> ((Reservation)srcReservation).equals(arg_0)).map(Reservation::getProducts).findAny().orElse(null);
                productListAfterClone.removeAll(productList);
                resultMessages.addAll(errorList);
                result.set(new BookingFileService.BookingFileRPCResult(resultMessages, null, ((BaseProduct)productListAfterClone.get(0)).getUid()));
            });
        }
        catch (Throwable t) {
            this.log.error("failed re-submit product to same reservation " + bookingFileEntityReference, t);
            throw new ServiceException("failed re-submitting product", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return (BookingFileService.BookingFileRPCResult)result.get();
    }

    public BookingFileService.BookingFileRPCResult<? extends BaseEntity> reSubmitProductToNewBookingFile(ServiceInvocationContext ctx, String srcProductUID, EntityReference<BookingFile> srcBookingFileEntityReference, GdsName gdsName, RecordLocatorType recordLocatorType, String reservationNum, String ticketNum, EntityReference<Organization> targetClient, EntityReference<Contract> targetContract) throws ServiceException {
        BookingFileService.BookingFileRPCResult result;
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-clone-air-product");
        ArrayList<Message> resultMessages = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            ArrayList<Message> errorList = new ArrayList<Message>();
            AgencyMemoProduct srcProduct = null;
            EntityContainer srcBookingFileContainer = EntityStorage.get().resolve(srcBookingFileEntityReference);
            if (srcBookingFileContainer == null) {
                this.addContainerResolveErrorMessage(errorList, srcProductUID);
            }
            if (errorList.isEmpty() && srcBookingFileContainer != null && (srcProduct = (AgencyMemoProduct)BookingHelper.findProductByUid((String)srcProductUID, (BookingFile)((BookingFile)srcBookingFileContainer.getEntity()))) == null) {
                BookingFileService.BookingFileRPCResult result2;
                this.addProductResolveErrorMessage(errorList, srcProductUID);
                resultMessages.addAll(errorList);
                BookingFileService.BookingFileRPCResult bookingFileRPCResult = result2 = new BookingFileService.BookingFileRPCResult(resultMessages, null, null);
                return bookingFileRPCResult;
            }
            EntityContainer destBookingFileEntityContainer = new EntityContainer(BookingFile.class);
            AgencyMemoProductFXHandler fxHandler = (AgencyMemoProductFXHandler)ProductFXHandlersRegistry.get().getForProduct(srcProduct);
            if (fxHandler != null) {
                srcProduct.getReservation().setResDate(new Date());
                List<Message> messages = fxHandler.reSubmitProductToNewBookingFile(srcProduct, (EntityContainer<BookingFile>)srcBookingFileContainer, (EntityContainer<BookingFile>)destBookingFileEntityContainer, gdsName, recordLocatorType, reservationNum, ticketNum, targetClient, targetContract);
                resultMessages.addAll(messages);
            } else {
                resultMessages.addAll(BookingFileServiceImpl.getNoSuchHandlerMessage((BaseProduct)srcProduct));
            }
            resultMessages.addAll(errorList);
            result = new BookingFileService.BookingFileRPCResult(resultMessages, destBookingFileEntityContainer.toReference(), ((BaseProduct)((Reservation)((BookingFile)destBookingFileEntityContainer.getEntity()).getReservations().get(0)).getProducts().get(0)).getUid());
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("failed re-submitting product for booking " + srcBookingFileEntityReference, t);
            throw new ServiceException("failed cloning product", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return result;
    }

    public BookingFileService.BookingFileRPCResult<BookingFile> cloneProductToSameReservation(ServiceInvocationContext ctx, String srcProductUID, EntityReference<BookingFile> bookingFileRef, String reservationNum, String ticketNum, int ticketAmounts, boolean forwardAgencyMemo) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-clone-product");
        ArrayList resultMessages = new ArrayList();
        AtomicReference result = new AtomicReference();
        try {
            this.checkContext(ctx);
            LockUtil.lock(bookingFileRef, bookingFileCtr -> {
                ArrayList<Message> errorList = new ArrayList<Message>();
                if (bookingFileCtr == null) {
                    this.addContainerResolveErrorMessage(errorList, srcProductUID);
                }
                BaseProduct srcProduct = null;
                if (errorList.isEmpty() && bookingFileCtr != null && (srcProduct = BookingHelper.findProductByUid((String)srcProductUID, (BookingFile)((BookingFile)bookingFileCtr.getEntity()))) == null) {
                    this.addProductResolveErrorMessage(errorList, srcProductUID);
                    resultMessages.addAll(errorList);
                    result.set(new BookingFileService.BookingFileRPCResult(resultMessages, null, null));
                    return;
                }
                Reservation srcReservation = srcProduct.getReservation();
                ArrayList productList = new ArrayList(srcReservation.getProducts());
                if (errorList.isEmpty()) {
                    ProductFXHandler<BaseProduct> fxHandler = ProductFXHandlersRegistry.get().getForProduct(srcProduct);
                    if (fxHandler != null) {
                        List<Message> messages = fxHandler.cloneProductToSameReservation(srcProduct, (EntityContainer<BookingFile>)bookingFileCtr, reservationNum, ticketNum, ticketAmounts, forwardAgencyMemo);
                        resultMessages.addAll(messages);
                    } else {
                        resultMessages.addAll(BookingFileServiceImpl.getNoSuchHandlerMessage(srcProduct));
                    }
                }
                List productListAfterClone = BookingStreamHelper.reservationStreamSafe((BookingFile)((BookingFile)bookingFileCtr.getEntity())).filter(arg_0 -> ((Reservation)srcReservation).equals(arg_0)).map(Reservation::getProducts).findAny().orElse(null);
                productListAfterClone.removeAll(productList);
                resultMessages.addAll(errorList);
                result.set(new BookingFileService.BookingFileRPCResult(resultMessages, null, ((BaseProduct)productListAfterClone.get(0)).getUid()));
            });
        }
        catch (Throwable t) {
            this.log.error("failed cloning product to same reservation " + bookingFileRef, t);
            throw new ServiceException("failed cloning product", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return (BookingFileService.BookingFileRPCResult)result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookingFileService.BookingFileRPCResult<BookingFile> cloneProductToNewReservation(ServiceInvocationContext ctx, String srcProductUID, EntityReference<BookingFile> bookingFileEntityReference, GdsName gdsName, RecordLocatorType recordLocatorType, String reservationNum, String ticketNum, int ticketAmounts, boolean forwardAgencyMemo) throws ServiceException {
        BookingFileService.BookingFileRPCResult result;
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-clone-air-product");
        ArrayList<Message> resultMessages = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            ArrayList<Message> errorList = new ArrayList<Message>();
            EntityContainer srcBookingFileContainer = EntityStorage.get().resolve(bookingFileEntityReference);
            if (srcBookingFileContainer == null) {
                BookingFileService.BookingFileRPCResult result2;
                this.addContainerResolveErrorMessage(errorList, srcProductUID);
                resultMessages.addAll(errorList);
                BookingFileService.BookingFileRPCResult bookingFileRPCResult = result2 = new BookingFileService.BookingFileRPCResult(resultMessages, null, null);
                return bookingFileRPCResult;
            }
            BaseProduct srcProduct = BookingHelper.findProductByUid((String)srcProductUID, (BookingFile)((BookingFile)srcBookingFileContainer.getEntity()));
            if (srcProduct == null) {
                this.addProductResolveErrorMessage(errorList, srcProductUID);
            }
            if (errorList.isEmpty() && srcProduct != null) {
                ProductFXHandler<BaseProduct> fxHandler = ProductFXHandlersRegistry.get().getForProduct(srcProduct);
                if (fxHandler != null) {
                    List<Message> messages = fxHandler.cloneProductToNewReservation(srcProduct, (EntityContainer<BookingFile>)srcBookingFileContainer, gdsName, recordLocatorType, reservationNum, ticketNum, ticketAmounts, forwardAgencyMemo);
                    resultMessages.addAll(messages);
                } else {
                    resultMessages.addAll(BookingFileServiceImpl.getNoSuchHandlerMessage(srcProduct));
                }
            }
            List newReservation = ((BookingFile)srcBookingFileContainer.getEntity()).getReservations().stream().filter(e -> CommonReservationGdsNameInfoHelper.containsRecordLocator((Reservation)e, (String)reservationNum)).collect(Collectors.toList());
            String resultUid = null;
            if (!newReservation.isEmpty() && !((Reservation)newReservation.get(0)).getProducts().isEmpty()) {
                resultUid = ((BaseProduct)((Reservation)newReservation.get(0)).getProducts().get(0)).getUid();
            }
            resultMessages.addAll(errorList);
            result = new BookingFileService.BookingFileRPCResult(resultMessages, null, resultUid);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return result;
    }

    public BookingFileService.BookingFileRPCResult<BookingFile> cloneProductToNewBookingFile(ServiceInvocationContext ctx, String srcProductUID, EntityReference<BookingFile> bookingFileEntityReference, GdsName gdsName, RecordLocatorType recordLocatorType, String reservationNum, String ticketNum, int ticketAmounts, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer) throws ServiceException {
        BookingFileService.BookingFileRPCResult result;
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-clone-air-product");
        ArrayList<Message> resultMessages = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            ArrayList<Message> errorList = new ArrayList<Message>();
            BaseProduct srcProduct = null;
            EntityContainer srcBookingFileContainer = EntityStorage.get().resolve(bookingFileEntityReference);
            if (srcBookingFileContainer == null) {
                this.addContainerResolveErrorMessage(errorList, srcProductUID);
            }
            if (errorList.isEmpty() && srcBookingFileContainer != null && (srcProduct = BookingHelper.findProductByUid((String)srcProductUID, (BookingFile)((BookingFile)srcBookingFileContainer.getEntity()))) == null) {
                BookingFileService.BookingFileRPCResult result2;
                this.addProductResolveErrorMessage(errorList, srcProductUID);
                resultMessages.addAll(errorList);
                BookingFileService.BookingFileRPCResult bookingFileRPCResult = result2 = new BookingFileService.BookingFileRPCResult(resultMessages, null, null);
                return bookingFileRPCResult;
            }
            EntityContainer destBookingFileEntityContainer = new EntityContainer(BookingFile.class);
            if (errorList.isEmpty() && srcProduct != null) {
                ((BookingFile)destBookingFileEntityContainer.getEntity()).setCreateDate(new Date());
                destBookingFileEntityContainer.getVersionInfo().setDataSource("fx-cloneProductToNewBookingFile");
                ((BookingFile)destBookingFileEntityContainer.getEntity()).setAgency(((BookingFile)srcBookingFileContainer.getEntity()).getAgency());
                ((BookingFile)destBookingFileEntityContainer.getEntity()).setCustomerProfile(((BookingFile)srcBookingFileContainer.getEntity()).getCustomerProfile());
                ProductFXHandler<BaseProduct> fxHandler = ProductFXHandlersRegistry.get().getForProduct(srcProduct);
                if (fxHandler != null) {
                    srcProduct.getReservation().setResDate(new Date());
                    List<Message> messages = fxHandler.cloneProductToNewBookingFile(srcProduct, (EntityContainer<BookingFile>)srcBookingFileContainer, gdsName, recordLocatorType, reservationNum, ticketNum, (EntityContainer<BookingFile>)destBookingFileEntityContainer, ticketAmounts, forwardAgencyMemo, targetClient, changeRetailPayer);
                    resultMessages.addAll(messages);
                } else {
                    resultMessages.addAll(BookingFileServiceImpl.getNoSuchHandlerMessage(srcProduct));
                }
            }
            resultMessages.addAll(errorList);
            result = new BookingFileService.BookingFileRPCResult(resultMessages, destBookingFileEntityContainer.toReference(), ((BaseProduct)((Reservation)((BookingFile)destBookingFileEntityContainer.getEntity()).getReservations().get(0)).getProducts().get(0)).getUid());
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("failed cloning product for booking " + bookingFileEntityReference, t);
            throw new ServiceException("failed cloning product", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return result;
    }

    public BookingFileService.BookingFileRPCResult<BookingFile> cloneProductsForCorrection(ServiceInvocationContext ctx, List<String> srcProductsUID, EntityReference<BookingFile> bookingFileEntityReference, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-clone-products-for-correction");
        try {
            this.checkContext(ctx);
            ArrayList<Message> resultMessages = new ArrayList<Message>();
            EntityContainer destBookingFileEntityContainer = new EntityContainer(BookingFile.class);
            EntityContainer srcBookingFileContainer = EntityStorage.get().resolve(bookingFileEntityReference);
            HashMap<String, String> uidsMapping = new HashMap<String, String>();
            ArrayList<Message> errorList = new ArrayList<Message>();
            if (srcBookingFileContainer == null) {
                this.addContainerResolveErrorMessage(errorList, srcProductsUID.get(0));
            }
            if (errorList.isEmpty() && srcBookingFileContainer != null) {
                ((BookingFile)destBookingFileEntityContainer.getEntity()).setCreateDate(new Date());
                destBookingFileEntityContainer.getVersionInfo().setDataSource("fx-cloneProductsForCorrection");
                ((BookingFile)destBookingFileEntityContainer.getEntity()).setAgency(((BookingFile)srcBookingFileContainer.getEntity()).getAgency());
                ((BookingFile)destBookingFileEntityContainer.getEntity()).setCustomerProfile(((BookingFile)srcBookingFileContainer.getEntity()).getCustomerProfile());
                for (String productUid : srcProductsUID) {
                    BaseProduct srcProduct = BookingHelper.findProductByUid((String)productUid, (BookingFile)((BookingFile)srcBookingFileContainer.getEntity()));
                    if (srcProduct == null) {
                        BookingFileService.BookingFileRPCResult result;
                        this.addProductResolveErrorMessage(errorList, productUid);
                        resultMessages.addAll(errorList);
                        BookingFileService.BookingFileRPCResult bookingFileRPCResult = result = new BookingFileService.BookingFileRPCResult(resultMessages, null, null);
                        return bookingFileRPCResult;
                    }
                    BaseProduct clonedProduct = BookingHelper.findProductByUid((String)((String)uidsMapping.get(srcProduct.getUid())), (BookingFile)((BookingFile)destBookingFileEntityContainer.getEntity()));
                    if (clonedProduct != null) continue;
                    this.cloneProduct(srcProduct, (EntityContainer<BookingFile>)destBookingFileEntityContainer, targetClient, targetPayer, uidsMapping, resultMessages);
                    clonedProduct = BookingHelper.findProductByUid((String)((String)uidsMapping.get(srcProduct.getUid())), (BookingFile)((BookingFile)destBookingFileEntityContainer.getEntity()));
                    this.replaceTraveller(srcProduct, clonedProduct, uidsMapping);
                    BaseProduct nextProduct = ProductHandler.of((BaseProduct)srcProduct).getNextProduct(srcProduct);
                    BaseProduct previousProduct = ProductHandler.of((BaseProduct)srcProduct).getPreviousProduct(srcProduct);
                    while (nextProduct != null) {
                        BaseProduct clonedNextProduct = BookingHelper.findProductByUid((String)((String)uidsMapping.get(nextProduct.getUid())), (BookingFile)((BookingFile)destBookingFileEntityContainer.getEntity()));
                        if (clonedNextProduct == null) {
                            this.cloneProduct(nextProduct, (EntityContainer<BookingFile>)destBookingFileEntityContainer, targetClient, targetPayer, uidsMapping, resultMessages);
                            clonedNextProduct = BookingHelper.findProductByUid((String)((String)uidsMapping.get(nextProduct.getUid())), (BookingFile)((BookingFile)destBookingFileEntityContainer.getEntity()));
                            this.replaceTraveller(srcProduct, clonedProduct, uidsMapping);
                        }
                        ProductHandler.of((BaseProduct)clonedProduct).setNextProduct(clonedProduct, clonedNextProduct);
                        ProductHandler.of((BaseProduct)clonedNextProduct).setPreviousProduct(clonedNextProduct, clonedProduct);
                        nextProduct = ProductHandler.of((BaseProduct)srcProduct).getNextProduct(srcProduct);
                        clonedProduct = clonedNextProduct;
                    }
                    while (previousProduct != null) {
                        BaseProduct clonedPreviousProduct = BookingHelper.findProductByUid((String)((String)uidsMapping.get(previousProduct.getUid())), (BookingFile)((BookingFile)destBookingFileEntityContainer.getEntity()));
                        if (clonedPreviousProduct == null) {
                            this.cloneProduct(previousProduct, (EntityContainer<BookingFile>)destBookingFileEntityContainer, targetClient, targetPayer, uidsMapping, resultMessages);
                            clonedPreviousProduct = BookingHelper.findProductByUid((String)((String)uidsMapping.get(previousProduct.getUid())), (BookingFile)((BookingFile)destBookingFileEntityContainer.getEntity()));
                            this.replaceTraveller(srcProduct, clonedProduct, uidsMapping);
                        }
                        if (!srcProductsUID.contains(previousProduct.getUid())) {
                            ProductHandler.of((BaseProduct)clonedPreviousProduct).setTicketType(clonedPreviousProduct, TicketType.FAKE);
                        }
                        ProductHandler.of((BaseProduct)clonedProduct).setPreviousProduct(clonedProduct, clonedPreviousProduct);
                        ProductHandler.of((BaseProduct)clonedPreviousProduct).setNextProduct(clonedPreviousProduct, clonedProduct);
                        previousProduct = ProductHandler.of((BaseProduct)previousProduct).getPreviousProduct(previousProduct);
                        clonedProduct = clonedPreviousProduct;
                    }
                }
                for (BaseProduct baseProduct : BookingHelper.getProducts((BookingFile)((BookingFile)srcBookingFileContainer.getEntity()))) {
                    BaseProduct clonedProduct = BookingHelper.findProductByUid((String)((String)uidsMapping.get(baseProduct.getUid())), (BookingFile)((BookingFile)destBookingFileEntityContainer.getEntity()));
                    if (clonedProduct == null) continue;
                    List relatedProducts = ProductHandler.of((BaseProduct)baseProduct).getRelatedProducts(baseProduct);
                    for (BaseProduct relatedProduct : relatedProducts) {
                        BaseProduct clonedRelatedProduct = BookingHelper.findProductByUid((String)((String)uidsMapping.get(relatedProduct.getUid())), (BookingFile)((BookingFile)destBookingFileEntityContainer.getEntity()));
                        if (clonedRelatedProduct == null) continue;
                        ProductHandler.of((BaseProduct)clonedProduct).addRelatedProduct(clonedProduct, clonedRelatedProduct);
                    }
                }
                ((BookingFile)destBookingFileEntityContainer.getEntity()).getTravellers().addAll(((BookingFile)srcBookingFileContainer.getEntity()).getTravellers());
                ((BookingFile)destBookingFileEntityContainer.getEntity()).getTravellers().removeIf(traveller -> BookingHelper.getProducts((BookingFile)((BookingFile)destBookingFileEntityContainer.getEntity())).stream().flatMap(baseProduct -> ProductHandler.of((BaseProduct)baseProduct).getTravellers(baseProduct).stream()).noneMatch(targetTraveller -> targetTraveller.equals(traveller)));
                srcBookingFileContainer.getVersionInfo().setDataSource("change-ticket-type-to-correction");
                EntityStorage.get().save(srcBookingFileContainer, true);
                destBookingFileEntityContainer.getVersionInfo().setDataSource("clone-products-to-new-booking-file");
                EntityStorage.get().save(destBookingFileEntityContainer, true);
            }
            resultMessages.addAll(errorList);
            BookingFileService.BookingFileRPCResult result = new BookingFileService.BookingFileRPCResult(resultMessages, destBookingFileEntityContainer.toReference(), ((BaseProduct)((Reservation)((BookingFile)destBookingFileEntityContainer.getEntity()).getReservations().get(0)).getProducts().get(0)).getUid());
            BookingFileService.BookingFileRPCResult bookingFileRPCResult = result;
            return bookingFileRPCResult;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("failed cloning product for booking " + bookingFileEntityReference, t);
            throw new ServiceException("failed cloning product", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private void cloneProduct(BaseProduct srcProduct, EntityContainer<BookingFile> destBookingFileEntityContainer, EntityReference<Organization> targetClient, EntityReference<Organization> targetPayer, Map<String, String> uidsMapping, List<Message> resultMessages) {
        ProductFXHandler<BaseProduct> fxHandler = ProductFXHandlersRegistry.get().getForProduct(srcProduct);
        if (fxHandler != null) {
            List<Message> messages = fxHandler.cloneProductForCorrection(srcProduct, destBookingFileEntityContainer, targetClient, targetPayer, uidsMapping);
            resultMessages.addAll(messages);
        } else {
            resultMessages.addAll(BookingFileServiceImpl.getNoSuchHandlerMessage(srcProduct));
        }
    }

    private void replaceTraveller(BaseProduct srcProduct, BaseProduct clonedProduct, Map<String, String> uidsMapping) {
        for (Traveller oldTraveller : ProductHandler.of((BaseProduct)srcProduct).getTravellers(srcProduct)) {
            Optional<Traveller> optionalNewTraveller = ProductHandler.of((BaseProduct)clonedProduct).getTravellers(clonedProduct).stream().filter(traveller -> traveller.getUid().equals(uidsMapping.get(oldTraveller.getUid()))).findFirst();
            if (!optionalNewTraveller.isPresent()) continue;
            Traveller newTraveller = optionalNewTraveller.get();
            ProductHandler.of((BaseProduct)clonedProduct).replaceTraveller(clonedProduct, oldTraveller, newTraveller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getAvailablePayersUids(ServiceInvocationContext ctx, EntityReference<Organization> organization, boolean addRetailClient) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-getAvailablePayersUids");
        try {
            this.checkContext(ctx);
            Collection<String> collection = BookingFileHelper.getAvailablePayersUids((EntityContainer<Organization>)EntityStorage.get().resolve(organization), true);
            return collection;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> sellProduct(ServiceInvocationContext ctx, String prodUid, EntityReference<BookingFile> ref, String number) throws ServiceException {
        ArrayList<Message> result;
        block13: {
            DebugUtil.setThreadName((String)"BookingFileServiceImpl-sellProduct");
            result = new ArrayList<Message>();
            try {
                this.checkContext(ctx);
                EntityContainer ctr = EntityStorage.get().resolve(ref);
                if (ctr == null) {
                    result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Error resolving booking file container for product with UID: %s", prodUid), (Object[])new Object[0]));
                }
                if (!result.isEmpty()) break block13;
                BaseProduct product = BookingHelper.findProductByUid((String)prodUid, (BookingFile)((BookingFile)ctr.getEntity()));
                if (product == null) {
                    result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Error finding product in booking file with product UID: %s", prodUid), (Object[])new Object[0]));
                }
                if (result.isEmpty()) {
                    ProductFXHandler<BaseProduct> fxHandler = ProductFXHandlersRegistry.get().getForProduct(product);
                    if (fxHandler != null) {
                        this.checkSystemNumberUniqueness(product, number, result);
                        if (result.isEmpty()) {
                            result.addAll(fxHandler.sellProduct(product, number));
                        }
                    } else {
                        result.addAll(BookingFileServiceImpl.getNoSuchHandlerMessage(product));
                    }
                }
                if (result.isEmpty()) {
                    try {
                        ctr.getVersionInfo().setDataSource("fx-sellProduct");
                        EntityStorage.get().save(ctr, true);
                    }
                    catch (Exception e) {
                        result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"Error saving booking file", (Object[])new Object[0]));
                        this.updateErrorListWithXeption(result, e);
                    }
                }
                if (result.isEmpty()) {
                    result.add(Messages.getNotificationSaleSuccess((String)((BookingFile)ctr.getEntity()).getNumber()));
                }
            }
            finally {
                DebugUtil.restoreThreadName();
            }
        }
        return result;
    }

    private void checkSystemNumberUniqueness(BaseProduct product, String number, List<Message> result) {
        ProductCategory productCategory;
        Date issueDate;
        if (!(product instanceof Product)) {
            return;
        }
        ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)product);
        EntityReference blankOwner = handler.getBlankOwner(product);
        if (blankOwner == null) {
            return;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductSearchIndex.Property.blankOwner.name(), (Object)blankOwner));
        DictionaryReference blankType = handler.getBlankType(product);
        if (blankType != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductSearchIndex.Property.blankType.name(), (Object)blankType));
        }
        if ((issueDate = handler.findIssueDate(product)) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)ProductSearchIndex.Property.issueDate.name(), (Object)DateUtils.addYears((Date)issueDate, (int)-1)));
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)ProductSearchIndex.Property.issueDate.name(), (Object)DateUtils.addYears((Date)issueDate, (int)1)));
        }
        if ((productCategory = handler.getProductCategory(product)) != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductSearchIndex.Property.productCategory.name(), (Object)ProductCategory.AIR));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductSearchIndex.Property.systemNumber.name(), (Object)number));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductSearchIndex.Property.status.name(), (Object)ProductStatus.SELL));
        query.setResultMode(ResultMode.DATA_ONLY);
        SearchResult search = EntityStorage.get().search(ProductSearchIndex.class, query);
        if (!search.getData().isEmpty()) {
            result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u043a\u0430\u0437 {0} c \u043d\u043e\u043c\u0435\u0440\u043e\u043c \u0431\u0438\u043b\u0435\u0442\u0430 {1}", (Object[])new Object[]{((ProductSearchIndex)search.getData().get(0)).getSource(), number}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> unsellProduct(ServiceInvocationContext ctx, String prodUid, EntityReference<BookingFile> ref) throws ServiceException {
        ArrayList<Message> result;
        block12: {
            DebugUtil.setThreadName((String)"BookingFileServiceImpl-voidProduct");
            result = new ArrayList<Message>();
            try {
                this.checkContext(ctx);
                EntityContainer ctr = EntityStorage.get().resolve(ref);
                if (ctr == null) {
                    result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Error resolving booking file container for product with UID: %s", prodUid), (Object[])new Object[0]));
                }
                if (!result.isEmpty()) break block12;
                BaseProduct product = BookingHelper.findProductByUid((String)prodUid, (BookingFile)((BookingFile)ctr.getEntity()));
                if (product == null) {
                    result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Error finding product in booking file with product UID: %s", prodUid), (Object[])new Object[0]));
                }
                if (result.isEmpty()) {
                    ProductFXHandler<BaseProduct> fxHandler = ProductFXHandlersRegistry.get().getForProduct(product);
                    if (fxHandler != null) {
                        result.addAll(fxHandler.unsellProduct(product));
                    } else {
                        result.addAll(BookingFileServiceImpl.getNoSuchHandlerMessage(product));
                    }
                }
                if (result.isEmpty()) {
                    try {
                        ctr.getVersionInfo().setDataSource("fx-unsellProduct");
                        EntityStorage.get().save(ctr, true);
                    }
                    catch (Exception e) {
                        result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"Error saving booking file", (Object[])new Object[0]));
                        this.updateErrorListWithXeption(result, e);
                    }
                }
                if (result.isEmpty()) {
                    result.add(Messages.getNotificationCancelSuccess((String)((BookingFile)ctr.getEntity()).getNumber()));
                }
            }
            finally {
                DebugUtil.restoreThreadName();
            }
        }
        return result;
    }

    public List<Message> clearPassiveSegments(ServiceInvocationContext ctx, EntityReference<BookingFile> ref, String prodUid) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-voidProduct");
        ArrayList<Message> result = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            LockUtil.lock(ref, () -> {
                EntityContainer ctr = EntityStorage.get().resolve(ref);
                if (ctr == null) {
                    result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Error resolving booking file container for product with UID: %s", prodUid), (Object[])new Object[0]));
                } else {
                    BaseProduct product = BookingHelper.findProductByUid((String)prodUid, (BookingFile)((BookingFile)ctr.getEntity()));
                    if (product == null) {
                        result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Error finding product in booking file with product UID: %s", prodUid), (Object[])new Object[0]));
                    }
                    if (result.isEmpty()) {
                        product.setPassiveSegmentsCreationResult(null);
                        ctr.getVersionInfo().setDataSource("fx-clearPassiveSegments");
                        EntityStorage.get().save(ctr, true);
                    }
                }
            });
        }
        catch (InterruptedException | TimeoutException e) {
            throw new ServiceException((Throwable)e);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return result;
    }

    public List<Message> recalculateVAT(ServiceInvocationContext ctx, EntityReference<BookingFile> ref, String prodUid) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-recalculateVAT");
        ArrayList<Message> result = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            EntityContainer ctr = EntityStorage.get().resolve(ref);
            if (ctr == null) {
                result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Error resolving booking file container for product with UID: %s", prodUid), (Object[])new Object[0]));
            } else {
                Product product = (Product)BookingHelper.findProductByUid((String)prodUid, (BookingFile)((BookingFile)ctr.getEntity()));
                if (product == null) {
                    result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Error finding product in booking file with product UID: %s", prodUid), (Object[])new Object[0]));
                }
                if (result.isEmpty()) {
                    product.setVendorVatCalculated(false);
                    product.setTotalVendorEquivalentVatAmount(null);
                    EntityStorageThreadContext.execute(() -> {
                        ctr.getVersionInfo().setDataSource("fx-recalculateVAT");
                        EntityStorageThreadContext.setActionSource((EntityStorageThreadContext.ActionSource)EntityStorageThreadContext.ActionSource.MIDOFFICE_CLIENT_FX);
                        EntityStorage.get().save(ctr, true);
                    });
                }
            }
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MCOFeesSource> findMCOFeesSources(ServiceInvocationContext ctx, EntityReference<BookingFile> ref) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-findMCOFeesSources");
        ArrayList<MCOFeesSource> result = new ArrayList<MCOFeesSource>();
        try {
            this.checkContext(ctx);
            EntityContainer ctr = EntityStorage.get().resolve(ref);
            if (ctr != null) {
                ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(el -> el.getProducts().stream()).filter(el -> !(el instanceof MCOFees)).forEach(bp -> {
                    ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
                    if (handler.includeInFinanceDocuments(bp)) {
                        result.addAll(handler.getMcoFeesSources(bp));
                    }
                });
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SabreProfilesPccSettings> getSabreProfilesPccSettings(ServiceInvocationContext ctx, EntityReference<Person> ref) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-get-sabre-profiles-pcc-settings-create-pas-segments");
        try {
            SabrePassiveSegmentsConnectionSettings spcs;
            this.checkContext(ctx);
            ArrayList<SabreProfilesPccSettings> result = new ArrayList<SabreProfilesPccSettings>();
            EntityContainer userContainer = EntityStorage.get().resolve(ref);
            if (userContainer != null && userContainer.getEntity() != null) {
                result.addAll(((Person)userContainer.getEntity()).getSabrePassiveSegmentsAllowedPCCs());
            }
            if (result.isEmpty() && (spcs = SabrePassiveSegmentsUtil.getSabrePassiveSegmentsSettings()) != null) {
                result.addAll(spcs.getAllowedPCCs());
            }
            ArrayList<SabreProfilesPccSettings> arrayList = result;
            return arrayList;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<EntityReference<Organization>> getProductSubAgency(ServiceInvocationContext ctx, EntityReference<BookingFile> ref) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-get-product-subagency");
        try {
            this.checkContext(ctx);
            HashSet<EntityReference<Organization>> result = new HashSet<EntityReference<Organization>>();
            EntityContainer bfContainer = EntityStorage.get().resolve(ref);
            if (bfContainer == null) {
                HashSet<EntityReference<Organization>> hashSet = result;
                return hashSet;
            }
            ((BookingFile)bfContainer.getEntity()).getReservations().stream().flatMap(res -> res.getProducts().stream()).forEach(prod -> result.add(ProductFXHandlersRegistry.get().getForProduct((BaseProduct)prod).getSubAgency((BaseProduct)prod)));
            HashSet<EntityReference<Organization>> hashSet = result;
            return hashSet;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> validatePassiveSegmentsParameters(ServiceInvocationContext ctx, EntityReference<BookingFile> ref, SabrePassiveSegmentsSettings settings) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-validate-passive-segments-parameters");
        try {
            this.checkContext(ctx);
            List<Message> list = BookingFileServiceImpl.validatePassiveSegmentsParameters(settings, ref);
            return list;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private static List<Message> validatePassiveSegmentsParameters(SabrePassiveSegmentsSettings settings, EntityReference<BookingFile> ref) {
        ArrayList<Message> result = new ArrayList<Message>();
        EntityContainer bfContainer = EntityStorage.get().resolve(ref);
        if (bfContainer == null) {
            result.add(Messages.getExceptionFailedToLoadBaseEntity(ref));
            return result;
        }
        HashMap productMap = new HashMap();
        for (Reservation reservation : ((BookingFile)bfContainer.getEntity()).getReservations()) {
            for (BaseProduct bp : reservation.getProducts()) {
                if (!settings.getProductUids().contains(bp.getUid())) continue;
                ProductPassiveSegmentsHandler handler = HandlersRegistry.get().findProductPassiveSegmentsHandler(bp.getClass());
                if (!productMap.containsKey(handler)) {
                    productMap.put(handler, new ArrayList());
                }
                List list = (List)productMap.get(handler);
                list.add(bp);
            }
        }
        for (Map.Entry entry : productMap.entrySet()) {
            boolean validationResult = ((ProductPassiveSegmentsHandler)entry.getKey()).validateProducts((List)entry.getValue(), result);
            if (validationResult) continue;
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> voidProduct(ServiceInvocationContext ctx, Map<String, EntityReference<BookingFile>> productMap) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-voidProduct");
        ArrayList<Message> result = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            ArrayList errorList = new ArrayList();
            productMap.forEach((productUID, value) -> {
                BaseProduct productToVoid = null;
                EntityContainer ctr = EntityStorage.get().resolve(value);
                if (ctr == null) {
                    this.addContainerResolveErrorMessage(errorList, (String)productUID);
                }
                if (errorList.isEmpty() && ctr != null && (productToVoid = BookingHelper.findProductByUid((String)productUID, (BookingFile)((BookingFile)ctr.getEntity()))) == null) {
                    this.addProductResolveErrorMessage(errorList, (String)productUID);
                }
                if (errorList.isEmpty()) {
                    ProductFXHandler<Object> fxHandler = ProductFXHandlersRegistry.get().getForProduct(productToVoid);
                    if (fxHandler != null) {
                        List<Message> messages = fxHandler.voidProduct(productToVoid);
                        errorList.addAll(messages);
                    } else {
                        errorList.addAll(BookingFileServiceImpl.getNoSuchHandlerMessage(productToVoid));
                    }
                    try {
                        ctr.getVersionInfo().setDataSource("fx-voidProduct");
                        EntityStorage.get().save(ctr, true);
                    }
                    catch (Exception e) {
                        errorList.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"Error saving booking file", (Object[])new Object[0]));
                        this.updateErrorListWithXeption(errorList, e);
                    }
                }
                if (errorList.isEmpty() && ctr != null) {
                    String productName = BookingHelper.generateShortProductName((BaseProduct)productToVoid);
                    Message successMes = Messages.getNotificationSuccessfullyCancelled((String)productName, (String)((BookingFile)ctr.getEntity()).getNumber());
                    result.add(successMes);
                    BookingFileServiceImpl.audit(ctr.toReference(), "entity-modification", successMes, errorList);
                }
                result.addAll(errorList);
            });
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> unvoidBaseProduct(ServiceInvocationContext ctx, Map<String, EntityReference<BookingFile>> productMap) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-unvoidBaseProduct");
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            productMap.forEach((key, value) -> {
                ArrayList<Message> errorList = new ArrayList<Message>();
                EntityContainer ctr = EntityStorage.get().resolve(value);
                if (ctr == null) {
                    errorList.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Error resolving booking file container for product with UID: %s", key), (Object[])new Object[0]));
                }
                if (errorList.isEmpty()) {
                    BaseProduct productToUnvoid = BookingHelper.findProductByUid((String)key, (BookingFile)((BookingFile)ctr.getEntity()));
                    if (productToUnvoid == null) {
                        errorList.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Error finding product in booking file with product UID: %s", key), (Object[])new Object[0]));
                    }
                    if (errorList.isEmpty()) {
                        ProductFXHandler<BaseProduct> fxHandler = ProductFXHandlersRegistry.get().getForProduct(productToUnvoid);
                        if (fxHandler != null) {
                            errorList.addAll(fxHandler.unVoidProduct(productToUnvoid));
                        } else {
                            errorList.addAll(BookingFileServiceImpl.getNoSuchHandlerMessage(productToUnvoid));
                        }
                    }
                    if (errorList.isEmpty()) {
                        try {
                            ctr.getVersionInfo().setDataSource("fx-unvoidBaseProduct");
                            EntityStorage.get().save(ctr, true);
                        }
                        catch (Exception e) {
                            errorList.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"Error saving booking file", (Throwable)e, (Object[])new Object[0]));
                            this.updateErrorListWithXeption(errorList, e);
                        }
                    }
                    if (errorList.isEmpty()) {
                        messages.add(Messages.getNotificationSuccessfullyCancellationForOrder((String)((BookingFile)ctr.getEntity()).getNumber()));
                    }
                }
                messages.addAll(errorList);
            });
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> unvoidProduct(ServiceInvocationContext ctx, Map<String, EntityReference<BookingFile>> productMap) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-unvoidProduct");
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            productMap.forEach((key, value) -> {
                ArrayList<Message> errorList = new ArrayList<Message>();
                EntityContainer ctr = EntityStorage.get().resolve(value);
                if (ctr == null) {
                    errorList.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Error resolving booking file container for product with UID: %s", key), (Object[])new Object[0]));
                }
                if (errorList.isEmpty()) {
                    BaseProduct productToUnvoid = BookingHelper.findProductByUid((String)key, (BookingFile)((BookingFile)ctr.getEntity()));
                    if (productToUnvoid == null) {
                        errorList.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Error finding product in booking file with product UID: %s", key), (Object[])new Object[0]));
                    }
                    String productName = BookingHelper.generateShortProductName((BaseProduct)productToUnvoid);
                    if (errorList.isEmpty()) {
                        errorList.addAll(this.checkUnvoidableStatus(productToUnvoid));
                    }
                    if (errorList.isEmpty()) {
                        ProductFXHandler<BaseProduct> fxHandler = ProductFXHandlersRegistry.get().getForProduct(productToUnvoid);
                        if (fxHandler != null) {
                            errorList.addAll(fxHandler.unVoidProduct(productToUnvoid));
                        } else {
                            errorList.addAll(BookingFileServiceImpl.getNoSuchHandlerMessage(productToUnvoid));
                        }
                    }
                    if (errorList.isEmpty()) {
                        try {
                            ctr.getVersionInfo().setDataSource("fx-unvoidProduct");
                            EntityStorage.get().save(ctr, true);
                        }
                        catch (Exception e) {
                            errorList.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"Error saving booking file", (Object[])new Object[0]));
                            this.updateErrorListWithXeption(errorList, e);
                        }
                    }
                    if (errorList.isEmpty()) {
                        Message successMes = Messages.getNotificationSuccessfullyCancellationForOrderN((String)productName, (String)((BookingFile)ctr.getEntity()).getNumber());
                        messages.add(successMes);
                        BookingFileServiceImpl.audit(ctr.toReference(), "entity-modification", successMes, errorList);
                    }
                }
                messages.addAll(errorList);
            });
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> loadAppendixNumbers(ServiceInvocationContext ctx, EntityReference<BookingFile> bookingFileRef, String productUid, EntityReference<Contract> contractRef) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-load-appendix-numbers");
        List<String> result = new ArrayList<String>();
        try {
            this.checkContext(ctx);
            EntityContainer bookingFileContainer = EntityStorage.get().resolve(bookingFileRef);
            Product product = (Product)BookingHelper.findProductByUid((String)productUid, (BookingFile)((BookingFile)bookingFileContainer.getEntity()));
            Contract contract = (Contract)EntityStorage.get().resolve(contractRef).getEntity();
            if (product != null) {
                List<Segment> segments = product.getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream()).collect(Collectors.toList());
                DictionaryCache dictCache = DictionaryCache.get();
                LocalDate startDate = this.findMinDate(segments);
                LocalDate endDate = this.findMaxDate(segments);
                List contractAppendices = contract.getCustomers().stream().flatMap(info -> info.getAppendices().stream()).filter(a -> a instanceof SUBlockCharterAppendix).map(a -> (SUBlockCharterAppendix)a).collect(Collectors.toList());
                List depLocations = segments.stream().map(Segment::getDepartureLocation).map(arg_0 -> ((DictionaryCache)dictCache).resolveReference(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
                List arrLocations = segments.stream().map(Segment::getArriveLocation).map(arg_0 -> ((DictionaryCache)dictCache).resolveReference(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
                HashSet locations = new HashSet();
                locations.addAll(depLocations);
                locations.addAll(arrLocations);
                result = contractAppendices.stream().filter(a -> this.datesInRange((SUBlockCharterAppendix)a, startDate, endDate)).filter(a -> !TextUtil.isBlank((String)a.getItinerary())).filter(a -> this.containsLocation((SUBlockCharterAppendix)a, locations)).map(BaseContractAppendix::getNumber).collect(Collectors.toList());
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DictionaryReference<MetroLine> getMetroLine(ServiceInvocationContext ctx, DictionaryReference<MetroStation> metroStationDictionaryReference) throws ServiceException {
        DictionaryReference result;
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-get-metroLine");
        try {
            this.checkContext(ctx);
            MetroStation metroStation = (MetroStation)DictionaryCache.get().resolveReference(metroStationDictionaryReference);
            result = metroStation != null ? metroStation.getLine() : null;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BookingFileService.ProductFopsResult> getClientFops(ServiceInvocationContext ctx, EntityReference<BookingFile> bfReference, List<String> productUids) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-get-client-fops");
        try {
            this.checkContext(ctx);
            EntityContainer bfContainer = EntityStorage.get().resolve(bfReference);
            Objects.requireNonNull(bfContainer, () -> String.format("Booking file %s not found", bfReference));
            ArrayList<BookingFileService.ProductFopsResult> result = new ArrayList<BookingFileService.ProductFopsResult>();
            for (String productUid : productUids) {
                BaseProduct product = BookingHelper.findProduct((BookingFile)((BookingFile)bfContainer.getEntity()), (String)productUid);
                Objects.requireNonNull(product, () -> String.format("Product with uid %s not found in booking file %s", productUid, bfReference));
                List fops = GeneralProductHelper.getUnmodifiableFops((BaseProduct)product, (ContractType)ContractType.CLIENT);
                ProductStatus status = GeneralProductHelper.getStatus((BaseProduct)product);
                String productName = GeneralProductHelper.getHandler((BaseProduct)product).generateShortProductName(product);
                result.add(new BookingFileService.ProductFopsResult(productUid, productName, status, fops));
            }
            ArrayList<BookingFileService.ProductFopsResult> arrayList = result;
            return arrayList;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> recalculateFOP(ServiceInvocationContext ctx, Map<String, EntityReference<BookingFile>> productMap, ProductStatus[] appropriateStatusArray) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-recalculateFOP");
        ArrayList<Message> result = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            productMap.forEach((productUid, value) -> {
                ArrayList<Message> errorList = new ArrayList<Message>();
                BaseProduct product = null;
                EntityContainer ctr = EntityStorage.get().resolve(value);
                if (ctr == null) {
                    this.addBookingShouldBeSavedErrorMessage(errorList);
                }
                if (errorList.isEmpty() && ctr != null && (product = BookingHelper.findProductByUid((String)productUid, (BookingFile)((BookingFile)ctr.getEntity()))) == null) {
                    this.addProductResolveErrorMessage((Collection<Message>)errorList, (String)productUid);
                }
                if (errorList.isEmpty() && product != null) {
                    ProductFXHandler<BaseProduct> fxHandler = ProductFXHandlersRegistry.get().getForProduct(product);
                    if (fxHandler != null) {
                        List<Message> messages = fxHandler.recalculateFOP(product, appropriateStatusArray, (EntityContainer<BookingFile>)ctr);
                        errorList.addAll(messages);
                    } else {
                        errorList.addAll(BookingFileServiceImpl.getNoSuchHandlerMessage(product));
                    }
                }
                if (errorList.isEmpty() && product != null) {
                    result.add(Messages.getNotificationFopRecalculated((String)BookingHelper.generateShortProductName((BaseProduct)product), (String)product.getReservation().getBookingFile().getNumber()));
                }
                result.addAll(errorList);
            });
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookingFileService.ProductRPCResult exchangeProduct(ServiceInvocationContext ctx, String productUID, EntityReference<BookingFile> bookingFileReference, ProductExchangeRefundProperties exchangeProperties) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-exchangeProduct");
        ArrayList<Message> errorList = new ArrayList<Message>();
        String resultProductUid = null;
        try {
            this.checkContext(ctx);
            BaseProduct productToExchange = null;
            EntityContainer ctr = EntityStorage.get().resolve(bookingFileReference);
            if (ctr == null) {
                this.addContainerResolveErrorMessage(errorList, productUID);
            }
            if (errorList.isEmpty() && ctr != null && (productToExchange = BookingHelper.findProductByUid((String)productUID, (BookingFile)((BookingFile)ctr.getEntity()))) == null) {
                this.addProductResolveErrorMessage(errorList, productUID);
            }
            if (errorList.isEmpty()) {
                ProductFXHandler<Object> fxHandler = ProductFXHandlersRegistry.get().getForProduct(productToExchange);
                if (fxHandler != null) {
                    BookingFileService.ProductRPCResult res = fxHandler.exchangeProduct(productToExchange, (EntityContainer<BookingFile>)ctr, exchangeProperties);
                    resultProductUid = res.getResultProductUid();
                    errorList.addAll(res.getResultMessageList().stream().filter(msg -> msg.getType() == MessageType.ERROR).collect(Collectors.toList()));
                }
                try {
                    ctr.getVersionInfo().setDataSource("fx-exchangeProduct");
                    EntityStorage.get().save(ctr, true);
                }
                catch (Exception e) {
                    errorList.add(Messages.getExceptionSavingOrder((Throwable)e));
                    this.updateErrorListWithXeption(errorList, e);
                }
            }
            if (errorList.isEmpty() && ctr != null) {
                String productName = BookingHelper.generateShortProductName((BaseProduct)productToExchange);
                errorList.add(Messages.getNotificationSuccessfullyExchanged((String)productName, (String)((BookingFile)ctr.getEntity()).getNumber()));
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return new BookingFileService.ProductRPCResult(errorList, resultProductUid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookingFileService.ProductRPCResult exchangeProductToVoucher(ServiceInvocationContext ctx, String productUid, EntityReference<BookingFile> bookingFileReference, ProductExchangeRefundProperties exchangeProperties) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-exchangeProductToVoucher");
        ArrayList<Message> errorList = new ArrayList<Message>();
        String resultProductUid = null;
        try {
            this.checkContext(ctx);
            BaseProduct productToExchange = null;
            EntityContainer ctr = EntityStorage.get().resolve(bookingFileReference);
            if (ctr == null) {
                this.addContainerResolveErrorMessage(errorList, productUid);
            }
            if (errorList.isEmpty() && ctr != null && (productToExchange = BookingHelper.findProductByUid((String)productUid, (BookingFile)((BookingFile)ctr.getEntity()))) == null) {
                this.addProductResolveErrorMessage(errorList, productUid);
            }
            if (errorList.isEmpty()) {
                ProductFXHandler<Object> fxHandler = ProductFXHandlersRegistry.get().getForProduct(productToExchange);
                if (fxHandler != null) {
                    BookingFileService.ProductRPCResult res = fxHandler.exchangeProductToVoucher(productToExchange, (EntityContainer<BookingFile>)ctr, exchangeProperties);
                    resultProductUid = res.getResultProductUid();
                    errorList.addAll(res.getResultMessageList().stream().filter(msg -> msg.getType() == MessageType.ERROR).collect(Collectors.toList()));
                }
                try {
                    ctr.getVersionInfo().setDataSource("fx-exchangeProductToVoucher");
                    EntityStorage.get().save(ctr, true);
                }
                catch (Exception e) {
                    errorList.add(Messages.getExceptionSavingOrder((Throwable)e));
                    this.updateErrorListWithXeption(errorList, e);
                }
            }
            if (errorList.isEmpty() && ctr != null) {
                String productName = BookingHelper.generateShortProductName((BaseProduct)productToExchange);
                errorList.add(Messages.getNotificationSuccessfullyExchanged((String)productName, (String)((BookingFile)ctr.getEntity()).getNumber()));
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return new BookingFileService.ProductRPCResult(errorList, resultProductUid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookingFileService.ProductRPCResult refundProduct(ServiceInvocationContext ctx, String productUID, EntityReference<BookingFile> bookingFileReference, ProductExchangeRefundProperties refundProperties) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-refundProduct");
        ArrayList<Message> errorList = new ArrayList<Message>();
        String resultProductUid = null;
        try {
            BaseProduct productToRefund;
            this.checkContext(ctx);
            EntityContainer ctr = EntityStorage.get().resolve(bookingFileReference);
            if (ctr == null) {
                this.addContainerResolveErrorMessage(errorList, productUID);
            }
            BaseProduct baseProduct = productToRefund = errorList.isEmpty() && ctr != null ? BookingHelper.findProductByUid((String)productUID, (BookingFile)((BookingFile)ctr.getEntity())) : null;
            if (productToRefund == null) {
                this.addProductResolveErrorMessage(errorList, productUID);
            }
            if (errorList.isEmpty()) {
                ProductFXHandler<BaseProduct> fxHandler = ProductFXHandlersRegistry.get().getForProduct(productToRefund);
                if (fxHandler != null) {
                    BookingFileService.ProductRPCResult res = fxHandler.refundProduct(productToRefund, (EntityContainer<BookingFile>)ctr, refundProperties);
                    resultProductUid = res.getResultProductUid();
                    errorList.addAll(res.getResultMessageList().stream().filter(msg -> msg.getType() == MessageType.ERROR).collect(Collectors.toList()));
                    Optional.ofNullable(BookingHelper.findProductByUid((String)resultProductUid, (BookingFile)((BookingFile)ctr.getEntity()))).ifPresent(prod -> {
                        ((BaseProduct)prod).setSalesOriginProvider(productToRefund.getSalesOriginProvider());
                        ((BaseProduct)prod).setSalesOriginContent(productToRefund.getSalesOriginContent());
                    });
                }
                try {
                    ctr.getVersionInfo().setDataSource("fx-refundProduct");
                    EntityStorage.get().save(ctr, true);
                }
                catch (Exception e) {
                    errorList.add(Messages.getExceptionSavingOrder((Throwable)e));
                    this.updateErrorListWithXeption(errorList, e);
                }
            }
            if (errorList.isEmpty() && ctr != null) {
                String productName = BookingHelper.generateShortProductName((BaseProduct)productToRefund);
                errorList.add(Messages.getNotificationSuccessfullyReturned((String)productName, (String)((BookingFile)ctr.getEntity()).getNumber()));
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return new BookingFileService.ProductRPCResult(errorList, resultProductUid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookingFileService.ProductRPCResult addCertificateOfCompletedFlight(ServiceInvocationContext ctx, String productUID, EntityReference<BookingFile> bookingFileReference, List<String> usedSegments) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-addCertificateOfCompletedFlight");
        ArrayList<Message> errorList = new ArrayList<Message>();
        String resultProductUid = null;
        try {
            this.checkContext(ctx);
            EntityContainer ctr = EntityStorage.get().resolve(bookingFileReference);
            if (ctr == null) {
                this.addContainerResolveErrorMessage(errorList, productUID);
            }
            BaseProduct product = null;
            if (errorList.isEmpty() && ctr != null && (product = BookingHelper.findProductByUid((String)productUID, (BookingFile)((BookingFile)ctr.getEntity()))) == null) {
                this.addProductResolveErrorMessage(errorList, productUID);
            }
            if (errorList.isEmpty()) {
                ProductFXHandler<Object> fxHandler = ProductFXHandlersRegistry.get().getForProduct(product);
                BookingFileService.ProductRPCResult res = fxHandler.addCertificateOfCompletedFlight(product, usedSegments);
                resultProductUid = res.getResultProductUid();
                try {
                    ctr.getVersionInfo().setDataSource("fx-addCertificateOfCompletedFlight");
                    EntityStorage.get().save(ctr, true);
                }
                catch (Exception e) {
                    errorList.add(Messages.getExceptionSavingOrder((Throwable)e));
                    this.updateErrorListWithXeption(errorList, e);
                }
            }
            if (errorList.isEmpty() && ctr != null) {
                String productName = BookingHelper.generateShortProductName((BaseProduct)product);
                errorList.add(Messages.getNotificationSuccessfullyReturned((String)productName, (String)((BookingFile)ctr.getEntity()).getNumber()));
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return new BookingFileService.ProductRPCResult(errorList, resultProductUid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookingFileService.ProductRPCResult refundHotel(ServiceInvocationContext ctx, String prodUid, EntityReference<BookingFile> ref, HotelRefundSettings settings) {
        DebugUtil.setThreadName((String)"VipBookingFileServiceImpl-refundTransfer");
        ArrayList<Message> result = new ArrayList<Message>();
        try {
            Optional<BaseProduct> optProduct;
            this.checkContext(ctx);
            EntityContainer ctr = EntityStorage.get().resolve(ref);
            if (ctr == null) {
                result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"Error refunding Hotel", (Object[])new Object[0]));
                new BookingFileService.ProductRPCResult(result, null);
            }
            if (!(optProduct = ((BookingFile)ctr.getEntity()).getReservations().stream().flatMap(el -> el.getProducts().stream()).filter(el -> TextUtil.isSame((String)el.getUid(), (String)prodUid)).findFirst()).isPresent()) {
                result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"Error refunding Hotel", (Object[])new Object[0]));
                BookingFileService.ProductRPCResult productRPCResult = new BookingFileService.ProductRPCResult(result, null);
                return productRPCResult;
            }
            HotelProduct product = (HotelProduct)optProduct.get();
            if (product.getStatus() != ProductStatus.SELL || product.getNextProduct() != null) {
                result.add(Messages.getExceptionImmposibleToReturnTicket());
                BookingFileService.ProductRPCResult productRPCResult = new BookingFileService.ProductRPCResult(result, null);
                return productRPCResult;
            }
            BookingFileService.ProductRPCResult res = this.refundHotelHelper(product, settings);
            if (!ValidationUtil.hasErrors(result)) {
                try {
                    ctr.getVersionInfo().setDataSource("fx-refundHotel");
                    EntityStorage.get().save(ctr, true);
                }
                catch (Exception e) {
                    result.add(Messages.getExceptionSaveReservationFile((Throwable)e));
                    this.updateErrorListWithXeption(result, e);
                }
            }
        }
        catch (Exception e) {
            result.add(Messages.getExceptionImmposibleToReturnTicket());
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return new BookingFileService.ProductRPCResult(result, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookingFileService.ItineraryReceiptRPCResult createAirItineraryReceipts(ServiceInvocationContext ctx, AirItineraryReceiptProperties properties) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-createItineraryReceipts");
        ArrayList<FilledTemplateDocument> result = new ArrayList<FilledTemplateDocument>();
        ArrayList<Message> errorList = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            HashMap<EntityReference, EntityContainer> ref2ctr = new HashMap<EntityReference, EntityContainer>();
            Map<String, Collection> productUids2TemplateCtrs = properties.getProductsWithTemplates().entrySet().stream().map(entry -> {
                List templateCtrs = ((Collection)entry.getValue()).stream().map(templateRef -> {
                    EntityContainer templateCtr = EntityStorage.get().resolve(templateRef);
                    if (templateCtr == null) {
                        errorList.add(Messages.getExceptionNotFindTemplate((EntityReference)templateRef));
                    }
                    return templateCtr;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                return new AbstractMap.SimpleEntry(entry.getKey(), templateCtrs);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            ArrayList<InformationNote> notes = new ArrayList<InformationNote>();
            for (DictionaryReference dictionaryReference : properties.getNotes()) {
                InformationNote note = (InformationNote)DictionaryCache.get().resolveReference(dictionaryReference);
                if (note != null) {
                    notes.add(note);
                    continue;
                }
                errorList.add(Messages.getExceptionNotFindElement((DictionaryReference)dictionaryReference));
            }
            for (Map.Entry entry2 : properties.getProductsWithBookings().entrySet()) {
                String productUid = (String)entry2.getKey();
                Collection templateCtrs = productUids2TemplateCtrs.get(productUid);
                EntityReference bfRef = (EntityReference)entry2.getValue();
                EntityContainer bfCont = ref2ctr.computeIfAbsent(bfRef, k -> EntityStorage.get().resolve(bfRef));
                Product product = (Product)BookingHelper.findProductByUid((String)productUid, (BookingFile)((BookingFile)bfCont.getEntity()));
                if (product == null) {
                    this.addProductResolveErrorMessage(errorList, productUid);
                }
                if (product == null) continue;
                if (product.getTraveller() == null) {
                    errorList.add(Messages.getErrorFormingItineraryNoTraveller((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                    continue;
                }
                for (EntityContainer templateCtr : templateCtrs) {
                    try {
                        result.add(new ItineraryReceiptRender().renderReport(bfCont, product, templateCtr, notes, properties.isITTariff(), properties.isUseCyrilicForTravelerName(), properties.isIncludePayer(), properties.isIncludeVat(), properties.isIncludeLogo(), properties.isIncludeAgencyFees(), properties.isIncludeAgencyFeesIntoTaxes(), properties.isIncludeVendorFees(), properties.isIncludeVendorFeesIntoTaxes(), properties.isShowTaxesSum(), properties.isIncludeVatDetalization(), properties.isHidePassport()));
                        errorList.add(Messages.getNotificationItineraryGenerated((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                        BookingFileServiceImpl.audit(bfRef, "entity-modification", Messages.getNotificationItineraryCreated((String)BookingHelper.generateShortProductName((BaseProduct)product)), errorList);
                    }
                    catch (Exception e) {
                        this.log.error(String.format("unable to render itinerary for %s of booking %s", product.getSystemNumber(), bfRef), (Throwable)e);
                        errorList.add(Messages.getExceptionFormingItinerary((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                    }
                }
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return new BookingFileService.ItineraryReceiptRPCResult(errorList, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookingFileService.ItineraryReceiptRPCResult createRailwayItineraryReceipts(ServiceInvocationContext ctx, RailwayItineraryReceiptProperties properties) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-createRailwayItineraryReceipts");
        ArrayList<FilledTemplateDocument> result = new ArrayList<FilledTemplateDocument>();
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            HashMap<EntityReference, EntityContainer> ref2ctr = new HashMap<EntityReference, EntityContainer>();
            Map<String, Collection> productUids2TemplateCtrs = properties.getProductsWithTemplates().entrySet().stream().map(entry -> {
                List templateCtrs = ((Collection)entry.getValue()).stream().map(templateRef -> {
                    EntityContainer templateCtr = EntityStorage.get().resolve(templateRef);
                    if (templateCtr == null) {
                        messages.add(Messages.getExceptionNotFindTemplate((EntityReference)templateRef));
                    }
                    return templateCtr;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                return new AbstractMap.SimpleEntry(entry.getKey(), templateCtrs);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            ArrayList<InformationNote> notes = new ArrayList<InformationNote>();
            for (DictionaryReference dictionaryReference : properties.getNotes()) {
                InformationNote note = (InformationNote)DictionaryCache.get().resolveReference(dictionaryReference);
                if (note != null) {
                    notes.add(note);
                    continue;
                }
                messages.add(Messages.getExceptionNotFindElement((DictionaryReference)dictionaryReference));
            }
            for (Map.Entry entry2 : properties.getProductsWithBookings().entrySet()) {
                String productUid = (String)entry2.getKey();
                Collection templateCtrs = productUids2TemplateCtrs.get(productUid);
                EntityReference bfRef = (EntityReference)entry2.getValue();
                EntityContainer bfCont = ref2ctr.computeIfAbsent(bfRef, k -> EntityStorage.get().resolve(bfRef));
                RailwayProduct product = (RailwayProduct)BookingHelper.findProductByUid((String)productUid, (BookingFile)((BookingFile)bfCont.getEntity()));
                if (product == null) {
                    this.addProductResolveErrorMessage(messages, productUid);
                }
                if (product == null) continue;
                if (product.getPassengers().isEmpty()) {
                    messages.add(Messages.getErrorFormingItineraryNoTraveller((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                    continue;
                }
                for (EntityContainer templateCtr : templateCtrs) {
                    try {
                        result.add(new RailwayItineraryReceiptRender().renderReport(bfCont, product, templateCtr, notes));
                        messages.add(Messages.getNotificationItineraryGenerated((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                        BookingFileServiceImpl.audit(bfRef, "entity-modification", Messages.getNotificationItineraryCreated((String)BookingHelper.generateShortProductName((BaseProduct)product)), messages);
                    }
                    catch (Exception e) {
                        this.log.error(String.format("unable to render itinerary for %s of booking %s", product.getSystemNumber(), bfRef), (Throwable)e);
                        messages.add(Messages.getExceptionFormingItinerary((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                    }
                }
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return new BookingFileService.ItineraryReceiptRPCResult(messages, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookingFileService.ItineraryReceiptRPCResult createTransferItineraryReceipts(ServiceInvocationContext ctx, TransferItineraryReceiptProperties properties) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-createTransferItineraryReceipts");
        ArrayList<FilledTemplateDocument> result = new ArrayList<FilledTemplateDocument>();
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            HashMap<EntityReference, EntityContainer> ref2ctr = new HashMap<EntityReference, EntityContainer>();
            Map<String, Collection> productUids2TemplateCtrs = properties.getProductsWithTemplates().entrySet().stream().map(entry -> {
                List templateCtrs = ((Collection)entry.getValue()).stream().map(templateRef -> {
                    EntityContainer templateCtr = EntityStorage.get().resolve(templateRef);
                    if (templateCtr == null) {
                        messages.add(Messages.getExceptionNotFindTemplate((EntityReference)templateRef));
                    }
                    return templateCtr;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                return new AbstractMap.SimpleEntry(entry.getKey(), templateCtrs);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            ArrayList<InformationNote> notes = new ArrayList<InformationNote>();
            for (DictionaryReference dictionaryReference : properties.getNotes()) {
                InformationNote note = (InformationNote)DictionaryCache.get().resolveReference(dictionaryReference);
                if (note != null) {
                    notes.add(note);
                    continue;
                }
                messages.add(Messages.getExceptionNotFindElement((DictionaryReference)dictionaryReference));
            }
            for (Map.Entry entry2 : properties.getProductsWithBookings().entrySet()) {
                String productUid = (String)entry2.getKey();
                Collection templateCtrs = productUids2TemplateCtrs.get(productUid);
                EntityReference bfRef = (EntityReference)entry2.getValue();
                EntityContainer bfCont = ref2ctr.computeIfAbsent(bfRef, k -> EntityStorage.get().resolve(bfRef));
                Transfer product = (Transfer)BookingHelper.findProductByUid((String)productUid, (BookingFile)((BookingFile)bfCont.getEntity()));
                if (product == null) {
                    this.addProductResolveErrorMessage(messages, productUid);
                }
                if (product == null) continue;
                if (product.getTravellers().isEmpty()) {
                    messages.add(Messages.getErrorFormingItineraryNoTraveller((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                    continue;
                }
                for (EntityContainer templateCtr : templateCtrs) {
                    try {
                        result.add(new TransferItineraryReceiptRender().renderReport(bfCont, product, templateCtr, notes));
                        messages.add(Messages.getNotificationItineraryGenerated((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                        BookingFileServiceImpl.audit(bfRef, "entity-modification", Messages.getNotificationItineraryCreated((String)BookingHelper.generateShortProductName((BaseProduct)product)), messages);
                    }
                    catch (Exception e) {
                        this.log.error(String.format("unable to render itinerary for %s of booking %s", product.getSystemNumber(), bfRef), (Throwable)e);
                        messages.add(Messages.getExceptionFormingItinerary((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                    }
                }
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return new BookingFileService.ItineraryReceiptRPCResult(messages, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookingFileService.ItineraryReceiptRPCResult createAeroexpressItineraryReceipts(ServiceInvocationContext ctx, AeroexpressItineraryReceiptProperties properties) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-createAeroexpressItineraryReceipts");
        ArrayList<FilledTemplateDocument> result = new ArrayList<FilledTemplateDocument>();
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            HashMap<EntityReference, EntityContainer> ref2ctr = new HashMap<EntityReference, EntityContainer>();
            Map<String, Collection> productUids2TemplateCtrs = properties.getProductsWithTemplates().entrySet().stream().map(entry -> {
                List templateCtrs = ((Collection)entry.getValue()).stream().map(templateRef -> {
                    EntityContainer templateCtr = EntityStorage.get().resolve(templateRef);
                    if (templateCtr == null) {
                        messages.add(Messages.getExceptionNotFindTemplate((EntityReference)templateRef));
                    }
                    return templateCtr;
                }).filter(Objects::nonNull).collect(Collectors.toList());
                return new AbstractMap.SimpleEntry(entry.getKey(), templateCtrs);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            ArrayList<InformationNote> notes = new ArrayList<InformationNote>();
            for (DictionaryReference dictionaryReference : properties.getNotes()) {
                InformationNote note = (InformationNote)DictionaryCache.get().resolveReference(dictionaryReference);
                if (note != null) {
                    notes.add(note);
                    continue;
                }
                messages.add(Messages.getExceptionNotFindElement((DictionaryReference)dictionaryReference));
            }
            for (Map.Entry entry2 : properties.getProductsWithBookings().entrySet()) {
                String productUid = (String)entry2.getKey();
                Collection templateCtrs = productUids2TemplateCtrs.get(productUid);
                EntityReference bfRef = (EntityReference)entry2.getValue();
                EntityContainer bfCont = ref2ctr.computeIfAbsent(bfRef, k -> EntityStorage.get().resolve(bfRef));
                AeroexpressTicket product = (AeroexpressTicket)BookingHelper.findProductByUid((String)productUid, (BookingFile)((BookingFile)bfCont.getEntity()));
                if (product == null) {
                    this.addProductResolveErrorMessage(messages, productUid);
                }
                if (product == null) continue;
                if (product.getTraveller() == null) {
                    messages.add(Messages.getErrorFormingItineraryNoTraveller((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                    continue;
                }
                for (EntityContainer templateCtr : templateCtrs) {
                    try {
                        result.add(new AeroexpressReceiptRender().renderReport(bfCont, product, templateCtr, notes));
                        messages.add(Messages.getNotificationItineraryGenerated((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                        BookingFileServiceImpl.audit(bfRef, "entity-modification", Messages.getNotificationItineraryCreated((String)BookingHelper.generateShortProductName((BaseProduct)product)), messages);
                    }
                    catch (Exception e) {
                        this.log.error(String.format("unable to render itinerary for %s of booking %s", product.getSystemNumber(), bfRef), (Throwable)e);
                        messages.add(Messages.getExceptionFormingItinerary((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                    }
                }
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return new BookingFileService.ItineraryReceiptRPCResult(messages, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookingFileService.ItineraryReceiptRPCResult createCertificateOfCompletedFlight(ServiceInvocationContext ctx, CertificateOfCompletedFlightProperties properties) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-createCertificateOfCompletedFlight");
        ArrayList result = new ArrayList();
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            HashMap<EntityReference, EntityContainer> ref2ctr = new HashMap<EntityReference, EntityContainer>();
            Collection templateCtrs = properties.getTemplateRefs().stream().map(templateRef -> {
                EntityContainer templateCtr = EntityStorage.get().resolve(templateRef);
                if (templateCtr == null) {
                    messages.add(Messages.getExceptionNotFindTemplate((EntityReference)templateRef));
                }
                return templateCtr;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            Boolean useFacsimile = properties.isUseFacsimile();
            ArrayList<InformationNote> notes = new ArrayList<InformationNote>();
            for (DictionaryReference dictionaryReference : properties.getNotes()) {
                InformationNote note = (InformationNote)DictionaryCache.get().resolveReference(dictionaryReference);
                if (note != null) {
                    notes.add(note);
                    continue;
                }
                messages.add(Messages.getExceptionNotFindElement((DictionaryReference)dictionaryReference));
            }
            for (Map.Entry entry : properties.getProductsWithBookings().entrySet()) {
                EntityReference bfRef;
                EntityContainer bfCont;
                String productUid = (String)entry.getKey();
                AdditionalServiceProduct product = (AdditionalServiceProduct)BookingHelper.findProductByUid((String)productUid, (BookingFile)((BookingFile)(bfCont = ref2ctr.computeIfAbsent(bfRef = (EntityReference)entry.getValue(), k -> EntityStorage.get().resolve(bfRef))).getEntity()));
                if (product == null) {
                    this.addProductResolveErrorMessage(messages, productUid);
                }
                if (product == null) continue;
                if (CollectionUtil.head((Iterable)product.getTravellers()) == null) {
                    messages.add(Messages.getErrorFormingItineraryNoTraveller((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                    continue;
                }
                try {
                    result.addAll(new CertificateOfCompletedFlightRender().renderReports(bfCont, product, templateCtrs, useFacsimile, properties.getSignatures()));
                    messages.add(Messages.getNotificationCertificateOfCompletedFlightGenerated((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                    BookingFileServiceImpl.audit(bfRef, "entity-modification", Messages.getNotificationCertificateOfCompletedFlightCreated((String)BookingHelper.generateShortProductName((BaseProduct)product)), messages);
                }
                catch (Exception e) {
                    this.log.error(String.format("unable to render certificate of completed flight for %s of booking %s", product.getSystemNumber(), bfRef), (Throwable)e);
                    messages.add(Messages.getExceptionFormingCertificateOfCompletedFlight((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                }
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return new BookingFileService.ItineraryReceiptRPCResult(messages, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookingFileService.RefundReceiptRPCResult createAirRefundReceipts(ServiceInvocationContext ctx, AirRefundReceiptProperties properties) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-createRefundReceipts");
        ArrayList<FilledTemplateDocument> result = new ArrayList<FilledTemplateDocument>();
        ArrayList<Message> errorList = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            HashMap<EntityReference, EntityContainer> ref2ctr = new HashMap<EntityReference, EntityContainer>();
            Collection templateCtrs = properties.getTemplateRefs().stream().map(templateRef -> {
                EntityContainer templateCtr = EntityStorage.get().resolve(templateRef);
                if (templateCtr == null) {
                    errorList.add(Messages.getExceptionNotFindTemplate((EntityReference)templateRef));
                }
                return templateCtr;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            for (EntityContainer templateCtr : templateCtrs) {
                ArrayList<InformationNote> notes = new ArrayList<InformationNote>();
                for (DictionaryReference dictionaryReference : properties.getNotes()) {
                    InformationNote note = (InformationNote)DictionaryCache.get().resolveReference(dictionaryReference);
                    if (note != null) {
                        notes.add(note);
                        continue;
                    }
                    errorList.add(Messages.getExceptionNotFindElement((DictionaryReference)dictionaryReference));
                }
                for (Map.Entry entry : properties.getProductsWithBookings().entrySet()) {
                    EntityReference bfRef;
                    EntityContainer bfCont;
                    String productUid = (String)entry.getKey();
                    Product product = (Product)BookingHelper.findProductByUid((String)productUid, (BookingFile)((BookingFile)(bfCont = ref2ctr.computeIfAbsent(bfRef = (EntityReference)entry.getValue(), k -> EntityStorage.get().resolve(bfRef))).getEntity()));
                    if (product == null) {
                        this.addProductResolveErrorMessage(errorList, productUid);
                    }
                    if (product == null) continue;
                    try {
                        result.add(new RefundReceiptRender().renderReport(bfCont, product, templateCtr, notes, properties.isITTariff(), properties.isUseCyrilicForTravelerName(), properties.isIncludePayer(), properties.isIncludeVat(), properties.isIncludeAgencyFees(), properties.isIncludeAgencyFeesIntoTaxes(), properties.isIncludeVendorFees(), properties.isIncludeVendorFeesIntoTaxes(), properties.isShowTaxesSum(), properties.isIncludeVatDetalization(), properties.isHidePassport()));
                        errorList.add(Messages.getNotificationRefundGenerated((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                        BookingFileServiceImpl.audit(bfRef, "entity-modification", Messages.getNotificationRefundCreated((String)BookingHelper.generateShortProductName((BaseProduct)product)), errorList);
                    }
                    catch (Exception e) {
                        this.log.error(String.format("unable to render refund receipt for %s of booking %s", product.getSystemNumber(), bfRef), (Throwable)e);
                        errorList.add(Messages.getExceptionFormingRefund((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                    }
                }
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return new BookingFileService.RefundReceiptRPCResult(errorList, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookingFileService.RefundReceiptRPCResult createRailwayRefundReceipts(ServiceInvocationContext ctx, RailwayRefundReceiptProperties properties) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-createRefundReceipts");
        ArrayList<FilledTemplateDocument> result = new ArrayList<FilledTemplateDocument>();
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            HashMap<EntityReference, EntityContainer> ref2ctr = new HashMap<EntityReference, EntityContainer>();
            Collection templateCtrs = properties.getTemplateRefs().stream().map(templateRef -> {
                EntityContainer templateCtr = EntityStorage.get().resolve(templateRef);
                if (templateCtr == null) {
                    messages.add(Messages.getExceptionNotFindTemplate((EntityReference)templateRef));
                }
                return templateCtr;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            for (EntityContainer templateCtr : templateCtrs) {
                ArrayList<InformationNote> notes = new ArrayList<InformationNote>();
                for (DictionaryReference dictionaryReference : properties.getNotes()) {
                    InformationNote note = (InformationNote)DictionaryCache.get().resolveReference(dictionaryReference);
                    if (note != null) {
                        notes.add(note);
                        continue;
                    }
                    messages.add(Messages.getExceptionNotFindElement((DictionaryReference)dictionaryReference));
                }
                for (Map.Entry entry : properties.getProductsWithBookings().entrySet()) {
                    EntityReference bfRef;
                    EntityContainer bfCont;
                    String productUid = (String)entry.getKey();
                    RailwayProduct product = (RailwayProduct)BookingHelper.findProductByUid((String)productUid, (BookingFile)((BookingFile)(bfCont = ref2ctr.computeIfAbsent(bfRef = (EntityReference)entry.getValue(), k -> EntityStorage.get().resolve(bfRef))).getEntity()));
                    if (product == null) {
                        this.addProductResolveErrorMessage(messages, productUid);
                    }
                    if (product == null) continue;
                    try {
                        result.add(new RailwayRefundReceiptRender().renderReport(bfCont, product, templateCtr, notes));
                        messages.add(Messages.getNotificationRefundGenerated((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                        BookingFileServiceImpl.audit(bfRef, "entity-modification", Messages.getNotificationRefundCreated((String)BookingHelper.generateShortProductName((BaseProduct)product)), messages);
                    }
                    catch (Exception e) {
                        this.log.error(String.format("unable to render refund receipt for %s of booking %s", product.getSystemNumber(), bfRef), (Throwable)e);
                        messages.add(Messages.getExceptionFormingRefund((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                    }
                }
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return new BookingFileService.RefundReceiptRPCResult(messages, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<BaseProduct, EntityReference<BookingFile>> getProductsForItineraryAndRefundReceipt(ServiceInvocationContext ctx, Map<String, EntityReference<BookingFile>> productMap) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-getProductsForItineraryAndRefundReceipt");
        HashMap<BaseProduct, EntityReference<BookingFile>> result = new HashMap<BaseProduct, EntityReference<BookingFile>>();
        try {
            this.checkContext(ctx);
            HashMap<EntityReference, EntityContainer> bfRef2Cont = new HashMap<EntityReference, EntityContainer>();
            for (Map.Entry<String, EntityReference<BookingFile>> entry : productMap.entrySet()) {
                EntityReference<BookingFile> bfRef = entry.getValue();
                EntityContainer bfCont = bfRef2Cont.computeIfAbsent(bfRef, k -> EntityStorage.get().resolve(bfRef));
                BaseProduct prod = BookingHelper.findProductByUid((String)entry.getKey(), (BookingFile)((BookingFile)bfCont.getEntity()));
                if (prod == null) continue;
                result.put(prod, bfRef);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookingFileService.VoucherRPCResult createVoucher(ServiceInvocationContext ctx, VoucherProperties properties) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-createVoucher");
        ArrayList<FilledTemplateDocument> result = new ArrayList<FilledTemplateDocument>();
        ArrayList<Message> errorList = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            HashMap<EntityReference, EntityContainer> ref2ctr = new HashMap<EntityReference, EntityContainer>();
            List templateCtrs = properties.getTemplateRefs().stream().map(templateRef -> {
                EntityContainer templateCtr = EntityStorage.get().resolve(templateRef);
                if (templateCtr == null) {
                    errorList.add(Messages.getExceptionNotFindVoucherTemplate((EntityReference)templateRef));
                }
                return templateCtr;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            ArrayList<InformationNote> notes = new ArrayList<InformationNote>();
            for (DictionaryReference dictionaryReference : properties.getNotes()) {
                InformationNote note = (InformationNote)DictionaryCache.get().resolveReference(dictionaryReference);
                if (note != null) {
                    notes.add(note);
                    continue;
                }
                errorList.add(Messages.getExceptionNotFindElement((DictionaryReference)dictionaryReference));
            }
            for (Map.Entry entry : properties.getProductUids2BookingFileRefs().entrySet()) {
                EntityReference bfRef;
                EntityContainer bfCont;
                String productUid = (String)entry.getKey();
                HotelProduct product = (HotelProduct)BookingHelper.findProductByUid((String)productUid, (BookingFile)((BookingFile)(bfCont = ref2ctr.computeIfAbsent(bfRef = (EntityReference)entry.getValue(), k -> EntityStorage.get().resolve(bfRef))).getEntity()));
                if (product == null) {
                    this.addProductResolveErrorMessage(errorList, productUid);
                }
                if (product == null) continue;
                for (EntityContainer templateCtr : templateCtrs) {
                    try {
                        result.add(new VoucherRender().renderReport(bfCont, product, templateCtr, properties.getAgencyContacts(), notes, properties.isHidePrice(), properties.isHideMeal(), properties.isHideBasicEssentialInfo(), properties.isHideAmenities(), properties.isIncludeFeesInTotalPrice()));
                        errorList.add(Messages.getNotificationVoucherGenerated((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                        BookingFileServiceImpl.audit(bfRef, "entity-modification", Messages.getNotificationVoucherCreated((String)BookingHelper.generateShortProductName((BaseProduct)product)), errorList);
                    }
                    catch (Exception e) {
                        errorList.add(Messages.getExceptionFormingVoucher((String)product.getSystemNumber(), (String)bfRef.getCaption()));
                    }
                }
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return new BookingFileService.VoucherRPCResult(errorList, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> sendMailDocument(ServiceInvocationContext ctx, EntityReference<MailDocument> ref) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-sendMailDocument");
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            EntityContainer doc = EntityStorage.get().resolve(ref);
            if (doc.getEntity() != null) {
                ((MailSender)Environment.getPublished(MailSender.class)).send((MailDocument)doc.getEntity());
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return messages;
    }

    private void addBookingShouldBeSavedErrorMessage(Collection<Message> errorList) {
        errorList.add(Messages.getUpdateOfUnsavedBookingFileErrorMessage());
    }

    private void addContainerResolveErrorMessage(Collection<Message> errorList, String productUID) {
        errorList.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Error resolving booking file container for product with UID: %s", productUID), (Object[])new Object[0]));
    }

    private void addContainerResolveErrorMessage(Collection<Message> errorList) {
        errorList.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"Error resolving booking file container", (Object[])new Object[0]));
    }

    private void addProductResolveErrorMessage(Collection<Message> errorList, String productUID) {
        errorList.add(Messages.getExceptionCannotFindProductInDB((String)productUID));
    }

    private Collection<? extends Message> checkUnvoidableStatus(BaseProduct productToUnvoid) {
        BaseTicketProduct ticketProduct;
        ArrayList<Message> errorList = new ArrayList<Message>();
        String productName = BookingHelper.generateShortProductName((BaseProduct)productToUnvoid);
        if (productToUnvoid instanceof BaseTicketProduct && (ticketProduct = (BaseTicketProduct)productToUnvoid).getStatus() != ProductStatus.VOID_BOOKING && ticketProduct.getStatus() != ProductStatus.VOID) {
            errorList.add(Messages.getWarningProductStatusOther((String)productName, (ProductStatus)ProductStatus.VOID_BOOKING, (ProductStatus)ProductStatus.VOID));
        }
        return errorList;
    }

    private LocalDate findMinDate(List<Segment> segments) {
        return !segments.isEmpty() ? segments.stream().filter(segment -> segment.getStartDate() != null).map(segment -> DateUtil.asLocalDate(segment.getStartDate())).reduce(DateUtil.asLocalDate(segments.get(0).getStartDate()), (date1, date2) -> date1.isBefore((ChronoLocalDate)date2) ? date1 : date2) : null;
    }

    private LocalDate findMaxDate(List<Segment> segments) {
        return !segments.isEmpty() ? segments.stream().filter(segment -> segment.getStartDate() != null).map(segment -> DateUtil.asLocalDate(segment.getStartDate())).reduce(DateUtil.asLocalDate(segments.get(0).getStartDate()), (date1, date2) -> date1.isAfter((ChronoLocalDate)date2) ? date1 : date2) : null;
    }

    private boolean datesInRange(SUBlockCharterAppendix appendix, ChronoLocalDate startDate, ChronoLocalDate endDate) {
        LocalDate appendixEndDate;
        if (startDate != null && appendix.getEndDate() != null && (appendixEndDate = DateUtil.asLocalDate(appendix.getEndDate())).isBefore(startDate)) {
            return false;
        }
        if (endDate != null && appendix.getStartDate() != null) {
            LocalDate appendixStartDate = DateUtil.asLocalDate(appendix.getStartDate());
            return !appendixStartDate.isAfter(endDate);
        }
        return true;
    }

    private boolean containsLocation(SUBlockCharterAppendix appendix, Collection<GeoLocation> locations) {
        return Stream.concat(locations.stream().flatMap(geoLocation -> geoLocation.getCodeVariants().values().stream()), locations.stream().map(BaseDictionary::getCode)).anyMatch(code -> appendix.getItinerary().contains((CharSequence)code));
    }

    private Collection<Message> applyRules(EntityReference<BookingFile> bookingFileReference) {
        ArrayList<Message> result = new ArrayList<Message>();
        List<Message> errorList = this.performChecksRules(bookingFileReference);
        EntityContainer ctr = EntityStorage.get().resolve(bookingFileReference);
        if (ctr == null) {
            this.addContainerResolveErrorMessage(errorList);
        }
        if (errorList.isEmpty()) {
            try {
                RulesHelper.applyRules((EntityContainer)ctr, (boolean)true, (boolean)false, result);
            }
            catch (Exception e) {
                errorList.addAll(this.handleExceptionRules(e, bookingFileReference));
            }
        }
        if (errorList.isEmpty()) {
            try {
                ctr.getVersionInfo().setDataSource("fx-applyRules");
                EntityStorage.get().save(ctr, true);
            }
            catch (Exception e) {
                errorList.add(Messages.getExceptionApplyingRules((String)bookingFileReference.toString()));
                this.updateErrorListWithXeption(errorList, e);
            }
        }
        if (errorList.isEmpty()) {
            result.add(Messages.getNotificationRulesApplied((String)bookingFileReference.toString()));
        }
        result.addAll(errorList);
        return result;
    }

    private List<Message> performChecksRules(EntityReference<BookingFile> bookingFileReference) {
        ArrayList<Message> result = new ArrayList<Message>(1);
        if (!this.isAccessGranted()) {
            result.add(Messages.getExceptionApplyingRules((String)bookingFileReference.toString()));
            result.add(Messages.getExceptionAccessDenied());
        }
        return result;
    }

    private Collection<Message> handleExceptionRules(Throwable t, EntityReference<BookingFile> bookingFileReference) {
        ArrayList<Message> result = new ArrayList<Message>();
        Message message = Messages.getExceptionApplyingRules((String)bookingFileReference.toString());
        try {
            message.setDetails(TextUtil.getExceptionStackTraceRegular((Throwable)t));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        result.add(message);
        return result;
    }

    private boolean isAccessGranted() {
        return true;
    }

    private BookingFileService.ProductRPCResult refundHotelHelper(HotelProduct product, HotelRefundSettings settings) throws Exception {
        EntityContainer agentContainer;
        ArrayList<Message> messages = new ArrayList<Message>();
        HotelProduct refundProduct = new HotelProduct();
        HotelProductHelper.copy((HotelProduct)product, (HotelProduct)refundProduct, (boolean)false);
        for (HotelProductContractRelationData relation : HotelProductHelper.getContractRelations((HotelProduct)refundProduct)) {
            relation.getFops().removeIf(fop -> fop.getType() == PaymentType.TICKET);
        }
        EntityContainer entityContainer = agentContainer = settings.getAgent() == null ? null : EntityStorage.get().resolve(settings.getAgent());
        if (product.getReservation() != null && !product.getReservation().getProducts().contains(refundProduct)) {
            product.getReservation().getProducts().add(refundProduct);
        }
        product.setNextProduct(refundProduct);
        refundProduct.setPreviousProduct(product);
        refundProduct.setIssueDate(settings.getDate());
        refundProduct.setCashier(settings.getAgent());
        refundProduct.setCashierCode(agentContainer == null ? null : ((Person)agentContainer.getEntity()).getCode());
        refundProduct.setStatus(ProductStatus.REFUND);
        refundProduct.setChecked(false);
        refundProduct.setContractRulesApplied(false);
        refundProduct.setForcedRefund(settings.isForced());
        this.updateHotelRefundFare(refundProduct, settings.getFares());
        this.updateHotelRefundTaxes(refundProduct, settings.getTaxes());
        this.updateHotelRefundPenalties(refundProduct, settings.getPenalties());
        this.updateHotelRefundFops(refundProduct, (EntityReference<Person>)settings.getAgent(), settings.getDate());
        messages.add(Messages.getNotificationSuccessfullyAdded((String)BookingHelper.generateShortProductName((BaseProduct)refundProduct)));
        return new BookingFileService.ProductRPCResult(messages, refundProduct.getUid());
    }

    private void updateHotelRefundFops(HotelProduct refundProduct, EntityReference<Person> agent, Date date) throws Exception {
        HotelProductHelper.updateFops((HotelProduct)refundProduct);
        HotelProductHelper.updateFopsByDate((HotelProduct)refundProduct, (Date)date);
        HotelProductHelper.updateClientFop((HotelProduct)refundProduct, (Date)date, agent);
    }

    private void updateHotelRefundPenalties(HotelProduct refundProduct, List<Penalty> penalties) throws Exception {
        refundProduct.getPenalties().clear();
        for (Penalty p : penalties) {
            if (p.getEquivalentAmount() == null) continue;
            Penalty pen = (Penalty)XCloneHelper.clone((XCloneable)p);
            refundProduct.getPenalties().add(pen);
        }
    }

    private void updateHotelRefundTaxes(HotelProduct refundProduct, List<HotelProductTax> taxes) {
        HashMap<String, HotelProductTax> mapOfTaxes = new HashMap<String, HotelProductTax>();
        if (taxes.isEmpty()) {
            refundProduct.getTaxes().clear();
            return;
        }
        refundProduct.getTaxes().retainAll(taxes);
        for (HotelProductTax tax : refundProduct.getTaxes()) {
            mapOfTaxes.put(tax.getUid(), tax);
        }
        for (HotelProductTax refundedTax : taxes) {
            HotelProductTax currentTax = (HotelProductTax)mapOfTaxes.get(refundedTax.getUid());
            if (currentTax == null) continue;
            currentTax.setEquivalentAmount(refundedTax.getEquivalentAmount());
            if (currentTax.getAmount() == null || refundedTax.getAmount() == null) continue;
            currentTax.getAmount().setValue(refundedTax.getAmount().getValue());
        }
    }

    private void updateHotelRefundFare(HotelProduct refundProduct, List<HotelRefundFaresSettings> refFares) {
        Map<String, HotelRefundFaresSettings> fares = refFares.stream().collect(Collectors.toMap(BaseIdentity::getUid, el -> el));
        for (Room room : refundProduct.getRooms()) {
            BigDecimal subtr;
            if (!fares.containsKey(room.getUid())) continue;
            HotelRefundFaresSettings wrapper = fares.get(room.getUid());
            if (room.getEquivalentPrice() != null) {
                subtr = BigDecimal.ZERO;
                if (wrapper.getEquivalentValue() != null) {
                    subtr = wrapper.getEquivalentValue();
                } else if (wrapper.getBaseValue() != null && wrapper.getExchangeRate() != null) {
                    subtr = wrapper.getBaseValue().multiply(wrapper.getExchangeRate());
                }
                room.setEquivalentPrice(room.getEquivalentPrice().subtract(subtr));
            }
            if (room.getBasePrice() == null || room.getBasePrice().getValue() == null) continue;
            subtr = BigDecimal.ZERO;
            if (wrapper.getBaseValue() != null) {
                subtr = wrapper.getBaseValue();
            } else if (wrapper.getEquivalentValue() != null && wrapper.getExchangeRate() != null && BigDecimal.ZERO.compareTo(wrapper.getExchangeRate()) != 0) {
                subtr = wrapper.getEquivalentValue().divide(wrapper.getExchangeRate());
            }
            room.getBasePrice().setValue(room.getBasePrice().getValue().subtract(subtr));
        }
    }

    public List<ProductFop> getAirProductFops(ServiceInvocationContext ctx, EntityReference<BookingFile> bFRef, String uidProduct) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-getAirProductFops");
        try {
            this.checkContext(ctx);
            Product product = ((BookingFile)EntityStorage.get().resolve(bFRef).getEntity()).getReservations().stream().map(reservation -> reservation.getProducts().stream().filter(baseProduct -> uidProduct.equals(baseProduct.getUid())).findFirst().orElse(null)).findFirst().orElse(null);
            List list = AirProductHelper.getVendorContractRelation((Product)product).getFops();
            return list;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("Failed getting product fops", t);
            throw new ServiceException("Failed getting product fops", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public void saveFopMap(ServiceInvocationContext ctx, EntityReference<BookingFile> bFRef, String uidProduct, List<PriceComponentWrapper> priceComponents, List<ExchangePaymentTypeWrapper> exchangePaymentTypes) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-saveFopMap");
        try {
            this.checkContext(ctx);
            EntityContainer bfCtr = EntityStorage.get().resolve(bFRef);
            Product product = ((BookingFile)bfCtr.getEntity()).getReservations().stream().map(reservation -> reservation.getProducts().stream().filter(baseProduct -> uidProduct.equals(baseProduct.getUid())).findFirst().orElse(null)).findFirst().orElse(null);
            List fops = AirProductHelper.getVendorContractRelation((Product)product).getFops();
            for (ProductFop fop : fops) {
                fop.getFares().clear();
                fop.getTaxes().clear();
                fop.setHasPenaltyComponent(false);
                for (PriceComponentWrapper priceComponentWrapper : priceComponents) {
                    if (!priceComponentWrapper.getFopUids().contains(fop.getUid())) continue;
                    for (String fareUid : priceComponentWrapper.getPriceComponent().getFaresUids()) {
                        fop.getFares().add(CollectionUtil.find((Iterable)product.getFares(), (String)fareUid));
                    }
                    for (String taxUid : priceComponentWrapper.getPriceComponent().getTaxesUids()) {
                        fop.getTaxes().add(CollectionUtil.find((Iterable)product.getTaxes(), (String)taxUid));
                    }
                    if (!(priceComponentWrapper.getPriceComponent() instanceof PenaltyCostItem)) continue;
                    fop.setHasPenaltyComponent(true);
                }
                for (ExchangePaymentTypeWrapper exchangePaymentTypeWrapper : exchangePaymentTypes) {
                    if (!exchangePaymentTypeWrapper.getFop().getFopUid().equals(fop.getUid())) continue;
                    fop.setExchangePaymentType(exchangePaymentTypeWrapper.getPaymentType());
                }
            }
            bfCtr.getVersionInfo().setDataSource("fx-fop map");
            EntityStorage.get().save(bfCtr, true);
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("Failed save product fops", t);
            throw new ServiceException("Failed save product fops", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public List<Hotel> searchSabreHotels(ServiceInvocationContext ctx, String id, DictionaryReference<Country> country, DictionaryReference<GeoLocation> location, DictionaryReference<HotelsBrand> chain, String name) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-searchHotels");
        try {
            this.checkContext(ctx);
            int limit = 50;
            ArrayList<Hotel> result = new ArrayList<Hotel>();
            if (HotelAggregatorHelper.isHotelAggregatorEnabled()) {
                if (TextUtil.nonBlank((String)id)) {
                    result.addAll(CollectionUtil.toList((Object)HotelAggregatorHelper.searchHotelByProviderCode((String)id, (HotelProvider)HotelProvider.SABRE)));
                } else {
                    result.addAll(HotelAggregatorHelper.searchHotels((HotelProvider)HotelProvider.SABRE, country, location, (String)name, (Integer)limit, null));
                }
            }
            if (result.size() < limit) {
                result.addAll(((RemoteDictionaryResolver)Environment.getPublished(RemoteDictionaryResolver.class)).getHotel(TextUtil.isBlank((String)id) ? "" : id, country == null ? "" : country.getCode(), location == null ? "" : location.getCode(), chain == null ? "" : chain.getCode(), TextUtil.isBlank((String)name) ? "" : name, limit - result.size()));
            }
            ArrayList<Hotel> arrayList = result;
            return arrayList;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("failed searching sabre hotels", t);
            throw new ServiceException("failed searching sabre hotels", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public BookingFileService.SetPayerToRetailClientResult setPayerToRetailClient(ServiceInvocationContext ctx, EntityReference<BookingFile> bookingRef) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-setPayerToRetailClient");
        try {
            BookingFileService.SetPayerToRetailClientResult setPayerToRetailClientResult;
            this.checkContext(ctx);
            ArrayList<Message> result = new ArrayList<Message>();
            EntityReference retailProfileRef = ProfileHelper.findRetailProfileReference();
            if (retailProfileRef == null) {
                result.add(Messages.getNoRetailProfileFound());
                BookingFileService.SetPayerToRetailClientResult setPayerToRetailClientResult2 = new BookingFileService.SetPayerToRetailClientResult(false, result);
                return setPayerToRetailClientResult2;
            }
            EntityContainer bookingCtr = EntityStorage.get().resolve(bookingRef);
            if (bookingCtr == null) {
                result.add(Messages.getUnableToLoadBooking());
                BookingFileService.SetPayerToRetailClientResult setPayerToRetailClientResult3 = new BookingFileService.SetPayerToRetailClientResult(false, result);
                return setPayerToRetailClientResult3;
            }
            boolean changed = false;
            for (Reservation res : ((BookingFile)bookingCtr.getEntity()).getReservations()) {
                for (BaseProduct bp : res.getProducts()) {
                    List relations = GeneralProductHelper.copyContractRelations((BaseProduct)bp);
                    GeneralProductContractRelationData relation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)relations, (ContractType)ContractType.CLIENT);
                    if (relation == null) {
                        result.add(Messages.getUnableToFindClientRelationsInProduct((String)GeneralProductHelper.getProductTitle((BaseProduct)bp)));
                        continue;
                    }
                    if (relation.getFops().stream().allMatch(fop -> retailProfileRef.equals((Object)fop.getPayer()))) {
                        result.add(Messages.getProductAlreadyPayedByRetail((String)GeneralProductHelper.getProductTitle((BaseProduct)bp)));
                        continue;
                    }
                    relation.getFops().forEach(it -> it.setPayer(retailProfileRef));
                    GeneralProductHelper.getHandler((BaseProduct)bp).updateContractRelations(bp, relations);
                    changed = true;
                }
            }
            if (changed) {
                bookingCtr.getVersionInfo().setDataSource("fx-setPayerToRetailClient");
                EntityStorage.get().save(bookingCtr, true);
                result.add(Messages.getPayerSuccessfullySet());
                setPayerToRetailClientResult = new BookingFileService.SetPayerToRetailClientResult(true, result);
                return setPayerToRetailClientResult;
            }
            result.add(Messages.getBookingIsNotChanged());
            setPayerToRetailClientResult = new BookingFileService.SetPayerToRetailClientResult(false, result);
            return setPayerToRetailClientResult;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Throwable t) {
            this.log.error("failed setting payer to retail client in booking " + bookingRef, t);
            throw new ServiceException("failed setting payer to retail client in booking", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public BookingFileService.DeliveryRPCResult renderDeliveryRouteList(ServiceInvocationContext ctx, List<DeliveryIndex> list, EntityReference<TemplateDocument> templateReference) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-render-delivery-route-list");
        try {
            this.checkContext(ctx);
            EntityReference resultRef = null;
            ArrayList<Message> errorList = new ArrayList<Message>();
            EntityContainer templateCtr = EntityStorage.get().resolve(templateReference);
            if (templateCtr == null) {
                this.addContainerResolveErrorMessage(errorList, null);
            } else {
                ArrayList deliveries = new ArrayList();
                for (DeliveryIndex deliveryIndex : list) {
                    EntityContainer bookingCtr = EntityStorage.get().resolve(deliveryIndex.getSource());
                    if (bookingCtr == null) continue;
                    BookingHelper.getProducts((BookingFile)((BookingFile)bookingCtr.getEntity())).stream().filter(product -> MiscUtil.equals((Object)product.getUid(), (Object)deliveryIndex.getNavigationKey())).findFirst().map(Delivery.class::cast).ifPresent(deliveries::add);
                }
                Document document = DeliveryBlankRenderer.renderRouteBlank(deliveries, (EntityContainer)templateCtr, errorList);
                if (errorList.isEmpty()) {
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.name.name(), (Object)document.getName()));
                    List data = EntityStorage.get().search(BasicDocumentIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData();
                    for (BasicDocumentIndex index : data) {
                        EntityStorage.get().delete(EntityStorage.get().resolve(index.getSource()));
                    }
                    EntityContainer docCtr = EntityContainer.create((BaseEntity)document);
                    docCtr.getVersionInfo().setDataSource("fx-createDeliveryRouteList");
                    EntityStorage.get().save(docCtr, true);
                    resultRef = docCtr.toReference();
                }
            }
            BookingFileService.DeliveryRPCResult deliveryRPCResult = new BookingFileService.DeliveryRPCResult(errorList, resultRef, null);
            return deliveryRPCResult;
        }
        catch (Exception e) {
            this.log.error("Failed to render delivery route list for deliveries: " + list.stream().map(DeliveryIndex::getSystemNumber).collect(Collectors.joining(", ")), (Throwable)e);
            throw new ServiceException("Failed to render delivery route list", (Throwable)e);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public BookingFileService.ProductReplaceDetailsPrepareResult prepareProductReplaceDetails(ServiceInvocationContext ctx, Map<EntityReference<BookingFile>, List<String>> entityReferenceToUidMap) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-prepareProductReplaceDetails");
        try {
            this.checkContext(ctx);
            List<Object> payerUids = new ArrayList();
            EnumSet<ProductReplaceDetailsType> allowedTypes = EnumSet.allOf(ProductReplaceDetailsType.class);
            HashSet<EntityReference> processedOrgs = new HashSet<EntityReference>();
            HashSet<EntityReference> subagencies = new HashSet<EntityReference>();
            HashSet<HotelProvider> hotelProviders = new HashSet<HotelProvider>();
            HotelProvider provider = null;
            block5: for (EntityReference<BookingFile> bookingReference : entityReferenceToUidMap.keySet()) {
                EntityContainer bookingContainer = EntityStorage.get().resolve(bookingReference);
                EntityReference customerProfile = ((BookingFile)bookingContainer.getEntity()).getCustomerProfile();
                if (customerProfile != null && !processedOrgs.contains(customerProfile)) {
                    processedOrgs.add(customerProfile);
                    EntityContainer customerProfileContainer = EntityStorage.get().resolve(customerProfile);
                    if (EntityStorageHelper.nonEmpty((EntityContainer)customerProfileContainer)) {
                        payerUids.addAll(BookingFileHelper.getAvailablePayersUids((EntityContainer<Organization>)customerProfileContainer, true));
                    }
                }
                Map proxyMap = RestrictionsHelper.buildProxies((EntityContainer)bookingContainer, (String)ModelRestrictionEntityResources.ENTITY_BOOKING_FILE.getId());
                for (String productUid : entityReferenceToUidMap.get(bookingReference)) {
                    boolean subagentShipmentsDateEditGranted;
                    boolean clientShipmentsDateEditGranted;
                    boolean fopEditGranted;
                    List fopsUids;
                    boolean agentEditGranted;
                    BaseProduct product = BookingHelper.findProductByUid((String)productUid, (BookingFile)((BookingFile)bookingContainer.getEntity()));
                    ProductHandler handler = ProductHandler.of((BaseProduct)product);
                    boolean productEditGranted = com.gridnine.xtrip.server.security.acl.helper.AclHelper.isGranted((RestrictionResourceProxy)((RestrictionResourceProxy)proxyMap.get(productUid)), (String)ModelRestrictionEntityResources.ENTITY_PRODUCT.getId(), (String)UserData.get().getCurrentUser(), (String)StandardRestrictionResourceOperations.EDIT.getId(), Collections.emptyList());
                    if (!productEditGranted) {
                        allowedTypes.clear();
                    }
                    if (allowedTypes.contains(ProductReplaceDetailsType.HOTEL)) {
                        if (product instanceof HotelProduct) {
                            HotelProduct hotelProduct = (HotelProduct)product;
                            hotelProviders.add(hotelProduct.getProvider());
                        } else {
                            allowedTypes.remove(ProductReplaceDetailsType.HOTEL);
                        }
                    }
                    if (allowedTypes.contains(ProductReplaceDetailsType.AGENT) && !(agentEditGranted = com.gridnine.xtrip.server.security.acl.helper.AclHelper.isGranted((RestrictionResourceProxy)((RestrictionResourceProxy)proxyMap.get(AclHelper.createCompoundId((String)productUid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_AGENT.getId()))), (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_AGENT.getId(), (String)UserData.get().getCurrentUser(), (String)StandardRestrictionResourceOperations.EDIT.getId(), Collections.emptyList()))) {
                        allowedTypes.remove(ProductReplaceDetailsType.AGENT);
                    }
                    if (allowedTypes.contains(ProductReplaceDetailsType.CLIENT_CONTRACT)) {
                        EntityReference subagency = GeneralProductHelper.getSubagency((BaseProduct)product);
                        subagencies.add(subagency);
                        if (processedOrgs.stream().filter(Objects::nonNull).count() > 1L || subagencies.stream().filter(Objects::nonNull).count() > 1L) {
                            allowedTypes.remove(ProductReplaceDetailsType.CLIENT_CONTRACT);
                        }
                    }
                    if ((allowedTypes.contains(ProductReplaceDetailsType.AGENCY) || allowedTypes.contains(ProductReplaceDetailsType.SUBAGENCY)) && ShipmentHelper.hasSubagentRelatedShipment((BaseProduct)product)) {
                        allowedTypes.remove(ProductReplaceDetailsType.AGENCY);
                        allowedTypes.remove(ProductReplaceDetailsType.SUBAGENCY);
                    }
                    if ((allowedTypes.contains(ProductReplaceDetailsType.SUBAGENCY) || allowedTypes.contains(ProductReplaceDetailsType.CLIENT)) && ShipmentHelper.hasClientRelatedShipment((BaseProduct)product)) {
                        allowedTypes.remove(ProductReplaceDetailsType.SUBAGENCY);
                        allowedTypes.remove(ProductReplaceDetailsType.CLIENT);
                    }
                    if (allowedTypes.contains(ProductReplaceDetailsType.VENDOR_FOP_AGENT)) {
                        fopsUids = handler.getFopsUids(product, ContractType.VENDOR);
                        for (String fopUid : fopsUids) {
                            fopEditGranted = com.gridnine.xtrip.server.security.acl.helper.AclHelper.isGranted((RestrictionResourceProxy)((RestrictionResourceProxy)proxyMap.get(fopUid)), (String)ModelRestrictionEntityResources.ENTITY_FOP.getId(), (String)UserData.get().getCurrentUser(), (String)StandardRestrictionResourceOperations.EDIT.getId(), Collections.emptyList());
                            if (fopEditGranted) continue;
                            allowedTypes.remove(ProductReplaceDetailsType.VENDOR_FOP_AGENT);
                            break;
                        }
                    }
                    if (allowedTypes.contains(ProductReplaceDetailsType.SUBAGENCY_FOP_AGENT)) {
                        if (ShipmentHelper.hasSubagentRelatedShipment((BaseProduct)product)) {
                            allowedTypes.remove(ProductReplaceDetailsType.SUBAGENCY_FOP_AGENT);
                        }
                        fopsUids = handler.getFopsUids(product, ContractType.SUBAGENCY);
                        for (String fopUid : fopsUids) {
                            fopEditGranted = com.gridnine.xtrip.server.security.acl.helper.AclHelper.isGranted((RestrictionResourceProxy)((RestrictionResourceProxy)proxyMap.get(fopUid)), (String)ModelRestrictionEntityResources.ENTITY_FOP.getId(), (String)UserData.get().getCurrentUser(), (String)StandardRestrictionResourceOperations.EDIT.getId(), Collections.emptyList());
                            if (fopEditGranted) continue;
                            allowedTypes.remove(ProductReplaceDetailsType.SUBAGENCY_FOP_AGENT);
                            break;
                        }
                    }
                    if (allowedTypes.contains(ProductReplaceDetailsType.CLIENT_FOP_AGENT)) {
                        if (ShipmentHelper.hasClientRelatedShipment((BaseProduct)product)) {
                            allowedTypes.remove(ProductReplaceDetailsType.CLIENT_FOP_AGENT);
                        }
                        fopsUids = handler.getFopsUids(product, ContractType.CLIENT);
                        for (String fopUid : fopsUids) {
                            fopEditGranted = com.gridnine.xtrip.server.security.acl.helper.AclHelper.isGranted((RestrictionResourceProxy)((RestrictionResourceProxy)proxyMap.get(fopUid)), (String)ModelRestrictionEntityResources.ENTITY_FOP.getId(), (String)UserData.get().getCurrentUser(), (String)StandardRestrictionResourceOperations.EDIT.getId(), Collections.emptyList());
                            if (fopEditGranted) continue;
                            allowedTypes.remove(ProductReplaceDetailsType.CLIENT_FOP_AGENT);
                            break;
                        }
                    }
                    if (allowedTypes.contains(ProductReplaceDetailsType.CLIENT_SHIPMENTS_DATE) && !(clientShipmentsDateEditGranted = com.gridnine.xtrip.server.security.acl.helper.AclHelper.isGranted((RestrictionResourceProxy)((RestrictionResourceProxy)proxyMap.get(AclHelper.createCompoundId((String)productUid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_CLIENT_SHIPMENTS_DATE.getId()))), (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_CLIENT_SHIPMENTS_DATE.getId(), (String)UserData.get().getCurrentUser(), (String)StandardRestrictionResourceOperations.EDIT.getId(), Collections.emptyList()))) {
                        allowedTypes.remove(ProductReplaceDetailsType.CLIENT_SHIPMENTS_DATE);
                    }
                    if (allowedTypes.contains(ProductReplaceDetailsType.SUBAGENT_SHIPMENTS_DATE) && !(subagentShipmentsDateEditGranted = com.gridnine.xtrip.server.security.acl.helper.AclHelper.isGranted((RestrictionResourceProxy)((RestrictionResourceProxy)proxyMap.get(AclHelper.createCompoundId((String)productUid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SUBAGENT_SHIPMENTS_DATE.getId()))), (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SUBAGENT_SHIPMENTS_DATE.getId(), (String)UserData.get().getCurrentUser(), (String)StandardRestrictionResourceOperations.EDIT.getId(), Collections.emptyList()))) {
                        allowedTypes.remove(ProductReplaceDetailsType.SUBAGENT_SHIPMENTS_DATE);
                    }
                    if (!allowedTypes.isEmpty()) continue;
                    break block5;
                }
            }
            if (hotelProviders.size() == 1 && !hotelProviders.contains(null)) {
                provider = (HotelProvider)hotelProviders.stream().findFirst().get();
            }
            payerUids = payerUids.stream().distinct().collect(Collectors.toList());
            EntityReference customer = processedOrgs.stream().filter(Objects::nonNull).findFirst().orElse(null);
            EntityReference subagency = subagencies.stream().filter(Objects::nonNull).findFirst().orElse(null);
            BookingFileService.ProductReplaceDetailsPrepareResult productReplaceDetailsPrepareResult = new BookingFileService.ProductReplaceDetailsPrepareResult(payerUids, allowedTypes, customer, subagency, provider);
            return productReplaceDetailsPrepareResult;
        }
        catch (Exception e) {
            this.log.error("Failed to prepare product replace", (Throwable)e);
            throw new ServiceException("Failed to prepare product replace", (Throwable)e);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public MiscUtil.Pair<List<MiscUtil.Pair<EntityReference<BookingFile>, String>>, List<Message>> checkDeleteProductPermissions(ServiceInvocationContext ctx, List<MiscUtil.Pair<EntityReference<BookingFile>, String>> pairList) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-isProductListDeletable");
        try {
            this.checkContext(ctx);
            HashMap entityReferenceToUidMap = new HashMap();
            pairList.forEach(pair -> entityReferenceToUidMap.computeIfAbsent(pair.getFirst(), key -> new ArrayList()).add(pair.getSecond()));
            ArrayList<MiscUtil.Pair> grantedPairList = new ArrayList<MiscUtil.Pair>();
            ArrayList<Message> messages = new ArrayList<Message>();
            for (EntityReference bookingReference : entityReferenceToUidMap.keySet()) {
                EntityContainer bookingContainer = EntityStorage.get().resolve(bookingReference);
                Map proxyMap = RestrictionsHelper.buildProxies((EntityContainer)bookingContainer, (String)ModelRestrictionEntityResources.ENTITY_BOOKING_FILE.getId());
                for (String productUid : (List)entityReferenceToUidMap.get(bookingReference)) {
                    boolean productDeleteGranted = com.gridnine.xtrip.server.security.acl.helper.AclHelper.isGranted((RestrictionResourceProxy)((RestrictionResourceProxy)proxyMap.get(productUid)), (String)ModelRestrictionEntityResources.ENTITY_PRODUCT.getId(), (String)UserData.get().getCurrentUser(), (String)StandardRestrictionResourceOperations.DELETE.getId(), Collections.emptyList());
                    if (productDeleteGranted) {
                        grantedPairList.add(new MiscUtil.Pair((Object)bookingReference, (Object)productUid));
                        continue;
                    }
                    BaseProduct product = BookingHelper.findProduct((EntityContainer)bookingContainer, (String)productUid);
                    messages.add(Messages.getProductIsNotDeleted((String)ProductHandler.of((BaseProduct)product).generateShortProductName(product)));
                }
            }
            MiscUtil.Pair pair2 = new MiscUtil.Pair(grantedPairList, messages);
            return pair2;
        }
        catch (Exception e) {
            this.log.error("Failed to check products delete permissions", (Throwable)e);
            throw new ServiceException("Failed to check products delete permissions", (Throwable)e);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public BookingFileService.CopyProductActionParameters getCopyActionParameters(ServiceInvocationContext ctx, EntityReference<BookingFile> bookingRef, String productUid) {
        EntityContainer bookingCtr = EntityStorage.get().resolve(bookingRef);
        if (bookingCtr == null) {
            return null;
        }
        BaseProduct product = BookingHelper.findProduct((BookingFile)((BookingFile)bookingCtr.getEntity()), (String)productUid);
        List payers = GeneralProductHelper.getClientFops((BaseProduct)product).stream().map(GeneralProductFop::getPayer).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(EntityReference::getCaption)).collect(Collectors.toList());
        return new BookingFileService.CopyProductActionParameters(bookingCtr, payers);
    }

    public BookingFileService.CorrectionCreateActionParameters getCorrectionCreateActionParameters(ServiceInvocationContext ctx, EntityReference<BookingFile> bookingRef) {
        EntityContainer bookingCtr = EntityStorage.get().resolve(bookingRef);
        List products = BookingHelper.getProducts((BookingFile)((BookingFile)bookingCtr.getEntity()));
        List payers = products.stream().flatMap(baseProduct -> GeneralProductHelper.getClientFops((BaseProduct)baseProduct).stream()).map(GeneralProductFop::getPayer).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(EntityReference::getCaption)).collect(Collectors.toList());
        HashMap<BaseProduct, List> relatedProductsMap = new HashMap<BaseProduct, List>();
        for (BaseProduct baseProduct2 : products) {
            for (BaseProduct product : products) {
                if (!ProductHandler.of((BaseProduct)product).getRelatedProducts(product).contains(baseProduct2)) continue;
                List value = relatedProductsMap.getOrDefault(baseProduct2, new ArrayList());
                value.add(product);
                relatedProductsMap.put(baseProduct2, value);
            }
        }
        for (BaseProduct baseProduct2 : products) {
            BaseProduct nextProduct = ProductHandler.of((BaseProduct)baseProduct2).getNextProduct(baseProduct2);
            while (nextProduct != null) {
                List value = relatedProductsMap.getOrDefault(baseProduct2, new ArrayList());
                value.add(nextProduct);
                relatedProductsMap.put(baseProduct2, value);
                nextProduct = ProductHandler.of((BaseProduct)nextProduct).getNextProduct(nextProduct);
            }
        }
        return new BookingFileService.CorrectionCreateActionParameters(payers, relatedProductsMap);
    }

    public VatCalculationSettingsSynchronizationResult synchronizeVatCalculationSettings(ServiceInvocationContext ctx, EntityReference<VatCalculationSettings> settingsRef) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-synchronizeVatCalculationSettings");
        try {
            this.checkContext(ctx);
            VatCalculationSettingsSynchronizationResult vatCalculationSettingsSynchronizationResult = CommonVatSynchronizationHelper.synchronizeVatCalculationSetting(settingsRef);
            return vatCalculationSettingsSynchronizationResult;
        }
        catch (Exception e) {
            this.log.error("Failed to update vat settings", (Throwable)e);
            throw new ServiceException("Failed to update vat settings", (Throwable)e);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public Collection<BookingFileService.JoinProductData> getJoinProducts(ServiceInvocationContext ctx, Set<EntityReference<BookingFile>> bookings) throws ServiceException {
        ArrayList<BookingFileService.JoinProductData> result = new ArrayList<BookingFileService.JoinProductData>();
        for (EntityReference<BookingFile> bookingRef : bookings) {
            EntityContainer bookingCtr = EntityStorage.get().resolve(bookingRef);
            if (bookingCtr == null) {
                BookingFileNotFoundException ex = new BookingFileNotFoundException(bookingRef);
                this.log.error("Booking file not found", (Throwable)ex);
                throw ex;
            }
            ((BookingFile)bookingCtr.getEntity()).getReservations().stream().flatMap(it -> it.getProducts().stream()).forEach(it -> {
                GeneralProductContractRelationData subagencyContractRelation;
                ProductStatus status;
                ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)it);
                ProductType productType = handler.getProductType(it);
                TravelSubject travelSubject = handler.findTravelSubject(it);
                StringBuilder sbName = new StringBuilder(productType != null ? productType.toString() : travelSubject.toString()).append(" - ");
                List productNumbers = handler.getProductNumbers(it);
                if (!productNumbers.isEmpty()) {
                    sbName.append((String)productNumbers.iterator().next()).append(" - ");
                }
                if ((status = handler.getStatus(it)) != null) {
                    sbName.append(status);
                }
                List relations = handler.getUnmodifiableContractRelations(it);
                GeneralProductContractRelationData clientContractRelation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)relations, (ContractType)ContractType.CLIENT);
                HashSet payers = new HashSet();
                boolean hasClientShipment = false;
                boolean hasSubagencyShipment = false;
                if (clientContractRelation != null) {
                    clientContractRelation.getFops().forEach(fop -> {
                        if (fop.getPayer() != null) {
                            payers.add(fop.getPayer());
                        }
                    });
                    Set fopUids = clientContractRelation.getFops().stream().map(BaseIdentity::getUid).collect(Collectors.toSet());
                    hasClientShipment = it.getFopDetalizations().entrySet().stream().filter(item -> fopUids.contains(item.getKey())).flatMap(item -> ((FopDetalization)item.getValue()).getComponents().stream()).anyMatch(item -> item.getShipment() != null);
                }
                if ((subagencyContractRelation = (GeneralProductContractRelationData)GeneralProductHelper.findContractRelation((List)relations, (ContractType)ContractType.SUBAGENCY)) != null) {
                    Set fopUids = subagencyContractRelation.getFops().stream().map(BaseIdentity::getUid).collect(Collectors.toSet());
                    hasSubagencyShipment = it.getFopDetalizations().entrySet().stream().filter(item -> fopUids.contains(item.getKey())).flatMap(item -> ((FopDetalization)item.getValue()).getComponents().stream()).anyMatch(item -> item.getShipment() != null);
                }
                String name = handler.getTravellers(it).stream().map(Traveller::getName).filter(TextUtil::nonBlank).sorted().collect(Collectors.joining(", "));
                result.add(new BookingFileService.JoinProductData(bookingRef, it.getUid(), sbName.toString(), ((BookingFile)bookingCtr.getEntity()).getCustomerProfile(), payers, GeneralProductHelper.getAgency((BaseProduct)it), GeneralProductHelper.getSubagency((BaseProduct)it), name, hasClientShipment, hasSubagencyShipment));
            });
        }
        return result;
    }

    public String getBlankOwnerCode(ServiceInvocationContext ctx, EntityReference<Organization> orgRef) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-getBlankOwnerCode");
        try {
            this.checkContext(ctx);
            if (orgRef == null) {
                String string = null;
                return string;
            }
            String string = HotelProductHelper.getBlankOwnerCode(orgRef);
            return string;
        }
        catch (Exception e) {
            this.log.error("Failed to get blank owner code", (Throwable)e);
            throw new ServiceException("Failed to get blank owner code", (Throwable)e);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public AirItineraryReceiptData getAirItineraryReceiptData(ServiceInvocationContext serviceInvocationContext, NestedEntityReference<BookingFile, Product> productReference) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-getAirItineraryReceiptData");
        try {
            this.checkContext(serviceInvocationContext);
            Product product = (Product)EntityStorageHelper.resolve(productReference);
            if (product == null) {
                AirItineraryReceiptData airItineraryReceiptData = null;
                return airItineraryReceiptData;
            }
            RuleProxy ruleProxy = AirRulesHelper.applyContracts((Product)product, new ArrayList(), (ContractType)ContractType.CLIENT);
            if (ruleProxy != null && ((ProductCommissionActionSet)ruleProxy.getActionSet()).getItineraryReceiptData() != null) {
                AirItineraryReceiptData airItineraryReceiptData = this.checkedAirItineraryReceiptData(((ProductCommissionActionSet)ruleProxy.getActionSet()).getItineraryReceiptData());
                return airItineraryReceiptData;
            }
            AirItineraryReceiptData airItineraryReceiptData = null;
            return airItineraryReceiptData;
        }
        catch (Exception exception) {
            this.log.error("Failed to get air itinerary receipt data", (Throwable)exception);
            throw new ServiceException("Failed to get air itinerary receipt data");
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private AirItineraryReceiptData checkedAirItineraryReceiptData(AirItineraryReceiptData itineraryReceiptData) {
        itineraryReceiptData.getTemplates().removeIf(templateRef -> EntityStorage.get().resolve(templateRef) == null);
        return !itineraryReceiptData.getTemplates().isEmpty() ? itineraryReceiptData : null;
    }

    public HotelVoucherData getHotelVoucherData(ServiceInvocationContext serviceInvocationContext, NestedEntityReference<BookingFile, HotelProduct> productReference) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-getHotelVoucherData");
        try {
            this.checkContext(serviceInvocationContext);
            HotelProduct product = (HotelProduct)EntityStorageHelper.resolve(productReference);
            if (product == null) {
                HotelVoucherData hotelVoucherData = null;
                return hotelVoucherData;
            }
            ArrayList messages = new ArrayList();
            List contracts = HotelRulesHelper.getContracts((HotelProduct)product, null, messages);
            RuleProxy ruleProxy = HotelRulesHelper.applyContracts((HotelProduct)product, (List)contracts, messages);
            if (ruleProxy != null) {
                HotelVoucherData hotelVoucherData = ((HotelActionSet)ruleProxy.getActionSet()).getHotelVoucherData();
                return hotelVoucherData;
            }
            HotelVoucherData hotelVoucherData = null;
            return hotelVoucherData;
        }
        catch (Exception exception) {
            this.log.error("Failed to get hotel voucher data");
            throw new ServiceException("Failed to get hotel voucher data");
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public Collection<EntityReference<TemplateDocument>> getTemplateDocuments(ServiceInvocationContext serviceInvocationContext, BaseProduct baseProduct, EntityReference<BookingFile> bfReference) throws Exception {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-getTemplateDocuments");
        try {
            RulesProductHandler transferHandler;
            Transfer product;
            RuleProxy ruleProxy;
            this.checkContext(serviceInvocationContext);
            EntityContainer bfContainer = EntityStorage.get().resolve(bfReference);
            if (bfContainer == null) {
                List<EntityReference<TemplateDocument>> list = Collections.emptyList();
                return list;
            }
            if (baseProduct instanceof Transfer && (ruleProxy = GeneralProductRulesHelper.applyRules((BaseProduct)(product = (Transfer)baseProduct), (EntityContainer)bfContainer, (RulesProductHandler)(transferHandler = TransferRulesHandler.get().createRulesHandler()), new ArrayList(), null, null, (boolean)true, (boolean)false, (boolean)true)) != null) {
                Collection collection = ((TransferActionSet)ruleProxy.getActionSet()).getReceiptTemplates();
                return collection;
            }
            if (baseProduct instanceof AeroexpressTicket) {
                product = (AeroexpressTicket)baseProduct;
                AeroexpressTicketRulesHandler aeroexpressRulesHandler = ((ServerHandlersRegistry)Environment.getPublished(ServerHandlersRegistry.class)).getAllRulesHandlers().stream().filter(rulesHandler -> AeroexpressTicketRulesHandler.ID.equals(rulesHandler.getId())).map(AeroexpressTicketRulesHandler.class::cast).findFirst().orElseThrow(() -> new Exception("AeroexpressTicketRulesHandler not found in registry"));
                RulesProductHandler aeroexpressHandler = aeroexpressRulesHandler.createRulesHandler();
                RuleProxy ruleProxy2 = GeneralProductRulesHelper.applyRules((BaseProduct)product, (EntityContainer)bfContainer, (RulesProductHandler)aeroexpressHandler, new ArrayList(), null, null, (boolean)true, (boolean)false, (boolean)true);
                if (ruleProxy2 != null) {
                    Collection collection = ((AeroexpressTicketActionSet)ruleProxy2.getActionSet()).getReceiptTemplates();
                    return collection;
                }
            }
            List<EntityReference<TemplateDocument>> list = Collections.emptyList();
            return list;
        }
        catch (Exception exception) {
            this.log.error("Failed to get template document");
            throw new ServiceException("Failed to get template document");
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public BaseProduct getProductByUid(ServiceInvocationContext serviceInvocationContext, String uid) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-getProductByUid");
        try {
            this.checkContext(serviceInvocationContext);
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"navigationKey", (Object)uid));
            List indices = EntityStorage.get().search(CommonProductIndex.class, query).getData();
            for (CommonProductIndex index : indices) {
                BaseProduct product;
                EntityReference bfRef = index.getSource();
                EntityContainer bfCtr = EntityStorage.get().resolve(bfRef);
                if (bfCtr == null || (product = (BaseProduct)((BookingFile)bfCtr.getEntity()).getReservations().stream().flatMap(item -> item.getProducts().stream()).filter(item -> uid.equals(item.getUid())).findFirst().orElse(null)) == null) continue;
                BaseProduct baseProduct = product;
                return baseProduct;
            }
            Iterator iterator = null;
            return iterator;
        }
        catch (Exception exception) {
            this.log.error("Failed to get product by id");
            throw new ServiceException("Failed to get product by id");
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public List<CostCode> getClientShipmentCostCodes(ServiceInvocationContext serviceInvocationContext, BaseProduct product) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-getClientShipmentCostCodes");
        try {
            this.checkContext(serviceInvocationContext);
            List clientFops = GeneralProductHelper.getClientFops((BaseProduct)product);
            Set fopsUids = clientFops.stream().map(BaseIdentity::getUid).collect(Collectors.toSet());
            List<CostCode> list = product.getFopDetalizations().entrySet().stream().filter(it -> fopsUids.contains(it.getKey())).flatMap(it -> ((FopDetalization)it.getValue()).getComponents().stream()).map(FopComponent::getShipment).filter(Objects::nonNull).distinct().map(item -> EntityStorage.get().resolve(item)).filter(Objects::nonNull).map(EntityContainer::getEntity).flatMap(item -> item.getCostCodes().stream()).collect(Collectors.toList());
            return list;
        }
        catch (Exception exception) {
            this.log.error("Failed to get client shipment cost codes");
            throw new ServiceException("Failed to get client shipment cost codes");
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public List<CostCodeProperties> getCostCodeProperties(ServiceInvocationContext serviceInvocationContext, EntityReference<Organization> organization) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-getClientCostCodeProperties");
        try {
            this.checkContext(serviceInvocationContext);
            if (organization == null) {
                List<CostCodeProperties> list = Collections.emptyList();
                return list;
            }
            EntityContainer organizationCtr = EntityStorage.get().resolve(organization);
            if (organizationCtr != null) {
                List list = ((Organization)organizationCtr.getEntity()).getCostCodeProperties();
                return list;
            }
            List<CostCodeProperties> list = Collections.emptyList();
            return list;
        }
        catch (Exception exception) {
            this.log.error("Failed to get client cost code properties");
            throw new ServiceException("Failed to get client cost code properties");
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public List<CostCode> getCostCodes(ServiceInvocationContext serviceInvocationContext, EntityReference<Organization> organization) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-getClientCostCodes");
        try {
            this.checkContext(serviceInvocationContext);
            if (organization == null) {
                List<CostCode> list = Collections.emptyList();
                return list;
            }
            EntityContainer organizationCtr = EntityStorage.get().resolve(organization);
            if (organizationCtr != null) {
                List list = ((Organization)organizationCtr.getEntity()).getCostCodes();
                return list;
            }
            List<CostCode> list = Collections.emptyList();
            return list;
        }
        catch (Exception exception) {
            this.log.error("Failed to get client cost code properties");
            throw new ServiceException("Failed to get client cost code properties");
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public boolean isHotelAggregatorAvailable(ServiceInvocationContext serviceInvocationContext) throws ServiceException {
        DebugUtil.setThreadName((String)"BookingFileServiceImpl-isHotelAggregatorAvailable");
        try {
            this.checkContext(serviceInvocationContext);
            boolean bl = HotelAggregatorHelper.isHotelAggregatorEnabled();
            return bl;
        }
        catch (Exception exception) {
            this.log.error("Failed to find if hotel aggregator is available");
            throw new ServiceException("Failed to find if hotel aggregator is available");
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> rejectProduct(ServiceInvocationContext ctx, String prodUid, EntityReference<BookingFile> ref, String number) throws ServiceException {
        ArrayList<Message> result;
        block12: {
            DebugUtil.setThreadName((String)"BookingFileServiceImpl-rejectProduct");
            result = new ArrayList<Message>();
            try {
                this.checkContext(ctx);
                EntityContainer ctr = EntityStorage.get().resolve(ref);
                if (ctr == null) {
                    result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Error resolving booking file container for product with UID: %s", prodUid), (Object[])new Object[0]));
                }
                if (!result.isEmpty()) break block12;
                BaseProduct product = BookingHelper.findProductByUid((String)prodUid, (BookingFile)((BookingFile)ctr.getEntity()));
                if (product == null) {
                    result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Error finding product in booking file with product UID: %s", prodUid), (Object[])new Object[0]));
                }
                if (result.isEmpty()) {
                    ProductFXHandler<BaseProduct> fxHandler = ProductFXHandlersRegistry.get().getForProduct(product);
                    if (fxHandler != null) {
                        result.addAll(fxHandler.rejectProduct(product, number));
                    } else {
                        result.addAll(BookingFileServiceImpl.getNoSuchHandlerMessage(product));
                    }
                }
                if (result.isEmpty()) {
                    try {
                        ctr.getVersionInfo().setDataSource("fx-rejectProduct");
                        EntityStorage.get().save(ctr, true);
                    }
                    catch (Exception e) {
                        result.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"Error saving booking file", (Object[])new Object[0]));
                        this.updateErrorListWithXeption(result, e);
                    }
                }
                if (result.isEmpty()) {
                    result.add(Messages.getNotificationCancelSuccess((String)((BookingFile)ctr.getEntity()).getNumber()));
                }
            }
            finally {
                DebugUtil.restoreThreadName();
            }
        }
        return result;
    }

    private void updateErrorListWithXeption(Collection<Message> errorList, Throwable e) {
        Xeption xeption = this.findEndUserException(e);
        if (xeption != null) {
            errorList.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)xeption.toMessageString(), (Object[])new Object[0]));
        }
    }
}

