/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.rpc.ContractService;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.contract.Contract2ModelContractUIData;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.ModelContractIndex;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.server.fx.util.DateUtil;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ContractServiceImpl
extends BaseSecureServiceImpl
implements ContractService {
    public List<Contract2ModelContractUIData> getContract2ModelContractUIData(ServiceInvocationContext ctx, EntityReference<Contract> contractRef, SearchQuery query) throws ServiceException {
        DebugUtil.setThreadName((String)"FxContractServiceImpl-getContract2ModelContractUIData");
        try {
            this.checkContext(ctx);
            query.setLimit(0);
            ArrayList<Contract2ModelContractUIData> result = new ArrayList<Contract2ModelContractUIData>();
            EntityStorage storage = EntityStorage.get();
            EntityContainer container = storage.resolve(contractRef);
            if (container != null) {
                ArrayList<SearchCriterion> searchCriterions = new ArrayList<SearchCriterion>();
                if (((Contract)container.getEntity()).getSupplier() != null) {
                    searchCriterions.add(SearchCriterion.contains((String)ModelContractIndex.Property.suppliers.name(), (Object)((Contract)container.getEntity()).getSupplier()));
                }
                if (((Contract)container.getEntity()).getCustomer() != null) {
                    searchCriterions.add(SearchCriterion.contains((String)ModelContractIndex.Property.customers.name(), (Object)((Contract)container.getEntity()).getCustomer()));
                }
                if (((Contract)container.getEntity()).getContractType() != null) {
                    searchCriterions.add(SearchCriterion.eq((String)ModelContractIndex.Property.contractType.name(), (Object)((Contract)container.getEntity()).getContractType()));
                }
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])searchCriterions.toArray(new SearchCriterion[searchCriterions.size()])));
                storage.search(ModelContractIndex.class, query).getData().forEach(index -> {
                    EntityReference modelContractRef = index.getSource();
                    if (result.stream().anyMatch(v -> Objects.equals(modelContractRef, v.getSource()) && !v.isDirectBinding())) {
                        return;
                    }
                    Contract2ModelContractUIData view = new Contract2ModelContractUIData();
                    view.setName(index.getName());
                    if (index.getPriority() != null) {
                        view.setPriority(index.getPriority().toString());
                    }
                    if (index.getSource() != null) {
                        view.setSource(modelContractRef);
                    }
                    view.setDirectBinding(false);
                    result.add(view);
                });
                ((Contract)container.getEntity()).getModelContracts().forEach(m2mc -> {
                    if (null == m2mc) {
                        return;
                    }
                    EntityReference modelContractRef = m2mc.getModelContract();
                    if (modelContractRef == null || result.stream().anyMatch(v -> Objects.equals(modelContractRef, v.getSource()) && v.isDirectBinding())) {
                        return;
                    }
                    EntityContainer modelContract = storage.resolve(modelContractRef);
                    if (modelContract != null) {
                        Contract2ModelContractUIData view = new Contract2ModelContractUIData();
                        view.setName(((ModelContract)modelContract.getEntity()).getName());
                        view.setPriority(String.valueOf(((ModelContract)modelContract.getEntity()).getPriority()));
                        LocalDate startDate = DateUtil.asLocalDate(m2mc.getStartDate());
                        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy", LocaleManager.get().getCurrentLocale());
                        view.setStartDate(startDate == null ? null : startDate.format(dateFormatter));
                        LocalDate endDate = DateUtil.asLocalDate(m2mc.getEndDate());
                        view.setEndDate(endDate == null ? null : endDate.format(dateFormatter));
                        view.setSource(modelContractRef);
                        view.setDirectBinding(true);
                        view.setTranslateSupplierFees(Boolean.valueOf(m2mc.isTranslateSupplierFees()));
                        result.add(view);
                    }
                });
            }
            ArrayList<Contract2ModelContractUIData> arrayList = result;
            return arrayList;
        }
        catch (Throwable t) {
            this.log.error("failed get Contract2ModelContractUIData", t);
            throw new ServiceException("failed load Contract data", t);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }
}

