/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.rpc.CopySegmentsForEmdProductService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.util.List;
import java.util.Optional;

public class CopySegmentsForEmdProductServiceImpl
extends BaseSecureServiceImpl
implements CopySegmentsForEmdProductService {
    public void populateSegments(Product product, EntityContainer<BookingFile> bookingFileEntityContainer) throws Exception {
        List<SegmentTariff> segments = CopySegmentsForEmdProductServiceImpl.getSegmentTariffs(product);
        if (segments == null) {
            throw new Exception("Unable to get segments from related product");
        }
        AirProductHelper.setClonedSegmentTariffs((Product)product, segments);
        EntityStorage.get().save(bookingFileEntityContainer, true);
    }

    private static List<SegmentTariff> getSegmentTariffs(Product product) {
        return Optional.ofNullable(product).filter(p -> ProductCategory.MCO.equals((Object)p.getProductCategory())).map(Product::getRelatedProducts).filter(rp -> !rp.isEmpty()).map(rp -> ((Product)rp.get(0)).getSegmentTariffs()).filter(st -> !st.isEmpty()).orElse(null);
    }
}

