/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DeliveryService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryItem;
import com.gridnine.xtrip.common.model.delivery.DeliveryItemIndex;
import com.gridnine.xtrip.common.model.delivery.DeliveryItemType;
import com.gridnine.xtrip.common.model.delivery.DeliveryStatus;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DeliveryHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.helpers.FinanceDocumentHelper;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DeliveryServiceImpl
extends BaseSecureServiceImpl
implements DeliveryService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeliveryHelper.OrganizationContactData getOrganizationContactData(ServiceInvocationContext context, EntityReference<Organization> organization) throws ServiceException {
        DebugUtil.setThreadName((String)"DeliveryServiceImpl-getContactData");
        try {
            this.checkContext(context);
            DeliveryHelper.OrganizationContactData organizationContactData = Optional.ofNullable(EntityStorage.get().resolve(organization)).map(item -> DeliveryHelper.getOrganizationContactData((Organization)((Organization)item.getEntity()))).orElse(null);
            return organizationContactData;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NestedEntityReference<BookingFile, BaseProduct> addProductToDelivery(ServiceInvocationContext context, Map<String, EntityReference<BookingFile>> productMap, EntityReference<BookingFile> bookingFileReference, String reservationUid, String deliveryUid) throws ServiceException {
        DebugUtil.setThreadName((String)"DeliveryServiceImpl-deliveryProductAdd");
        NestedEntityReference result = null;
        try {
            this.checkContext(context);
            this.removeProductsExistingInDeliveries(productMap);
            Reservation reservation = new Reservation();
            Delivery delivery = new Delivery();
            EntityContainer ctr = bookingFileReference == null ? EntityContainer.create((BaseEntity)new BookingFile()) : EntityStorage.get().resolve(bookingFileReference);
            if (ctr == null) {
                throw new ServiceException(String.format("Booking file %s (%s) load failed", bookingFileReference, bookingFileReference.getUid()));
            }
            if (TextUtil.isBlank((String)reservationUid) && TextUtil.isBlank((String)deliveryUid)) {
                reservation.setResDate(new Date());
                reservation.setBookingFile((BookingFile)ctr.getEntity());
                reservation.getProducts().add(delivery);
                ((BookingFile)ctr.getEntity()).getReservations().add(reservation);
            }
            if (!TextUtil.isBlank((String)reservationUid) && TextUtil.isBlank((String)deliveryUid)) {
                Optional<Reservation> reservationOptional = ((BookingFile)ctr.getEntity()).getReservations().stream().filter(r -> TextUtil.isSame((String)r.getUid(), (String)reservationUid)).findFirst();
                if (reservationOptional.isPresent()) {
                    reservation = reservationOptional.get();
                    reservation.getProducts().add(delivery);
                } else {
                    throw new ServiceException(String.format("Reservation %s search failed", reservationUid));
                }
            }
            if (!TextUtil.isBlank((String)deliveryUid)) {
                delivery = (Delivery)BookingHelper.findProductByUid((String)deliveryUid, (BookingFile)((BookingFile)ctr.getEntity()));
                if (delivery == null) {
                    throw new ServiceException(String.format("Delivery %s search failed", deliveryUid));
                }
                reservation = delivery.getReservation();
            }
            if (deliveryUid != null) {
                this.updateExistingDelivery(productMap, (EntityContainer<BookingFile>)ctr, delivery);
            } else {
                this.updateDelivery(productMap, (EntityContainer<BookingFile>)ctr, delivery, reservation);
            }
            ctr.getVersionInfo().setDataSource("fx-addProductToDelivery");
            EntityStorage.get().save(ctr, true);
            result = new NestedEntityReference(ctr, (BaseEntity)delivery);
        }
        finally {
            DebugUtil.restoreThreadName();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NestedEntityReference<BookingFile, BaseProduct> addFinanceDocumentsToDelivery(ServiceInvocationContext context, List<EntityReference<FinanceDocument>> financeDocumentReferences, EntityReference<BookingFile> bookingFileReference, String reservationUid, String deliveryUid) throws ServiceException {
        DebugUtil.setThreadName((String)"DeliveryServiceImpl-deliveryFinanceDocumentsAdd");
        try {
            Delivery product;
            Reservation reservation;
            EntityContainer bookingFileContainer;
            this.checkContext(context);
            ArrayList<EntityContainer> includeFinanceDocumentContainers = new ArrayList<EntityContainer>();
            for (EntityReference<FinanceDocument> financeDocumentReference : financeDocumentReferences) {
                EntityContainer financeDocumentEntityContainer = EntityStorage.get().resolve(financeDocumentReference);
                FinanceDocument financeDocument = Optional.ofNullable(financeDocumentEntityContainer).map(EntityContainer::getEntity).orElse(null);
                if (financeDocument == null || financeDocument.getDelivery() != null) continue;
                includeFinanceDocumentContainers.add(financeDocumentEntityContainer);
            }
            if (includeFinanceDocumentContainers.size() == 0) {
                Iterator<EntityReference<FinanceDocument>> iterator = null;
                return iterator;
            }
            if (bookingFileReference != null) {
                bookingFileContainer = EntityStorage.get().resolve(bookingFileReference);
                if (bookingFileContainer == null) {
                    throw new ServiceException(String.format("Booking file %s (%s) load failed", bookingFileReference, bookingFileReference.getUid()));
                }
            } else {
                bookingFileContainer = new EntityContainer(BookingFile.class);
                ((BookingFile)bookingFileContainer.getEntity()).setCreateDate(new Date());
                ((BookingFile)bookingFileContainer.getEntity()).setAgency(((FinanceDocument)((EntityContainer)includeFinanceDocumentContainers.get(0)).getEntity()).getSupplier());
            }
            BookingFile bookingFile = (BookingFile)bookingFileContainer.getEntity();
            if (!TextUtil.isBlank((String)reservationUid)) {
                reservation = bookingFile.getReservations().stream().filter(item -> MiscUtil.equals((Object)item.getUid(), (Object)reservationUid)).findFirst().orElse(null);
                if (reservation == null) {
                    throw new ServiceException(String.format("Reservation %s search failed", reservationUid));
                }
            } else {
                reservation = new Reservation();
                reservation.setBookingAgent(((FinanceDocument)((EntityContainer)includeFinanceDocumentContainers.get(0)).getEntity()).getAgent());
                bookingFile.getReservations().add(reservation);
                reservation.setBookingFile(bookingFile);
            }
            if (!TextUtil.isBlank((String)deliveryUid)) {
                product = reservation.getProducts().stream().filter(item -> MiscUtil.equals((Object)item.getUid(), (Object)deliveryUid) && item instanceof Delivery).map(item -> (Delivery)item).findFirst().orElse(null);
                if (product == null) {
                    throw new ServiceException(String.format("Delivery %s search failed", deliveryUid));
                }
            } else {
                product = new Delivery();
                product.setAgency(bookingFile.getAgency());
                product.setAgent(reservation.getBookingAgent());
                product.setSalesPoint(reservation.getSalesPoint());
                reservation.getProducts().add(product);
                product.setReservation(reservation);
            }
            for (EntityContainer includeFinanceDocumentContainer : includeFinanceDocumentContainers) {
                DeliveryItem deliveryItem = new DeliveryItem();
                deliveryItem.setType(DeliveryItemType.FINANCE_DOCUMENT);
                deliveryItem.setObject((Object)includeFinanceDocumentContainer.toReference());
                deliveryItem.setCost(FinanceDocumentHelper.getBillingItems((List)((FinanceDocument)includeFinanceDocumentContainer.getEntity()).getBillingItems(), (EntityStorageContext)new EntityStorageContext()).stream().map(billingItem -> billingItem.getAmount().getTotal()).reduce(BigDecimal.ZERO, BigDecimal::add));
                Optional.ofNullable(((FinanceDocument)includeFinanceDocumentContainer.getEntity()).getCurrency()).ifPresent(currency -> deliveryItem.setCurrency(currency.getCode()));
                product.getDeliveryItems().add(deliveryItem);
            }
            bookingFileContainer.getVersionInfo().setDataSource("delivery-finance-documents-add");
            EntityStorage.get().save(bookingFileContainer, true);
            NestedEntityReference nestedEntityReference = new NestedEntityReference(bookingFileContainer, (BaseEntity)product);
            return nestedEntityReference;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private void removeProductsExistingInDeliveries(Map<String, EntityReference<BookingFile>> productMap) {
        Map<String, String> productsInExistingDeliveries = DeliveryServiceImpl.getProductsInExistingDeliveries(new ArrayList<String>(productMap.keySet()));
        productMap.keySet().removeAll(productsInExistingDeliveries.keySet());
    }

    private static Map<String, String> getProductsInExistingDeliveries(List<String> productUidList) {
        SearchQuery query = new SearchQuery();
        Object[] uids = productUidList.toArray(new Object[productUidList.size()]);
        query.getPreferredProperties().add(DeliveryItemIndex.Property.nestedEntityUid.name());
        query.getPreferredProperties().add(DeliveryItemIndex.Property.deliverySystemNumber.name());
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)DeliveryItemIndex.Property.type.name(), (Object)DeliveryItemType.PRODUCT));
        query.getCriteria().getCriterions().add(SearchCriterion.in((String)DeliveryItemIndex.Property.nestedEntityUid.name(), (Object[])uids));
        return EntityStorage.get().search(DeliveryItemIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData().stream().collect(Collectors.toMap(DeliveryItemIndex::getNestedEntityUid, DeliveryItemIndex::getDeliverySystemNumber));
    }

    private void updateDelivery(Map<String, EntityReference<BookingFile>> productMap, EntityContainer<BookingFile> ctr, Delivery delivery, Reservation reservation) {
        HashSet<PaymentType> paymentTypes = new HashSet<PaymentType>();
        if (delivery.getAgency() == null) {
            delivery.setAgency(((BookingFile)ctr.getEntity()).getAgency());
        }
        delivery.setChecked(false);
        delivery.setContractRulesApplied(false);
        if (delivery.getIssueDate() == null) {
            delivery.setIssueDate(new Date());
        }
        delivery.setStatus(DeliveryStatus.PLANNED);
        delivery.getValidationMessages().clear();
        delivery.setReservation(reservation);
        for (Map.Entry<String, EntityReference<BookingFile>> entry : productMap.entrySet()) {
            this.createDeliveryItems(productMap, delivery, paymentTypes, entry.getKey(), entry.getValue());
        }
        this.updateDeliveryFOPs(delivery, paymentTypes);
        DeliveryHelper.importDataFromProfile((Delivery)delivery, (EntityReference)delivery.getReservation().getBookingFile().getCustomerProfile());
    }

    private void updateExistingDelivery(Map<String, EntityReference<BookingFile>> productMap, EntityContainer<BookingFile> ctr, Delivery delivery) {
        HashSet<PaymentType> paymentTypes = new HashSet<PaymentType>();
        if (delivery.getAgency() == null) {
            delivery.setAgency(((BookingFile)ctr.getEntity()).getAgency());
        }
        delivery.setContractRulesApplied(false);
        if (delivery.getIssueDate() == null) {
            delivery.setIssueDate(new Date());
        }
        delivery.getValidationMessages().clear();
        for (Map.Entry<String, EntityReference<BookingFile>> entry : productMap.entrySet()) {
            this.createDeliveryItems(productMap, delivery, paymentTypes, entry.getKey(), entry.getValue());
        }
        this.updateDeliveryFOPs(delivery, paymentTypes);
    }

    private void createDeliveryItems(Map<String, EntityReference<BookingFile>> productMap, Delivery delivery, Set<PaymentType> paymentTypes, String productUid, EntityReference<BookingFile> bookingFileEntityReference) {
        VatAmount productPrice;
        EntityContainer container = EntityStorage.get().resolve(bookingFileEntityReference);
        BaseProduct product = BookingHelper.findProductByUid((String)productUid, (BookingFile)((BookingFile)container.getEntity()));
        DeliveryItem item = new DeliveryItem();
        ProductHandler handler = HandlersRegistry.get().findProductHandler(product.getClass());
        Fop fop = GeneralProductHelper.findFop((BaseProduct)product);
        item.setType(DeliveryItemType.PRODUCT);
        item.setObject((Object)new NestedEntityReference(productMap.get(product.getUid()), (BaseEntity)product, ProductHandler.of((BaseProduct)product).generateShortProductName(product)));
        item.setPaymentType(fop == null ? PaymentType.CASH : fop.getType());
        paymentTypes.add(item.getPaymentType());
        BigDecimal cost = GeneralProductHelper.calculateFee((BaseProduct)product, (ContractType)ContractType.CLIENT);
        if (cost == null) {
            cost = BigDecimal.ZERO;
        }
        if ((productPrice = handler.calculateProductPrice(product, ContractType.CLIENT)) != null) {
            cost = cost.add(productPrice.getTotal());
        }
        item.setCost(cost);
        delivery.getDeliveryItems().add(item);
    }

    private void updateDeliveryFOPs(Delivery delivery, Set<PaymentType> paymentTypes) {
        if (!paymentTypes.isEmpty() && delivery.getClientFops().isEmpty()) {
            GeneralProductFop fop = new GeneralProductFop();
            delivery.getClientFops().add(fop);
            if (paymentTypes.contains(PaymentType.CASH)) {
                fop.setType(PaymentType.CASH);
            } else {
                fop.setType(paymentTypes.iterator().next());
                fop.setAgent(delivery.getAgent());
                fop.setOperationDate(delivery.getIssueDate());
            }
        }
    }

    private void addProductResolveErrorMessage(Collection<Message> errorList, String productUID) {
        errorList.add(Messages.getExceptionCannotFindProductInDB((String)productUID));
    }

    private void addContainerResolveErrorMessage(Collection<Message> errorList, String productUID) {
        errorList.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)String.format("Error resolving booking file container for product with UID: %s", productUID), (Object[])new Object[0]));
    }
}

