/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.test.TestBase;
import com.gridnine.xtrip.common.test.TestDictionaryCache;
import com.gridnine.xtrip.common.util.ResourceUtil;
import com.gridnine.xtrip.server.fx.rpc.DictServiceImpl;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class DictServiceImplTest
extends TestBase {
    protected void setUpEnvironment() throws Exception {
        super.setUpEnvironment();
        MetaRegistry.get().register(ResourceUtil.getResource((String)"com/gridnine/xtrip/common/model/model-dict.xml"));
        TestDictionaryCache dictCache = new TestDictionaryCache();
        dictCache.loadDictionaries(((Object)((Object)this)).getClass().getResource("dictionaries.xml"));
        Environment.publish(DictionaryCache.class, (Object)dictCache);
    }

    @Test
    public void testSearch() throws Exception {
        DictServiceImpl service = new DictServiceImpl(){

            protected void checkContext(ServiceInvocationContext ctx) {
            }

            protected boolean isAclGranted(Class<? extends BaseDictionary> cls, String operationId) throws Exception {
                return true;
            }
        };
        DictQuery query = new DictQuery();
        List items = service.search(null, GeoLocation.class, query);
        Assert.assertEquals((long)200L, (long)items.size());
        query = new DictQuery();
        query.setOffset(100);
        query.getFields().add(BaseDictionary.Property.code.name());
        query.getFields().add(BaseDictionary.Property.translations.name());
        query.getFields().add(GeoLocation.Property.country.name());
        query.getFields().add(GeoLocation.Property.type.name());
        items = service.search(null, GeoLocation.class, query);
        Assert.assertEquals((long)200L, (long)items.size());
        query = new DictQuery();
        query.getFields().add(BaseDictionary.Property.code.name());
        query.getFields().add(BaseDictionary.Property.translations.name());
        query.getFields().add(GeoLocation.Property.country.name());
        query.getFields().add(GeoLocation.Property.type.name());
        query.setPattern("\u043c\u043f\u0430\u043d");
        Assert.assertEquals((long)0L, (long)service.search(null, GeoLocation.class, query).size());
        query.setPattern("\u0434\u0436\u0438\u043c");
        Assert.assertEquals((long)3L, (long)service.search(null, GeoLocation.class, query).size());
        query = new DictQuery();
        query.getFields().add(BaseDictionary.Property.code.name());
        query.getFields().add(BaseDictionary.Property.translations.name());
        query.setPattern("\u041b\u0430\u043c\u0438");
        query.getSorting().put(BaseDictionary.Property.translations.name(), SortOrder.ASC);
        items = service.search(null, GeoLocation.class, query);
        Assert.assertEquals((long)4L, (long)items.size());
        Assert.assertEquals((Object)"airport LNB", (Object)((DictItem)items.get(0)).getReference().getCode());
        Assert.assertEquals((Object)"airport LUB", (Object)((DictItem)items.get(3)).getReference().getCode());
        query = new DictQuery();
        query.getFields().add(BaseDictionary.Property.code.name());
        query.getFields().add(BaseDictionary.Property.translations.name());
        query.setPattern("\u041b\u0430\u043c\u0438");
        query.getSorting().put(BaseDictionary.Property.code.name(), SortOrder.DESC);
        items = service.search(null, GeoLocation.class, query);
        Assert.assertEquals((long)4L, (long)items.size());
        Assert.assertEquals((Object)"airport LUB", (Object)((DictItem)items.get(0)).getReference().getCode());
        Assert.assertEquals((Object)"airport LDN", (Object)((DictItem)items.get(3)).getReference().getCode());
    }
}

