/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.ETicketQuotaService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.assets.ExportReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.stockcontrol.ETicketQuota;
import com.gridnine.xtrip.common.model.stockcontrol.ETicketQuotaIndex;
import com.gridnine.xtrip.common.model.stockcontrol.ETicketQuotaItem;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.server.model.helpers.IndexBuilderHelper;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ETicketQuotaServiceImpl
extends BaseSecureServiceImpl
implements ETicketQuotaService {
    private static final Message EXCEPTION_INSUFFICIENT_UNALLOCATED_QUOTA = Messages.getExceptionInsufficientUnallocatedQuota();
    private static final Message EXCEPTION_INSUFFICIENT_QUOTA_RESERVE = Messages.getExceptionInsufficientQuotaReserve();
    private static final Message EXCEPTION_INSUFFICIENT_UNALLOCATED_QUOTA_RESERVE = Messages.getExceptionInsufficientUnallocatedQuotaReserve();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> allocateETicketQuota(ServiceInvocationContext ctx, Collection<EntityIndex<ETicketQuota>> indices, int value) throws ServiceException {
        DebugUtil.setThreadName((String)"ETicketQuotaServiceImpl-allocate");
        ArrayList<Message> result = new ArrayList<Message>();
        try {
            this.checkContext(ctx);
            try {
                if (!indices.isEmpty()) {
                    this.handleRequest(indices, value, result);
                }
            }
            catch (Throwable t) {
                this.log.error(t.getMessage() + ExportReference.Property.ref, t);
                throw new ServiceException(t.getMessage(), t);
            }
            {
            }
        }
        finally {
            DebugUtil.restoreThreadName();
            return result;
        }
    }

    public void updateIndexes(ServiceInvocationContext ctx) throws ServiceException {
        DebugUtil.setThreadName((String)"ETicketQuotaServiceImpl-update-indexes");
        try {
            this.checkContext(ctx);
            try {
                IndexBuilderHelper.rebuild((String)ETicketQuota.class.getName());
            }
            catch (Throwable t) {
                this.log.error("" + ExportReference.Property.ref, t);
                throw new ServiceException(t.getMessage(), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private void handleRequest(Collection<EntityIndex<ETicketQuota>> indices, int value, List<Message> result) throws ServiceException {
        EntityContainer eTicketQuotaContainer;
        Optional<ETicketQuotaItem> eTicketQuotaItemOptional;
        SearchQuery eTicketIndexQuery = new SearchQuery();
        indices.stream().map(Identity::getUid).forEach(uid -> eTicketIndexQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)"uid", (Object)uid)));
        eTicketIndexQuery.getPreferredProperties().clear();
        ETicketQuotaIndex eTicketQuotaIndex = (ETicketQuotaIndex)EntityStorage.get().search(ETicketQuotaIndex.class, eTicketIndexQuery, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData().get(0);
        boolean isStockHolderQuota = eTicketQuotaIndex.getCurrentLocation() == null || eTicketQuotaIndex.getStockHolder().equals((Object)eTicketQuotaIndex.getCurrentLocation());
        ETicketQuotaIndex stockHolderIndex = null;
        if (isStockHolderQuota) {
            if (value < 0 && eTicketQuotaIndex.getUnusedQuota() < Math.abs(value)) {
                result.add(EXCEPTION_INSUFFICIENT_UNALLOCATED_QUOTA);
                return;
            }
        } else {
            if (value < 0 && eTicketQuotaIndex.getRemainder() < Math.abs(value)) {
                result.add(EXCEPTION_INSUFFICIENT_QUOTA_RESERVE);
                return;
            }
            SearchQuery query = new SearchQuery();
            Collection gdsCriterions = eTicketQuotaIndex.getGdsNames().stream().map(gdsName -> SearchCriterion.contains((String)ETicketQuotaIndex.Property.gdsNames.name(), (Object)gdsName.name())).collect(Collectors.toList());
            List mainCriterions = query.getCriteria().getCriterions();
            mainCriterions.add(SearchCriterion.eq((String)ETicketQuotaIndex.Property.blankOwner.name(), (Object)eTicketQuotaIndex.getBlankOwner()));
            mainCriterions.add(SearchCriterion.eq((String)ETicketQuotaIndex.Property.stockHolder.name(), (Object)eTicketQuotaIndex.getStockHolder()));
            mainCriterions.add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ETicketQuotaIndex.Property.currentLocation.name(), null), SearchCriterion.eq((String)ETicketQuotaIndex.Property.currentLocation.name(), (Object)eTicketQuotaIndex.getStockHolder())}));
            mainCriterions.add(SearchCriterion.eq((String)ETicketQuotaIndex.Property.blankType.name(), (Object)eTicketQuotaIndex.getBlankType()));
            mainCriterions.add(SearchCriterion.and((SearchCriterion[])gdsCriterions.toArray(new SearchCriterion[gdsCriterions.size()])));
            List stockHolderIndexes = EntityStorage.get().search(ETicketQuotaIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData();
            ETicketQuotaIndex eTicketQuotaIndex2 = stockHolderIndex = stockHolderIndexes.isEmpty() ? null : (ETicketQuotaIndex)stockHolderIndexes.get(0);
            if (stockHolderIndex != null && stockHolderIndex.getUnusedQuota() < value) {
                result.add(EXCEPTION_INSUFFICIENT_UNALLOCATED_QUOTA_RESERVE);
                return;
            }
        }
        if ((eTicketQuotaItemOptional = ((ETicketQuota)(eTicketQuotaContainer = EntityStorage.get().resolve(eTicketQuotaIndex.getSource())).getEntity()).getQuotaItems().stream().filter(eTicketQuotaItem -> eTicketQuotaItem.getBlankType().equals((Object)eTicketQuotaIndex.getBlankType()) && eTicketQuotaItem.getGdsNames().size() == eTicketQuotaIndex.getGdsNames().size() && eTicketQuotaItem.getGdsNames().containsAll(eTicketQuotaIndex.getGdsNames())).findFirst()).isPresent()) {
            eTicketQuotaItemOptional.get().setTotalQuota(eTicketQuotaItemOptional.get().getTotalQuota() + (long)value);
            EntityStorage.get().save(eTicketQuotaContainer, false);
            if (!isStockHolderQuota && stockHolderIndex != null) {
                EntityStorage.get().save(EntityStorage.get().resolve(stockHolderIndex.getSource()), false);
            }
        }
    }
}

