/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.rpc.ErasureService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.erasure.BatchErasureParams;
import com.gridnine.xtrip.common.model.erasure.ErasureRequest;
import com.gridnine.xtrip.common.model.erasure.GenericErasureParams;
import com.gridnine.xtrip.common.model.erasure.IndividualErasureParams;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.server.model.helpers.erasure.util.Util;
import com.gridnine.xtrip.server.model.tasks.standard.ErasureProcessingTask;
import com.gridnine.xtrip.server.model.tasks.standard.ErasureSearchingTask;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;

public class ErasureServiceImpl
extends BaseSecureServiceImpl
implements ErasureService {
    public <T extends GenericErasureParams> EntityReference<ErasureRequest> createErasureRequest(ServiceInvocationContext ctx, T params) throws ServiceException {
        DebugUtil.setThreadName((String)"FxErasureServiceImpl-createErasureRequest");
        try {
            this.checkContext(ctx);
            try {
                EntityContainer result = null;
                if (params instanceof BatchErasureParams) {
                    result = Util.newErasureRequest((BatchErasureParams)((BatchErasureParams)params));
                } else if (params instanceof IndividualErasureParams) {
                    result = Util.newErasureRequest((IndividualErasureParams)((IndividualErasureParams)params));
                }
                EntityReference entityReference = result.toReference();
                return entityReference;
            }
            catch (Throwable t) {
                this.log.error("failed create ErasureRequest", t);
                throw new ServiceException("failed create ErasureRequest", t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    public void startNewSearchTask(ServiceInvocationContext ctx, EntityReference<ErasureRequest> ref) throws ServiceException {
        this.startNewTask(ctx, ref, ErasureSearchingTask.class);
    }

    public void startNewErasureTask(ServiceInvocationContext ctx, EntityReference<ErasureRequest> ref) throws ServiceException {
        this.startNewTask(ctx, ref, ErasureProcessingTask.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNewTask(ServiceInvocationContext ctx, EntityReference<ErasureRequest> ref, Class<?> taskClass) throws ServiceException {
        String taskClassName = taskClass.getSimpleName();
        DebugUtil.setThreadName((String)("FxErasureServiceImpl-startNewTask" + taskClassName));
        try {
            this.checkContext(ctx);
            try {
                EntityContainer ctr = EntityStorage.get().load(ErasureRequest.class, ref.getUid());
                Util.startTask((EntityContainer)ctr, taskClass);
            }
            catch (Throwable t) {
                this.log.error("failed start new task" + taskClassName, t);
                throw new ServiceException("failed start new task" + taskClassName, t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }
}

