/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.fx.rpc;

import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.rpc.ExchangeFilesService;
import com.gridnine.xtrip.common.l10n.Messages;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.parsers.UTSItineraryParserParameters;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointIndex;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.parsers.model.ExchangeDocumentRegistrationResult;
import com.gridnine.xtrip.common.parsers.model.ExchangeFile;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.fx.prefetched.PrefetchedDataHelper;
import com.gridnine.xtrip.server.parsers.ExchangeProcessHelper;
import com.gridnine.xtrip.server.rpc.service.BaseSecureServiceImpl;
import java.util.Date;
import java.util.List;

public class ExchangeFilesServiceImpl
extends BaseSecureServiceImpl
implements ExchangeFilesService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExchangeDocumentRegistrationResult registerExchangeFile(ServiceInvocationContext ctx, ExchangeFile file) throws ServiceException {
        DebugUtil.setThreadName((String)"ExchangeFilesServiceImpl-registerExchangeFile");
        try {
            try {
                this.checkContext(ctx);
            }
            catch (Throwable e) {
                if (ExchangeFilesServiceImpl.isVersionMismatchError(e)) {
                    ExchangeDocumentRegistrationResult exchangeDocumentRegistrationResult = this.registerExchangeFile(file);
                    DebugUtil.restoreThreadName();
                    return exchangeDocumentRegistrationResult;
                }
                throw e;
            }
            ExchangeDocumentRegistrationResult exchangeDocumentRegistrationResult = this.registerExchangeFile(file);
            return exchangeDocumentRegistrationResult;
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }

    private ExchangeDocumentRegistrationResult registerExchangeFile(ExchangeFile file) throws ServiceException {
        try {
            return ExchangeProcessHelper.registerExchangeFile((ExchangeFile)file);
        }
        catch (Throwable t) {
            this.log.error(String.format("failed registering exchange file %s", file != null ? file.getType() : ""), t);
            throw new ServiceException(t.getMessage(), t);
        }
    }

    static boolean isVersionMismatchError(Throwable error) {
        if (!(error instanceof Xeption)) {
            return false;
        }
        Xeption xeption = (Xeption)error;
        return xeption.getEndUserMessage() != null && L10n.get((String)Messages.BaseSecureServiceImpl_clientVersionDiffersFromTheServer).equals(xeption.getEndUserMessage().getKey());
    }

    public UTSItineraryParserParameters getUTSItineraryParameters(ServiceInvocationContext ctx, String validatorProperty, String pccProperty, String salesPointUidProperty, String agentUidProperty, String agencyUidProperty, String fakeID) throws ServiceException {
        DebugUtil.setThreadName((String)"ExchangeFilesServiceImpl-getUTSItineraryParameters");
        try {
            this.checkContext(ctx);
            try {
                String validator = validatorProperty;
                String pcc = pccProperty;
                EntityContainer salesPCtr = EntityStorage.get().load(SalesPoint.class, salesPointUidProperty);
                String salesPointCode = salesPCtr != null ? ((SalesPoint)salesPCtr.getEntity()).getCode() : "";
                EntityReference salesPoint = null;
                UTSItineraryParserParameters res = new UTSItineraryParserParameters();
                AgentData agentData = new AgentData();
                PrefetchedDataHelper.populateCurrentAgentData(agentData, agencyUidProperty, salesPointUidProperty, null, null, null);
                if (TextUtil.isBlank((String)validator)) {
                    EntityContainer spCtr;
                    validator = fakeID;
                    EntityReference unRef = null;
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.airline.name(), (Object)new AirlineReference("UN")));
                    query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.BLANK_OWNER.name()));
                    List data = EntityStorage.get().search(OrganizationIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData();
                    if (!data.isEmpty()) {
                        unRef = ((OrganizationIndex)data.get(0)).getSource();
                    }
                    if (unRef != null && (spCtr = EntityStorage.get().resolve(agentData.getSalesPoint())) != null) {
                        Date currentDate = new Date();
                        for (Validator val : ((SalesPoint)spCtr.getEntity()).getValidators()) {
                            if (!unRef.equals((Object)val.getBlankOwner()) || val.getOpened() != null && MiscUtil.clearTime((Date)val.getOpened()).after(currentDate) || val.getClosed() != null && MiscUtil.setDayEndTime((Date)val.getClosed()).before(currentDate)) continue;
                            validator = val.getNumber();
                        }
                    }
                }
                if (TextUtil.isBlank((String)pcc)) {
                    pcc = (String)agentData.getPccMap().get(GdsName.GABRIEL);
                }
                String agentCode = fakeID;
                EntityReference agent = new EntityReference(fakeID, Person.class, null);
                EntityContainer agentCtr = EntityStorage.get().resolve(agentData.getAgent());
                if (agentCtr != null) {
                    agentCode = ((Person)agentCtr.getEntity()).getCode();
                    agent = agentCtr.toReference();
                }
                if (TextUtil.isBlank((String)salesPointCode)) {
                    salesPointCode = fakeID;
                    salesPoint = new EntityReference(fakeID, SalesPoint.class, null);
                    EntityContainer salesPointCtr = EntityStorage.get().resolve(agentData.getSalesPoint());
                    if (salesPointCtr != null) {
                        salesPointCode = ((SalesPoint)salesPointCtr.getEntity()).getCode();
                        salesPoint = salesPointCtr.toReference();
                    }
                }
                if (salesPoint == null && salesPointCode != null) {
                    salesPoint = new EntityReference(fakeID, SalesPoint.class, null);
                    SearchQuery query = new SearchQuery();
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)SalesPointIndex.Property.code.name(), (Object)salesPointCode));
                    List data = EntityStorage.get().search(SalesPointIndex.class, query, (EntityStorageSearchParameters)new EntityStorageSearchParameters().noCache(true)).getData();
                    if (!data.isEmpty()) {
                        salesPoint = ((SalesPointIndex)data.get(0)).getSource();
                    }
                }
                res.setValidator(validator);
                res.setPcc(pcc);
                res.setAgentCode(agentCode);
                res.setAgent(agent);
                res.setSalesPointCode(salesPointCode);
                res.setSalesPoint(salesPoint);
                UTSItineraryParserParameters uTSItineraryParserParameters = res;
                return uTSItineraryParserParameters;
            }
            catch (Throwable t) {
                this.log.error("Exception while preparing parameters for UTSItinerary parser", t);
                throw new ServiceException(t.getMessage(), t);
            }
        }
        finally {
            DebugUtil.restoreThreadName();
        }
    }
}

